/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Arrays;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public abstract class BlobKey
implements Serializable,
Comparable<BlobKey> {
    private static final long serialVersionUID = 3847117712521785209L;
    public static final int SIZE = 20;
    private final byte[] key;
    private final BlobType type;
    private final AbstractID random;

    protected BlobKey(BlobType type) {
        this.type = (BlobType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.key = new byte[20];
        this.random = new AbstractID();
    }

    protected BlobKey(BlobType type, byte[] key) {
        if (key == null || key.length != 20) {
            throw new IllegalArgumentException("BLOB key must have a size of 20 bytes");
        }
        this.type = (BlobType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.key = key;
        this.random = new AbstractID();
    }

    protected BlobKey(BlobType type, byte[] key, byte[] random) {
        if (key == null || key.length != 20) {
            throw new IllegalArgumentException("BLOB key must have a size of 20 bytes");
        }
        this.type = (BlobType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.key = key;
        this.random = new AbstractID(random);
    }

    @VisibleForTesting
    static BlobKey createKey(BlobType type) {
        if (type == BlobType.PERMANENT_BLOB) {
            return new PermanentBlobKey();
        }
        return new TransientBlobKey();
    }

    static BlobKey createKey(BlobType type, byte[] key) {
        if (type == BlobType.PERMANENT_BLOB) {
            return new PermanentBlobKey(key);
        }
        return new TransientBlobKey(key);
    }

    static BlobKey createKey(BlobType type, byte[] key, byte[] random) {
        if (type == BlobType.PERMANENT_BLOB) {
            return new PermanentBlobKey(key, random);
        }
        return new TransientBlobKey(key, random);
    }

    @VisibleForTesting
    public byte[] getHash() {
        return this.key;
    }

    BlobType getType() {
        return this.type;
    }

    public void addToMessageDigest(MessageDigest md) {
        md.update(this.key);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlobKey)) {
            return false;
        }
        BlobKey bk = (BlobKey)obj;
        return Arrays.equals(this.key, bk.key) && this.type == bk.type && this.random.equals((Object)bk.random);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.key);
        result = 37 * result + this.type.hashCode();
        result = 37 * result + this.random.hashCode();
        return result;
    }

    public String toString() {
        return BlobKey.toString(this);
    }

    @Override
    public int compareTo(BlobKey o) {
        byte[] aarr = this.key;
        byte[] barr = o.key;
        int len = Math.min(aarr.length, barr.length);
        for (int i = 0; i < len; ++i) {
            int a = aarr[i] & 0xFF;
            int b = barr[i] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        if (aarr.length == barr.length) {
            int typeCompare = this.type.compareTo(o.type);
            if (typeCompare == 0) {
                return this.random.compareTo(o.random);
            }
            return typeCompare;
        }
        return aarr.length - barr.length;
    }

    static BlobKey readFromInputStream(InputStream inputStream) throws IOException {
        BlobType blobType;
        int bytesRead;
        int read;
        byte[] key = new byte[20];
        byte[] random = new byte[16];
        for (bytesRead = 0; bytesRead < key.length; bytesRead += read) {
            read = inputStream.read(key, bytesRead, key.length - bytesRead);
            if (read >= 0) continue;
            throw new EOFException("Read an incomplete BLOB key");
        }
        int read2 = inputStream.read();
        if (read2 < 0) {
            throw new EOFException("Read an incomplete BLOB type");
        }
        if (read2 == BlobType.TRANSIENT_BLOB.ordinal()) {
            blobType = BlobType.TRANSIENT_BLOB;
        } else if (read2 == BlobType.PERMANENT_BLOB.ordinal()) {
            blobType = BlobType.PERMANENT_BLOB;
        } else {
            throw new IOException("Invalid data received for the BLOB type: " + read2);
        }
        for (bytesRead = 0; bytesRead < 16; bytesRead += read2) {
            read2 = inputStream.read(random, bytesRead, 16 - bytesRead);
            if (read2 >= 0) continue;
            throw new EOFException("Read an incomplete BLOB key");
        }
        return BlobKey.createKey(blobType, key, random);
    }

    void writeToOutputStream(OutputStream outputStream) throws IOException {
        outputStream.write(this.key);
        outputStream.write(this.type.ordinal());
        outputStream.write(this.random.getBytes());
    }

    static BlobKey fromString(String stringRepresentation) {
        BlobType blobType;
        String[] splits = stringRepresentation.split("-");
        Preconditions.checkState((splits.length == 3 ? 1 : 0) != 0, (Object)"Blobs have to follow the format format (t|p)-key-random");
        char blobTypeCharacter = splits[0].charAt(0);
        switch (blobTypeCharacter) {
            case 't': {
                blobType = BlobType.TRANSIENT_BLOB;
                break;
            }
            case 'p': {
                blobType = BlobType.PERMANENT_BLOB;
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unknown blob type %s.", Character.valueOf(blobTypeCharacter)));
            }
        }
        byte[] key = StringUtils.hexStringToByte((String)splits[1]);
        byte[] random = StringUtils.hexStringToByte((String)splits[2]);
        return BlobKey.createKey(blobType, key, random);
    }

    private static String toString(BlobKey blobKey) {
        String typeString;
        switch (blobKey.type) {
            case TRANSIENT_BLOB: {
                typeString = "t-";
                break;
            }
            case PERMANENT_BLOB: {
                typeString = "p-";
                break;
            }
            default: {
                throw new IllegalStateException("Invalid BLOB type");
            }
        }
        return typeString + StringUtils.byteToHexString((byte[])blobKey.key) + "-" + blobKey.random.toString();
    }

    static enum BlobType {
        PERMANENT_BLOB,
        TRANSIENT_BLOB;

    }
}

