/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import akka.actor.Address;
import java.net.MalformedURLException;
import java.util.UUID;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.util.FlinkException;

public class LeaderConnectionInfo {
    private final String address;
    private final UUID leaderSessionID;
    private final String hostname;
    private final int port;

    public LeaderConnectionInfo(String address, UUID leaderSessionID) throws FlinkException {
        Address akkaAddress;
        this.address = address;
        this.leaderSessionID = leaderSessionID;
        try {
            akkaAddress = AkkaUtils.getAddressFromAkkaURL(address);
        }
        catch (MalformedURLException e) {
            throw new FlinkException("Could not extract the hostname from the given address '" + address + "'.", (Throwable)e);
        }
        this.hostname = akkaAddress.host().isDefined() ? (String)akkaAddress.host().get() : "localhost";
        this.port = akkaAddress.port().isDefined() ? (Integer)akkaAddress.port().get() : -1;
    }

    public String getAddress() {
        return this.address;
    }

    public UUID getLeaderSessionID() {
        return this.leaderSessionID;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return "LeaderConnectionInfo{address='" + this.address + '\'' + ", leaderSessionID=" + this.leaderSessionID + '}';
    }
}

