/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala;

import java.io.BufferedReader;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.scala.FlinkILoop;
import org.apache.flink.api.scala.FlinkShell;
import org.apache.flink.api.scala.FlinkShell$Config$;
import org.apache.flink.api.scala.FlinkShell$ExecutionMode$;
import org.apache.flink.api.scala.FlinkShell$YarnConfig$;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.CustomCommandLine;
import org.apache.flink.client.deployment.ClusterClientFactory;
import org.apache.flink.client.deployment.ClusterDescriptor;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.deployment.DefaultClusterClientServiceLoader;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.MiniClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.internal.settings.MutableSettings;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scala.tools.nsc.Settings;
import scopt.OptionDef;
import scopt.OptionParser;
import scopt.Read$;

public final class FlinkShell$ {
    public static final FlinkShell$ MODULE$;
    private Option<BufferedReader> bufferedReader;

    static {
        new FlinkShell$();
    }

    public Option<BufferedReader> bufferedReader() {
        return this.bufferedReader;
    }

    public void bufferedReader_$eq(Option<BufferedReader> x$1) {
        this.bufferedReader = x$1;
    }

    public void main(String[] args) {
        OptionParser<FlinkShell.Config> parser = new OptionParser<FlinkShell.Config>(){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Flink Scala Shell"}));
                this.cmd("local").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FlinkShell.Config apply(BoxedUnit x$1, FlinkShell.Config c) {
                        Enumeration.Value x$7 = FlinkShell$ExecutionMode$.MODULE$.LOCAL();
                        Option<String> x$8 = c.copy$default$1();
                        Option<Object> x$9 = c.copy$default$2();
                        Option<String[]> x$10 = c.copy$default$3();
                        Option<FlinkShell.YarnConfig> x$11 = c.copy$default$5();
                        Option<String> x$12 = c.copy$default$6();
                        return c.copy(x$8, x$9, x$10, x$7, x$11, x$12);
                    }
                }).text("Starts Flink scala shell with a local Flink cluster").children((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionDef[]{this.opt("addclasspath", Read$.MODULE$.stringRead()).abbr("a").valueName("<path/to/jar>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FlinkShell.Config apply(String x0$1, FlinkShell.Config x1$1) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
                        if (tuple2 != null) {
                            String x = (String)tuple2._1();
                            FlinkShell.Config c = (FlinkShell.Config)tuple2._2();
                            String[] xArray = x.split(":");
                            Option x$13 = Option$.MODULE$.apply((Object)xArray);
                            Option<String> x$14 = c.copy$default$1();
                            Option<Object> x$15 = c.copy$default$2();
                            Enumeration.Value x$16 = c.copy$default$4();
                            Option<FlinkShell.YarnConfig> x$17 = c.copy$default$5();
                            Option<String> x$18 = c.copy$default$6();
                            FlinkShell.Config config = c.copy(x$14, x$15, (Option<String[]>)x$13, x$16, x$17, x$18);
                            return config;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                }).text("Specifies additional jars to be used in Flink")}));
                this.cmd("remote").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FlinkShell.Config apply(BoxedUnit x$2, FlinkShell.Config c) {
                        Enumeration.Value x$19 = FlinkShell$ExecutionMode$.MODULE$.REMOTE();
                        Option<String> x$20 = c.copy$default$1();
                        Option<Object> x$21 = c.copy$default$2();
                        Option<String[]> x$22 = c.copy$default$3();
                        Option<FlinkShell.YarnConfig> x$23 = c.copy$default$5();
                        Option<String> x$24 = c.copy$default$6();
                        return c.copy(x$20, x$21, x$22, x$19, x$23, x$24);
                    }
                }).text("Starts Flink scala shell connecting to a remote cluster").children((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionDef[]{this.arg("<host>", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FlinkShell.Config apply(String h, FlinkShell.Config c) {
                        return c.copy((Option<String>)new Some((Object)h), c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6());
                    }
                }).text("Remote host name as string"), this.arg("<port>", Read$.MODULE$.intRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FlinkShell.Config apply(int p, FlinkShell.Config c) {
                        Some x$25 = new Some((Object)BoxesRunTime.boxToInteger((int)p));
                        Option<String> x$26 = c.copy$default$1();
                        Option<String[]> x$27 = c.copy$default$3();
                        Enumeration.Value x$28 = c.copy$default$4();
                        Option<FlinkShell.YarnConfig> x$29 = c.copy$default$5();
                        Option<String> x$30 = c.copy$default$6();
                        return c.copy(x$26, (Option<Object>)x$25, x$27, x$28, x$29, x$30);
                    }
                }).text("Remote port as integer\n"), this.opt("addclasspath", Read$.MODULE$.stringRead()).abbr("a").valueName("<path/to/jar>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FlinkShell.Config apply(String x0$2, FlinkShell.Config x1$2) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)x1$2);
                        if (tuple2 != null) {
                            String x = (String)tuple2._1();
                            FlinkShell.Config c = (FlinkShell.Config)tuple2._2();
                            String[] xArray = x.split(":");
                            Option x$31 = Option$.MODULE$.apply((Object)xArray);
                            Option<String> x$32 = c.copy$default$1();
                            Option<Object> x$33 = c.copy$default$2();
                            Enumeration.Value x$34 = c.copy$default$4();
                            Option<FlinkShell.YarnConfig> x$35 = c.copy$default$5();
                            Option<String> x$36 = c.copy$default$6();
                            FlinkShell.Config config = c.copy(x$32, x$33, (Option<String[]>)x$31, x$34, x$35, x$36);
                            return config;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                }).text("Specifies additional jars to be used in Flink")}));
                this.cmd("yarn").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FlinkShell.Config apply(BoxedUnit x$3, FlinkShell.Config c) {
                        Enumeration.Value x$37 = FlinkShell$ExecutionMode$.MODULE$.YARN();
                        None$ x$38 = None$.MODULE$;
                        Option<String> x$39 = c.copy$default$1();
                        Option<Object> x$40 = c.copy$default$2();
                        Option<String[]> x$41 = c.copy$default$3();
                        Option<String> x$42 = c.copy$default$6();
                        return c.copy(x$39, x$40, x$41, x$37, (Option<FlinkShell.YarnConfig>)x$38, x$42);
                    }
                }).text("Starts Flink scala shell connecting to a yarn cluster").children((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionDef[]{this.opt("jobManagerMemory", Read$.MODULE$.stringRead()).abbr("jm").valueName("arg").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FlinkShell.Config apply(String x, FlinkShell.Config c) {
                        FlinkShell.YarnConfig qual$1 = FlinkShell$.MODULE$.ensureYarnConfig(c);
                        Some x$43 = new Some((Object)x);
                        Option<String> x$44 = qual$1.copy$default$2();
                        Option<String> x$45 = qual$1.copy$default$3();
                        Option<Object> x$46 = qual$1.copy$default$4();
                        Option<String> x$47 = qual$1.copy$default$5();
                        Some x$48 = new Some((Object)qual$1.copy((Option<String>)x$43, x$44, x$45, x$46, x$47));
                        Option<String> x$49 = c.copy$default$1();
                        Option<Object> x$50 = c.copy$default$2();
                        Option<String[]> x$51 = c.copy$default$3();
                        Enumeration.Value x$52 = c.copy$default$4();
                        Option<String> x$53 = c.copy$default$6();
                        return c.copy(x$49, x$50, x$51, x$52, (Option<FlinkShell.YarnConfig>)x$48, x$53);
                    }
                }).text("Memory for JobManager container"), this.opt("name", Read$.MODULE$.stringRead()).abbr("nm").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FlinkShell.Config apply(String x, FlinkShell.Config c) {
                        FlinkShell.YarnConfig qual$2 = FlinkShell$.MODULE$.ensureYarnConfig(c);
                        Some x$54 = new Some((Object)x);
                        Option<String> x$55 = qual$2.copy$default$1();
                        Option<String> x$56 = qual$2.copy$default$3();
                        Option<Object> x$57 = qual$2.copy$default$4();
                        Option<String> x$58 = qual$2.copy$default$5();
                        Some x$59 = new Some((Object)qual$2.copy(x$55, (Option<String>)x$54, x$56, x$57, x$58));
                        Option<String> x$60 = c.copy$default$1();
                        Option<Object> x$61 = c.copy$default$2();
                        Option<String[]> x$62 = c.copy$default$3();
                        Enumeration.Value x$63 = c.copy$default$4();
                        Option<String> x$64 = c.copy$default$6();
                        return c.copy(x$60, x$61, x$62, x$63, (Option<FlinkShell.YarnConfig>)x$59, x$64);
                    }
                }).text("Set a custom name for the application on YARN"), this.opt("queue", Read$.MODULE$.stringRead()).abbr("qu").valueName("<arg>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FlinkShell.Config apply(String x, FlinkShell.Config c) {
                        FlinkShell.YarnConfig qual$3 = FlinkShell$.MODULE$.ensureYarnConfig(c);
                        Some x$65 = new Some((Object)x);
                        Option<String> x$66 = qual$3.copy$default$1();
                        Option<String> x$67 = qual$3.copy$default$2();
                        Option<Object> x$68 = qual$3.copy$default$4();
                        Option<String> x$69 = qual$3.copy$default$5();
                        Some x$70 = new Some((Object)qual$3.copy(x$66, x$67, (Option<String>)x$65, x$68, x$69));
                        Option<String> x$71 = c.copy$default$1();
                        Option<Object> x$72 = c.copy$default$2();
                        Option<String[]> x$73 = c.copy$default$3();
                        Enumeration.Value x$74 = c.copy$default$4();
                        Option<String> x$75 = c.copy$default$6();
                        return c.copy(x$71, x$72, x$73, x$74, (Option<FlinkShell.YarnConfig>)x$70, x$75);
                    }
                }).text("Specifies YARN queue"), this.opt("slots", Read$.MODULE$.intRead()).abbr("s").valueName("<arg>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FlinkShell.Config apply(int x, FlinkShell.Config c) {
                        FlinkShell.YarnConfig qual$4 = FlinkShell$.MODULE$.ensureYarnConfig(c);
                        Some x$76 = new Some((Object)BoxesRunTime.boxToInteger((int)x));
                        Option<String> x$77 = qual$4.copy$default$1();
                        Option<String> x$78 = qual$4.copy$default$2();
                        Option<String> x$79 = qual$4.copy$default$3();
                        Option<String> x$80 = qual$4.copy$default$5();
                        Some x$81 = new Some((Object)qual$4.copy(x$77, x$78, x$79, (Option<Object>)x$76, x$80));
                        Option<String> x$82 = c.copy$default$1();
                        Option<Object> x$83 = c.copy$default$2();
                        Option<String[]> x$84 = c.copy$default$3();
                        Enumeration.Value x$85 = c.copy$default$4();
                        Option<String> x$86 = c.copy$default$6();
                        return c.copy(x$82, x$83, x$84, x$85, (Option<FlinkShell.YarnConfig>)x$81, x$86);
                    }
                }).text("Number of slots per TaskManager"), this.opt("taskManagerMemory", Read$.MODULE$.stringRead()).abbr("tm").valueName("<arg>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FlinkShell.Config apply(String x, FlinkShell.Config c) {
                        FlinkShell.YarnConfig qual$5 = FlinkShell$.MODULE$.ensureYarnConfig(c);
                        Some x$87 = new Some((Object)x);
                        Option<String> x$88 = qual$5.copy$default$1();
                        Option<String> x$89 = qual$5.copy$default$2();
                        Option<String> x$90 = qual$5.copy$default$3();
                        Option<Object> x$91 = qual$5.copy$default$4();
                        Some x$92 = new Some((Object)qual$5.copy(x$88, x$89, x$90, x$91, (Option<String>)x$87));
                        Option<String> x$93 = c.copy$default$1();
                        Option<Object> x$94 = c.copy$default$2();
                        Option<String[]> x$95 = c.copy$default$3();
                        Enumeration.Value x$96 = c.copy$default$4();
                        Option<String> x$97 = c.copy$default$6();
                        return c.copy(x$93, x$94, x$95, x$96, (Option<FlinkShell.YarnConfig>)x$92, x$97);
                    }
                }).text("Memory per TaskManager container"), this.opt("addclasspath", Read$.MODULE$.stringRead()).abbr("a").valueName("<path/to/jar>").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FlinkShell.Config apply(String x0$3, FlinkShell.Config x1$3) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$3, (Object)x1$3);
                        if (tuple2 != null) {
                            String x = (String)tuple2._1();
                            FlinkShell.Config c = (FlinkShell.Config)tuple2._2();
                            String[] xArray = x.split(":");
                            Option x$98 = Option$.MODULE$.apply((Object)xArray);
                            Option<String> x$99 = c.copy$default$1();
                            Option<Object> x$100 = c.copy$default$2();
                            Enumeration.Value x$101 = c.copy$default$4();
                            Option<FlinkShell.YarnConfig> x$102 = c.copy$default$5();
                            Option<String> x$103 = c.copy$default$6();
                            FlinkShell.Config config = c.copy(x$99, x$100, (Option<String[]>)x$98, x$101, x$102, x$103);
                            return config;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                }).text("Specifies additional jars to be used in Flink")}));
                this.opt("configDir", Read$.MODULE$.stringRead()).optional().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FlinkShell.Config apply(String arg, FlinkShell.Config conf) {
                        Option x$104 = Option$.MODULE$.apply((Object)arg);
                        Option<String> x$105 = conf.copy$default$1();
                        Option<Object> x$106 = conf.copy$default$2();
                        Option<String[]> x$107 = conf.copy$default$3();
                        Enumeration.Value x$108 = conf.copy$default$4();
                        Option<FlinkShell.YarnConfig> x$109 = conf.copy$default$5();
                        return conf.copy(x$105, x$106, x$107, x$108, x$109, (Option<String>)x$104);
                    }
                }).text("The configuration directory.");
                this.help("help").abbr("h").text("Prints this usage text");
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new FlinkShell.Config(FlinkShell$Config$.MODULE$.apply$default$1(), FlinkShell$Config$.MODULE$.apply$default$2(), FlinkShell$Config$.MODULE$.apply$default$3(), FlinkShell$Config$.MODULE$.apply$default$4(), FlinkShell$Config$.MODULE$.apply$default$5(), FlinkShell$Config$.MODULE$.apply$default$6()));
        if (option instanceof Some) {
            Some some = (Some)option;
            FlinkShell.Config config = (FlinkShell.Config)some.x();
            this.startShell(config);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Predef$.MODULE$.println((Object)"Could not parse program arguments");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Internal
    public FlinkShell.YarnConfig ensureYarnConfig(FlinkShell.Config config) {
        Option<FlinkShell.YarnConfig> option;
        block4: {
            FlinkShell.YarnConfig yarnConfig;
            block3: {
                block2: {
                    FlinkShell.YarnConfig yarnConfig2;
                    option = config.yarnConfig();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    yarnConfig = yarnConfig2 = (FlinkShell.YarnConfig)some.x();
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                yarnConfig = new FlinkShell.YarnConfig(FlinkShell$YarnConfig$.MODULE$.apply$default$1(), FlinkShell$YarnConfig$.MODULE$.apply$default$2(), FlinkShell$YarnConfig$.MODULE$.apply$default$3(), FlinkShell$YarnConfig$.MODULE$.apply$default$4(), FlinkShell$YarnConfig$.MODULE$.apply$default$5());
            }
            return yarnConfig;
        }
        throw new MatchError(option);
    }

    private String getConfigDir(FlinkShell.Config config) {
        return (String)config.configDir().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return CliFrontend.getConfigurationDirectoryFromEnv();
            }
        });
    }

    private Configuration getGlobalConfig(FlinkShell.Config config) {
        String confDirPath = this.getConfigDir(config);
        File configDirectory = new File(confDirPath);
        return GlobalConfiguration.loadConfiguration((String)configDirectory.getAbsolutePath());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startShell(FlinkShell.Config config) {
        Tuple2 tuple22;
        Predef$.MODULE$.println((Object)"Starting Flink Shell:");
        Configuration flinkConfig = this.getGlobalConfig(config);
        Tuple2 tuple2 = this.liftedTree1$1(config, flinkConfig);
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        FlinkILoop repl = (FlinkILoop)((Object)tuple2._1());
        Option clusterClient = (Option)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)repl, (Object)clusterClient);
        FlinkILoop repl2 = (FlinkILoop)((Object)tuple23._1());
        Option clusterClient2 = (Option)tuple23._2();
        Settings settings = new Settings();
        ((MutableSettings.SettingValue)settings.usejavacp()).value_$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
        settings.Yreplsync().value_$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
        try {
            repl2.process(settings);
        }
        catch (Throwable throwable) {
            void var9_9;
            void var8_8;
            var8_8.closeInterpreter();
            void var12_12 = var9_9;
            if (var12_12 instanceof Some) {
                Some some = (Some)var12_12;
                ClusterClient clusterClient3 = (ClusterClient)some.x();
                clusterClient3.shutDownCluster();
                clusterClient3.close();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                throw throwable;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        repl2.closeInterpreter();
        Option option = clusterClient2;
        if (option instanceof Some) {
            Some some = (Some)option;
            ClusterClient clusterClient3 = (ClusterClient)some.x();
            clusterClient3.shutDownCluster();
            clusterClient3.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.println((Object)" good bye ..");
    }

    @Internal
    public Tuple2<Configuration, Option<ClusterClient<?>>> fetchConnectionInfo(FlinkShell.Config config, Configuration flinkConfig) {
        Enumeration.Value value;
        block7: {
            Tuple2<Configuration, Some<MiniClusterClient>> tuple2;
            block5: {
                block6: {
                    block4: {
                        value = config.executionMode();
                        Enumeration.Value value2 = FlinkShell$ExecutionMode$.MODULE$.LOCAL();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block4;
                        tuple2 = this.createLocalClusterAndConfig(flinkConfig);
                        break block5;
                    }
                    Enumeration.Value value4 = FlinkShell$ExecutionMode$.MODULE$.REMOTE();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block6;
                    tuple2 = this.createRemoteConfig(config, flinkConfig);
                    break block5;
                }
                Enumeration.Value value6 = FlinkShell$ExecutionMode$.MODULE$.YARN();
                Enumeration.Value value7 = value;
                if (value6 != null ? !value6.equals(value7) : value7 != null) break block7;
                tuple2 = this.createYarnClusterIfNeededAndGetConfig(config, flinkConfig);
            }
            return tuple2;
        }
        Enumeration.Value value8 = FlinkShell$ExecutionMode$.MODULE$.UNDEFINED();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            throw new IllegalArgumentException("please specify execution mode:\n[local | remote <host> <port> | yarn]");
        }
        throw new MatchError((Object)value);
    }

    private Tuple2<Configuration, Option<ClusterClient<Nothing$>>> createYarnClusterIfNeededAndGetConfig(FlinkShell.Config config, Configuration flinkConfig) {
        Option<FlinkShell.YarnConfig> option;
        block6: {
            Tuple2 tuple2;
            block7: {
                Option option2;
                block10: {
                    Tuple2<Configuration, None$> tuple22;
                    Option clusterClient;
                    block9: {
                        Configuration clusterConfig;
                        block8: {
                            Tuple2 tuple23;
                            Tuple2 tuple24;
                            block5: {
                                block4: {
                                    flinkConfig.setBoolean(DeploymentOptions.ATTACHED, true);
                                    option = config.yarnConfig();
                                    if (!(option instanceof Some)) break block4;
                                    tuple24 = this.deployNewYarnCluster(config, flinkConfig);
                                    break block5;
                                }
                                if (!None$.MODULE$.equals(option)) break block6;
                                tuple24 = new Tuple2((Object)flinkConfig, (Object)None$.MODULE$);
                            }
                            tuple2 = tuple24;
                            if (tuple2 == null) break block7;
                            Configuration clusterConfig2 = (Configuration)tuple2._1();
                            Option clusterClient2 = (Option)tuple2._2();
                            Tuple2 tuple25 = tuple23 = new Tuple2((Object)clusterConfig2, (Object)clusterClient2);
                            clusterConfig = (Configuration)tuple25._1();
                            clusterClient = (Option)tuple25._2();
                            option2 = clusterClient;
                            if (!(option2 instanceof Some)) break block8;
                            tuple22 = this.fetchDeployedYarnClusterInfo(config, clusterConfig, "yarn-cluster");
                            break block9;
                        }
                        if (!None$.MODULE$.equals(option2)) break block10;
                        tuple22 = this.fetchDeployedYarnClusterInfo(config, clusterConfig, "default");
                    }
                    Tuple2<Configuration, None$> tuple26 = tuple22;
                    if (tuple26 != null) {
                        Configuration effectiveConfig;
                        Configuration configuration;
                        Configuration effectiveConfig2 = configuration = (effectiveConfig = (Configuration)tuple26._1());
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Configuration: ").append((Object)effectiveConfig2).toString());
                        return new Tuple2((Object)effectiveConfig2, (Object)clusterClient);
                    }
                    throw new MatchError(tuple26);
                }
                throw new MatchError((Object)option2);
            }
            throw new MatchError((Object)tuple2);
        }
        throw new MatchError(option);
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Configuration, Some<ClusterClient<Nothing$>>> deployNewYarnCluster(FlinkShell.Config config, Configuration flinkConfig) {
        ClusterClient clusterClient;
        Configuration effectiveConfig = new Configuration(flinkConfig);
        String[] args = this.parseArgList(config, "yarn-cluster");
        String configurationDirectory = this.getConfigDir(config);
        CliFrontend frontend = new CliFrontend(effectiveConfig, CliFrontend.loadCustomCommandLines((Configuration)effectiveConfig, (String)configurationDirectory));
        Options commandOptions = CliFrontendParser.getRunCommandOptions();
        Options commandLineOptions = CliFrontendParser.mergeOptions((Options)commandOptions, (Options)frontend.getCustomCommandLineOptions());
        CommandLine commandLine = CliFrontendParser.parse((Options)commandLineOptions, (String[])args, (boolean)true);
        CustomCommandLine customCLI = frontend.validateAndGetActiveCommandLine(commandLine);
        effectiveConfig.addAll(customCLI.toConfiguration(commandLine));
        DefaultClusterClientServiceLoader serviceLoader = new DefaultClusterClientServiceLoader();
        ClusterClientFactory clientFactory = serviceLoader.getClusterClientFactory(effectiveConfig);
        ClusterDescriptor clusterDescriptor = clientFactory.createClusterDescriptor(effectiveConfig);
        ClusterSpecification clusterSpecification = clientFactory.getClusterSpecification(effectiveConfig);
        try {
            clusterClient = clusterDescriptor.deploySessionCluster(clusterSpecification).getClusterClient();
        }
        catch (Throwable throwable) {
            void var13_13;
            void var3_3;
            var3_3.set(DeploymentOptions.TARGET, (Object)"yarn-session");
            var13_13.close();
            throw throwable;
        }
        effectiveConfig.set(DeploymentOptions.TARGET, (Object)"yarn-session");
        clusterDescriptor.close();
        ClusterClient clusterClient2 = clusterClient;
        return new Tuple2((Object)effectiveConfig, (Object)new Some((Object)clusterClient2));
    }

    private Tuple2<Configuration, None$> fetchDeployedYarnClusterInfo(FlinkShell.Config config, Configuration flinkConfig, String mode) {
        Configuration effectiveConfig = new Configuration(flinkConfig);
        String[] args = this.parseArgList(config, mode);
        String configurationDirectory = this.getConfigDir(config);
        CliFrontend frontend = new CliFrontend(effectiveConfig, CliFrontend.loadCustomCommandLines((Configuration)effectiveConfig, (String)configurationDirectory));
        Options commandOptions = CliFrontendParser.getRunCommandOptions();
        Options commandLineOptions = CliFrontendParser.mergeOptions((Options)commandOptions, (Options)frontend.getCustomCommandLineOptions());
        CommandLine commandLine = CliFrontendParser.parse((Options)commandLineOptions, (String[])args, (boolean)true);
        CustomCommandLine customCLI = frontend.validateAndGetActiveCommandLine(commandLine);
        effectiveConfig.addAll(customCLI.toConfiguration(commandLine));
        return new Tuple2((Object)effectiveConfig, (Object)None$.MODULE$);
    }

    public String[] parseArgList(FlinkShell.Config config, String mode) {
        Option<FlinkShell.YarnConfig> option;
        block4: {
            String[] stringArray;
            block3: {
                ArrayBuffer args;
                block2: {
                    String string = mode;
                    String string2 = "default";
                    args = !(string != null ? !string.equals(string2) : string2 != null) ? (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$) : (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-m", mode}));
                    option = config.yarnConfig();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    FlinkShell.YarnConfig yarnConfig = (FlinkShell.YarnConfig)some.x();
                    yarnConfig.jobManagerMemory().foreach((Function1)new Serializable(args){
                        public static final long serialVersionUID = 0L;
                        private final ArrayBuffer args$1;

                        public final ArrayBuffer<String> apply(String jmMem) {
                            return this.args$1.$plus$plus$eq((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-yjm", jmMem.toString()})));
                        }
                        {
                            this.args$1 = args$1;
                        }
                    });
                    yarnConfig.taskManagerMemory().foreach((Function1)new Serializable(args){
                        public static final long serialVersionUID = 0L;
                        private final ArrayBuffer args$1;

                        public final ArrayBuffer<String> apply(String tmMem) {
                            return this.args$1.$plus$plus$eq((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-ytm", tmMem.toString()})));
                        }
                        {
                            this.args$1 = args$1;
                        }
                    });
                    yarnConfig.name().foreach((Function1)new Serializable(args){
                        public static final long serialVersionUID = 0L;
                        private final ArrayBuffer args$1;

                        public final ArrayBuffer<String> apply(String name) {
                            return this.args$1.$plus$plus$eq((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-ynm", name.toString()})));
                        }
                        {
                            this.args$1 = args$1;
                        }
                    });
                    yarnConfig.queue().foreach((Function1)new Serializable(args){
                        public static final long serialVersionUID = 0L;
                        private final ArrayBuffer args$1;

                        public final ArrayBuffer<String> apply(String queue) {
                            return this.args$1.$plus$plus$eq((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-yqu", queue.toString()})));
                        }
                        {
                            this.args$1 = args$1;
                        }
                    });
                    yarnConfig.slots().foreach((Function1)new Serializable(args){
                        public static final long serialVersionUID = 0L;
                        private final ArrayBuffer args$1;

                        public final ArrayBuffer<String> apply(int slots) {
                            return this.args$1.$plus$plus$eq((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-ys", ((Object)BoxesRunTime.boxToInteger((int)slots)).toString()})));
                        }
                        {
                            this.args$1 = args$1;
                        }
                    });
                    stringArray = (String[])args.toArray(ClassTag$.MODULE$.apply(String.class));
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                stringArray = (String[])args.toArray(ClassTag$.MODULE$.apply(String.class));
            }
            return stringArray;
        }
        throw new MatchError(option);
    }

    private Tuple2<Configuration, None$> createRemoteConfig(FlinkShell.Config config, Configuration flinkConfig) {
        if (config.host().isEmpty() || config.port().isEmpty()) {
            throw new IllegalArgumentException("<host> or <port> is not specified!");
        }
        Configuration effectiveConfig = new Configuration(flinkConfig);
        this.setJobManagerInfoToConfig(effectiveConfig, (String)config.host().get(), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)config.port().get())));
        effectiveConfig.set(DeploymentOptions.TARGET, (Object)"remote");
        effectiveConfig.setBoolean(DeploymentOptions.ATTACHED, true);
        return new Tuple2((Object)effectiveConfig, (Object)None$.MODULE$);
    }

    private Tuple2<Configuration, Some<MiniClusterClient>> createLocalClusterAndConfig(Configuration flinkConfig) {
        Configuration config = new Configuration(flinkConfig);
        config.setInteger(JobManagerOptions.PORT, 0);
        MiniCluster cluster = this.createLocalCluster(config);
        int port = ((URI)cluster.getRestAddress().get()).getPort();
        this.setJobManagerInfoToConfig(config, "localhost", Predef$.MODULE$.int2Integer(port));
        config.set(DeploymentOptions.TARGET, (Object)"remote");
        config.setBoolean(DeploymentOptions.ATTACHED, true);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nStarting local Flink cluster (host: localhost, port: ", ").\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)port)})));
        MiniClusterClient clusterClient = new MiniClusterClient(config, cluster);
        return new Tuple2((Object)config, (Object)new Some((Object)clusterClient));
    }

    private MiniCluster createLocalCluster(Configuration flinkConfig) {
        int numTaskManagers = flinkConfig.getInteger("local.number-taskmanager", 1);
        int numSlotsPerTaskManager = flinkConfig.getInteger(TaskManagerOptions.NUM_TASK_SLOTS);
        MiniClusterConfiguration miniClusterConfig = new MiniClusterConfiguration.Builder().setConfiguration(flinkConfig).setNumSlotsPerTaskManager(numSlotsPerTaskManager).setNumTaskManagers(numTaskManagers).build();
        MiniCluster cluster = new MiniCluster(miniClusterConfig);
        cluster.start();
        return cluster;
    }

    private void setJobManagerInfoToConfig(Configuration config, String host, Integer port) {
        config.setString(JobManagerOptions.ADDRESS, host);
        config.setInteger(JobManagerOptions.PORT, Predef$.MODULE$.Integer2int(port));
        config.setString(RestOptions.ADDRESS, host);
        config.setInteger(RestOptions.PORT, Predef$.MODULE$.Integer2int(port));
    }

    private final Tuple2 liftedTree1$1(FlinkShell.Config config$1, Configuration flinkConfig$1) {
        try {
            Tuple2<Configuration, Option<ClusterClient<?>>> tuple2;
            block4: {
                Option<BufferedReader> option;
                block7: {
                    FlinkILoop flinkILoop;
                    Option clusterClient;
                    block6: {
                        Configuration effectiveConfig;
                        block5: {
                            Tuple2 tuple22;
                            tuple2 = this.fetchConnectionInfo(config$1, flinkConfig$1);
                            if (tuple2 == null) break block4;
                            Configuration effectiveConfig2 = (Configuration)tuple2._1();
                            Option clusterClient2 = (Option)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)effectiveConfig2, (Object)clusterClient2);
                            effectiveConfig = (Configuration)tuple23._1();
                            clusterClient = (Option)tuple23._2();
                            String host = effectiveConfig.getString(JobManagerOptions.ADDRESS);
                            int port = effectiveConfig.getInteger(JobManagerOptions.PORT);
                            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nConnecting to Flink cluster (host: ", ", port: ", ").\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{host, BoxesRunTime.boxToInteger((int)port)})));
                            option = this.bufferedReader();
                            if (!(option instanceof Some)) break block5;
                            Some some = (Some)option;
                            BufferedReader reader = (BufferedReader)some.x();
                            StringWriter out = new StringWriter();
                            flinkILoop = new FlinkILoop(effectiveConfig, config$1.externalJars(), reader, new PrintWriter(out));
                            break block6;
                        }
                        if (!None$.MODULE$.equals(option)) break block7;
                        flinkILoop = new FlinkILoop(effectiveConfig, config$1.externalJars());
                    }
                    FlinkILoop repl = flinkILoop;
                    return new Tuple2((Object)repl, (Object)clusterClient);
                }
                throw new MatchError(option);
            }
            throw new MatchError(tuple2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{illegalArgumentException.getMessage()})));
            throw package$.MODULE$.exit();
        }
    }

    private FlinkShell$() {
        MODULE$ = this;
        this.bufferedReader = None$.MODULE$;
    }
}

