/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.tree.Evaluator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.linq4j.tree.Visitor;

public class ConstantExpression
extends Expression {
    public final Object value;

    public ConstantExpression(Type type, Object value) {
        super(ExpressionType.Constant, type);
        this.value = value;
        if (value != null && type instanceof Class) {
            Class clazz = (Class)type;
            Primitive primitive = Primitive.of(clazz);
            if (primitive != null) {
                clazz = primitive.boxClass;
            }
            if (!clazz.isInstance(value) && (clazz != Float.class && clazz != Double.class || !(value instanceof BigDecimal))) {
                throw new AssertionError((Object)("value " + value + " does not match type " + type));
            }
        }
    }

    @Override
    public Object evaluate(Evaluator evaluator) {
        return this.value;
    }

    @Override
    public Expression accept(Shuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        if (this.value == null) {
            if (!writer.requireParentheses(this, lprec, rprec)) {
                writer.append("(").append(this.type).append(") null");
            }
            return;
        }
        ConstantExpression.write(writer, this.value, this.type);
    }

    private static ExpressionWriter write(ExpressionWriter writer, Object value, Type type) {
        if (value == null) {
            return writer.append("null");
        }
        if (type == null && Primitive.isBox(type = value.getClass())) {
            type = Primitive.ofBox(type).primitiveClass;
        }
        if (value instanceof String) {
            ConstantExpression.escapeString(writer.getBuf(), (String)value);
            return writer;
        }
        Primitive primitive = Primitive.of(type);
        if (primitive != null) {
            switch (primitive) {
                case BYTE: {
                    return writer.append("(byte)").append(((Byte)value).intValue());
                }
                case CHAR: {
                    return writer.append("(char)").append((Object)((Character)value).charValue());
                }
                case SHORT: {
                    return writer.append("(short)").append(((Short)value).intValue());
                }
                case LONG: {
                    return writer.append(value).append("L");
                }
                case FLOAT: {
                    BigDecimal bigDecimal = value instanceof BigDecimal ? (BigDecimal)value : BigDecimal.valueOf(((Float)value).floatValue());
                    if (bigDecimal.precision() > 6) {
                        return writer.append("Float.intBitsToFloat(").append(Float.floatToIntBits(bigDecimal.floatValue())).append(")");
                    }
                    return writer.append(value).append("F");
                }
                case DOUBLE: {
                    BigDecimal bigDecimal = value instanceof BigDecimal ? (BigDecimal)value : BigDecimal.valueOf((Double)value);
                    if (bigDecimal.precision() > 10) {
                        return writer.append("Double.longBitsToDouble(").append(Double.doubleToLongBits(bigDecimal.doubleValue())).append("L)");
                    }
                    return writer.append(value).append("D");
                }
            }
            return writer.append(value);
        }
        Primitive primitive2 = Primitive.ofBox(type);
        if (primitive2 != null) {
            writer.append(primitive2.boxName + ".valueOf(");
            ConstantExpression.write(writer, value, primitive2.primitiveClass);
            return writer.append(")");
        }
        if (value instanceof Enum) {
            return writer.append(((Enum)value).getDeclaringClass()).append('.').append(((Enum)value).name());
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = ((BigDecimal)value).stripTrailingZeros();
            try {
                int scale = bigDecimal.scale();
                long exact = bigDecimal.scaleByPowerOfTen(scale).longValueExact();
                writer.append("new java.math.BigDecimal(").append(exact).append("L");
                if (scale != 0) {
                    writer.append(", ").append(scale);
                }
                return writer.append(")");
            }
            catch (ArithmeticException e) {
                return writer.append("new java.math.BigDecimal(\"").append(bigDecimal.toString()).append("\")");
            }
        }
        if (value instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)value;
            return writer.append("new java.math.BigInteger(\"").append(bigInteger.toString()).append("\")");
        }
        if (value instanceof Class) {
            Class clazz = (Class)value;
            return writer.append(clazz.getCanonicalName()).append(".class");
        }
        if (value instanceof Types.RecordType) {
            Types.RecordType recordType = (Types.RecordType)value;
            return writer.append(recordType.getName()).append(".class");
        }
        if (value.getClass().isArray()) {
            writer.append("new ").append(value.getClass().getComponentType());
            ConstantExpression.list(writer, Primitive.asList(value), "[] {\n", ",\n", "}");
            return writer;
        }
        if (value instanceof List) {
            if (((List)value).isEmpty()) {
                writer.append("java.util.Collections.EMPTY_LIST");
                return writer;
            }
            ConstantExpression.list(writer, (List)value, "java.util.Arrays.asList(", ",\n", ")");
            return writer;
        }
        if (value instanceof Map) {
            return ConstantExpression.writeMap(writer, (Map)value);
        }
        Constructor constructor = ConstantExpression.matchingConstructor(value);
        if (constructor != null) {
            writer.append("new ").append(value.getClass());
            ConstantExpression.list(writer, Arrays.stream(value.getClass().getFields()).map(field -> {
                try {
                    return field.get(value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList()), "(\n", ",\n", ")");
            return writer;
        }
        return writer.append(value);
    }

    private static void list(ExpressionWriter writer, List list, String begin, String sep, String end) {
        writer.begin(begin);
        for (int i = 0; i < list.size(); ++i) {
            Object value = list.get(i);
            if (i > 0) {
                writer.append(sep).indent();
            }
            ConstantExpression.write(writer, value, null);
        }
        writer.end(end);
    }

    private static ExpressionWriter writeMap(ExpressionWriter writer, Map map) {
        writer.append("org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap.");
        if (map.isEmpty()) {
            return writer.append("of()");
        }
        if (map.size() < 5) {
            return ConstantExpression.map(writer, map, "of(", ",\n", ")");
        }
        return ConstantExpression.map(writer, map, "builder().put(", ")\n.put(", ").build()");
    }

    private static ExpressionWriter map(ExpressionWriter writer, Map map, String begin, String entrySep, String end) {
        writer.append(begin);
        boolean comma = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            if (comma) {
                writer.append(entrySep).indent();
            }
            ConstantExpression.write(writer, entry.getKey(), null);
            writer.append(", ");
            ConstantExpression.write(writer, entry.getValue(), null);
            comma = true;
        }
        return writer.append(end);
    }

    private static Constructor matchingConstructor(Object value) {
        Field[] fields2 = value.getClass().getFields();
        for (Constructor<?> constructor : value.getClass().getConstructors()) {
            if (!ConstantExpression.argsMatchFields(fields2, constructor.getParameterTypes())) continue;
            return constructor;
        }
        return null;
    }

    private static boolean argsMatchFields(Field[] fields2, Class<?>[] parameterTypes) {
        if (parameterTypes.length != fields2.length) {
            return false;
        }
        for (int i = 0; i < fields2.length; ++i) {
            if (fields2[i].getType() == parameterTypes[i]) continue;
            return false;
        }
        return true;
    }

    private static void escapeString(StringBuilder buf, String s) {
        buf.append('\"');
        int n = s.length();
        int lastChar = 0;
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\r': {
                    if (lastChar == 10) break;
                    buf.append("\\r");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            lastChar = c;
        }
        buf.append('\"');
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConstantExpression that = (ConstantExpression)o;
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.type, this.value});
    }
}

