/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.accumulators.SerializedListAccumulator;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.Utils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.types.TypeInfoDataTypeConverter;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.types.Row;
import org.apache.flink.util.AbstractID;

@Experimental
public class TableUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Row> collectToList(Table table) throws Exception {
        List deserializedList;
        TableEnvironment tEnv = ((TableImpl)table).getTableEnvironment();
        String id = new AbstractID().toString();
        TableSchema schema = TableUtils.buildNewTableSchema(table);
        DataType rowDataType = schema.toRowDataType();
        TypeSerializer serializer = TypeInfoDataTypeConverter.fromDataTypeToTypeInfo((DataType)rowDataType).createSerializer(new ExecutionConfig());
        Utils.CollectHelper outputFormat = new Utils.CollectHelper(id, serializer);
        TableResultSink sink = new TableResultSink(schema, (Utils.CollectHelper<Row>)outputFormat);
        String tableName = table.toString();
        String sinkName = "tableResultSink_" + tableName + "_" + id;
        String jobName = "tableResultToList_" + tableName + "_" + id;
        try {
            tEnv.registerTableSink(sinkName, (TableSink)sink);
            tEnv.insertInto(sinkName, table);
            JobExecutionResult executionResult = tEnv.execute(jobName);
            ArrayList accResult = (ArrayList)executionResult.getAccumulatorResult(id);
            deserializedList = SerializedListAccumulator.deserializeList((ArrayList)accResult, (TypeSerializer)serializer);
        }
        finally {
            tEnv.dropTemporaryTable(sinkName);
        }
        return deserializedList;
    }

    private static TableSchema buildNewTableSchema(Table table) {
        TableSchema oldSchema = table.getSchema();
        DataType[] oldTypes = oldSchema.getFieldDataTypes();
        String[] oldNames = oldSchema.getFieldNames();
        TableSchema.Builder schemaBuilder = TableSchema.builder();
        for (int i = 0; i < oldSchema.getFieldCount(); ++i) {
            TimestampType timestampType;
            DataType fieldType = LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)oldTypes[i]));
            String fieldName = oldNames[i];
            if (fieldType.getLogicalType() instanceof TimestampType && !(timestampType = (TimestampType)fieldType.getLogicalType()).getKind().equals((Object)TimestampKind.REGULAR)) {
                schemaBuilder.field(fieldName, DataTypes.TIMESTAMP((int)3));
                continue;
            }
            schemaBuilder.field(fieldName, fieldType);
        }
        return schemaBuilder.build();
    }

    private static class TableResultSink
    implements AppendStreamTableSink<Row> {
        private final TableSchema schema;
        private final DataType rowType;
        private final Utils.CollectHelper<Row> outputFormat;

        TableResultSink(TableSchema schema, Utils.CollectHelper<Row> outputFormat) {
            this.schema = schema;
            this.rowType = schema.toRowDataType();
            this.outputFormat = outputFormat;
        }

        public DataType getConsumedDataType() {
            return this.rowType;
        }

        public TableSchema getTableSchema() {
            return this.schema;
        }

        public TableSink<Row> configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
            throw new UnsupportedOperationException("This sink is configured by passing a static schema when initiating");
        }

        public void emitDataStream(DataStream<Row> dataStream) {
            throw new UnsupportedOperationException("Deprecated method, use consumeDataStream instead");
        }

        public DataStreamSink<?> consumeDataStream(DataStream<Row> dataStream) {
            return dataStream.writeUsingOutputFormat(this.outputFormat).setParallelism(1).name("tableResult");
        }
    }
}

