/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.table.planner.delegation.ExecutorBase;
import org.apache.flink.table.planner.utils.ExecutorUtils;

@Internal
public class BatchExecutor
extends ExecutorBase {
    @VisibleForTesting
    public BatchExecutor(StreamExecutionEnvironment executionEnvironment) {
        super(executionEnvironment);
    }

    public JobExecutionResult execute(String jobName) throws Exception {
        StreamGraph streamGraph = this.getStreamGraph(jobName);
        return this.getExecutionEnvironment().execute(streamGraph);
    }

    @Override
    public StreamGraph getStreamGraph(String jobName) {
        StreamExecutionEnvironment execEnv = this.getExecutionEnvironment();
        ExecutorUtils.setBatchProperties(execEnv, this.tableConfig);
        StreamGraph streamGraph = execEnv.getStreamGraph();
        streamGraph.setJobName(this.getNonEmptyJobName(jobName));
        ExecutorUtils.setBatchProperties(streamGraph, this.tableConfig);
        return streamGraph;
    }
}

