/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.converter;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.LocalReferenceExpression;
import org.apache.flink.table.expressions.TimeIntervalUnit;
import org.apache.flink.table.expressions.TimePointUnit;
import org.apache.flink.table.expressions.TypeLiteralExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.RexFieldVariable;
import org.apache.flink.table.planner.expressions.RexNodeExpression;
import org.apache.flink.table.planner.expressions.converter.CallExpressionConvertRule;
import org.apache.flink.table.planner.expressions.converter.CustomizedConvertRule;
import org.apache.flink.table.planner.expressions.converter.DirectConvertRule;
import org.apache.flink.table.planner.expressions.converter.OverConvertRule;
import org.apache.flink.table.planner.expressions.converter.ScalarFunctionConvertRule;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.util.TimestampStringUtils;

public class ExpressionConverter
implements ExpressionVisitor<RexNode> {
    private static final List<CallExpressionConvertRule> FUNCTION_CONVERT_CHAIN = Arrays.asList(new ScalarFunctionConvertRule(), new OverConvertRule(), new DirectConvertRule(), new CustomizedConvertRule());
    private final RelBuilder relBuilder;
    private final FlinkTypeFactory typeFactory;

    public ExpressionConverter(RelBuilder relBuilder) {
        this.relBuilder = relBuilder;
        this.typeFactory = (FlinkTypeFactory)relBuilder.getRexBuilder().getTypeFactory();
    }

    public RexNode visit(CallExpression call) {
        for (CallExpressionConvertRule rule : FUNCTION_CONVERT_CHAIN) {
            Optional<RexNode> converted = rule.convert(call, this.newFunctionContext());
            if (!converted.isPresent()) continue;
            return converted.get();
        }
        throw new RuntimeException("Unknown call expression: " + call);
    }

    public RexNode visit(ValueLiteralExpression valueLiteral) {
        LogicalType type = LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)valueLiteral.getOutputDataType());
        RexBuilder rexBuilder = this.relBuilder.getRexBuilder();
        FlinkTypeFactory typeFactory = (FlinkTypeFactory)this.relBuilder.getTypeFactory();
        if (valueLiteral.isNull()) {
            return this.relBuilder.getRexBuilder().makeCast(typeFactory.createFieldTypeFromLogicalType(type), this.relBuilder.getRexBuilder().constantNull());
        }
        switch (type.getTypeRoot()) {
            case DECIMAL: {
                DecimalType dt = (DecimalType)type;
                BigDecimal bigDecimal = ExpressionConverter.extractValue(valueLiteral, BigDecimal.class);
                RelDataType decType = this.relBuilder.getTypeFactory().createSqlType(SqlTypeName.DECIMAL, dt.getPrecision(), dt.getScale());
                return this.relBuilder.getRexBuilder().makeExactLiteral(bigDecimal, decType);
            }
            case TINYINT: {
                return this.relBuilder.getRexBuilder().makeLiteral(ExpressionConverter.extractValue(valueLiteral, Object.class), typeFactory.createSqlType(SqlTypeName.TINYINT), true);
            }
            case SMALLINT: {
                return this.relBuilder.getRexBuilder().makeLiteral(ExpressionConverter.extractValue(valueLiteral, Object.class), typeFactory.createSqlType(SqlTypeName.SMALLINT), true);
            }
            case INTEGER: {
                return this.relBuilder.getRexBuilder().makeLiteral(ExpressionConverter.extractValue(valueLiteral, Object.class), typeFactory.createSqlType(SqlTypeName.INTEGER), true);
            }
            case BIGINT: {
                BigDecimal bigint = ExpressionConverter.extractValue(valueLiteral, BigDecimal.class);
                return this.relBuilder.getRexBuilder().makeBigintLiteral(bigint);
            }
            case FLOAT: {
                return this.relBuilder.getRexBuilder().makeApproxLiteral(ExpressionConverter.extractValue(valueLiteral, BigDecimal.class), this.relBuilder.getTypeFactory().createSqlType(SqlTypeName.FLOAT));
            }
            case DOUBLE: {
                return rexBuilder.makeApproxLiteral(ExpressionConverter.extractValue(valueLiteral, BigDecimal.class), this.relBuilder.getTypeFactory().createSqlType(SqlTypeName.DOUBLE));
            }
            case DATE: {
                return this.relBuilder.getRexBuilder().makeDateLiteral(DateString.fromCalendarFields(ExpressionConverter.valueAsCalendar(ExpressionConverter.extractValue(valueLiteral, Date.class))));
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return this.relBuilder.getRexBuilder().makeTimeLiteral(TimeString.fromCalendarFields(ExpressionConverter.valueAsCalendar(ExpressionConverter.extractValue(valueLiteral, Time.class))), 0);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)type;
                LocalDateTime datetime = ExpressionConverter.extractValue(valueLiteral, LocalDateTime.class);
                return this.relBuilder.getRexBuilder().makeTimestampLiteral(TimestampStringUtils.fromLocalDateTime(datetime), timestampType.getPrecision());
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType lzTs = (LocalZonedTimestampType)type;
                TimeZone timeZone = TimeZone.getTimeZone(this.relBuilder.getCluster().getPlanner().getContext().unwrap(FlinkContext.class).getTableConfig().getLocalTimeZone());
                Instant instant = ExpressionConverter.extractValue(valueLiteral, Instant.class);
                return this.relBuilder.getRexBuilder().makeTimestampWithLocalTimeZoneLiteral(TimestampStringUtils.fromLocalDateTime(LocalDateTime.ofInstant(instant, timeZone.toZoneId())), lzTs.getPrecision());
            }
            case INTERVAL_YEAR_MONTH: {
                return this.relBuilder.getRexBuilder().makeIntervalLiteral(BigDecimal.valueOf(ExpressionConverter.extractValue(valueLiteral, Integer.class).intValue()), new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, SqlParserPos.ZERO));
            }
            case INTERVAL_DAY_TIME: {
                return this.relBuilder.getRexBuilder().makeIntervalLiteral(BigDecimal.valueOf(ExpressionConverter.extractValue(valueLiteral, Long.class)), new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.SECOND, SqlParserPos.ZERO));
            }
        }
        Object object = ExpressionConverter.extractValue(valueLiteral, Object.class);
        if (object instanceof TimePointUnit) {
            TimeUnit value = ExpressionConverter.timePointUnitToTimeUnit((TimePointUnit)object);
            return this.relBuilder.getRexBuilder().makeFlag(value);
        }
        if (object instanceof TimeIntervalUnit) {
            TimeUnitRange value = ExpressionConverter.intervalUnitToUnitRange((TimeIntervalUnit)object);
            return this.relBuilder.getRexBuilder().makeFlag(value);
        }
        return this.relBuilder.literal(ExpressionConverter.extractValue(valueLiteral, Object.class));
    }

    public RexNode visit(FieldReferenceExpression fieldReference2) {
        return this.relBuilder.field(fieldReference2.getName());
    }

    public RexNode visit(TypeLiteralExpression typeLiteral) {
        throw new UnsupportedOperationException();
    }

    public RexNode visit(Expression other) {
        if (other instanceof RexNodeExpression) {
            return ((RexNodeExpression)other).getRexNode();
        }
        if (other instanceof LocalReferenceExpression) {
            LocalReferenceExpression local = (LocalReferenceExpression)other;
            return new RexFieldVariable(local.getName(), this.typeFactory.createFieldTypeFromLogicalType(LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)local.getOutputDataType())));
        }
        throw new UnsupportedOperationException(other.getClass().getSimpleName() + ":" + other.toString());
    }

    public static List<RexNode> toRexNodes(CallExpressionConvertRule.ConvertContext context, List<Expression> expr) {
        return expr.stream().map(context::toRexNode).collect(Collectors.toList());
    }

    private CallExpressionConvertRule.ConvertContext newFunctionContext() {
        return new CallExpressionConvertRule.ConvertContext(){

            @Override
            public RexNode toRexNode(Expression expr) {
                return (RexNode)expr.accept((ExpressionVisitor)ExpressionConverter.this);
            }

            @Override
            public RelBuilder getRelBuilder() {
                return ExpressionConverter.this.relBuilder;
            }

            @Override
            public FlinkTypeFactory getTypeFactory() {
                return ExpressionConverter.this.typeFactory;
            }
        };
    }

    private static TimeUnit timePointUnitToTimeUnit(TimePointUnit unit) {
        switch (unit) {
            case YEAR: {
                return TimeUnit.YEAR;
            }
            case MONTH: {
                return TimeUnit.MONTH;
            }
            case DAY: {
                return TimeUnit.DAY;
            }
            case HOUR: {
                return TimeUnit.HOUR;
            }
            case MINUTE: {
                return TimeUnit.MINUTE;
            }
            case SECOND: {
                return TimeUnit.SECOND;
            }
            case QUARTER: {
                return TimeUnit.QUARTER;
            }
            case WEEK: {
                return TimeUnit.WEEK;
            }
            case MILLISECOND: {
                return TimeUnit.MILLISECOND;
            }
            case MICROSECOND: {
                return TimeUnit.MICROSECOND;
            }
        }
        throw new UnsupportedOperationException("TimePointUnit is: " + unit);
    }

    private static TimeUnitRange intervalUnitToUnitRange(TimeIntervalUnit intervalUnit) {
        switch (intervalUnit) {
            case YEAR: {
                return TimeUnitRange.YEAR;
            }
            case YEAR_TO_MONTH: {
                return TimeUnitRange.YEAR_TO_MONTH;
            }
            case QUARTER: {
                return TimeUnitRange.QUARTER;
            }
            case MONTH: {
                return TimeUnitRange.MONTH;
            }
            case WEEK: {
                return TimeUnitRange.WEEK;
            }
            case DAY: {
                return TimeUnitRange.DAY;
            }
            case DAY_TO_HOUR: {
                return TimeUnitRange.DAY_TO_HOUR;
            }
            case DAY_TO_MINUTE: {
                return TimeUnitRange.DAY_TO_MINUTE;
            }
            case DAY_TO_SECOND: {
                return TimeUnitRange.DAY_TO_SECOND;
            }
            case HOUR: {
                return TimeUnitRange.HOUR;
            }
            case SECOND: {
                return TimeUnitRange.SECOND;
            }
            case HOUR_TO_MINUTE: {
                return TimeUnitRange.HOUR_TO_MINUTE;
            }
            case HOUR_TO_SECOND: {
                return TimeUnitRange.HOUR_TO_SECOND;
            }
            case MINUTE: {
                return TimeUnitRange.MINUTE;
            }
            case MINUTE_TO_SECOND: {
                return TimeUnitRange.MINUTE_TO_SECOND;
            }
        }
        throw new UnsupportedOperationException("TimeIntervalUnit is: " + intervalUnit);
    }

    public static <T> T extractValue(ValueLiteralExpression literal, Class<T> clazz) {
        Optional possibleObject = literal.getValueAs(Object.class);
        if (!possibleObject.isPresent()) {
            throw new TableException("Invalid literal.");
        }
        Object object = possibleObject.get();
        if (clazz.equals(BigDecimal.class)) {
            Optional possibleDecimal = literal.getValueAs(BigDecimal.class);
            if (possibleDecimal.isPresent()) {
                return possibleDecimal.get();
            }
            if (object instanceof Decimal) {
                return (T)((Decimal)object).toBigDecimal();
            }
        }
        return literal.getValueAs(clazz).orElseThrow(() -> new TableException("Unsupported literal class: " + clazz));
    }

    private static Calendar valueAsCalendar(Object value) {
        java.util.Date date = (java.util.Date)value;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }
}

