/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.BinaryStringUtil;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.runtime.typeutils.BinaryStringTypeInfo;
import org.apache.flink.util.FlinkRuntimeException;

public final class ListAggWithRetractAggFunction
extends AggregateFunction<BinaryString, ListAggWithRetractAccumulator> {
    private static final long serialVersionUID = -2836795091288790955L;
    private static final BinaryString lineDelimiter = BinaryString.fromString((String)",");

    public ListAggWithRetractAccumulator createAccumulator() {
        return new ListAggWithRetractAccumulator();
    }

    public void accumulate(ListAggWithRetractAccumulator acc, BinaryString value) throws Exception {
        if (value != null) {
            acc.list.add((Object)value);
        }
    }

    public void retract(ListAggWithRetractAccumulator acc, BinaryString value) throws Exception {
        if (value != null && !acc.list.remove((Object)value)) {
            acc.retractList.add((Object)value);
        }
    }

    public void merge(ListAggWithRetractAccumulator acc, Iterable<ListAggWithRetractAccumulator> its) throws Exception {
        for (ListAggWithRetractAccumulator otherAcc : its) {
            Object binaryString2;
            ArrayList<BinaryString> buffer = new ArrayList<BinaryString>();
            for (Object binaryString2 : acc.list.get()) {
                buffer.add((BinaryString)binaryString2);
            }
            for (Object binaryString2 : otherAcc.list.get()) {
                buffer.add((BinaryString)binaryString2);
            }
            ArrayList<BinaryString> retractBuffer = new ArrayList<BinaryString>();
            for (BinaryString binaryString3 : acc.retractList.get()) {
                retractBuffer.add(binaryString3);
            }
            binaryString2 = otherAcc.retractList.get().iterator();
            while (binaryString2.hasNext()) {
                BinaryString binaryString3;
                binaryString3 = (BinaryString)binaryString2.next();
                retractBuffer.add(binaryString3);
            }
            ArrayList<BinaryString> newRetractBuffer = new ArrayList<BinaryString>();
            for (BinaryString binaryString4 : retractBuffer) {
                if (buffer.remove(binaryString4)) continue;
                newRetractBuffer.add(binaryString4);
            }
            acc.list.clear();
            acc.list.addAll(buffer);
            acc.retractList.clear();
            acc.retractList.addAll(newRetractBuffer);
        }
    }

    public BinaryString getValue(ListAggWithRetractAccumulator acc) {
        try {
            Iterable accList = acc.list.get();
            if (accList == null || !accList.iterator().hasNext()) {
                return null;
            }
            return BinaryStringUtil.concatWs((BinaryString)lineDelimiter, (Iterable)accList);
        }
        catch (Exception e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public void resetAccumulator(ListAggWithRetractAccumulator acc) {
        acc.list.clear();
        acc.retractList.clear();
    }

    public static class ListAggWithRetractAccumulator {
        public ListView<BinaryString> list = new ListView((TypeInformation)BinaryStringTypeInfo.INSTANCE);
        public ListView<BinaryString> retractList = new ListView((TypeInformation)BinaryStringTypeInfo.INSTANCE);

        @VisibleForTesting
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListAggWithRetractAccumulator that = (ListAggWithRetractAccumulator)o;
            return Objects.equals(this.list, that.list) && Objects.equals(this.retractList, that.retractList);
        }
    }
}

