/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.sql.parser.ddl.SqlAlterDatabase;
import org.apache.flink.sql.parser.ddl.SqlAlterFunction;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;
import org.apache.flink.sql.parser.ddl.SqlAlterTableProperties;
import org.apache.flink.sql.parser.ddl.SqlAlterTableRename;
import org.apache.flink.sql.parser.ddl.SqlCreateDatabase;
import org.apache.flink.sql.parser.ddl.SqlCreateFunction;
import org.apache.flink.sql.parser.ddl.SqlCreateTable;
import org.apache.flink.sql.parser.ddl.SqlDropDatabase;
import org.apache.flink.sql.parser.ddl.SqlDropFunction;
import org.apache.flink.sql.parser.ddl.SqlDropTable;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.SqlTableOption;
import org.apache.flink.sql.parser.ddl.SqlUseCatalog;
import org.apache.flink.sql.parser.ddl.SqlUseDatabase;
import org.apache.flink.sql.parser.dml.RichSqlInsert;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.UseCatalogOperation;
import org.apache.flink.table.operations.UseDatabaseOperation;
import org.apache.flink.table.operations.ddl.AlterDatabaseOperation;
import org.apache.flink.table.operations.ddl.AlterFunctionOperation;
import org.apache.flink.table.operations.ddl.AlterTablePropertiesOperation;
import org.apache.flink.table.operations.ddl.AlterTableRenameOperation;
import org.apache.flink.table.operations.ddl.CreateDatabaseOperation;
import org.apache.flink.table.operations.ddl.CreateFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.operations.ddl.CreateTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.DropDatabaseOperation;
import org.apache.flink.table.operations.ddl.DropFunctionOperation;
import org.apache.flink.table.operations.ddl.DropTableOperation;
import org.apache.flink.table.operations.ddl.DropTempSystemFunctionOperation;
import org.apache.flink.table.planner.calcite.FlinkCalciteSqlValidator;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.operations.SqlConversionException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.StringUtils;

public class SqlToOperationConverter {
    private final FlinkPlannerImpl flinkPlanner;
    private final CatalogManager catalogManager;

    private SqlToOperationConverter(FlinkPlannerImpl flinkPlanner, CatalogManager catalogManager) {
        this.flinkPlanner = flinkPlanner;
        this.catalogManager = catalogManager;
    }

    public static Optional<Operation> convert(FlinkPlannerImpl flinkPlanner, CatalogManager catalogManager, SqlNode sqlNode) {
        SqlNode validated = flinkPlanner.validate(sqlNode);
        SqlToOperationConverter converter = new SqlToOperationConverter(flinkPlanner, catalogManager);
        if (validated instanceof SqlCreateTable) {
            return Optional.of(converter.convertCreateTable((SqlCreateTable)validated));
        }
        if (validated instanceof SqlDropTable) {
            return Optional.of(converter.convertDropTable((SqlDropTable)validated));
        }
        if (validated instanceof SqlAlterTable) {
            return Optional.of(converter.convertAlterTable((SqlAlterTable)validated));
        }
        if (validated instanceof SqlCreateFunction) {
            return Optional.of(converter.convertCreateFunction((SqlCreateFunction)validated));
        }
        if (validated instanceof SqlAlterFunction) {
            return Optional.of(converter.convertAlterFunction((SqlAlterFunction)validated));
        }
        if (validated instanceof SqlDropFunction) {
            return Optional.of(converter.convertDropFunction((SqlDropFunction)validated));
        }
        if (validated instanceof RichSqlInsert) {
            return Optional.of(converter.convertSqlInsert((RichSqlInsert)validated));
        }
        if (validated instanceof SqlUseCatalog) {
            return Optional.of(converter.convertUseCatalog((SqlUseCatalog)validated));
        }
        if (validated instanceof SqlUseDatabase) {
            return Optional.of(converter.convertUseDatabase((SqlUseDatabase)validated));
        }
        if (validated instanceof SqlCreateDatabase) {
            return Optional.of(converter.convertCreateDatabase((SqlCreateDatabase)validated));
        }
        if (validated instanceof SqlDropDatabase) {
            return Optional.of(converter.convertDropDatabase((SqlDropDatabase)validated));
        }
        if (validated instanceof SqlAlterDatabase) {
            return Optional.of(converter.convertAlterDatabase((SqlAlterDatabase)validated));
        }
        if (validated.getKind().belongsTo(SqlKind.QUERY)) {
            return Optional.of(converter.convertSqlQuery(validated));
        }
        return Optional.empty();
    }

    private Operation convertCreateTable(SqlCreateTable sqlCreateTable) {
        if (sqlCreateTable.getPrimaryKeyList().size() > 0 || sqlCreateTable.getUniqueKeysList().size() > 0) {
            throw new SqlConversionException("Primary key and unique key are not supported yet.");
        }
        HashMap properties = new HashMap();
        sqlCreateTable.getPropertyList().getList().forEach(p -> properties.put(((SqlTableOption)p).getKeyString(), ((SqlTableOption)p).getValueString()));
        TableSchema tableSchema = this.createTableSchema(sqlCreateTable);
        String tableComment = sqlCreateTable.getComment().map(comment -> comment.getNlsString().getValue()).orElse(null);
        List partitionKeys = sqlCreateTable.getPartitionKeyList().getList().stream().map(p -> ((SqlIdentifier)p).getSimple()).collect(Collectors.toList());
        CatalogTableImpl catalogTable = new CatalogTableImpl(tableSchema, partitionKeys, properties, tableComment);
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlCreateTable.fullTableName());
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new CreateTableOperation(identifier, (CatalogTable)catalogTable, sqlCreateTable.isIfNotExists());
    }

    private Operation convertDropTable(SqlDropTable sqlDropTable) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlDropTable.fullTableName());
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new DropTableOperation(identifier, sqlDropTable.getIfExists());
    }

    private Operation convertAlterTable(SqlAlterTable sqlAlterTable) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlAlterTable.fullTableName());
        ObjectIdentifier tableIdentifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        if (sqlAlterTable instanceof SqlAlterTableRename) {
            UnresolvedIdentifier newUnresolvedIdentifier = UnresolvedIdentifier.of((String[])((SqlAlterTableRename)sqlAlterTable).fullNewTableName());
            ObjectIdentifier newTableIdentifier = this.catalogManager.qualifyIdentifier(newUnresolvedIdentifier);
            return new AlterTableRenameOperation(tableIdentifier, newTableIdentifier);
        }
        if (sqlAlterTable instanceof SqlAlterTableProperties) {
            Optional optionalCatalogTable = this.catalogManager.getTable(tableIdentifier);
            if (optionalCatalogTable.isPresent() && !((CatalogManager.TableLookupResult)optionalCatalogTable.get()).isTemporary()) {
                CatalogTable originalCatalogTable = (CatalogTable)((CatalogManager.TableLookupResult)optionalCatalogTable.get()).getTable();
                HashMap properties = new HashMap();
                properties.putAll(originalCatalogTable.getProperties());
                ((SqlAlterTableProperties)sqlAlterTable).getPropertyList().getList().forEach(p -> properties.put(((SqlTableOption)p).getKeyString(), ((SqlTableOption)p).getValueString()));
                CatalogTableImpl catalogTable = new CatalogTableImpl(originalCatalogTable.getSchema(), originalCatalogTable.getPartitionKeys(), properties, originalCatalogTable.getComment());
                return new AlterTablePropertiesOperation(tableIdentifier, (CatalogTable)catalogTable);
            }
            throw new ValidationException(String.format("Table %s doesn't exist or is a temporary table.", tableIdentifier.toString()));
        }
        return null;
    }

    private Operation convertCreateFunction(SqlCreateFunction sqlCreateFunction) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlCreateFunction.getFunctionIdentifier());
        if (sqlCreateFunction.isSystemFunction()) {
            return new CreateTempSystemFunctionOperation(unresolvedIdentifier.getObjectName(), sqlCreateFunction.getFunctionClassName().getValueAs(String.class), sqlCreateFunction.isIfNotExists());
        }
        FunctionLanguage language = this.parseLanguage(sqlCreateFunction.getFunctionLanguage());
        CatalogFunctionImpl catalogFunction = new CatalogFunctionImpl(sqlCreateFunction.getFunctionClassName().getValueAs(String.class), language);
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new CreateFunctionOperation(identifier, (CatalogFunction)catalogFunction, sqlCreateFunction.isIfNotExists(), sqlCreateFunction.isTemporary());
    }

    private Operation convertAlterFunction(SqlAlterFunction sqlAlterFunction) {
        if (sqlAlterFunction.isSystemFunction()) {
            throw new ValidationException("Alter temporary system function is not supported");
        }
        FunctionLanguage language = this.parseLanguage(sqlAlterFunction.getFunctionLanguage());
        CatalogFunctionImpl catalogFunction = new CatalogFunctionImpl(sqlAlterFunction.getFunctionClassName().getValueAs(String.class), language);
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlAlterFunction.getFunctionIdentifier());
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new AlterFunctionOperation(identifier, (CatalogFunction)catalogFunction, sqlAlterFunction.isIfExists(), sqlAlterFunction.isTemporary());
    }

    private Operation convertDropFunction(SqlDropFunction sqlDropFunction) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlDropFunction.getFunctionIdentifier());
        if (sqlDropFunction.isSystemFunction()) {
            return new DropTempSystemFunctionOperation(unresolvedIdentifier.getObjectName(), sqlDropFunction.getIfExists());
        }
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return new DropFunctionOperation(identifier, sqlDropFunction.getIfExists(), sqlDropFunction.isTemporary());
    }

    private FunctionLanguage parseLanguage(String languageString) {
        FunctionLanguage language;
        if (StringUtils.isNullOrWhitespaceOnly((String)languageString)) {
            return FunctionLanguage.JAVA;
        }
        try {
            language = FunctionLanguage.valueOf((String)languageString);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(String.format("Unrecognized function language string %s", languageString), e);
        }
        if (language.equals((Object)FunctionLanguage.PYTHON)) {
            throw new UnsupportedOperationException("Only function language JAVA and SCALA are supported for now.");
        }
        return language;
    }

    private Operation convertSqlInsert(RichSqlInsert insert) {
        ImmutableList<String> targetTablePath = ((SqlIdentifier)insert.getTargetTable()).names;
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])targetTablePath.toArray(new String[0]));
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        PlannerQueryOperation query = (PlannerQueryOperation)SqlToOperationConverter.convert(this.flinkPlanner, this.catalogManager, insert.getSource()).orElseThrow(() -> new TableException("Unsupported node type " + insert.getSource().getClass().getSimpleName()));
        return new CatalogSinkModifyOperation(identifier, (QueryOperation)query, insert.getStaticPartitionKVs(), insert.isOverwrite());
    }

    private Operation convertUseCatalog(SqlUseCatalog useCatalog) {
        return new UseCatalogOperation(useCatalog.getCatalogName());
    }

    private Operation convertUseDatabase(SqlUseDatabase useDatabase) {
        String[] fullDatabaseName = useDatabase.fullDatabaseName();
        if (fullDatabaseName.length > 2) {
            throw new SqlConversionException("use database identifier format error");
        }
        String catalogName = fullDatabaseName.length == 2 ? fullDatabaseName[0] : this.catalogManager.getCurrentCatalog();
        String databaseName = fullDatabaseName.length == 2 ? fullDatabaseName[1] : fullDatabaseName[0];
        return new UseDatabaseOperation(catalogName, databaseName);
    }

    private Operation convertCreateDatabase(SqlCreateDatabase sqlCreateDatabase) {
        String[] fullDatabaseName = sqlCreateDatabase.fullDatabaseName();
        if (fullDatabaseName.length > 2) {
            throw new SqlConversionException("create database identifier format error");
        }
        String catalogName = fullDatabaseName.length == 1 ? this.catalogManager.getCurrentCatalog() : fullDatabaseName[0];
        String databaseName = fullDatabaseName.length == 1 ? fullDatabaseName[0] : fullDatabaseName[1];
        boolean ignoreIfExists = sqlCreateDatabase.isIfNotExists();
        String databaseComment = sqlCreateDatabase.getComment().map(comment -> comment.getNlsString().getValue()).orElse(null);
        HashMap properties = new HashMap();
        sqlCreateDatabase.getPropertyList().getList().forEach(p -> properties.put(((SqlTableOption)p).getKeyString(), ((SqlTableOption)p).getValueString()));
        CatalogDatabaseImpl catalogDatabase = new CatalogDatabaseImpl(properties, databaseComment);
        return new CreateDatabaseOperation(catalogName, databaseName, (CatalogDatabase)catalogDatabase, ignoreIfExists);
    }

    private Operation convertDropDatabase(SqlDropDatabase sqlDropDatabase) {
        String[] fullDatabaseName = sqlDropDatabase.fullDatabaseName();
        if (fullDatabaseName.length > 2) {
            throw new SqlConversionException("drop database identifier format error");
        }
        String catalogName = fullDatabaseName.length == 1 ? this.catalogManager.getCurrentCatalog() : fullDatabaseName[0];
        String databaseName = fullDatabaseName.length == 1 ? fullDatabaseName[0] : fullDatabaseName[1];
        return new DropDatabaseOperation(catalogName, databaseName, sqlDropDatabase.getIfExists(), sqlDropDatabase.isCascade());
    }

    private Operation convertAlterDatabase(SqlAlterDatabase sqlAlterDatabase) {
        CatalogDatabase originCatalogDatabase;
        String[] fullDatabaseName = sqlAlterDatabase.fullDatabaseName();
        if (fullDatabaseName.length > 2) {
            throw new SqlConversionException("alter database identifier format error");
        }
        String catalogName = fullDatabaseName.length == 1 ? this.catalogManager.getCurrentCatalog() : fullDatabaseName[0];
        String databaseName = fullDatabaseName.length == 1 ? fullDatabaseName[0] : fullDatabaseName[1];
        HashMap properties = new HashMap();
        Optional catalog = this.catalogManager.getCatalog(catalogName);
        if (catalog.isPresent()) {
            try {
                originCatalogDatabase = ((Catalog)catalog.get()).getDatabase(databaseName);
                properties.putAll(originCatalogDatabase.getProperties());
            }
            catch (DatabaseNotExistException e) {
                throw new SqlConversionException(String.format("Database %s not exists", databaseName), e);
            }
        } else {
            throw new SqlConversionException(String.format("Catalog %s not exists", catalogName));
        }
        sqlAlterDatabase.getPropertyList().getList().forEach(p -> properties.put(((SqlTableOption)p).getKeyString(), ((SqlTableOption)p).getValueString()));
        CatalogDatabaseImpl catalogDatabase = new CatalogDatabaseImpl(properties, originCatalogDatabase.getComment());
        return new AlterDatabaseOperation(catalogName, databaseName, (CatalogDatabase)catalogDatabase);
    }

    private Operation convertSqlQuery(SqlNode node) {
        return this.toQueryOperation(this.flinkPlanner, node);
    }

    private TableSchema createTableSchema(SqlCreateTable sqlCreateTable) {
        SqlNodeList columnList = sqlCreateTable.getColumnList();
        HashMap<String, RelDataType> physicalFieldNamesToTypes = new HashMap<String, RelDataType>();
        FlinkCalciteSqlValidator validator = this.flinkPlanner.getOrCreateSqlValidator();
        for (SqlNode node : columnList.getList()) {
            if (!(node instanceof SqlTableColumn)) continue;
            SqlTableColumn column = (SqlTableColumn)node;
            RelDataType relType = column.getType().deriveType(validator, column.getType().getNullable());
            String name = column.getName().getSimple();
            physicalFieldNamesToTypes.put(name, relType);
        }
        HashMap<String, RelDataType> allFieldNamesToTypes = new HashMap<String, RelDataType>(physicalFieldNamesToTypes);
        TableSchema.Builder builder = new TableSchema.Builder();
        for (SqlNode node : columnList) {
            if (node instanceof SqlTableColumn) {
                SqlTableColumn column = (SqlTableColumn)node;
                String fieldName = column.getName().getSimple();
                assert (physicalFieldNamesToTypes.containsKey(fieldName));
                builder.field(fieldName, TypeConversions.fromLogicalToDataType((LogicalType)FlinkTypeFactory.toLogicalType((RelDataType)physicalFieldNamesToTypes.get(fieldName))));
                continue;
            }
            if (node instanceof SqlBasicCall) {
                SqlBasicCall call = (SqlBasicCall)node;
                SqlNode validatedExpr = validator.validateParameterizedExpression((SqlNode)call.operand(0), (Map<String, RelDataType>)physicalFieldNamesToTypes);
                RelDataType validatedType = validator.getValidatedNodeType(validatedExpr);
                builder.field(((SqlNode)call.operand(1)).toString(), TypeConversions.fromLogicalToDataType((LogicalType)FlinkTypeFactory.toLogicalType(validatedType)), this.getQuotedSqlString(validatedExpr));
                String fieldName = ((SqlNode)call.operand(1)).toString();
                allFieldNamesToTypes.put(fieldName, validatedType);
                continue;
            }
            throw new TableException("Unexpected table column type!");
        }
        sqlCreateTable.getWatermark().ifPresent(watermark -> {
            String rowtimeAttribute = watermark.getEventTimeColumnName().toString();
            SqlNode expression2 = watermark.getWatermarkStrategy();
            SqlNode validated = validator.validateParameterizedExpression(expression2, allFieldNamesToTypes);
            RelDataType validatedType = validator.getValidatedNodeType(validated);
            DataType exprDataType = TypeConversions.fromLogicalToDataType((LogicalType)FlinkTypeFactory.toLogicalType(validatedType));
            builder.watermark(rowtimeAttribute, this.getQuotedSqlString(validated), exprDataType);
        });
        return builder.build();
    }

    private String getQuotedSqlString(SqlNode sqlNode) {
        SqlParser.Config parserConfig = this.flinkPlanner.config().getParserConfig();
        CalciteSqlDialect dialect = new CalciteSqlDialect(SqlDialect.EMPTY_CONTEXT.withQuotedCasing(parserConfig.unquotedCasing()).withConformance(parserConfig.conformance()).withUnquotedCasing(parserConfig.unquotedCasing()).withIdentifierQuoteString(parserConfig.quoting().string));
        return sqlNode.toSqlString(dialect).getSql();
    }

    private PlannerQueryOperation toQueryOperation(FlinkPlannerImpl planner, SqlNode validated) {
        RelRoot relational = planner.rel(validated);
        return new PlannerQueryOperation(relational.project());
    }
}

