/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.time.Duration;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.utils.WindowEmitStrategy$;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.triggers.ElementTriggers;
import org.apache.flink.table.runtime.operators.window.triggers.EventTimeTriggers;
import org.apache.flink.table.runtime.operators.window.triggers.ProcessingTimeTriggers;
import org.apache.flink.table.runtime.operators.window.triggers.Trigger;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u0001\u0003\u0001E\u0011!cV5oI><X)\\5u'R\u0014\u0018\r^3hs*\u00111\u0001B\u0001\u0006kRLGn\u001d\u0006\u0003\u000b\u0019\tA\u0001\u001d7b]*\u0011q\u0001C\u0001\ba2\fgN\\3s\u0015\tI!\"A\u0003uC\ndWM\u0003\u0002\f\u0019\u0005)a\r\\5oW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g\u0011!I\u0002A!A!\u0002\u0013Q\u0012aC5t\u000bZ,g\u000e\u001e+j[\u0016\u0004\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\t1\fgn\u001a\u0006\u0002?\u0005!!.\u0019<b\u0013\t\tCDA\u0004C_>dW-\u00198\t\u0011\r\u0002!\u0011!Q\u0001\ni\tq\"[:TKN\u001c\u0018n\u001c8XS:$wn\u001e\u0005\tK\u0001\u0011\t\u0011)A\u0005M\u0005qQ-\u0019:ms\u001aK'/\u001a#fY\u0006L\bCA\u000e(\u0013\tACD\u0001\u0003M_:<\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002+\u0015\f'\u000f\\=GSJ,G)\u001a7bs\u0016s\u0017M\u00197fI\"AA\u0006\u0001B\u0001B\u0003%a%A\u0007mCR,g)\u001b:f\t\u0016d\u0017-\u001f\u0005\t]\u0001\u0011\t\u0011)A\u00055\u0005!B.\u0019;f\r&\u0014X\rR3mCf,e.\u00192mK\u0012D\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u000eC2dwn\u001e'bi\u0016tWm]:\t\u000bI\u0002A\u0011A\u001a\u0002\rqJg.\u001b;?)!!dg\u000e\u001d:umb\u0004CA\u001b\u0001\u001b\u0005\u0011\u0001\"B\r2\u0001\u0004Q\u0002\"B\u00122\u0001\u0004Q\u0002\"B\u00132\u0001\u00041\u0003\"\u0002\u00162\u0001\u0004Q\u0002\"\u0002\u00172\u0001\u00041\u0003\"\u0002\u00182\u0001\u0004Q\u0002\"\u0002\u00192\u0001\u00041\u0003\"\u0002 \u0001\t\u0003y\u0014\u0001E4fi\u0006cGn\\<MCR,g.Z:t+\u00051\u0003\"B!\u0001\t\u0013\u0011\u0015aD2iK\u000e\\g+\u00197jI\u0006$\u0018n\u001c8\u0015\u0003\r\u0003\"a\u0005#\n\u0005\u0015#\"\u0001B+oSRDQa\u0012\u0001\u0005\u0002!\u000ba\u0002\u001d:pIV\u001cW-\u00169eCR,7/F\u0001\u001b\u0011\u0015Q\u0005\u0001\"\u0001L\u0003)9W\r\u001e+sS\u001e<WM]\u000b\u0002\u0019B\u0019QJ\u0016-\u000e\u00039S!a\u0014)\u0002\u0011Q\u0014\u0018nZ4feNT!!\u0015*\u0002\r]Lg\u000eZ8x\u0015\t\u0019F+A\u0005pa\u0016\u0014\u0018\r^8sg*\u0011Q\u000bC\u0001\beVtG/[7f\u0013\t9fJA\u0004Ue&<w-\u001a:\u0011\u0005eSV\"\u0001)\n\u0005m\u0003&A\u0003+j[\u0016<\u0016N\u001c3po\")Q\f\u0001C!=\u0006AAo\\*ue&tw\rF\u0001`!\t\u00017M\u0004\u0002\u0014C&\u0011!\rF\u0001\u0007!J,G-\u001a4\n\u0005\u0011,'AB*ue&twM\u0003\u0002c)!)q\r\u0001C\u0005Q\u0006I2M]3bi\u0016$&/[4hKJ4%o\\7J]R,'O^1m)\rIGN\u001c\t\u0004')d\u0015BA6\u0015\u0005\u0019y\u0005\u000f^5p]\")QN\u001aa\u00015\u0005yQM\\1cY\u0016$U\r\\1z\u000b6LG\u000fC\u0003pM\u0002\u0007a%\u0001\u0005j]R,'O^1m\u0011\u0015\t\b\u0001\"\u0003s\u0003AIg\u000e^3sm\u0006dGk\\*ue&tw\rF\u0002`gRDQ!\u001c9A\u0002iAQa\u001c9A\u0002\u0019:QA\u001e\u0002\t\u0002]\f!cV5oI><X)\\5u'R\u0014\u0018\r^3hsB\u0011Q\u0007\u001f\u0004\u0006\u0003\tA\t!_\n\u0003qJAQA\r=\u0005\u0002m$\u0012a\u001e\u0005\u0006{b$\tA`\u0001\u0006CB\u0004H.\u001f\u000b\u0005i}\fy\u0001C\u0004\u0002\u0002q\u0004\r!a\u0001\u0002\u0017Q\f'\r\\3D_:4\u0017n\u001a\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002\u0005\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002\u000e\u0005\u001d!a\u0003+bE2,7i\u001c8gS\u001eDa!\u0015?A\u0002\u0005E\u0001\u0003BA\n\u00033i!!!\u0006\u000b\u0007\u0005]A!A\u0004m_\u001eL7-\u00197\n\t\u0005m\u0011Q\u0003\u0002\u000e\u0019><\u0017nY1m/&tGm\\<\t\u0013\u0005}\u0001P1A\u0005\u0002\u0005\u0005\u0012A\t+B\u00052+u,\u0012-F\u0007~+U*\u0013+`\u000b\u0006\u0013F*W0G\u0013J+u,\u0012(B\u00052+E)\u0006\u0002\u0002$A)\u0011QEA\u001655\u0011\u0011q\u0005\u0006\u0004\u0003SQ\u0011!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0003\u0002.\u0005\u001d\"\u0001D\"p]\u001aLwm\u00149uS>t\u0007\u0002CA\u0019q\u0002\u0006I!a\t\u0002GQ\u000b%\tT#`\u000bb+5iX#N\u0013R{V)\u0011*M3~3\u0015JU#`\u000b:\u000b%\tT#EA!\"\u0011qFA\u001b!\u0011\t9$!\u0010\u000e\u0005\u0005e\"bAA\u001e\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0012\u0011\b\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c\u0005\n\u0003\u0007B(\u0019!C\u0001\u0003\u000b\n\u0001\u0005V!C\u0019\u0016{V\tW#D?\u0016k\u0015\nV0F\u0003Jc\u0015l\u0018$J%\u0016{F)\u0012'B3V\u0011\u0011q\t\t\u0006\u0003K\tYc\u0018\u0005\t\u0003\u0017B\b\u0015!\u0003\u0002H\u0005\tC+\u0011\"M\u000b~+\u0005,R\"`\u000b6KEkX#B%2KvLR%S\u000b~#U\tT!ZA!\"\u0011\u0011JA\u001b\u0011%\t\t\u0006\u001fb\u0001\n\u0003\t\t#A\u0011U\u0003\ncUiX#Y\u000b\u000e{V)T%U?2\u000bE+R0G\u0013J+u,\u0012(B\u00052+E\t\u0003\u0005\u0002Va\u0004\u000b\u0011BA\u0012\u0003\t\"\u0016I\u0011'F?\u0016CViQ0F\u001b&#v\fT!U\u000b~3\u0015JU#`\u000b:\u000b%\tT#EA!\"\u00111KA\u001b\u0011%\tY\u0006\u001fb\u0001\n\u0003\t)%A\u0010U\u0003\ncUiX#Y\u000b\u000e{V)T%U?2\u000bE+R0G\u0013J+u\fR#M\u0003fC\u0001\"a\u0018yA\u0003%\u0011qI\u0001!)\u0006\u0013E*R0F1\u0016\u001bu,R'J)~c\u0015\tV#`\r&\u0013Vi\u0018#F\u0019\u0006K\u0006\u0005\u000b\u0003\u0002^\u0005U\u0002")
public class WindowEmitStrategy {
    private final Boolean isEventTime;
    private final Boolean isSessionWindow;
    private final Long earlyFireDelay;
    private final Boolean earlyFireDelayEnabled;
    private final Long lateFireDelay;
    private final Boolean lateFireDelayEnabled;
    private final Long allowLateness;

    public static ConfigOption<String> TABLE_EXEC_EMIT_LATE_FIRE_DELAY() {
        return WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_DELAY();
    }

    public static ConfigOption<Boolean> TABLE_EXEC_EMIT_LATE_FIRE_ENABLED() {
        return WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED();
    }

    public static ConfigOption<String> TABLE_EXEC_EMIT_EARLY_FIRE_DELAY() {
        return WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_EARLY_FIRE_DELAY();
    }

    public static ConfigOption<Boolean> TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED() {
        return WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED();
    }

    public static WindowEmitStrategy apply(TableConfig tableConfig, LogicalWindow logicalWindow) {
        return WindowEmitStrategy$.MODULE$.apply(tableConfig, logicalWindow);
    }

    public Long getAllowLateness() {
        return this.allowLateness;
    }

    private void checkValidation() {
        if (Predef$.MODULE$.Boolean2boolean(this.isSessionWindow) && (Predef$.MODULE$.Boolean2boolean(this.earlyFireDelayEnabled) || Predef$.MODULE$.Boolean2boolean(this.lateFireDelayEnabled))) {
            throw new TableException("Session window doesn't support EMIT strategy currently.");
        }
        if (Predef$.MODULE$.Boolean2boolean(this.isEventTime) && Predef$.MODULE$.Boolean2boolean(this.lateFireDelayEnabled) && Predef$.MODULE$.Long2long(this.allowLateness) <= 0L) {
            throw new TableException("The 'AFTER WATERMARK' emit strategy requires set 'minIdleStateRetentionTime' in table config.");
        }
        if (Predef$.MODULE$.Boolean2boolean(this.earlyFireDelayEnabled) && (this.earlyFireDelay == null || Predef$.MODULE$.Long2long(this.earlyFireDelay) < 0L)) {
            throw new TableException("Early-fire delay should not be null or negative value whenenable early-fire emit strategy.");
        }
        if (Predef$.MODULE$.Boolean2boolean(this.lateFireDelayEnabled) && (this.lateFireDelay == null || Predef$.MODULE$.Long2long(this.lateFireDelay) < 0L)) {
            throw new TableException("Late-fire delay should not be null or negative value whenenable late-fire emit strategy.");
        }
    }

    public Boolean produceUpdates() {
        return Predef$.MODULE$.Boolean2boolean(this.isEventTime) ? Predef$.MODULE$.boolean2Boolean(Predef$.MODULE$.Long2long(this.allowLateness) > 0L || Predef$.MODULE$.Boolean2boolean(this.earlyFireDelayEnabled) || Predef$.MODULE$.Boolean2boolean(this.lateFireDelayEnabled)) : this.earlyFireDelayEnabled;
    }

    public Trigger<TimeWindow> getTrigger() {
        Option<Trigger<TimeWindow>> option;
        block11: {
            ProcessingTimeTriggers.AfterEndOfWindow afterEndOfWindow;
            block8: {
                ProcessingTimeTriggers.AfterEndOfWindow afterEndOfWindow2;
                block10: {
                    ProcessingTimeTriggers.AfterEndOfWindow trigger;
                    block9: {
                        Option<Trigger<TimeWindow>> earlyTrigger;
                        block2: {
                            Tuple2 tuple2;
                            block7: {
                                EventTimeTriggers.AfterEndOfWindow afterEndOfWindow3;
                                block4: {
                                    EventTimeTriggers.AfterEndOfWindow trigger2;
                                    block6: {
                                        block5: {
                                            block3: {
                                                earlyTrigger = this.createTriggerFromInterval(this.earlyFireDelayEnabled, this.earlyFireDelay);
                                                Option<Trigger<TimeWindow>> lateTrigger = this.createTriggerFromInterval(this.lateFireDelayEnabled, this.lateFireDelay);
                                                if (!Predef$.MODULE$.Boolean2boolean(this.isEventTime)) break block2;
                                                trigger2 = EventTimeTriggers.afterEndOfWindow();
                                                tuple2 = new Tuple2(earlyTrigger, lateTrigger);
                                                if (tuple2 == null) break block3;
                                                Option option2 = (Option)tuple2._1();
                                                Option option3 = (Option)tuple2._2();
                                                if (!(option2 instanceof Some)) break block3;
                                                Some some = (Some)option2;
                                                Trigger early = (Trigger)some.x();
                                                if (!(option3 instanceof Some)) break block3;
                                                Some some2 = (Some)option3;
                                                Trigger late = (Trigger)some2.x();
                                                afterEndOfWindow3 = trigger2.withEarlyFirings(early).withLateFirings(late);
                                                break block4;
                                            }
                                            if (tuple2 == null) break block5;
                                            Option option4 = (Option)tuple2._1();
                                            Option option5 = (Option)tuple2._2();
                                            if (!(option4 instanceof Some)) break block5;
                                            Some some = (Some)option4;
                                            Trigger early = (Trigger)some.x();
                                            if (!None$.MODULE$.equals(option5)) break block5;
                                            afterEndOfWindow3 = trigger2.withEarlyFirings(early);
                                            break block4;
                                        }
                                        if (tuple2 == null) break block6;
                                        Option option6 = (Option)tuple2._1();
                                        Option option7 = (Option)tuple2._2();
                                        if (!None$.MODULE$.equals(option6) || !(option7 instanceof Some)) break block6;
                                        Some some = (Some)option7;
                                        Trigger late = (Trigger)some.x();
                                        afterEndOfWindow3 = trigger2.withLateFirings(late);
                                        break block4;
                                    }
                                    if (tuple2 == null) break block7;
                                    Option option8 = (Option)tuple2._1();
                                    Option option9 = (Option)tuple2._2();
                                    if (!None$.MODULE$.equals(option8) || !None$.MODULE$.equals(option9)) break block7;
                                    afterEndOfWindow3 = trigger2;
                                }
                                afterEndOfWindow = afterEndOfWindow3;
                                break block8;
                            }
                            throw new MatchError((Object)tuple2);
                        }
                        trigger = ProcessingTimeTriggers.afterEndOfWindow();
                        option = earlyTrigger;
                        if (!(option instanceof Some)) break block9;
                        Some some = (Some)option;
                        Trigger early = (Trigger)some.x();
                        afterEndOfWindow2 = trigger.withEarlyFirings(early);
                        break block10;
                    }
                    if (!None$.MODULE$.equals(option)) break block11;
                    afterEndOfWindow2 = trigger;
                }
                afterEndOfWindow = afterEndOfWindow2;
            }
            return afterEndOfWindow;
        }
        throw new MatchError(option);
    }

    public String toString() {
        BoxedUnit boxedUnit;
        StringBuilder builder = new StringBuilder();
        String earlyString = this.intervalToString(this.earlyFireDelayEnabled, this.earlyFireDelay);
        String lateString = this.intervalToString(this.lateFireDelayEnabled, this.lateFireDelay);
        Object object = earlyString == null ? BoxedUnit.UNIT : builder.append("early ").append(earlyString);
        if (lateString == null) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            Object object2 = earlyString == null ? BoxedUnit.UNIT : builder.append(", ");
            boxedUnit = builder.append("late ").append(lateString);
        }
        return builder.toString();
    }

    private Option<Trigger<TimeWindow>> createTriggerFromInterval(Boolean enableDelayEmit, Long interval) {
        return Predef$.MODULE$.Boolean2boolean(enableDelayEmit) ? (Predef$.MODULE$.Long2long(interval) > 0L ? new Some((Object)ProcessingTimeTriggers.every((Duration)Duration.ofMillis(Predef$.MODULE$.Long2long(interval)))) : new Some((Object)ElementTriggers.every())) : None$.MODULE$;
    }

    private String intervalToString(Boolean enableDelayEmit, Long interval) {
        return Predef$.MODULE$.Boolean2boolean(enableDelayEmit) ? (Predef$.MODULE$.Long2long(interval) > 0L ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delay ", " millisecond"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{interval})) : "no delay") : null;
    }

    public WindowEmitStrategy(Boolean isEventTime, Boolean isSessionWindow, Long earlyFireDelay, Boolean earlyFireDelayEnabled, Long lateFireDelay, Boolean lateFireDelayEnabled, Long allowLateness) {
        this.isEventTime = isEventTime;
        this.isSessionWindow = isSessionWindow;
        this.earlyFireDelay = earlyFireDelay;
        this.earlyFireDelayEnabled = earlyFireDelayEnabled;
        this.lateFireDelay = lateFireDelay;
        this.lateFireDelayEnabled = lateFireDelayEnabled;
        this.allowLateness = allowLateness;
        this.checkValidation();
    }
}

