/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001B\u0001\u0003\u0001=\u0011qCU8x)&lWMQ8v]\u0012,GMU1oO\u0016|e/\u001a:\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001U\u0011\u0001cF\n\u0005\u0001EI#\u0007E\u0003\u0013'U\u00193%D\u0001\u0003\u0013\t!\"AA\u0010Qe>\u001cWm]:Gk:\u001cG/[8o/&$\bn\u00117fC:,\bo\u0015;bi\u0016\u0004\"AF\f\r\u0001\u0011)\u0001\u0004\u0001b\u00013\t\t1*\u0005\u0002\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t9aj\u001c;iS:<\u0007CA\u000e\"\u0013\t\u0011CDA\u0002B]f\u0004\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0003\u0002\u000bQL\b/Z:\n\u0005!*#\u0001B\"S_^\u00042AK\u00170\u001b\u0005Y#B\u0001\u0017\u0007\u0003\u001d\u0019w\u000eZ3hK:L!AL\u0016\u0003\u0011\r{W\u000e]5mKJ\u0004\"A\u0005\u0019\n\u0005E\u0012!!F$f]\u0016\u0014\u0018\r^3e\u0003\u001e<'/Z4bi&|gn\u001d\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k\u0019\tA!\u001e;jY&\u0011q\u0007\u000e\u0002\b\u0019><w-\u001b8h\u0011!I\u0004A!A!\u0002\u0013Q\u0014aD4f]\u0006;wM]3hCRLwN\\:\u0011\u0005)Z\u0014B\u0001\u001f,\u0005u9UM\\3sCR,G-Q4he\u0016<\u0017\r^5p]N4UO\\2uS>t\u0007\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \u0002)\u0005<wM]3hCRLwN\\*uCR,G+\u001f9f!\t\u0001u)D\u0001B\u0015\t\u00115)A\u0005usB,W\u000f^5mg*\u0011A)R\u0001\u0005U\u00064\u0018M\u0003\u0002G\u0011\u0005\u0019\u0011\r]5\n\u0005!\u000b%a\u0003*poRK\b/Z%oM>D\u0001B\u0013\u0001\u0003\u0002\u0003\u0006IaS\u0001\rS:\u0004X\u000f\u001e*poRK\b/\u001a\t\u0003I1K!!T\u0013\u0003\u0019\r\u0013vn\u001e+za\u0016LeNZ8\t\u0011=\u0003!\u0011!Q\u0001\nA\u000bq\u0002\u001d:fG\u0016$\u0017N\\4PM\u001a\u001cX\r\u001e\t\u00037EK!A\u0015\u000f\u0003\t1{gn\u001a\u0005\t)\u0002\u0011\t\u0011)A\u0005+\u0006Q!o\\<US6,\u0017\n\u001a=\u0011\u0005m1\u0016BA,\u001d\u0005\rIe\u000e\u001e\u0005\t3\u0002\u0011\t\u0011)A\u0005!\u0006\u0001R.\u001b8SKR,g\u000e^5p]RKW.\u001a\u0005\t7\u0002\u0011\t\u0011)A\u0005!\u0006\u0001R.\u0019=SKR,g\u000e^5p]RKW.\u001a\u0005\u0006;\u0002!\tAX\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011}\u0003\u0017MY2eK\u001a\u00042A\u0005\u0001\u0016\u0011\u0015ID\f1\u0001;\u0011\u0015qD\f1\u0001@\u0011\u0015QE\f1\u0001L\u0011\u0015yE\f1\u0001Q\u0011\u0015!F\f1\u0001V\u0011\u0015IF\f1\u0001Q\u0011\u0015YF\f1\u0001Q\u0011%A\u0007\u00011AA\u0002\u0013%\u0011.\u0001\u0004pkR\u0004X\u000f^\u000b\u0002G!I1\u000e\u0001a\u0001\u0002\u0004%I\u0001\\\u0001\u000b_V$\b/\u001e;`I\u0015\fHCA7q!\tYb.\u0003\u0002p9\t!QK\\5u\u0011\u001d\t(.!AA\u0002\r\n1\u0001\u001f\u00132\u0011%\u0019\b\u00011A\u0001B\u0003&1%A\u0004pkR\u0004X\u000f\u001e\u0011\t\u0013U\u0004\u0001\u0019!a\u0001\n\u00131\u0018!\u00067bgR$&/[4hKJLgn\u001a+t'R\fG/Z\u000b\u0002oB\u0019\u00010 )\u000e\u0003eT!A_>\u0002\u000bM$\u0018\r^3\u000b\u0005q,\u0015AB2p[6|g.\u0003\u0002\u007fs\nQa+\u00197vKN#\u0018\r^3\t\u0017\u0005\u0005\u0001\u00011AA\u0002\u0013%\u00111A\u0001\u001aY\u0006\u001cH\u000f\u0016:jO\u001e,'/\u001b8h)N\u001cF/\u0019;f?\u0012*\u0017\u000fF\u0002n\u0003\u000bAq!]@\u0002\u0002\u0003\u0007q\u000f\u0003\u0006\u0002\n\u0001\u0001\r\u0011!Q!\n]\fa\u0003\\1tiR\u0013\u0018nZ4fe&tw\rV:Ti\u0006$X\r\t\u0005\f\u0003\u001b\u0001\u0001\u0019!a\u0001\n\u0013\ty!\u0001\tbG\u000e,X.\u001e7bi>\u00148\u000b^1uKV\u0011\u0011\u0011\u0003\t\u0005qv\f\u0019\u0002\u0005\u0003\u0002\u0016\u0005eQBAA\f\u0015\t1\u0003\"\u0003\u0003\u0002\u001c\u0005]!a\u0001*po\"Y\u0011q\u0004\u0001A\u0002\u0003\u0007I\u0011BA\u0011\u0003Q\t7mY;nk2\fGo\u001c:Ti\u0006$Xm\u0018\u0013fcR\u0019Q.a\t\t\u0013E\fi\"!AA\u0002\u0005E\u0001bCA\u0014\u0001\u0001\u0007\t\u0011)Q\u0005\u0003#\t\u0011#Y2dk6,H.\u0019;peN#\u0018\r^3!\u0011-\tY\u0003\u0001a\u0001\u0002\u0004%I!!\f\u0002\u0013\u0011\fG/Y*uCR,WCAA\u0018!\u0019A\u0018\u0011\u0007)\u00026%\u0019\u00111G=\u0003\u00115\u000b\u0007o\u0015;bi\u0016\u0004b!a\u000e\u0002>\u0005MQBAA\u001d\u0015\r)\u00141\b\u0006\u0002\t&!\u0011qHA\u001d\u0005\u0011a\u0015n\u001d;\t\u0017\u0005\r\u0003\u00011AA\u0002\u0013%\u0011QI\u0001\u000eI\u0006$\u0018m\u0015;bi\u0016|F%Z9\u0015\u00075\f9\u0005C\u0005r\u0003\u0003\n\t\u00111\u0001\u00020!Y\u00111\n\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0018\u0003)!\u0017\r^1Ti\u0006$X\r\t\u0005\f\u0003\u001f\u0002\u0001\u0019!a\u0001\n\u0013\t\t&\u0001\u0005gk:\u001cG/[8o+\u0005y\u0003bCA+\u0001\u0001\u0007\t\u0019!C\u0005\u0003/\nABZ;oGRLwN\\0%KF$2!\\A-\u0011!\t\u00181KA\u0001\u0002\u0004y\u0003BCA/\u0001\u0001\u0007\t\u0011)Q\u0005_\u0005Ia-\u001e8di&|g\u000e\t\u0005\b\u0003C\u0002A\u0011IA2\u0003\u0011y\u0007/\u001a8\u0015\u00075\f)\u0007\u0003\u0005\u0002h\u0005}\u0003\u0019AA5\u0003\u0019\u0019wN\u001c4jOB!\u00111NA9\u001b\t\tiGC\u0002\u0002p!\tQbY8oM&<WO]1uS>t\u0017\u0002BA:\u0003[\u0012QbQ8oM&<WO]1uS>t\u0007bBA<\u0001\u0011\u0005\u0013\u0011P\u0001\u000faJ|7-Z:t\u000b2,W.\u001a8u)\u001di\u00171PA@\u00037Cq!! \u0002v\u0001\u00071%\u0001\u0004j]B,Ho\u0011\u0005\t\u0003\u0003\u000b)\b1\u0001\u0002\u0004\u0006\u00191\r\u001e=\u0011\t\u0005\u0015\u0015q\u0013\t\b\u0003\u000f\u000b\u0019*F\u0012$\u001b\t\tII\u0003\u0003\u0002\f\u00065\u0015!\u00034v]\u000e$\u0018n\u001c8t\u0015\r1\u0015q\u0012\u0006\u0004\u0003#C\u0011!C:ue\u0016\fW.\u001b8h\u0013\u0011\t)*!#\u0003)-+\u00170\u001a3Qe>\u001cWm]:Gk:\u001cG/[8o\u0013\u0011\tI*a%\u0003\u000f\r{g\u000e^3yi\"A\u0011QTA;\u0001\u0004\ty*A\u0002pkR\u0004R!!)\u0002&\u000ej!!a)\u000b\u0005UB\u0011\u0002BAT\u0003G\u0013\u0011bQ8mY\u0016\u001cGo\u001c:\t\u000f\u0005-\u0006\u0001\"\u0011\u0002.\u00069qN\u001c+j[\u0016\u0014HcB7\u00020\u0006M\u00161\u0018\u0005\b\u0003c\u000bI\u000b1\u0001Q\u0003%!\u0018.\\3ti\u0006l\u0007\u000f\u0003\u0005\u0002\u0002\u0006%\u0006\u0019AA[!\u0011\t))a.\n\t\u0005e\u00161\u0013\u0002\u000f\u001f:$\u0016.\\3s\u0007>tG/\u001a=u\u0011!\ti*!+A\u0002\u0005}\u0005bBA`\u0001\u0011\u0005\u0013\u0011Y\u0001\u0006G2|7/\u001a\u000b\u0002[\u0002")
public class RowTimeBoundedRangeOver<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final RowTypeInfo aggregationStateType;
    private final CRowTypeInfo inputRowType;
    private final long precedingOffset;
    private final int rowTimeIdx;
    private CRow output;
    private ValueState<Object> lastTriggeringTsState;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> dataState;
    private GeneratedAggregations function;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        RowTimeBoundedRangeOver rowTimeBoundedRangeOver = this;
        synchronized (rowTimeBoundedRangeOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Object> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(ValueState<Object> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> dataState() {
        return this.dataState;
    }

    private void dataState_$eq(MapState<Object, List<Row>> x$1) {
        this.dataState = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(30).append("Compiling AggregateHelper: ").append(this.genAggregations.name()).append(" \n\n").append(new StringBuilder(6).append("Code:\n").append(this.genAggregations.code()).toString()).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        ValueStateDescriptor lastTriggeringTsDescriptor = new ValueStateDescriptor("lastTriggeringTsState", Long.TYPE);
        this.lastTriggeringTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(lastTriggeringTsDescriptor));
        ValueStateDescriptor accumulatorStateDescriptor = new ValueStateDescriptor("accumulatorState", (TypeInformation)this.aggregationStateType);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(accumulatorStateDescriptor));
        BasicTypeInfo keyTypeInformation = BasicTypeInfo.LONG_TYPE_INFO;
        ListTypeInfo valueTypeInformation = new ListTypeInfo((TypeInformation)this.inputRowType.rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("dataState", (TypeInformation)keyTypeInformation, (TypeInformation)valueTypeInformation);
        this.dataState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        this.initCleanupTimeState("RowTimeBoundedRangeOverCleanupTime");
    }

    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        block2: {
            Row input = inputC.row();
            this.processCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
            long triggeringTs = BoxesRunTime.unboxToLong((Object)input.getField(this.rowTimeIdx));
            long lastTriggeringTs = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
            if (triggeringTs <= lastTriggeringTs) break block2;
            List data = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)triggeringTs));
            if (data != null) {
                data.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), (Object)data);
            } else {
                ArrayList<Row> data2 = new ArrayList<Row>();
                data2.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), data2);
                ctx.timerService().registerEventTimeTimer(triggeringTs);
            }
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.stateCleaningEnabled()) {
                Iterator keysIt = this.dataState().keys().iterator();
                long lastProcessedTime = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
                boolean noRecordsToProcess = true;
                while (keysIt.hasNext() && noRecordsToProcess) {
                    if (BoxesRunTime.unboxToLong(keysIt.next()) <= lastProcessedTime) continue;
                    noRecordsToProcess = false;
                }
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.dataState(), this.accumulatorState(), this.lastTriggeringTsState()}));
                    this.function().cleanup();
                } else {
                    this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        List inputs = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
        if (inputs != null) {
            Row accumulators = (Row)this.accumulatorState().value();
            int dataListIndex = 0;
            boolean aggregatesIndex = false;
            if (accumulators == null) {
                accumulators = this.function().createAccumulators();
                aggregatesIndex = false;
            }
            Iterator iter = this.dataState().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                long dataTs = BoxesRunTime.unboxToLong(entry.getKey());
                long offset = timestamp - dataTs;
                if (offset <= this.precedingOffset) continue;
                List retractDataList = (List)entry.getValue();
                for (dataListIndex = 0; dataListIndex < retractDataList.size(); ++dataListIndex) {
                    Row retractRow = (Row)retractDataList.get(dataListIndex);
                    this.function().retract(accumulators, retractRow);
                }
                iter.remove();
            }
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                Row curRow = (Row)inputs.get(dataListIndex);
                this.function().accumulate(accumulators, curRow);
            }
            this.function().setAggregationResults(accumulators, this.output().row());
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                aggregatesIndex = false;
                this.function().setForwardedFields((Row)inputs.get(dataListIndex), this.output().row());
                out.collect((Object)this.output());
            }
            this.accumulatorState().update((Object)accumulators);
        }
        this.lastTriggeringTsState().update((Object)BoxesRunTime.boxToLong((long)timestamp));
        this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    public void close() {
        block0: {
            if (this.function() == null) break block0;
            this.function().close();
        }
    }

    public RowTimeBoundedRangeOver(GeneratedAggregationsFunction genAggregations, RowTypeInfo aggregationStateType, CRowTypeInfo inputRowType, long precedingOffset, int rowTimeIdx, long minRetentionTime, long maxRetentionTime) {
        this.genAggregations = genAggregations;
        this.aggregationStateType = aggregationStateType;
        this.inputRowType = inputRowType;
        this.precedingOffset = precedingOffset;
        this.rowTimeIdx = rowTimeIdx;
        super(minRetentionTime, maxRetentionTime);
        Compiler.$init$(this);
        Logging.$init$(this);
        Preconditions.checkNotNull((Object)aggregationStateType);
        Preconditions.checkNotNull((Object)BoxesRunTime.boxToLong((long)precedingOffset));
    }
}

