/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class SqlOrderBy
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new Operator(){

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlOrderBy(pos, operands[0], (SqlNodeList)operands[1], operands[2], operands[3]);
        }
    };
    public final SqlNode query;
    public final SqlNodeList orderList;
    public final @Nullable SqlNode offset;
    public final @Nullable SqlNode fetch;

    public SqlOrderBy(SqlParserPos pos, SqlNode query, SqlNodeList orderList, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
        super(pos);
        this.query = query;
        this.orderList = orderList;
        this.offset = offset;
        this.fetch = fetch;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.ORDER_BY;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.query, this.orderList, this.offset, this.fetch);
    }

    private static class Operator
    extends SqlSpecialOperator {
        private Operator() {
            super("ORDER BY", SqlKind.ORDER_BY, 0);
        }

        @Override
        public SqlSyntax getSyntax() {
            return SqlSyntax.POSTFIX;
        }

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlOrderBy orderBy = (SqlOrderBy)call;
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.ORDER_BY);
            orderBy.query.unparse(writer, this.getLeftPrec(), this.getRightPrec());
            if (orderBy.orderList != SqlNodeList.EMPTY) {
                writer.sep(this.getName());
                writer.list(SqlWriter.FrameTypeEnum.ORDER_BY_LIST, SqlWriter.COMMA, orderBy.orderList);
            }
            if (orderBy.offset != null || orderBy.fetch != null) {
                writer.fetchOffset(orderBy.fetch, orderBy.offset);
            }
            writer.endList(frame);
        }
    }
}

