/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import org.apache.calcite.sql.ImmutableSqlWriterConfig;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlWriter;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Value;

@Value.Immutable
public interface SqlWriterConfig {
    public @Nullable SqlDialect dialect();

    public SqlWriterConfig withDialect(@Nullable SqlDialect var1);

    @Value.Default
    default public boolean keywordsLowerCase() {
        return false;
    }

    public SqlWriterConfig withKeywordsLowerCase(boolean var1);

    @Value.Default
    default public boolean quoteAllIdentifiers() {
        return true;
    }

    public SqlWriterConfig withQuoteAllIdentifiers(boolean var1);

    @Value.Default
    default public int indentation() {
        return 4;
    }

    public SqlWriterConfig withIndentation(int var1);

    @Value.Default
    default public boolean clauseStartsLine() {
        return true;
    }

    public SqlWriterConfig withClauseStartsLine(boolean var1);

    @Value.Default
    default public boolean clauseEndsLine() {
        return false;
    }

    public SqlWriterConfig withClauseEndsLine(boolean var1);

    @Value.Default
    default public boolean selectListItemsOnSeparateLines() {
        return false;
    }

    public SqlWriterConfig withSelectListItemsOnSeparateLines(boolean var1);

    public @Nullable LineFolding lineFolding();

    public SqlWriterConfig withLineFolding(@Nullable LineFolding var1);

    public @Nullable LineFolding selectFolding();

    public SqlWriterConfig withSelectFolding(@Nullable LineFolding var1);

    @Value.Default
    default public LineFolding fromFolding() {
        return LineFolding.TALL;
    }

    public SqlWriterConfig withFromFolding(LineFolding var1);

    public @Nullable LineFolding whereFolding();

    public SqlWriterConfig withWhereFolding(@Nullable LineFolding var1);

    public @Nullable LineFolding groupByFolding();

    public SqlWriterConfig withGroupByFolding(@Nullable LineFolding var1);

    public @Nullable LineFolding havingFolding();

    public SqlWriterConfig withHavingFolding(@Nullable LineFolding var1);

    public @Nullable LineFolding windowFolding();

    public SqlWriterConfig withWindowFolding(@Nullable LineFolding var1);

    public @Nullable LineFolding matchFolding();

    public SqlWriterConfig withMatchFolding(@Nullable LineFolding var1);

    public @Nullable LineFolding orderByFolding();

    public SqlWriterConfig withOrderByFolding(@Nullable LineFolding var1);

    public @Nullable LineFolding overFolding();

    public SqlWriterConfig withOverFolding(@Nullable LineFolding var1);

    public @Nullable LineFolding valuesFolding();

    public SqlWriterConfig withValuesFolding(@Nullable LineFolding var1);

    public @Nullable LineFolding updateSetFolding();

    public SqlWriterConfig withUpdateSetFolding(@Nullable LineFolding var1);

    @Value.Default
    default public boolean selectListExtraIndentFlag() {
        return true;
    }

    public SqlWriterConfig withSelectListExtraIndentFlag(boolean var1);

    @Value.Default
    default public boolean windowDeclListNewline() {
        return true;
    }

    public SqlWriterConfig withWindowDeclListNewline(boolean var1);

    @Value.Default
    default public boolean valuesListNewline() {
        return true;
    }

    public SqlWriterConfig withValuesListNewline(boolean var1);

    @Value.Default
    default public boolean updateSetListNewline() {
        return true;
    }

    public SqlWriterConfig withUpdateSetListNewline(boolean var1);

    @Value.Default
    default public boolean windowNewline() {
        return false;
    }

    public SqlWriterConfig withWindowNewline(boolean var1);

    @Value.Default
    default public boolean leadingComma() {
        return false;
    }

    public SqlWriterConfig withLeadingComma(boolean var1);

    @Value.Default
    default public SqlWriter.SubQueryStyle subQueryStyle() {
        return SqlWriter.SubQueryStyle.HYDE;
    }

    public SqlWriterConfig withSubQueryStyle(SqlWriter.SubQueryStyle var1);

    @Value.Default
    default public boolean whereListItemsOnSeparateLines() {
        return false;
    }

    public SqlWriterConfig withWhereListItemsOnSeparateLines(boolean var1);

    @Value.Default
    default public boolean alwaysUseParentheses() {
        return false;
    }

    public SqlWriterConfig withAlwaysUseParentheses(boolean var1);

    @Value.Default
    default public int lineLength() {
        return 0;
    }

    public SqlWriterConfig withLineLength(int var1);

    @Value.Default
    default public int foldLength() {
        return 80;
    }

    public SqlWriterConfig withFoldLength(int var1);

    @Value.Default
    default public boolean caseClausesOnNewLines() {
        return false;
    }

    public SqlWriterConfig withCaseClausesOnNewLines(boolean var1);

    public static SqlWriterConfig of() {
        return ImmutableSqlWriterConfig.of();
    }

    public static enum LineFolding {
        WIDE,
        STEP,
        FOLD,
        CHOP,
        TALL;

    }
}

