/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.slicing;

import java.time.ZoneId;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.table.runtime.operators.window.slicing.WindowTimerService;
import org.apache.flink.table.runtime.util.TimeWindowUtil;

public class WindowTimerServiceImpl
implements WindowTimerService<Long> {
    private final InternalTimerService<Long> internalTimerService;
    private final ZoneId shiftTimeZone;

    public WindowTimerServiceImpl(InternalTimerService<Long> internalTimerService, ZoneId shiftTimeZone) {
        this.internalTimerService = internalTimerService;
        this.shiftTimeZone = shiftTimeZone;
    }

    @Override
    public ZoneId getShiftTimeZone() {
        return this.shiftTimeZone;
    }

    @Override
    public long currentProcessingTime() {
        return this.internalTimerService.currentProcessingTime();
    }

    @Override
    public long currentWatermark() {
        return this.internalTimerService.currentWatermark();
    }

    @Override
    public void registerProcessingTimeWindowTimer(Long window) {
        this.internalTimerService.registerProcessingTimeTimer((Object)window, TimeWindowUtil.toEpochMillsForTimer(window - 1L, this.shiftTimeZone));
    }

    @Override
    public void registerEventTimeWindowTimer(Long window) {
        this.internalTimerService.registerEventTimeTimer((Object)window, TimeWindowUtil.toEpochMillsForTimer(window - 1L, this.shiftTimeZone));
    }
}

