/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.Strong;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;
import org.apache.flink.calcite.shaded.com.google.common.collect.ArrayListMultimap;
import org.apache.flink.calcite.shaded.com.google.common.collect.BoundType;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.Iterables;
import org.apache.flink.calcite.shaded.com.google.common.collect.Range;

public class RexSimplify {
    public final RexBuilder rexBuilder;
    private final RelOptPredicateList predicates;
    final boolean unknownAsFalse;
    private final RexExecutor executor;

    public RexSimplify(RexBuilder rexBuilder, RelOptPredicateList predicates, boolean unknownAsFalse, RexExecutor executor) {
        this.rexBuilder = Preconditions.checkNotNull(rexBuilder);
        this.predicates = Preconditions.checkNotNull(predicates);
        this.unknownAsFalse = unknownAsFalse;
        this.executor = Preconditions.checkNotNull(executor);
    }

    @Deprecated
    public RexSimplify(RexBuilder rexBuilder, boolean unknownAsFalse, RexExecutor executor) {
        this(rexBuilder, RelOptPredicateList.EMPTY, unknownAsFalse, executor);
    }

    public RexSimplify withUnknownAsFalse(boolean unknownAsFalse) {
        return unknownAsFalse == this.unknownAsFalse ? this : new RexSimplify(this.rexBuilder, this.predicates, unknownAsFalse, this.executor);
    }

    public RexSimplify withPredicates(RelOptPredicateList predicates) {
        return predicates == this.predicates ? this : new RexSimplify(this.rexBuilder, predicates, this.unknownAsFalse, this.executor);
    }

    public RexNode simplifyPreservingType(RexNode e2) {
        RexNode e22 = this.simplify(e2);
        if (e22.getType() == e2.getType()) {
            return e22;
        }
        RexNode e3 = this.rexBuilder.makeCast(e2.getType(), e22, true);
        if (e3.equals(e2)) {
            return e2;
        }
        return e3;
    }

    public RexNode simplify(RexNode e2) {
        switch (e2.getKind()) {
            case AND: {
                return this.simplifyAnd((RexCall)e2);
            }
            case OR: {
                return this.simplifyOr((RexCall)e2);
            }
            case NOT: {
                return this.simplifyNot((RexCall)e2);
            }
            case CASE: {
                return this.simplifyCase((RexCall)e2);
            }
            case CAST: {
                return this.simplifyCast((RexCall)e2);
            }
            case CEIL: 
            case FLOOR: {
                return this.simplifyCeilFloor((RexCall)e2);
            }
            case IS_NULL: 
            case IS_NOT_NULL: 
            case IS_TRUE: 
            case IS_NOT_TRUE: 
            case IS_FALSE: 
            case IS_NOT_FALSE: {
                assert (e2 instanceof RexCall);
                return this.simplifyIs((RexCall)e2);
            }
            case EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case NOT_EQUALS: {
                return this.simplifyComparison((RexCall)e2);
            }
        }
        return e2;
    }

    private RexNode simplifyComparison(RexCall e2) {
        return this.simplifyComparison(e2, Comparable.class);
    }

    private <C extends Comparable<C>> RexNode simplifyComparison(RexCall e2, Class<C> clazz) {
        ArrayList<RexNode> operands = new ArrayList<RexNode>(e2.operands);
        this.simplifyList(operands);
        RexNode o0 = (RexNode)operands.get(0);
        RexNode o1 = (RexNode)operands.get(1);
        if (RexUtil.eq(o0, o1) && (this.unknownAsFalse || !o0.getType().isNullable() && !o1.getType().isNullable())) {
            switch (e2.getKind()) {
                case EQUALS: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN_OR_EQUAL: {
                    return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, o0));
                }
            }
            return this.rexBuilder.makeLiteral(false);
        }
        if (o0.isA(SqlKind.LITERAL) && o1.isA(SqlKind.LITERAL) && o0.getType().equals(o1.getType())) {
            Comparable v0 = (Comparable)((RexLiteral)o0).getValueAs(clazz);
            Comparable v1 = (Comparable)((RexLiteral)o1).getValueAs(clazz);
            if (v0 == null || v1 == null) {
                return this.unknownAsFalse ? this.rexBuilder.makeLiteral(false) : this.rexBuilder.makeNullLiteral(e2.getType());
            }
            int comparisonResult = v0.compareTo(v1);
            switch (e2.getKind()) {
                case EQUALS: {
                    return this.rexBuilder.makeLiteral(comparisonResult == 0);
                }
                case GREATER_THAN: {
                    return this.rexBuilder.makeLiteral(comparisonResult > 0);
                }
                case GREATER_THAN_OR_EQUAL: {
                    return this.rexBuilder.makeLiteral(comparisonResult >= 0);
                }
                case LESS_THAN: {
                    return this.rexBuilder.makeLiteral(comparisonResult < 0);
                }
                case LESS_THAN_OR_EQUAL: {
                    return this.rexBuilder.makeLiteral(comparisonResult <= 0);
                }
                case NOT_EQUALS: {
                    return this.rexBuilder.makeLiteral(comparisonResult != 0);
                }
            }
            throw new AssertionError();
        }
        RexNode e22 = operands.equals(e2.operands) ? e2 : this.rexBuilder.makeCall(e2.op, operands);
        return this.simplifyUsingPredicates(e22, clazz);
    }

    public RexNode simplifyAnds(Iterable<? extends RexNode> nodes) {
        ArrayList<RexNode> terms = new ArrayList<RexNode>();
        ArrayList<RexNode> notTerms = new ArrayList<RexNode>();
        for (RexNode rexNode : nodes) {
            RelOptUtil.decomposeConjunction(rexNode, terms, notTerms);
        }
        this.simplifyList(terms);
        this.simplifyList(notTerms);
        if (this.unknownAsFalse) {
            return this.simplifyAnd2ForUnknownAsFalse(terms, notTerms);
        }
        return this.simplifyAnd2(terms, notTerms);
    }

    private void simplifyList(List<RexNode> terms) {
        for (int i = 0; i < terms.size(); ++i) {
            terms.set(i, this.withUnknownAsFalse(false).simplify(terms.get(i)));
        }
    }

    private RexNode simplifyNot(RexCall call) {
        RexNode a = call.getOperands().get(0);
        switch (a.getKind()) {
            case NOT: {
                return this.simplify(((RexCall)a).getOperands().get(0));
            }
        }
        SqlKind negateKind = a.getKind().negate();
        if (a.getKind() != negateKind) {
            return this.simplify(this.rexBuilder.makeCall(RexUtil.op(negateKind), ImmutableList.of(((RexCall)a).getOperands().get(0))));
        }
        SqlKind negateKind2 = a.getKind().negateNullSafe();
        if (a.getKind() != negateKind2) {
            return this.simplify(this.rexBuilder.makeCall(RexUtil.op(negateKind2), ((RexCall)a).getOperands()));
        }
        if (a.getKind() == SqlKind.AND) {
            ArrayList<RexNode> newOperands = new ArrayList<RexNode>();
            for (RexNode operand : ((RexCall)a).getOperands()) {
                newOperands.add(this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, operand)));
            }
            return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, newOperands));
        }
        if (a.getKind() == SqlKind.OR) {
            ArrayList<RexNode> newOperands = new ArrayList<RexNode>();
            for (RexNode operand : ((RexCall)a).getOperands()) {
                newOperands.add(this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, operand)));
            }
            return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, newOperands));
        }
        return call;
    }

    private RexNode simplifyIs(RexCall call) {
        RexNode a;
        SqlKind kind = call.getKind();
        RexNode simplified = this.simplifyIs2(kind, a = call.getOperands().get(0));
        if (simplified != null) {
            return simplified;
        }
        return call;
    }

    private RexNode simplifyIs2(SqlKind kind, RexNode a) {
        switch (kind) {
            case IS_NULL: {
                if (a.getType().isNullable()) break;
                return this.rexBuilder.makeLiteral(false);
            }
            case IS_NOT_NULL: {
                RexNode simplified = this.simplifyIsNotNull(a);
                if (simplified == null) break;
                return simplified;
            }
            case IS_TRUE: 
            case IS_NOT_FALSE: {
                if (a.getType().isNullable()) break;
                return this.simplify(a);
            }
            case IS_NOT_TRUE: 
            case IS_FALSE: {
                if (a.getType().isNullable()) break;
                return this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, a));
            }
        }
        switch (a.getKind()) {
            case NOT: {
                SqlOperator notKind = RexUtil.op(kind.negateNullSafe());
                RexNode arg = (RexNode)((RexCall)a).operands.get(0);
                return this.simplify(this.rexBuilder.makeCall(notKind, arg));
            }
        }
        RexNode a2 = this.simplify(a);
        if (a != a2) {
            return this.rexBuilder.makeCall(RexUtil.op(kind), ImmutableList.of(a2));
        }
        return null;
    }

    private RexNode simplifyIsNotNull(RexNode a) {
        if (!a.getType().isNullable()) {
            return this.rexBuilder.makeLiteral(true);
        }
        switch (Strong.policy(a.getKind())) {
            case ANY: {
                ArrayList<RexNode> operands = new ArrayList<RexNode>();
                for (RexNode operand : ((RexCall)a).getOperands()) {
                    RexNode simplified = this.simplifyIsNotNull(operand);
                    if (simplified == null) {
                        operands.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operand));
                        continue;
                    }
                    if (simplified.isAlwaysFalse()) {
                        return this.rexBuilder.makeLiteral(false);
                    }
                    operands.add(simplified);
                }
                return RexUtil.composeConjunction(this.rexBuilder, operands, false);
            }
            case CUSTOM: {
                switch (a.getKind()) {
                    case LITERAL: {
                        return this.rexBuilder.makeLiteral(!((RexLiteral)a).isNull());
                    }
                }
                throw new AssertionError((Object)("every CUSTOM policy needs a handler, " + (Object)((Object)a.getKind())));
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private RexNode simplifyCase(RexCall call) {
        ArrayList<RexNode> newOperands;
        List<RexNode> operands;
        block22: {
            operands = call.getOperands();
            newOperands = new ArrayList<RexNode>();
            HashSet<String> values = new HashSet<String>();
            for (int i = 0; i < operands.size(); ++i) {
                RexNode operand = operands.get(i);
                if (RexUtil.isCasePredicate(call, i)) {
                    if (operand.isAlwaysTrue()) {
                        newOperands.add(operands.get(++i));
                        if (this.unknownAsFalse && RexUtil.isNull(operands.get(i))) {
                            values.add(this.rexBuilder.makeLiteral(false).toString());
                            break;
                        }
                        values.add(operands.get(i).toString());
                        break;
                    }
                    if (operand.isAlwaysFalse() || RexUtil.isNull(operand)) {
                        ++i;
                        continue;
                    }
                } else if (this.unknownAsFalse && RexUtil.isNull(operand)) {
                    values.add(this.rexBuilder.makeLiteral(false).toString());
                } else {
                    values.add(operand.toString());
                }
                newOperands.add(operand);
            }
            assert (newOperands.size() % 2 == 1);
            if (newOperands.size() == 1 || values.size() == 1) {
                RexNode last = (RexNode)Util.last(newOperands);
                if (!call.getType().equals(last.getType())) {
                    return this.rexBuilder.makeAbstractCast(call.getType(), last);
                }
                return last;
            }
            if (call.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
                Object disjunction;
                ArrayList<RexNode> terms;
                List<Pair<RexNode, RexNode>> pairs = RexSimplify.casePairs(this.rexBuilder, newOperands);
                if (this.unknownAsFalse) {
                    void var7_11;
                    Pair<RexNode, RexNode> pair;
                    void var7_10;
                    terms = new ArrayList();
                    boolean bl = false;
                    while (var7_10 < pairs.size() && (pair = pairs.get((int)var7_10)).getValue().isAlwaysTrue()) {
                        terms.add(pair.getKey());
                        ++var7_10;
                    }
                    while (var7_11 < pairs.size() && ((pair = pairs.get((int)var7_11)).getValue().isAlwaysFalse() || RexUtil.isNull(pair.getValue()))) {
                        ++var7_11;
                    }
                    if (var7_11 == pairs.size()) {
                        disjunction = RexUtil.composeDisjunction(this.rexBuilder, terms);
                        if (!call.getType().equals(((RexNode)disjunction).getType())) {
                            return this.rexBuilder.makeCast(call.getType(), (RexNode)disjunction);
                        }
                        return disjunction;
                    }
                }
                for (Ord ord : Ord.zip(pairs)) {
                    if (!((RexNode)((Pair)ord.e).getKey()).getType().isNullable() && (((RexNode)((Pair)ord.e).getValue()).isAlwaysTrue() || ((RexNode)((Pair)ord.e).getValue()).isAlwaysFalse() || this.unknownAsFalse && RexUtil.isNull((RexNode)((Pair)ord.e).getValue()))) continue;
                    break block22;
                }
                terms = new ArrayList<RexNode>();
                ArrayList arrayList = new ArrayList();
                for (Ord ord : Ord.zip(pairs)) {
                    if (((RexNode)((Pair)ord.e).getValue()).isAlwaysTrue()) {
                        terms.add(RexUtil.andNot(this.rexBuilder, (RexNode)((Pair)ord.e).getKey(), arrayList));
                        continue;
                    }
                    arrayList.add(((Pair)ord.e).getKey());
                }
                disjunction = RexUtil.composeDisjunction(this.rexBuilder, terms);
                if (!call.getType().equals(((RexNode)disjunction).getType())) {
                    return this.rexBuilder.makeCast(call.getType(), (RexNode)disjunction);
                }
                return disjunction;
            }
        }
        if (newOperands.equals(operands)) {
            return call;
        }
        return call.clone(call.getType(), newOperands);
    }

    private static List<Pair<RexNode, RexNode>> casePairs(RexBuilder rexBuilder, List<RexNode> operands) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < operands.size() - 1; i += 2) {
            builder.add(Pair.of(operands.get(i), operands.get(i + 1)));
        }
        builder.add(Pair.of(rexBuilder.makeLiteral(true), Util.last(operands)));
        return builder.build();
    }

    public RexNode simplifyAnd(RexCall e2) {
        ArrayList<RexNode> terms = new ArrayList<RexNode>();
        ArrayList<RexNode> notTerms = new ArrayList<RexNode>();
        RelOptUtil.decomposeConjunction(e2, terms, notTerms);
        this.simplifyList(terms);
        this.simplifyList(notTerms);
        if (this.unknownAsFalse) {
            return this.simplifyAnd2ForUnknownAsFalse(terms, notTerms);
        }
        return this.simplifyAnd2(terms, notTerms);
    }

    RexNode simplifyAnd2(List<RexNode> terms, List<RexNode> notTerms) {
        for (RexNode term2 : terms) {
            if (!term2.isAlwaysFalse()) continue;
            return this.rexBuilder.makeLiteral(false);
        }
        if (terms.isEmpty() && notTerms.isEmpty()) {
            return this.rexBuilder.makeLiteral(true);
        }
        for (RexNode notDisjunction : notTerms) {
            List<RexNode> terms2 = RelOptUtil.conjunctions(notDisjunction);
            if (!terms.containsAll(terms2)) continue;
            return this.rexBuilder.makeLiteral(false);
        }
        for (RexNode notDisjunction : notTerms) {
            terms.add(this.simplify(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, notDisjunction)));
        }
        return RexUtil.composeConjunction(this.rexBuilder, terms, false);
    }

    RexNode simplifyAnd2ForUnknownAsFalse(List<RexNode> terms, List<RexNode> notTerms) {
        return this.simplifyAnd2ForUnknownAsFalse(terms, notTerms, Comparable.class);
    }

    private <C extends Comparable<C>> RexNode simplifyAnd2ForUnknownAsFalse(List<RexNode> terms, List<RexNode> notTerms, Class<C> clazz) {
        for (RexNode term2 : terms) {
            if (!term2.isAlwaysFalse()) continue;
            return this.rexBuilder.makeLiteral(false);
        }
        if (terms.isEmpty() && notTerms.isEmpty()) {
            return this.rexBuilder.makeLiteral(true);
        }
        if (terms.size() == 1 && notTerms.isEmpty()) {
            return this.simplify(terms.get(0));
        }
        ArrayListMultimap<String, Pair<String, RexNode>> equalityTerms = ArrayListMultimap.create();
        HashMap<String, Pair<Range<C>, List<RexNode>>> rangeTerms = new HashMap<String, Pair<Range<C>, List<RexNode>>>();
        HashMap<String, String> equalityConstantTerms = new HashMap<String, String>();
        HashSet<String> negatedTerms = new HashSet<String>();
        HashSet<String> nullOperands = new HashSet<String>();
        LinkedHashSet<RexNode> notNullOperands = new LinkedHashSet<RexNode>();
        HashSet<String> comparedOperands = new HashSet<String>();
        for (RexNode predicate : this.predicates.pulledUpPredicates) {
            RexNode result;
            Comparable v0;
            Comparison comparison2 = Comparison.of(predicate);
            if (comparison2 == null || comparison2.kind == SqlKind.NOT_EQUALS || (v0 = (Comparable)comparison2.literal.getValueAs(clazz)) == null || (result = RexSimplify.processRange(this.rexBuilder, terms, rangeTerms, predicate, comparison2.ref, v0, comparison2.kind)) == null) continue;
            return result;
        }
        block9: for (int i = 0; i < terms.size(); ++i) {
            RexCall call;
            RexNode term3 = terms.get(i);
            if (!RexUtil.isDeterministic(term3)) continue;
            while (term3.getKind() == SqlKind.EQUALS) {
                call = (RexCall)term3;
                if (call.getOperands().get(0).isAlwaysTrue()) {
                    term3 = call.getOperands().get(1);
                    terms.set(i, term3);
                    continue;
                }
                if (!call.getOperands().get(1).isAlwaysTrue()) break;
                term3 = call.getOperands().get(0);
                terms.set(i, term3);
            }
            switch (term3.getKind()) {
                case EQUALS: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case NOT_EQUALS: {
                    Comparable constant;
                    RexNode result;
                    RexNode term2;
                    RexNode negatedTerm;
                    Comparison comparison3;
                    call = (RexCall)term3;
                    RexNode left = call.getOperands().get(0);
                    comparedOperands.add(left.toString());
                    if (left.getKind() == SqlKind.CAST) {
                        RexCall leftCast = (RexCall)left;
                        comparedOperands.add(leftCast.getOperands().get(0).toString());
                    }
                    RexNode right = call.getOperands().get(1);
                    comparedOperands.add(right.toString());
                    if (right.getKind() == SqlKind.CAST) {
                        RexCall rightCast = (RexCall)right;
                        comparedOperands.add(rightCast.getOperands().get(0).toString());
                    }
                    if ((comparison3 = Comparison.of(term3)) != null && comparison3.literal.getValue() == null) {
                        return this.rexBuilder.makeLiteral(false);
                    }
                    if (term3.getKind() == SqlKind.EQUALS) {
                        if (comparison3 != null) {
                            String literal = comparison3.literal.toString();
                            String prevLiteral = equalityConstantTerms.put(comparison3.ref.toString(), literal);
                            if (prevLiteral != null && !literal.equals(prevLiteral)) {
                                return this.rexBuilder.makeLiteral(false);
                            }
                        } else if (RexUtil.isReferenceOrAccess(left, true) && RexUtil.isReferenceOrAccess(right, true)) {
                            equalityTerms.put(left.toString(), Pair.of(right.toString(), term3));
                        }
                    }
                    if ((negatedTerm = RexUtil.negate(this.rexBuilder, call)) != null) {
                        negatedTerms.add(negatedTerm.toString());
                        RexNode invertNegatedTerm = RexUtil.invert(this.rexBuilder, (RexCall)negatedTerm);
                        if (invertNegatedTerm != null) {
                            negatedTerms.add(invertNegatedTerm.toString());
                        }
                    }
                    if ((term2 = this.simplifyUsingPredicates(term3, clazz)) != term3) {
                        term3 = term2;
                        terms.set(i, term3);
                    }
                    if (comparison3 == null || comparison3.kind == SqlKind.NOT_EQUALS || (result = RexSimplify.processRange(this.rexBuilder, terms, rangeTerms, term3, comparison3.ref, constant = (Comparable)comparison3.literal.getValueAs(clazz), comparison3.kind)) == null) continue block9;
                    return result;
                }
                case IN: {
                    comparedOperands.add(((RexNode)((RexCall)term3).operands.get(0)).toString());
                    continue block9;
                }
                case BETWEEN: {
                    comparedOperands.add(((RexNode)((RexCall)term3).operands.get(1)).toString());
                    continue block9;
                }
                case IS_NOT_NULL: {
                    notNullOperands.add(((RexCall)term3).getOperands().get(0));
                    terms.remove(i);
                    --i;
                    continue block9;
                }
                case IS_NULL: {
                    nullOperands.add(((RexCall)term3).getOperands().get(0).toString());
                }
            }
        }
        if (!Collections.disjoint(nullOperands, comparedOperands)) {
            return this.rexBuilder.makeLiteral(false);
        }
        for (String ref1 : equalityTerms.keySet()) {
            String literal1 = (String)equalityConstantTerms.get(ref1);
            if (literal1 == null) continue;
            Collection references = equalityTerms.get(ref1);
            for (Pair ref2 : references) {
                String literal2 = (String)equalityConstantTerms.get(ref2.left);
                if (literal2 == null) continue;
                if (!literal1.equals(literal2)) {
                    return this.rexBuilder.makeLiteral(false);
                }
                terms.remove(ref2.right);
            }
        }
        for (RexNode operand : notNullOperands) {
            if (comparedOperands.contains(operand.toString())) continue;
            terms.add(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operand));
        }
        HashSet<String> termsSet = new HashSet<String>(RexUtil.strings(terms));
        for (RexNode notDisjunction : notTerms) {
            List<String> terms2Set;
            if (!RexUtil.isDeterministic(notDisjunction) || !termsSet.containsAll(terms2Set = RexUtil.strings(RelOptUtil.conjunctions(notDisjunction)))) continue;
            return this.rexBuilder.makeLiteral(false);
        }
        for (RexNode notDisjunction : notTerms) {
            RexNode call = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, notDisjunction);
            terms.add(this.simplify(call));
        }
        for (String negatedTerm : negatedTerms) {
            if (!termsSet.contains(negatedTerm)) continue;
            return this.rexBuilder.makeLiteral(false);
        }
        return RexUtil.composeConjunction(this.rexBuilder, terms, false);
    }

    private <C extends Comparable<C>> RexNode simplifyUsingPredicates(RexNode e2, Class<C> clazz) {
        Comparison comparison2 = Comparison.of(e2);
        if (comparison2 == null || comparison2.kind == SqlKind.NOT_EQUALS || comparison2.literal.getValue() == null) {
            return e2;
        }
        Comparable v0 = (Comparable)comparison2.literal.getValueAs(clazz);
        Range<Comparable> range = RexSimplify.range(comparison2.kind, v0);
        Range<Comparable> range2 = this.residue(comparison2.ref, range, this.predicates.pulledUpPredicates, clazz);
        if (range2 == null) {
            return this.rexBuilder.makeLiteral(false);
        }
        if (range2.equals(range)) {
            return e2;
        }
        if (range2.equals(Range.all())) {
            return this.rexBuilder.makeLiteral(true);
        }
        if (range2.lowerEndpoint().equals(range2.upperEndpoint())) {
            if (range2.lowerBoundType() == BoundType.OPEN || range2.upperBoundType() == BoundType.OPEN) {
                return this.rexBuilder.makeLiteral(false);
            }
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, comparison2.ref, this.rexBuilder.makeLiteral(range2.lowerEndpoint(), comparison2.literal.getType(), comparison2.literal.getTypeName()));
        }
        return e2;
    }

    private <C extends Comparable<C>> Range<C> residue(RexNode ref, Range<C> r0, List<RexNode> predicates, Class<C> clazz) {
        for (RexNode predicate : predicates) {
            switch (predicate.getKind()) {
                case EQUALS: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    RexCall call = (RexCall)predicate;
                    if (!((RexNode)call.operands.get(0)).equals(ref) || !(call.operands.get(1) instanceof RexLiteral)) break;
                    RexLiteral literal = (RexLiteral)call.operands.get(1);
                    Comparable c1 = (Comparable)literal.getValueAs(clazz);
                    Range<Comparable> r1 = RexSimplify.range(predicate.getKind(), c1);
                    if (r0.encloses(r1)) {
                        return Range.all();
                    }
                    if (r0.isConnected(r1)) {
                        return r0.intersection(r1);
                    }
                    return null;
                }
            }
        }
        return r0;
    }

    public RexNode simplifyOr(RexCall call) {
        assert (call.getKind() == SqlKind.OR);
        List<RexNode> terms = RelOptUtil.disjunctions(call);
        return this.simplifyOrs(terms);
    }

    public RexNode simplifyOrs(List<RexNode> terms) {
        block3: for (int i = 0; i < terms.size(); ++i) {
            RexNode term2 = this.simplify(terms.get(i));
            switch (term2.getKind()) {
                case LITERAL: {
                    if (!RexLiteral.isNullLiteral(term2)) {
                        if (RexLiteral.booleanValue(term2)) {
                            return term2;
                        }
                        terms.remove(i);
                        --i;
                        continue block3;
                    }
                }
                default: {
                    terms.set(i, term2);
                }
            }
        }
        return RexUtil.composeDisjunction(this.rexBuilder, terms);
    }

    private RexNode simplifyCast(RexCall e2) {
        RexNode operand = e2.getOperands().get(0);
        switch (operand.getKind()) {
            case LITERAL: {
                RexLiteral literal = (RexLiteral)operand;
                Comparable value = literal.getValueAs(Comparable.class);
                SqlTypeName typeName = literal.getTypeName();
                if (this.rexBuilder.canRemoveCastFromLiteral(e2.getType(), value, typeName)) {
                    return this.rexBuilder.makeCast(e2.getType(), operand);
                }
                switch (literal.getTypeName()) {
                    case TIME: {
                        switch (e2.getType().getSqlTypeName()) {
                            case TIMESTAMP: {
                                return e2;
                            }
                        }
                    }
                }
                ArrayList<RexNode> reducedValues = new ArrayList<RexNode>();
                this.executor.reduce(this.rexBuilder, ImmutableList.of(e2), reducedValues);
                return Preconditions.checkNotNull(Iterables.getOnlyElement(reducedValues));
            }
        }
        return e2;
    }

    private RexNode simplifyCeilFloor(RexCall e2) {
        if (e2.getOperands().size() != 2) {
            return e2;
        }
        RexNode operand = this.simplify(e2.getOperands().get(0));
        switch (operand.getKind()) {
            case CEIL: 
            case FLOOR: {
                RexCall child = (RexCall)operand;
                if (child.getOperands().size() != 2) {
                    return e2;
                }
                RexLiteral parentFlag = (RexLiteral)e2.operands.get(1);
                TimeUnitRange parentFlagValue = (TimeUnitRange)((Object)parentFlag.getValue());
                RexLiteral childFlag = (RexLiteral)child.operands.get(1);
                TimeUnitRange childFlagValue = (TimeUnitRange)((Object)childFlag.getValue());
                if (parentFlagValue == null || childFlagValue == null || !RexSimplify.canRollUp(parentFlagValue.startUnit, childFlagValue.startUnit)) break;
                return e2.clone(e2.getType(), ImmutableList.of(child.getOperands().get(0), parentFlag));
            }
        }
        return e2.clone(e2.getType(), ImmutableList.of(operand, e2.getOperands().get(1)));
    }

    private static boolean canRollUp(TimeUnit outer, TimeUnit inner) {
        switch (outer) {
            case YEAR: 
            case MONTH: 
            case DAY: 
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case MILLISECOND: 
            case MICROSECOND: {
                switch (inner) {
                    case YEAR: 
                    case QUARTER: 
                    case MONTH: 
                    case DAY: 
                    case HOUR: 
                    case MINUTE: 
                    case SECOND: 
                    case MILLISECOND: 
                    case MICROSECOND: {
                        if (inner == TimeUnit.QUARTER) {
                            return outer == TimeUnit.YEAR || outer == TimeUnit.QUARTER;
                        }
                        return outer.ordinal() <= inner.ordinal();
                    }
                }
                break;
            }
            case QUARTER: {
                switch (inner) {
                    case QUARTER: 
                    case MONTH: 
                    case DAY: 
                    case HOUR: 
                    case MINUTE: 
                    case SECOND: 
                    case MILLISECOND: 
                    case MICROSECOND: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public RexNode removeNullabilityCast(RexNode e2) {
        return RexUtil.removeNullabilityCast(this.rexBuilder.getTypeFactory(), e2);
    }

    private static <C extends Comparable<C>> RexNode processRange(RexBuilder rexBuilder, List<RexNode> terms, Map<String, Pair<Range<C>, List<RexNode>>> rangeTerms, RexNode term2, RexNode ref, C v0, SqlKind comparison2) {
        Pair<Range<C>, List<RexNode>> p = rangeTerms.get(ref.toString());
        if (p == null) {
            rangeTerms.put(ref.toString(), Pair.of(RexSimplify.range(comparison2, v0), ImmutableList.of(term2)));
        } else {
            ImmutableList.Builder newBounds;
            boolean removeUpperBound = false;
            boolean removeLowerBound = false;
            Range<C> r = (Range<C>)p.left;
            switch (comparison2) {
                case EQUALS: {
                    if (!r.contains(v0)) {
                        return rexBuilder.makeLiteral(false);
                    }
                    rangeTerms.put(ref.toString(), Pair.of(Range.singleton(v0), ImmutableList.of(term2)));
                    for (RexNode e2 : (List)p.right) {
                        Collections.replaceAll(terms, e2, rexBuilder.makeLiteral(true));
                    }
                    break;
                }
                case LESS_THAN: {
                    int comparisonResult = 0;
                    if (r.hasUpperBound()) {
                        comparisonResult = v0.compareTo(r.upperEndpoint());
                    }
                    if (comparisonResult <= 0) {
                        if (r.hasLowerBound()) {
                            if (v0.compareTo(r.lowerEndpoint()) <= 0) {
                                return rexBuilder.makeLiteral(false);
                            }
                            r = Range.range(r.lowerEndpoint(), r.lowerBoundType(), v0, BoundType.OPEN);
                        } else {
                            r = Range.lessThan(v0);
                        }
                        if (r.isEmpty()) {
                            return rexBuilder.makeLiteral(false);
                        }
                        removeUpperBound = true;
                        break;
                    }
                    int index = terms.indexOf(term2);
                    if (index < 0) break;
                    terms.set(index, rexBuilder.makeLiteral(true));
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    int comparisonResult = -1;
                    if (r.hasUpperBound()) {
                        comparisonResult = v0.compareTo(r.upperEndpoint());
                    }
                    if (comparisonResult < 0) {
                        if (r.hasLowerBound()) {
                            if (v0.compareTo(r.lowerEndpoint()) < 0) {
                                return rexBuilder.makeLiteral(false);
                            }
                            r = Range.range(r.lowerEndpoint(), r.lowerBoundType(), v0, BoundType.CLOSED);
                        } else {
                            r = Range.atMost(v0);
                        }
                        if (r.isEmpty()) {
                            return rexBuilder.makeLiteral(false);
                        }
                        removeUpperBound = true;
                        break;
                    }
                    int index = terms.indexOf(term2);
                    if (index < 0) break;
                    terms.set(index, rexBuilder.makeLiteral(true));
                    break;
                }
                case GREATER_THAN: {
                    int comparisonResult = 0;
                    if (r.hasLowerBound()) {
                        comparisonResult = v0.compareTo(r.lowerEndpoint());
                    }
                    if (comparisonResult >= 0) {
                        if (r.hasUpperBound()) {
                            if (v0.compareTo(r.upperEndpoint()) >= 0) {
                                return rexBuilder.makeLiteral(false);
                            }
                            r = Range.range(v0, BoundType.OPEN, r.upperEndpoint(), r.upperBoundType());
                        } else {
                            r = Range.greaterThan(v0);
                        }
                        if (r.isEmpty()) {
                            return rexBuilder.makeLiteral(false);
                        }
                        removeLowerBound = true;
                        break;
                    }
                    int index = terms.indexOf(term2);
                    if (index < 0) break;
                    terms.set(index, rexBuilder.makeLiteral(true));
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    int comparisonResult = 1;
                    if (r.hasLowerBound()) {
                        comparisonResult = v0.compareTo(r.lowerEndpoint());
                    }
                    if (comparisonResult > 0) {
                        if (r.hasUpperBound()) {
                            if (v0.compareTo(r.upperEndpoint()) > 0) {
                                return rexBuilder.makeLiteral(false);
                            }
                            r = Range.range(v0, BoundType.CLOSED, r.upperEndpoint(), r.upperBoundType());
                        } else {
                            r = Range.atLeast(v0);
                        }
                        if (r.isEmpty()) {
                            return rexBuilder.makeLiteral(false);
                        }
                        removeLowerBound = true;
                        break;
                    }
                    int index = terms.indexOf(term2);
                    if (index < 0) break;
                    terms.set(index, rexBuilder.makeLiteral(true));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (removeUpperBound) {
                newBounds = ImmutableList.builder();
                for (RexNode e3 : (List)p.right) {
                    if (RexSimplify.isUpperBound(e3)) {
                        Collections.replaceAll(terms, e3, rexBuilder.makeLiteral(true));
                        continue;
                    }
                    newBounds.add(e3);
                }
                newBounds.add(term2);
                rangeTerms.put(ref.toString(), Pair.of(r, newBounds.build()));
            } else if (removeLowerBound) {
                newBounds = ImmutableList.builder();
                for (RexNode e4 : (List)p.right) {
                    if (RexSimplify.isLowerBound(e4)) {
                        Collections.replaceAll(terms, e4, rexBuilder.makeLiteral(true));
                        continue;
                    }
                    newBounds.add(e4);
                }
                newBounds.add(term2);
                rangeTerms.put(ref.toString(), Pair.of(r, newBounds.build()));
            }
        }
        return null;
    }

    private static <C extends Comparable<C>> Range<C> range(SqlKind comparison2, C c) {
        switch (comparison2) {
            case EQUALS: {
                return Range.singleton(c);
            }
            case LESS_THAN: {
                return Range.lessThan(c);
            }
            case LESS_THAN_OR_EQUAL: {
                return Range.atMost(c);
            }
            case GREATER_THAN: {
                return Range.greaterThan(c);
            }
            case GREATER_THAN_OR_EQUAL: {
                return Range.atLeast(c);
            }
        }
        throw new AssertionError();
    }

    private static boolean isUpperBound(RexNode e2) {
        switch (e2.getKind()) {
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                List<RexNode> operands = ((RexCall)e2).getOperands();
                return RexUtil.isReferenceOrAccess(operands.get(0), true) && operands.get(1).isA(SqlKind.LITERAL);
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                List<RexNode> operands = ((RexCall)e2).getOperands();
                return RexUtil.isReferenceOrAccess(operands.get(1), true) && operands.get(0).isA(SqlKind.LITERAL);
            }
        }
        return false;
    }

    private static boolean isLowerBound(RexNode e2) {
        switch (e2.getKind()) {
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                List<RexNode> operands = ((RexCall)e2).getOperands();
                return RexUtil.isReferenceOrAccess(operands.get(1), true) && operands.get(0).isA(SqlKind.LITERAL);
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                List<RexNode> operands = ((RexCall)e2).getOperands();
                return RexUtil.isReferenceOrAccess(operands.get(0), true) && operands.get(1).isA(SqlKind.LITERAL);
            }
        }
        return false;
    }

    private static class Comparison {
        final RexNode ref;
        final SqlKind kind;
        final RexLiteral literal;

        private Comparison(RexNode ref, SqlKind kind, RexLiteral literal) {
            this.ref = Preconditions.checkNotNull(ref);
            this.kind = Preconditions.checkNotNull(kind);
            this.literal = Preconditions.checkNotNull(literal);
        }

        /*
         * Enabled aggressive block sorting
         */
        static Comparison of(RexNode e2) {
            switch (e2.getKind()) {
                case EQUALS: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case NOT_EQUALS: {
                    RexCall call = (RexCall)e2;
                    RexNode left = call.getOperands().get(0);
                    RexNode right = call.getOperands().get(1);
                    switch (right.getKind()) {
                        case LITERAL: {
                            if (!RexUtil.isReferenceOrAccess(left, true)) break;
                            return new Comparison(left, e2.getKind(), (RexLiteral)right);
                        }
                    }
                    switch (left.getKind()) {
                        case LITERAL: {
                            if (!RexUtil.isReferenceOrAccess(right, true)) return null;
                            return new Comparison(right, e2.getKind().reverse(), (RexLiteral)left);
                        }
                    }
                    return null;
                }
            }
            return null;
        }
    }
}

