/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.datastream;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.api.TableConfig$;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.plan.nodes.FlinkConventions$;
import org.apache.flink.table.plan.nodes.datastream.DataStreamJoin;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalJoin;
import org.apache.flink.table.plan.rules.datastream.DataStreamJoinRule$;
import org.apache.flink.table.plan.schema.RowSchema;
import org.apache.flink.table.runtime.join.WindowJoinUtil;
import org.apache.flink.table.runtime.join.WindowJoinUtil$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u3A!\u0001\u0002\u0001#\t\u0011B)\u0019;b'R\u0014X-Y7K_&t'+\u001e7f\u0015\t\u0019A!\u0001\u0006eCR\f7\u000f\u001e:fC6T!!\u0002\u0004\u0002\u000bI,H.Z:\u000b\u0005\u001dA\u0011\u0001\u00029mC:T!!\u0003\u0006\u0002\u000bQ\f'\r\\3\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CG\u0007\u0002))\u0011QCF\u0001\bG>tg/\u001a:u\u0015\t9\u0002$A\u0002sK2T!!\u0007\u0007\u0002\u000f\r\fGnY5uK&\u00111\u0004\u0006\u0002\u000e\u0007>tg/\u001a:uKJ\u0014V\u000f\\3\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005\u0011\u0001\"\u0002\u0012\u0001\t\u0003\u0019\u0013!F1dG\u0016\u001c8/Z:US6,\u0017\t\u001e;sS\n,H/\u001a\u000b\u0004I)\u0012\u0004CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#a\u0002\"p_2,\u0017M\u001c\u0005\u0006W\u0005\u0002\r\u0001L\u0001\u0005Kb\u0004(\u000f\u0005\u0002.a5\taF\u0003\u000201\u0005\u0019!/\u001a=\n\u0005Er#a\u0002*fq:{G-\u001a\u0005\u0006g\u0005\u0002\r\u0001N\u0001\nS:\u0004X\u000f\u001e+za\u0016\u0004\"!\u000e\u001d\u000e\u0003YR!a\u000e\f\u0002\tQL\b/Z\u0005\u0003sY\u00121BU3m\t\u0006$\u0018\rV=qK\")1\b\u0001C!y\u00059Q.\u0019;dQ\u0016\u001cHC\u0001\u0013>\u0011\u0015q$\b1\u0001@\u0003\u0011\u0019\u0017\r\u001c7\u0011\u0005\u0001\u0013U\"A!\u000b\u0005\u001dA\u0012BA\"B\u00059\u0011V\r\\(qiJ+H.Z\"bY2DQ!\u0006\u0001\u0005B\u0015#\"A\u0012&\u0011\u0005\u001dCU\"\u0001\f\n\u0005%3\"a\u0002*fY:{G-\u001a\u0005\u0006/\u0011\u0003\rAR\u0004\u0006\u0019\nA\t!T\u0001\u0013\t\u0006$\u0018m\u0015;sK\u0006l'j\\5o%VdW\r\u0005\u0002!\u001d\u001a)\u0011A\u0001E\u0001\u001fN\u0011a\n\u0015\t\u0003KEK!A\u0015\u0014\u0003\r\u0005s\u0017PU3g\u0011\u0015ib\n\"\u0001U)\u0005i\u0005b\u0002,O\u0005\u0004%\taV\u0001\t\u0013:\u001bF+\u0011(D\u000bV\t\u0001\f\u0005\u0002A3&\u0011!,\u0011\u0002\u000b%\u0016dw\n\u001d;Sk2,\u0007B\u0002/OA\u0003%\u0001,A\u0005J\u001dN#\u0016IT\"FA\u0001")
public class DataStreamJoinRule
extends ConverterRule {
    public static RelOptRule INSTANCE() {
        return DataStreamJoinRule$.MODULE$.INSTANCE();
    }

    public boolean accessesTimeAttribute(RexNode expr, RelDataType inputType) {
        boolean bl;
        RexNode rexNode = expr;
        if (rexNode instanceof RexInputRef) {
            RexInputRef rexInputRef = (RexInputRef)rexNode;
            RelDataType accessedType = inputType.getFieldList().get(rexInputRef.getIndex()).getType();
            bl = FlinkTypeFactory$.MODULE$.isTimeIndicatorType(accessedType);
        } else if (rexNode instanceof RexCall) {
            RexCall rexCall = (RexCall)rexNode;
            bl = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rexCall.operands).asScala()).exists((Function1)new Serializable(this, inputType){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DataStreamJoinRule $outer;
                private final RelDataType inputType$1;

                public final boolean apply(RexNode x$1) {
                    return this.$outer.accessesTimeAttribute(x$1, this.inputType$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.inputType$1 = inputType$1;
                }
            });
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalJoin join = (FlinkLogicalJoin)call.rel(0);
        JoinInfo joinInfo = join.analyzeCondition();
        Tuple2<Option<WindowJoinUtil.WindowBounds>, Option<RexNode>> tuple2 = WindowJoinUtil$.MODULE$.extractWindowBoundsFromPredicate(joinInfo.getRemaining(join.getCluster().getRexBuilder()), join.getLeft().getRowType().getFieldCount(), join.getRowType(), join.getCluster().getRexBuilder(), TableConfig$.MODULE$.DEFAULT());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Option windowBounds = (Option)tuple2._1();
            Option remainingPreds = (Option)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)windowBounds, (Object)remainingPreds);
            Option windowBounds2 = (Option)tuple23._1();
            Option remainingPreds2 = (Option)tuple23._2();
            boolean remainingPredsAccessTime = remainingPreds2.isDefined() && this.accessesTimeAttribute((RexNode)remainingPreds2.get(), join.getRowType());
            boolean rowTimeAttrInOutput = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(join.getRowType().getFieldList()).asScala()).exists((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(RelDataTypeField f) {
                    return FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(f.getType());
                }
            });
            return windowBounds2.isEmpty() && !remainingPredsAccessTime && !rowTimeAttrInOutput;
        }
        throw new MatchError(tuple2);
    }

    @Override
    public RelNode convert(RelNode rel) {
        FlinkLogicalJoin join = (FlinkLogicalJoin)rel;
        RelTraitSet traitSet = rel.getTraitSet().replace(FlinkConventions$.MODULE$.DATASTREAM());
        RelNode convLeft = RelOptRule.convert(join.getInput(0), FlinkConventions$.MODULE$.DATASTREAM());
        RelNode convRight = RelOptRule.convert(join.getInput(1), FlinkConventions$.MODULE$.DATASTREAM());
        JoinInfo joinInfo = join.analyzeCondition();
        RowSchema leftRowSchema = new RowSchema(convLeft.getRowType());
        RowSchema rightRowSchema = new RowSchema(convRight.getRowType());
        return new DataStreamJoin(rel.getCluster(), traitSet, convLeft, convRight, join.getCondition(), joinInfo, join.getJoinType(), leftRowSchema, rightRowSchema, new RowSchema(rel.getRowType()), this.description);
    }

    public DataStreamJoinRule() {
        super(FlinkLogicalJoin.class, FlinkConventions$.MODULE$.LOGICAL(), FlinkConventions$.MODULE$.DATASTREAM(), "DataStreamJoinRule");
    }
}

