/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001B\u0001\u0003\u0001=\u0011qc\u0012:pkB\fum\u001a)s_\u000e,7o\u001d$v]\u000e$\u0018n\u001c8\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\u000e$!\u0011\t\"\u0003\u0006\u000b\u000e\u0003\tI!a\u0005\u0002\u0003?A\u0013xnY3tg\u001a+hn\u0019;j_:<\u0016\u000e\u001e5DY\u0016\fg.\u001e9Ti\u0006$X\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u0005)A/\u001f9fg&\u0011\u0011D\u0006\u0002\u0005\u0007J{w\u000fE\u0002\u001c=\u0001j\u0011\u0001\b\u0006\u0003;\u0019\tqaY8eK\u001e,g.\u0003\u0002 9\tA1i\\7qS2,'\u000f\u0005\u0002\u0012C%\u0011!E\u0001\u0002\u0016\u000f\u0016tWM]1uK\u0012\fum\u001a:fO\u0006$\u0018n\u001c8t!\t!s%D\u0001&\u0015\t1c!\u0001\u0003vi&d\u0017B\u0001\u0015&\u0005\u001daunZ4j]\u001eD\u0001B\u000b\u0001\u0003\u0006\u0004%IaK\u0001\u0010O\u0016t\u0017iZ4sK\u001e\fG/[8ogV\tA\u0006\u0005\u0002\u001c[%\u0011a\u0006\b\u0002\u001e\u000f\u0016tWM]1uK\u0012\fum\u001a:fO\u0006$\u0018n\u001c8t\rVt7\r^5p]\"A\u0001\u0007\u0001B\u0001B\u0003%A&\u0001\thK:\fum\u001a:fO\u0006$\u0018n\u001c8tA!A!\u0007\u0001BC\u0002\u0013%1'\u0001\u000bbO\u001e\u0014XmZ1uS>t7\u000b^1uKRK\b/Z\u000b\u0002iA\u0011Q\u0007P\u0007\u0002m)\u0011q\u0007O\u0001\nif\u0004X-\u001e;jYNT!!\u000f\u001e\u0002\t)\fg/\u0019\u0006\u0003w!\t1!\u00199j\u0013\tidGA\u0006S_^$\u0016\u0010]3J]\u001a|\u0007\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002+\u0005<wM]3hCRLwN\\*uCR,G+\u001f9fA!A\u0011\t\u0001BC\u0002\u0013%!)\u0001\nhK:,'/\u0019;f%\u0016$(/Y2uS>tW#A\"\u0011\u0005\u0011;U\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\u000f\t{w\u000e\\3b]\"A!\n\u0001B\u0001B\u0003%1)A\nhK:,'/\u0019;f%\u0016$(/Y2uS>t\u0007\u0005\u0003\u0005M\u0001\t\u0015\r\u0011\"\u0003N\u0003-\tX/\u001a:z\u0007>tg-[4\u0016\u00039\u0003\"aT)\u000e\u0003AS!a\u000f\u0004\n\u0005I\u0003&!E*ue\u0016\fW.U;fef\u001cuN\u001c4jO\"AA\u000b\u0001B\u0001B\u0003%a*\u0001\u0007rk\u0016\u0014\u0018pQ8oM&<\u0007\u0005C\u0003W\u0001\u0011\u0005q+\u0001\u0004=S:LGO\u0010\u000b\u00061fS6\f\u0018\t\u0003#\u0001AQAK+A\u00021BQAM+A\u0002QBQ!Q+A\u0002\rCQ\u0001T+A\u00029C\u0011B\u0018\u0001A\u0002\u0003\u0007I\u0011B0\u0002\u0011\u0019,hn\u0019;j_:,\u0012\u0001\t\u0005\nC\u0002\u0001\r\u00111A\u0005\n\t\fABZ;oGRLwN\\0%KF$\"a\u00194\u0011\u0005\u0011#\u0017BA3F\u0005\u0011)f.\u001b;\t\u000f\u001d\u0004\u0017\u0011!a\u0001A\u0005\u0019\u0001\u0010J\u0019\t\r%\u0004\u0001\u0015)\u0003!\u0003%1WO\\2uS>t\u0007\u0005C\u0005l\u0001\u0001\u0007\t\u0019!C\u0005Y\u00061a.Z<S_^,\u0012\u0001\u0006\u0005\n]\u0002\u0001\r\u00111A\u0005\n=\f!B\\3x%><x\fJ3r)\t\u0019\u0007\u000fC\u0004h[\u0006\u0005\t\u0019\u0001\u000b\t\rI\u0004\u0001\u0015)\u0003\u0015\u0003\u001dqWm\u001e*po\u0002B\u0011\u0002\u001e\u0001A\u0002\u0003\u0007I\u0011\u00027\u0002\u000fA\u0014XM\u001e*po\"Ia\u000f\u0001a\u0001\u0002\u0004%Ia^\u0001\faJ,gOU8x?\u0012*\u0017\u000f\u0006\u0002dq\"9q-^A\u0001\u0002\u0004!\u0002B\u0002>\u0001A\u0003&A#\u0001\u0005qe\u00164(k\\<!\u0011%a\b\u00011AA\u0002\u0013%!)\u0001\u0005gSJ\u001cHOU8x\u0011%q\b\u00011AA\u0002\u0013%q0\u0001\u0007gSJ\u001cHOU8x?\u0012*\u0017\u000fF\u0002d\u0003\u0003AqaZ?\u0002\u0002\u0003\u00071\tC\u0004\u0002\u0006\u0001\u0001\u000b\u0015B\"\u0002\u0013\u0019L'o\u001d;S_^\u0004\u0003bCA\u0005\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0017\tQa\u001d;bi\u0016,\"!!\u0004\u0011\r\u0005=\u0011qCA\u000e\u001b\t\t\tB\u0003\u0003\u0002\n\u0005M!bAA\u000bu\u000511m\\7n_:LA!!\u0007\u0002\u0012\tQa+\u00197vKN#\u0018\r^3\u0011\t\u0005u\u0011\u0011E\u0007\u0003\u0003?Q!a\u0006\u0005\n\t\u0005\r\u0012q\u0004\u0002\u0004%><\bbCA\u0014\u0001\u0001\u0007\t\u0019!C\u0005\u0003S\t\u0011b\u001d;bi\u0016|F%Z9\u0015\u0007\r\fY\u0003C\u0005h\u0003K\t\t\u00111\u0001\u0002\u000e!A\u0011q\u0006\u0001!B\u0013\ti!\u0001\u0004ti\u0006$X\r\t\u0005\f\u0003g\u0001\u0001\u0019!a\u0001\n\u0013\t)$\u0001\u0005d]R\u001cF/\u0019;f+\t\t9\u0004\u0005\u0004\u0002\u0010\u0005]\u0011\u0011\b\t\u0005\u0003w\t\u0019%\u0004\u0002\u0002>)!\u0011qHA!\u0003\u0011a\u0017M\\4\u000b\u0003eJA!!\u0012\u0002>\t!Aj\u001c8h\u0011-\tI\u0005\u0001a\u0001\u0002\u0004%I!a\u0013\u0002\u0019\rtGo\u0015;bi\u0016|F%Z9\u0015\u0007\r\fi\u0005C\u0005h\u0003\u000f\n\t\u00111\u0001\u00028!A\u0011\u0011\u000b\u0001!B\u0013\t9$A\u0005d]R\u001cF/\u0019;fA!9\u0011Q\u000b\u0001\u0005B\u0005]\u0013\u0001B8qK:$2aYA-\u0011!\tY&a\u0015A\u0002\u0005u\u0013AB2p]\u001aLw\r\u0005\u0003\u0002`\u0005\u0015TBAA1\u0015\r\t\u0019\u0007C\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0014\u0011\r\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\u0005-\u0004\u0001\"\u0011\u0002n\u0005q\u0001O]8dKN\u001cX\t\\3nK:$HcB2\u0002p\u0005M\u0014q\u0012\u0005\b\u0003c\nI\u00071\u0001\u0015\u0003\u0019Ig\u000e];u\u0007\"A\u0011QOA5\u0001\u0004\t9(A\u0002dib\u0004B!!\u001f\u0002\fB1\u00111PAD)Qi!!! \u000b\t\u0005}\u0014\u0011Q\u0001\nMVt7\r^5p]NT1aOAB\u0015\r\t)\tC\u0001\ngR\u0014X-Y7j]\u001eLA!!#\u0002~\ty\u0001K]8dKN\u001ch)\u001e8di&|g.\u0003\u0003\u0002\u000e\u0006\u001d%aB\"p]R,\u0007\u0010\u001e\u0005\t\u0003#\u000bI\u00071\u0001\u0002\u0014\u0006\u0019q.\u001e;\u0011\u000b\u0005U\u0015\u0011\u0014\u000b\u000e\u0005\u0005]%B\u0001\u0014\t\u0013\u0011\tY*a&\u0003\u0013\r{G\u000e\\3di>\u0014\bbBAP\u0001\u0011\u0005\u0013\u0011U\u0001\b_:$\u0016.\\3s)\u001d\u0019\u00171UAV\u0003gC\u0001\"!*\u0002\u001e\u0002\u0007\u0011qU\u0001\ni&lWm\u001d;b[B\u00042\u0001RAU\u0013\r\t)%\u0012\u0005\t\u0003k\ni\n1\u0001\u0002.B!\u0011\u0011PAX\u0013\u0011\t\t,a\"\u0003\u001d=sG+[7fe\u000e{g\u000e^3yi\"A\u0011\u0011SAO\u0001\u0004\t\u0019\nC\u0004\u00028\u0002!\t%!/\u0002\u000b\rdwn]3\u0015\u0003\r\u0004")
public class GroupAggProcessFunction
extends ProcessFunctionWithCleanupState<CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final RowTypeInfo aggregationStateType;
    private final boolean generateRetraction;
    private final StreamQueryConfig queryConfig;
    private GeneratedAggregations function;
    private CRow newRow;
    private CRow prevRow;
    private boolean firstRow;
    private ValueState<Row> state;
    private ValueState<Long> cntState;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        GroupAggProcessFunction groupAggProcessFunction = this;
        synchronized (groupAggProcessFunction) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private GeneratedAggregationsFunction genAggregations() {
        return this.genAggregations;
    }

    private RowTypeInfo aggregationStateType() {
        return this.aggregationStateType;
    }

    private boolean generateRetraction() {
        return this.generateRetraction;
    }

    private StreamQueryConfig queryConfig() {
        return this.queryConfig;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    private CRow newRow() {
        return this.newRow;
    }

    private void newRow_$eq(CRow x$1) {
        this.newRow = x$1;
    }

    private CRow prevRow() {
        return this.prevRow;
    }

    private void prevRow_$eq(CRow x$1) {
        this.prevRow = x$1;
    }

    private boolean firstRow() {
        return this.firstRow;
    }

    private void firstRow_$eq(boolean x$1) {
        this.firstRow = x$1;
    }

    private ValueState<Row> state() {
        return this.state;
    }

    private void state_$eq(ValueState<Row> x$1) {
        this.state = x$1;
    }

    private ValueState<Long> cntState() {
        return this.cntState;
    }

    private void cntState_$eq(ValueState<Long> x$1) {
        this.cntState = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", ".name \\n\\n "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ".code"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations().name(), this.genAggregations().code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.newRow_$eq(new CRow(this.function().createOutputRow(), true));
        this.prevRow_$eq(new CRow(this.function().createOutputRow(), false));
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor("GroupAggregateState", (TypeInformation)this.aggregationStateType());
        this.state_$eq((ValueState<Row>)this.getRuntimeContext().getState(stateDescriptor));
        ValueStateDescriptor inputCntDescriptor = new ValueStateDescriptor("GroupAggregateInputCounter", Types$.MODULE$.LONG());
        this.cntState_$eq((ValueState<Long>)this.getRuntimeContext().getState(inputCntDescriptor));
        this.initCleanupTimeState("GroupAggregateCleanupTime");
    }

    public void processElement(CRow inputC, ProcessFunction.Context ctx, Collector<CRow> out) {
        long currentTime2 = ctx.timerService().currentProcessingTime();
        this.registerProcessingCleanupTimer(ctx, currentTime2);
        Row input = inputC.row();
        Row accumulators = (Row)this.state().value();
        Long inputCnt = (Long)this.cntState().value();
        if (accumulators == null) {
            this.firstRow_$eq(true);
            accumulators = this.function().createAccumulators();
        } else {
            this.firstRow_$eq(false);
        }
        if (inputCnt == null) {
            inputCnt = Predef$.MODULE$.long2Long(0L);
        }
        this.function().setForwardedFields(input, this.newRow().row());
        this.function().setForwardedFields(input, this.prevRow().row());
        this.function().setAggregationResults(accumulators, this.prevRow().row());
        if (inputC.change()) {
            inputCnt = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(inputCnt) + 1L);
            this.function().accumulate(accumulators, input);
            this.function().setAggregationResults(accumulators, this.newRow().row());
        } else {
            inputCnt = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(inputCnt) - 1L);
            this.function().retract(accumulators, input);
            this.function().setAggregationResults(accumulators, this.newRow().row());
        }
        if (BoxesRunTime.equalsNumObject((Number)inputCnt, (Object)BoxesRunTime.boxToInteger((int)0))) {
            out.collect((Object)this.prevRow());
            this.state().clear();
            this.cntState().clear();
        } else {
            this.state().update((Object)accumulators);
            this.cntState().update((Object)inputCnt);
            if (!this.firstRow()) {
                if (this.prevRow().row().equals((Object)this.newRow().row()) && !this.stateCleaningEnabled()) {
                    return;
                }
                if (this.generateRetraction()) {
                    out.collect((Object)this.prevRow());
                }
            }
            out.collect((Object)this.newRow());
        }
    }

    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.needToCleanupState(timestamp)) {
            this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.state(), this.cntState()}));
            this.function().cleanup();
        }
    }

    public void close() {
        this.function().close();
    }

    public GroupAggProcessFunction(GeneratedAggregationsFunction genAggregations, RowTypeInfo aggregationStateType, boolean generateRetraction, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.aggregationStateType = aggregationStateType;
        this.generateRetraction = generateRetraction;
        this.queryConfig = queryConfig;
        super(queryConfig);
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
    }
}

