/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.RowComparator;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.plan.schema.RowSchema;
import org.apache.flink.table.runtime.aggregate.CollectionRowComparator;
import org.apache.flink.table.runtime.aggregate.ProcTimeSortProcessFunction;
import org.apache.flink.table.runtime.aggregate.RowTimeSortProcessFunction;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.runtime.types.CRowTypeInfo$;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.reflect.ClassTag$;

public final class SortUtil$ {
    public static final SortUtil$ MODULE$;

    static {
        new SortUtil$();
    }

    public ProcessFunction<CRow, CRow> createRowTimeSortFunction(RelCollation collationSort, RelDataType inputType, TypeInformation<Row> inputTypeInfo, ExecutionConfig execCfg) {
        None$ none$;
        Preconditions.checkArgument((collationSort.getFieldCollations().size() > 0 ? 1 : 0) != 0);
        int rowtimeIdx = collationSort.getFieldCollations().get(0).getFieldIndex();
        if (collationSort.getFieldCollations().size() > 1) {
            RowComparator rowComp = this.createRowComparator(inputType, (Seq<RelFieldCollation>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(collationSort.getFieldCollations()).asScala()).tail()), execCfg);
            none$ = new Some((Object)new CollectionRowComparator((TypeComparator<Row>)rowComp));
        } else {
            none$ = None$.MODULE$;
        }
        None$ collectionRowComparator = none$;
        CRowTypeInfo inputCRowType = CRowTypeInfo$.MODULE$.apply(inputTypeInfo);
        return new RowTimeSortProcessFunction(inputCRowType, rowtimeIdx, (Option<CollectionRowComparator>)collectionRowComparator);
    }

    public ProcessFunction<CRow, CRow> createProcTimeSortFunction(RelCollation collationSort, RelDataType inputType, TypeInformation<Row> inputTypeInfo, ExecutionConfig execCfg) {
        RowComparator rowComp = this.createRowComparator(inputType, (Seq<RelFieldCollation>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(collationSort.getFieldCollations()).asScala()).tail()), execCfg);
        CollectionRowComparator collectionRowComparator = new CollectionRowComparator((TypeComparator<Row>)rowComp);
        CRowTypeInfo inputCRowType = CRowTypeInfo$.MODULE$.apply(inputTypeInfo);
        return new ProcTimeSortProcessFunction(inputCRowType, collectionRowComparator);
    }

    private RowComparator createRowComparator(RelDataType inputType, Seq<RelFieldCollation> fieldCollations, ExecutionConfig execConfig) {
        Seq sortFields = (Seq)fieldCollations.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(RelFieldCollation x$1) {
                return x$1.getFieldIndex();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq sortDirections = (Seq)((TraversableLike)fieldCollations.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RelFieldCollation.Direction apply(RelFieldCollation x$2) {
                return x$2.direction;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RelFieldCollation.Direction x0$1) {
                block4: {
                    boolean bl;
                    block3: {
                        RelFieldCollation.Direction direction;
                        block2: {
                            direction = x0$1;
                            if (!((Object)((Object)RelFieldCollation.Direction.ASCENDING)).equals((Object)((Object)direction))) break block2;
                            bl = true;
                            break block3;
                        }
                        if (!((Object)((Object)RelFieldCollation.Direction.DESCENDING)).equals((Object)((Object)direction))) break block4;
                        bl = false;
                    }
                    return bl;
                }
                throw new TableException("SQL/Table does not support such sorting");
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq fieldComps = (Seq)((TraversableLike)sortFields.zip((GenIterable)sortDirections, Seq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(inputType, execConfig){
            public static final long serialVersionUID = 0L;
            private final RelDataType inputType$1;
            private final ExecutionConfig execConfig$1;

            public final TypeComparator<Object> apply(Tuple2<Object, Object> x$3) {
                Tuple2<Object, Object> tuple2 = x$3;
                if (tuple2 != null) {
                    int k = tuple2._1$mcI$sp();
                    boolean o = tuple2._2$mcZ$sp();
                    TypeInformation<?> typeInformation = FlinkTypeFactory$.MODULE$.toTypeInfo(this.inputType$1.getFieldList().get(k).getType());
                    if (typeInformation instanceof AtomicType) {
                        TypeComparator typeComparator;
                        TypeInformation<?> typeInformation2 = typeInformation;
                        TypeComparator typeComparator2 = typeComparator = ((AtomicType)typeInformation2).createComparator(o, this.execConfig$1);
                        return typeComparator2;
                    }
                    if (typeInformation != null) {
                        TypeInformation<?> typeInformation3 = typeInformation;
                        throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported field type ", " to sort on."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeInformation3})));
                    }
                    throw new MatchError(typeInformation);
                }
                throw new MatchError(tuple2);
            }
            {
                this.inputType$1 = inputType$1;
                this.execConfig$1 = execConfig$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new RowComparator(new RowSchema(inputType).arity(), (int[])sortFields.toArray(ClassTag$.MODULE$.Int()), (TypeComparator[])fieldComps.toArray(ClassTag$.MODULE$.apply(TypeComparator.class)), new TypeSerializer[0], (boolean[])sortDirections.toArray(ClassTag$.MODULE$.Boolean()));
    }

    public RelFieldCollation.Direction getFirstSortDirection(RelCollation collationSort) {
        Preconditions.checkArgument((collationSort.getFieldCollations().size() > 0 ? 1 : 0) != 0);
        return collationSort.getFieldCollations().get((int)0).direction;
    }

    public RelDataTypeField getFirstSortField(RelCollation collationSort, RelDataType rowType) {
        Preconditions.checkArgument((collationSort.getFieldCollations().size() > 0 ? 1 : 0) != 0);
        int idx = collationSort.getFieldCollations().get(0).getFieldIndex();
        return rowType.getFieldList().get(idx);
    }

    private SortUtil$() {
        MODULE$ = this;
    }
}

