/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.shaded.org.apache.commons.lang.math;

public class IEEE754rUtils {
    public static double min(double[] array2) {
        if (array2 == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array2.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        double min = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            min = IEEE754rUtils.min(array2[i], min);
        }
        return min;
    }

    public static float min(float[] array2) {
        if (array2 == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array2.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        float min = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            min = IEEE754rUtils.min(array2[i], min);
        }
        return min;
    }

    public static double min(double a, double b, double c) {
        return IEEE754rUtils.min(IEEE754rUtils.min(a, b), c);
    }

    public static double min(double a, double b) {
        if (Double.isNaN(a)) {
            return b;
        }
        if (Double.isNaN(b)) {
            return a;
        }
        return Math.min(a, b);
    }

    public static float min(float a, float b, float c) {
        return IEEE754rUtils.min(IEEE754rUtils.min(a, b), c);
    }

    public static float min(float a, float b) {
        if (Float.isNaN(a)) {
            return b;
        }
        if (Float.isNaN(b)) {
            return a;
        }
        return Math.min(a, b);
    }

    public static double max(double[] array2) {
        if (array2 == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array2.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        double max = array2[0];
        for (int j2 = 1; j2 < array2.length; ++j2) {
            max = IEEE754rUtils.max(array2[j2], max);
        }
        return max;
    }

    public static float max(float[] array2) {
        if (array2 == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array2.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        float max = array2[0];
        for (int j2 = 1; j2 < array2.length; ++j2) {
            max = IEEE754rUtils.max(array2[j2], max);
        }
        return max;
    }

    public static double max(double a, double b, double c) {
        return IEEE754rUtils.max(IEEE754rUtils.max(a, b), c);
    }

    public static double max(double a, double b) {
        if (Double.isNaN(a)) {
            return b;
        }
        if (Double.isNaN(b)) {
            return a;
        }
        return Math.max(a, b);
    }

    public static float max(float a, float b, float c) {
        return IEEE754rUtils.max(IEEE754rUtils.max(a, b), c);
    }

    public static float max(float a, float b) {
        if (Float.isNaN(a)) {
            return b;
        }
        if (Float.isNaN(b)) {
            return a;
        }
        return Math.max(a, b);
    }
}

