/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.configuration;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.util.Preconditions;

@Internal
public enum YarnDeploymentTarget {
    PER_JOB("yarn-per-job"),
    SESSION("yarn-session"),
    APPLICATION("yarn-application");

    public static final String ERROR_MESSAGE = "No Executor found. Please make sure to export the HADOOP_CLASSPATH environment variable or have hadoop in your classpath. For more information refer to the \"Deployment\" section of the official Apache Flink documentation.";
    private final String name;

    private YarnDeploymentTarget(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    public static YarnDeploymentTarget fromConfig(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        String deploymentTargetStr = (String)configuration.get(DeploymentOptions.TARGET);
        YarnDeploymentTarget deploymentTarget = YarnDeploymentTarget.getFromName(deploymentTargetStr);
        if (deploymentTarget == null) {
            throw new IllegalArgumentException("Unknown Yarn deployment target \"" + deploymentTargetStr + "\". The available options are: " + YarnDeploymentTarget.options());
        }
        return deploymentTarget;
    }

    public String getName() {
        return this.name;
    }

    public static boolean isValidYarnTarget(String configValue) {
        return configValue != null && Arrays.stream(YarnDeploymentTarget.values()).anyMatch(yarnDeploymentTarget -> yarnDeploymentTarget.name.equalsIgnoreCase(configValue));
    }

    private static YarnDeploymentTarget getFromName(String deploymentTarget) {
        if (deploymentTarget == null) {
            return null;
        }
        if (YarnDeploymentTarget.PER_JOB.name.equalsIgnoreCase(deploymentTarget)) {
            return PER_JOB;
        }
        if (YarnDeploymentTarget.SESSION.name.equalsIgnoreCase(deploymentTarget)) {
            return SESSION;
        }
        if (YarnDeploymentTarget.APPLICATION.name.equalsIgnoreCase(deploymentTarget)) {
            return APPLICATION;
        }
        return null;
    }

    private static String options() {
        return Arrays.stream(YarnDeploymentTarget.values()).map(YarnDeploymentTarget::getName).collect(Collectors.joining(","));
    }
}

