/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContractRootDirectoryTest
extends AbstractFSContractTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractContractRootDirectoryTest.class);

    @Override
    public void setup() throws Exception {
        super.setup();
        this.skipIfUnsupported("test.root-tests-enabled");
    }

    @Test
    public void testMkDirDepth1() throws Throwable {
        FileSystem fs = this.getFileSystem();
        Path dir = new Path("/testmkdirdepth1");
        this.assertPathDoesNotExist("directory already exists", dir);
        fs.mkdirs(dir);
        ContractTestUtils.assertIsDirectory(this.getFileSystem(), dir);
        this.assertPathExists("directory already exists", dir);
        this.assertDeleted(dir, true);
    }

    @Test
    public void testRmEmptyRootDirNonRecursive() throws Throwable {
        this.skipIfUnsupported("test.root-tests-enabled");
        Path root = new Path("/");
        ContractTestUtils.assertIsDirectory(this.getFileSystem(), root);
        boolean deleted = this.getFileSystem().delete(root, true);
        LOG.info("rm / of empty dir result is {}", (Object)deleted);
        ContractTestUtils.assertIsDirectory(this.getFileSystem(), root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRmNonEmptyRootDirNonRecursive() throws Throwable {
        this.skipIfUnsupported("test.root-tests-enabled");
        Path root = new Path("/");
        String touchfile = "/testRmNonEmptyRootDirNonRecursive";
        Path file = new Path(touchfile);
        ContractTestUtils.touch(this.getFileSystem(), file);
        ContractTestUtils.assertIsDirectory(this.getFileSystem(), root);
        try {
            boolean deleted = this.getFileSystem().delete(root, false);
            AbstractContractRootDirectoryTest.fail((String)("non recursive delete should have raised an exception, but completed with exit code " + deleted));
        }
        catch (IOException e) {
            this.handleExpectedException(e);
        }
        finally {
            this.getFileSystem().delete(file, false);
        }
        ContractTestUtils.assertIsDirectory(this.getFileSystem(), root);
    }

    @Test
    public void testRmRootRecursive() throws Throwable {
        this.skipIfUnsupported("test.root-tests-enabled");
        Path root = new Path("/");
        ContractTestUtils.assertIsDirectory(this.getFileSystem(), root);
        Path file = new Path("/testRmRootRecursive");
        ContractTestUtils.touch(this.getFileSystem(), file);
        boolean deleted = this.getFileSystem().delete(root, true);
        ContractTestUtils.assertIsDirectory(this.getFileSystem(), root);
        LOG.info("rm -rf / result is {}", (Object)deleted);
        if (deleted) {
            this.assertPathDoesNotExist("expected file to be deleted", file);
        } else {
            this.assertPathExists("expected file to be preserved", file);
        }
    }

    @Test
    public void testCreateFileOverRoot() throws Throwable {
        Path root = new Path("/");
        byte[] dataset = ContractTestUtils.dataset(1024, 32, 122);
        try {
            ContractTestUtils.createFile(this.getFileSystem(), root, false, dataset);
            AbstractContractRootDirectoryTest.fail((String)("expected an exception, got a file created over root: " + this.ls(root)));
        }
        catch (IOException e) {
            this.handleExpectedException(e);
        }
        this.assertIsDirectory(root);
    }
}

