/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.Count;
import org.apache.hadoop.fs.shell.PathData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCount {
    private static final String WITH_QUOTAS = "Content summary with quotas";
    private static final String NO_QUOTAS = "Content summary without quotas";
    private static final String HUMAN = "human: ";
    private static final String BYTES = "bytes: ";
    private static Configuration conf;
    private static FileSystem mockFs;
    private static FileStatus fileStat;
    private static ContentSummary mockCs;

    @BeforeClass
    public static void setup() {
        conf = new Configuration();
        conf.setClass("fs.mockfs.impl", MockFileSystem.class, FileSystem.class);
        mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        fileStat = (FileStatus)Mockito.mock(FileStatus.class);
        mockCs = (ContentSummary)Mockito.mock(ContentSummary.class);
        Mockito.when((Object)fileStat.isFile()).thenReturn((Object)true);
    }

    @Before
    public void resetMock() {
        Mockito.reset((Object[])new FileSystem[]{mockFs});
    }

    @Test
    public void processOptionsHumanReadable() {
        LinkedList<String> options = new LinkedList<String>();
        options.add("-h");
        options.add("dummy");
        Count count = new Count();
        count.processOptions(options);
        Assert.assertFalse((boolean)count.isShowQuotas());
        Assert.assertTrue((boolean)count.isHumanReadable());
    }

    @Test
    public void processOptionsAll() {
        LinkedList<String> options = new LinkedList<String>();
        options.add("-q");
        options.add("-h");
        options.add("dummy");
        Count count = new Count();
        count.processOptions(options);
        Assert.assertTrue((boolean)count.isShowQuotas());
        Assert.assertTrue((boolean)count.isHumanReadable());
    }

    @Test
    public void processPathShowQuotas() throws Exception {
        Path path = new Path("mockfs:/test");
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)path))).thenReturn((Object)fileStat);
        PathData pathData = new PathData(path.toString(), conf);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Count count = new Count();
        count.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-q");
        options.add("dummy");
        count.processOptions(options);
        count.processPath(pathData);
        ((PrintStream)Mockito.verify((Object)out)).println("bytes: Content summary with quotas" + path.toString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathNoQuotas() throws Exception {
        Path path = new Path("mockfs:/test");
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)path))).thenReturn((Object)fileStat);
        PathData pathData = new PathData(path.toString(), conf);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Count count = new Count();
        count.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("dummy");
        count.processOptions(options);
        count.processPath(pathData);
        ((PrintStream)Mockito.verify((Object)out)).println("bytes: Content summary without quotas" + path.toString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathShowQuotasHuman() throws Exception {
        Path path = new Path("mockfs:/test");
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)path))).thenReturn((Object)fileStat);
        PathData pathData = new PathData(path.toString(), conf);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Count count = new Count();
        count.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-q");
        options.add("-h");
        options.add("dummy");
        count.processOptions(options);
        count.processPath(pathData);
        ((PrintStream)Mockito.verify((Object)out)).println("human: Content summary with quotas" + path.toString());
    }

    @Test
    public void processPathNoQuotasHuman() throws Exception {
        Path path = new Path("mockfs:/test");
        Mockito.when((Object)mockFs.getFileStatus((Path)Mockito.eq((Object)path))).thenReturn((Object)fileStat);
        PathData pathData = new PathData(path.toString(), conf);
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Count count = new Count();
        count.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-h");
        options.add("dummy");
        count.processOptions(options);
        count.processPath(pathData);
        ((PrintStream)Mockito.verify((Object)out)).println("human: Content summary without quotas" + path.toString());
    }

    @Test
    public void getCommandName() {
        Count count = new Count();
        String actual = count.getCommandName();
        String expected = "count";
        Assert.assertEquals((String)"Count.getCommandName", (Object)expected, (Object)actual);
    }

    @Test
    public void isDeprecated() {
        Count count = new Count();
        boolean actual = count.isDeprecated();
        boolean expected = false;
        Assert.assertEquals((String)"Count.isDeprecated", (Object)expected, (Object)actual);
    }

    @Test
    public void getReplacementCommand() {
        Count count = new Count();
        String actual = count.getReplacementCommand();
        Object expected = null;
        Assert.assertEquals((String)"Count.getReplacementCommand", expected, (Object)actual);
    }

    @Test
    public void getName() {
        Count count = new Count();
        String actual = count.getName();
        String expected = "count";
        Assert.assertEquals((String)"Count.getName", (Object)expected, (Object)actual);
    }

    @Test
    public void getUsage() {
        Count count = new Count();
        String actual = count.getUsage();
        String expected = "-count [-q] [-h] <path> ...";
        Assert.assertEquals((String)"Count.getUsage", (Object)expected, (Object)actual);
    }

    static class MockFileSystem
    extends FilterFileSystem {
        Configuration conf;

        MockFileSystem() {
            super(mockFs);
        }

        public void initialize(URI uri, Configuration conf) {
            this.conf = conf;
        }

        public Path makeQualified(Path path) {
            return path;
        }

        public ContentSummary getContentSummary(Path f) throws IOException {
            return new MockContentSummary();
        }

        public Configuration getConf() {
            return this.conf;
        }
    }

    static class MockContentSummary
    extends ContentSummary {
        public String toString(boolean qOption, boolean hOption) {
            if (qOption) {
                if (hOption) {
                    return "human: Content summary with quotas";
                }
                return "bytes: Content summary with quotas";
            }
            if (hOption) {
                return "human: Content summary without quotas";
            }
            return "bytes: Content summary without quotas";
        }
    }
}

