/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsBlocksMetadata;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.ChunkChecksum;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaAlreadyExistsException;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipelineInterface;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.UnexpectedReplicaStateException;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.LengthInputStream;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaInputStreams;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaOutputStreams;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.RollingLogs;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.metrics.FSDatasetMBean;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.DiskChecker;

public class SimulatedFSDataset
implements FsDatasetSpi<FsVolumeSpi> {
    public static final String CONFIG_PROPERTY_CAPACITY = "dfs.datanode.simulateddatastorage.capacity";
    public static final long DEFAULT_CAPACITY = 0x20000000000L;
    public static final byte DEFAULT_DATABYTE = 9;
    public static final String CONFIG_PROPERTY_STATE = "dfs.datanode.simulateddatastorage.state";
    private static final DatanodeStorage.State DEFAULT_STATE = DatanodeStorage.State.NORMAL;
    static final byte[] nullCrcFileData;
    private final Map<String, Map<Block, BInfo>> blockMap = new HashMap<String, Map<Block, BInfo>>();
    private final SimulatedStorage storage;
    private final SimulatedVolume volume;
    private final String datanodeUuid;
    private ObjectName mbeanName;

    public static void setFactory(Configuration conf) {
        conf.set("dfs.datanode.fsdataset.factory", Factory.class.getName());
    }

    public SimulatedFSDataset(DataStorage storage, Configuration conf) {
        if (storage != null) {
            for (int i = 0; i < storage.getNumStorageDirs(); ++i) {
                storage.createStorageID(storage.getStorageDir(i), false);
            }
            this.datanodeUuid = storage.getDatanodeUuid();
        } else {
            this.datanodeUuid = "SimulatedDatanode-" + DataNode.generateUuid();
        }
        this.registerMBean(this.datanodeUuid);
        this.storage = new SimulatedStorage(conf.getLong(CONFIG_PROPERTY_CAPACITY, 0x20000000000L), (DatanodeStorage.State)conf.getEnum(CONFIG_PROPERTY_STATE, (Enum)DEFAULT_STATE));
        this.volume = new SimulatedVolume(this.storage);
    }

    public synchronized void injectBlocks(String bpid, Iterable<Block> injectBlocks) throws IOException {
        ExtendedBlock blk = new ExtendedBlock();
        if (injectBlocks != null) {
            for (Block b : injectBlocks) {
                if (b == null) {
                    throw new NullPointerException("Null blocks in block list");
                }
                blk.set(bpid, b);
                if (!this.isValidBlock(blk)) continue;
                throw new IOException("Block already exists in  block list");
            }
            Map<Block, BInfo> map = this.blockMap.get(bpid);
            if (map == null) {
                map = new HashMap<Block, BInfo>();
                this.blockMap.put(bpid, map);
            }
            for (Block b : injectBlocks) {
                BInfo binfo = new BInfo(bpid, b, false);
                map.put(binfo.theBlock, binfo);
            }
        }
    }

    private Map<Block, BInfo> getMap(String bpid) throws IOException {
        Map<Block, BInfo> map = this.blockMap.get(bpid);
        if (map == null) {
            throw new IOException("Non existent blockpool " + bpid);
        }
        return map;
    }

    public synchronized void finalizeBlock(ExtendedBlock b) throws IOException {
        Map<Block, BInfo> map = this.getMap(b.getBlockPoolId());
        BInfo binfo = map.get(b.getLocalBlock());
        if (binfo == null) {
            throw new IOException("Finalizing a non existing block " + b);
        }
        binfo.finalizeBlock(b.getBlockPoolId(), b.getNumBytes());
    }

    public synchronized void unfinalizeBlock(ExtendedBlock b) throws IOException {
        if (this.isValidRbw(b)) {
            Map<Block, BInfo> map = this.getMap(b.getBlockPoolId());
            map.remove(b.getLocalBlock());
        }
    }

    synchronized BlockListAsLongs getBlockReport(String bpid) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        Map<Block, BInfo> map = this.blockMap.get(bpid);
        if (map != null) {
            for (BInfo b : map.values()) {
                if (!b.isFinalized()) continue;
                blocks.add(b.theBlock);
            }
        }
        return new BlockListAsLongs(blocks, null);
    }

    public synchronized Map<DatanodeStorage, BlockListAsLongs> getBlockReports(String bpid) {
        return Collections.singletonMap(this.storage.getDnStorage(), this.getBlockReport(bpid));
    }

    public List<Long> getCacheReport(String bpid) {
        return new LinkedList<Long>();
    }

    public long getCapacity() {
        return this.storage.getCapacity();
    }

    public long getDfsUsed() {
        return this.storage.getUsed();
    }

    public long getBlockPoolUsed(String bpid) throws IOException {
        return this.storage.getBlockPoolUsed(bpid);
    }

    public long getRemaining() {
        return this.storage.getFree();
    }

    public int getNumFailedVolumes() {
        return this.storage.getNumFailedVolumes();
    }

    public long getCacheUsed() {
        return 0L;
    }

    public long getCacheCapacity() {
        return 0L;
    }

    public long getNumBlocksCached() {
        return 0L;
    }

    public long getNumBlocksFailedToCache() {
        return 0L;
    }

    public long getNumBlocksFailedToUncache() {
        return 0L;
    }

    public synchronized long getLength(ExtendedBlock b) throws IOException {
        Map<Block, BInfo> map = this.getMap(b.getBlockPoolId());
        BInfo binfo = map.get(b.getLocalBlock());
        if (binfo == null) {
            throw new IOException("Finalizing a non existing block " + b);
        }
        return binfo.getNumBytes();
    }

    @Deprecated
    public Replica getReplica(String bpid, long blockId) {
        Map<Block, BInfo> map = this.blockMap.get(bpid);
        if (map != null) {
            return (Replica)map.get(new Block(blockId));
        }
        return null;
    }

    public synchronized String getReplicaString(String bpid, long blockId) {
        Object r = null;
        Map<Block, BInfo> map = this.blockMap.get(bpid);
        if (map != null) {
            r = (Replica)map.get(new Block(blockId));
        }
        return r == null ? "null" : r.toString();
    }

    public Block getStoredBlock(String bpid, long blkid) throws IOException {
        Map<Block, BInfo> map = this.blockMap.get(bpid);
        if (map != null) {
            BInfo binfo = map.get(new Block(blkid));
            if (binfo == null) {
                return null;
            }
            return new Block(blkid, binfo.getGenerationStamp(), binfo.getNumBytes());
        }
        return null;
    }

    public synchronized void invalidate(String bpid, Block[] invalidBlks) throws IOException {
        boolean error = false;
        if (invalidBlks == null) {
            return;
        }
        Map<Block, BInfo> map = this.getMap(bpid);
        for (Block b : invalidBlks) {
            if (b == null) continue;
            BInfo binfo = map.get(b);
            if (binfo == null) {
                error = true;
                DataNode.LOG.warn((Object)"Invalidate: Missing block");
                continue;
            }
            this.storage.free(bpid, binfo.getNumBytes());
            map.remove(b);
        }
        if (error) {
            throw new IOException("Invalidate: Missing blocks.");
        }
    }

    public void cache(String bpid, long[] cacheBlks) {
        throw new UnsupportedOperationException("SimulatedFSDataset does not support cache operation!");
    }

    public void uncache(String bpid, long[] uncacheBlks) {
        throw new UnsupportedOperationException("SimulatedFSDataset does not support uncache operation!");
    }

    public boolean isCached(String bpid, long blockId) {
        return false;
    }

    private BInfo getBInfo(ExtendedBlock b) {
        Map<Block, BInfo> map = this.blockMap.get(b.getBlockPoolId());
        return map == null ? null : map.get(b.getLocalBlock());
    }

    public boolean contains(ExtendedBlock block) {
        return this.getBInfo(block) != null;
    }

    public void checkBlock(ExtendedBlock b, long minLength, HdfsServerConstants.ReplicaState state) throws ReplicaNotFoundException, UnexpectedReplicaStateException {
        BInfo binfo = this.getBInfo(b);
        if (binfo == null) {
            throw new ReplicaNotFoundException(b);
        }
        if (state == HdfsServerConstants.ReplicaState.FINALIZED && !binfo.isFinalized() || state != HdfsServerConstants.ReplicaState.FINALIZED && binfo.isFinalized()) {
            throw new UnexpectedReplicaStateException(b, state);
        }
    }

    public synchronized boolean isValidBlock(ExtendedBlock b) {
        try {
            this.checkBlock(b, 0L, HdfsServerConstants.ReplicaState.FINALIZED);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public synchronized boolean isValidRbw(ExtendedBlock b) {
        try {
            this.checkBlock(b, 0L, HdfsServerConstants.ReplicaState.RBW);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getStorageInfo();
    }

    public synchronized ReplicaInPipelineInterface append(ExtendedBlock b, long newGS, long expectedBlockLen) throws IOException {
        Map<Block, BInfo> map = this.getMap(b.getBlockPoolId());
        BInfo binfo = map.get(b.getLocalBlock());
        if (binfo == null || !binfo.isFinalized()) {
            throw new ReplicaNotFoundException("Block " + b + " is not valid, and cannot be appended to.");
        }
        binfo.unfinalizeBlock();
        return binfo;
    }

    public synchronized ReplicaInPipelineInterface recoverAppend(ExtendedBlock b, long newGS, long expectedBlockLen) throws IOException {
        Map<Block, BInfo> map = this.getMap(b.getBlockPoolId());
        BInfo binfo = map.get(b.getLocalBlock());
        if (binfo == null) {
            throw new ReplicaNotFoundException("Block " + b + " is not valid, and cannot be appended to.");
        }
        if (binfo.isFinalized()) {
            binfo.unfinalizeBlock();
        }
        map.remove(b);
        binfo.theBlock.setGenerationStamp(newGS);
        map.put(binfo.theBlock, binfo);
        return binfo;
    }

    public String recoverClose(ExtendedBlock b, long newGS, long expectedBlockLen) throws IOException {
        Map<Block, BInfo> map = this.getMap(b.getBlockPoolId());
        BInfo binfo = map.get(b.getLocalBlock());
        if (binfo == null) {
            throw new ReplicaNotFoundException("Block " + b + " is not valid, and cannot be appended to.");
        }
        if (!binfo.isFinalized()) {
            binfo.finalizeBlock(b.getBlockPoolId(), binfo.getNumBytes());
        }
        map.remove(b.getLocalBlock());
        binfo.theBlock.setGenerationStamp(newGS);
        map.put(binfo.theBlock, binfo);
        return binfo.getStorageUuid();
    }

    public synchronized ReplicaInPipelineInterface recoverRbw(ExtendedBlock b, long newGS, long minBytesRcvd, long maxBytesRcvd) throws IOException {
        Map<Block, BInfo> map = this.getMap(b.getBlockPoolId());
        BInfo binfo = map.get(b.getLocalBlock());
        if (binfo == null) {
            throw new ReplicaNotFoundException("Block " + b + " does not exist, and cannot be appended to.");
        }
        if (binfo.isFinalized()) {
            throw new ReplicaAlreadyExistsException("Block " + b + " is valid, and cannot be written to.");
        }
        map.remove(b);
        binfo.theBlock.setGenerationStamp(newGS);
        map.put(binfo.theBlock, binfo);
        return binfo;
    }

    public synchronized ReplicaInPipelineInterface createRbw(StorageType storageType, ExtendedBlock b, boolean allowLazyPersist) throws IOException {
        return this.createTemporary(storageType, b);
    }

    public synchronized ReplicaInPipelineInterface createTemporary(StorageType storageType, ExtendedBlock b) throws IOException {
        if (this.isValidBlock(b)) {
            throw new ReplicaAlreadyExistsException("Block " + b + " is valid, and cannot be written to.");
        }
        if (this.isValidRbw(b)) {
            throw new ReplicaAlreadyExistsException("Block " + b + " is being written, and cannot be written to.");
        }
        Map<Block, BInfo> map = this.getMap(b.getBlockPoolId());
        BInfo binfo = new BInfo(b.getBlockPoolId(), b.getLocalBlock(), true);
        map.put(binfo.theBlock, binfo);
        return binfo;
    }

    synchronized InputStream getBlockInputStream(ExtendedBlock b) throws IOException {
        Map<Block, BInfo> map = this.getMap(b.getBlockPoolId());
        BInfo binfo = map.get(b.getLocalBlock());
        if (binfo == null) {
            throw new IOException("No such Block " + b);
        }
        return binfo.getIStream();
    }

    public synchronized InputStream getBlockInputStream(ExtendedBlock b, long seekOffset) throws IOException {
        InputStream result = this.getBlockInputStream(b);
        IOUtils.skipFully((InputStream)result, (long)seekOffset);
        return result;
    }

    public ReplicaInputStreams getTmpInputStreams(ExtendedBlock b, long blkoff, long ckoff) throws IOException {
        throw new IOException("Not supported");
    }

    public synchronized LengthInputStream getMetaDataInputStream(ExtendedBlock b) throws IOException {
        Map<Block, BInfo> map = this.getMap(b.getBlockPoolId());
        BInfo binfo = map.get(b.getLocalBlock());
        if (binfo == null) {
            throw new IOException("No such Block " + b);
        }
        if (!binfo.finalized) {
            throw new IOException("Block " + b + " is being written, its meta cannot be read");
        }
        SimulatedInputStream sin = binfo.getMetaIStream();
        return new LengthInputStream((InputStream)sin, sin.getLength());
    }

    public void checkDataDir() throws DiskChecker.DiskErrorException {
    }

    public synchronized void adjustCrcChannelPosition(ExtendedBlock b, ReplicaOutputStreams stream, int checksumSize) throws IOException {
    }

    void registerMBean(String storageId) {
        try {
            StandardMBean bean = new StandardMBean(this, FSDatasetMBean.class);
            this.mbeanName = MBeans.register((String)"DataNode", (String)("FSDatasetState-" + storageId), (Object)bean);
        }
        catch (NotCompliantMBeanException e) {
            DataNode.LOG.warn((Object)"Error registering FSDatasetState MBean", (Throwable)e);
        }
        DataNode.LOG.info((Object)"Registered FSDatasetState MBean");
    }

    public void shutdown() {
        if (this.mbeanName != null) {
            MBeans.unregister((ObjectName)this.mbeanName);
        }
    }

    public String getStorageInfo() {
        return "Simulated FSDataset-" + this.datanodeUuid;
    }

    public boolean hasEnoughResource() {
        return true;
    }

    public ReplicaRecoveryInfo initReplicaRecovery(BlockRecoveryCommand.RecoveringBlock rBlock) throws IOException {
        ExtendedBlock b = rBlock.getBlock();
        Map<Block, BInfo> map = this.getMap(b.getBlockPoolId());
        BInfo binfo = map.get(b.getLocalBlock());
        if (binfo == null) {
            throw new IOException("No such Block " + b);
        }
        return new ReplicaRecoveryInfo(binfo.getBlockId(), binfo.getBytesOnDisk(), binfo.getGenerationStamp(), binfo.isFinalized() ? HdfsServerConstants.ReplicaState.FINALIZED : HdfsServerConstants.ReplicaState.RBW);
    }

    public String updateReplicaUnderRecovery(ExtendedBlock oldBlock, long recoveryId, long newlength) {
        return this.datanodeUuid;
    }

    public long getReplicaVisibleLength(ExtendedBlock block) {
        return block.getNumBytes();
    }

    public void addBlockPool(String bpid, Configuration conf) {
        HashMap map = new HashMap();
        this.blockMap.put(bpid, map);
        this.storage.addBlockPool(bpid);
    }

    public void shutdownBlockPool(String bpid) {
        this.blockMap.remove(bpid);
        this.storage.removeBlockPool(bpid);
    }

    public void deleteBlockPool(String bpid, boolean force) {
    }

    public ReplicaInPipelineInterface convertTemporaryToRbw(ExtendedBlock temporary) throws IOException {
        Map<Block, BInfo> map = this.blockMap.get(temporary.getBlockPoolId());
        if (map == null) {
            throw new IOException("Block pool not found, temporary=" + temporary);
        }
        BInfo r = map.get(temporary.getLocalBlock());
        if (r == null) {
            throw new IOException("Block not found, temporary=" + temporary);
        }
        if (r.isFinalized()) {
            throw new IOException("Replica already finalized, temporary=" + temporary + ", r=" + r);
        }
        return r;
    }

    public BlockLocalPathInfo getBlockLocalPathInfo(ExtendedBlock b) {
        throw new UnsupportedOperationException();
    }

    public HdfsBlocksMetadata getHdfsBlocksMetadata(String bpid, long[] blockIds) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void enableTrash(String bpid) {
        throw new UnsupportedOperationException();
    }

    public void restoreTrash(String bpid) {
    }

    public boolean trashEnabled(String bpid) {
        return false;
    }

    public void setRollingUpgradeMarker(String bpid) {
    }

    public void clearRollingUpgradeMarker(String bpid) {
    }

    public void checkAndUpdate(String bpid, long blockId, File diskFile, File diskMetaFile, FsVolumeSpi vol) throws IOException {
        throw new UnsupportedOperationException();
    }

    public List<FsVolumeSpi> getVolumes() {
        throw new UnsupportedOperationException();
    }

    public void addVolume(StorageLocation location, List<NamespaceInfo> nsInfos) throws IOException {
        throw new UnsupportedOperationException();
    }

    public DatanodeStorage getStorage(String storageUuid) {
        return storageUuid.equals(this.storage.getStorageUuid()) ? this.storage.dnStorage : null;
    }

    public StorageReport[] getStorageReports(String bpid) {
        return new StorageReport[]{this.storage.getStorageReport(bpid)};
    }

    public List<FinalizedReplica> getFinalizedBlocks(String bpid) {
        throw new UnsupportedOperationException();
    }

    public List<FinalizedReplica> getFinalizedBlocksOnPersistentStorage(String bpid) {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> getVolumeInfoMap() {
        throw new UnsupportedOperationException();
    }

    public RollingLogs createRollingLogs(String bpid, String prefix) {
        throw new UnsupportedOperationException();
    }

    public FsVolumeSpi getVolume(ExtendedBlock b) {
        return this.volume;
    }

    public synchronized void removeVolumes(Collection<StorageLocation> volumes) {
        throw new UnsupportedOperationException();
    }

    public void submitBackgroundSyncFileRangeRequest(ExtendedBlock block, FileDescriptor fd, long offset, long nbytes, int flags) {
        throw new UnsupportedOperationException();
    }

    public void onCompleteLazyPersist(String bpId, long blockId, long creationTime, File[] savedFiles, FsVolumeImpl targetVolume) {
        throw new UnsupportedOperationException();
    }

    public void onFailLazyPersist(String bpId, long blockId) {
        throw new UnsupportedOperationException();
    }

    static {
        DataChecksum checksum = DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.NULL, (int)16384);
        byte[] nullCrcHeader = checksum.getHeader();
        nullCrcFileData = new byte[2 + nullCrcHeader.length];
        SimulatedFSDataset.nullCrcFileData[0] = 0;
        SimulatedFSDataset.nullCrcFileData[1] = 1;
        for (int i = 0; i < nullCrcHeader.length; ++i) {
            SimulatedFSDataset.nullCrcFileData[i + 2] = nullCrcHeader[i];
        }
    }

    private static class SimulatedOutputStream
    extends OutputStream {
        long length = 0L;

        SimulatedOutputStream() {
        }

        long getLength() {
            return this.length;
        }

        void setLength(long length) {
            this.length = length;
        }

        @Override
        public void write(int arg0) throws IOException {
            ++this.length;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.length += (long)b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.length += (long)len;
        }
    }

    private static class SimulatedInputStream
    extends InputStream {
        byte theRepeatedData = (byte)7;
        final long length;
        int currentPos = 0;
        byte[] data = null;

        SimulatedInputStream(long l, byte iRepeatedData) {
            this.length = l;
            this.theRepeatedData = iRepeatedData;
        }

        SimulatedInputStream(byte[] iData) {
            this.data = iData;
            this.length = this.data.length;
        }

        long getLength() {
            return this.length;
        }

        @Override
        public int read() throws IOException {
            if ((long)this.currentPos >= this.length) {
                return -1;
            }
            if (this.data != null) {
                return this.data[this.currentPos++];
            }
            ++this.currentPos;
            return this.theRepeatedData;
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (b.length == 0) {
                return 0;
            }
            if ((long)this.currentPos >= this.length) {
                return -1;
            }
            int bytesRead = (int)Math.min((long)b.length, this.length - (long)this.currentPos);
            if (this.data != null) {
                System.arraycopy(this.data, this.currentPos, b, 0, bytesRead);
            } else {
                for (byte i : b) {
                    b[i] = this.theRepeatedData;
                }
            }
            this.currentPos += bytesRead;
            return bytesRead;
        }
    }

    static class SimulatedVolume
    implements FsVolumeSpi {
        private final SimulatedStorage storage;

        SimulatedVolume(SimulatedStorage storage) {
            this.storage = storage;
        }

        public String getStorageID() {
            return this.storage.getStorageUuid();
        }

        public String[] getBlockPoolList() {
            return new String[0];
        }

        public long getAvailable() throws IOException {
            return this.storage.getCapacity() - this.storage.getUsed();
        }

        public String getBasePath() {
            return null;
        }

        public String getPath(String bpid) throws IOException {
            return null;
        }

        public File getFinalizedDir(String bpid) throws IOException {
            return null;
        }

        public StorageType getStorageType() {
            return null;
        }

        public boolean isTransientStorage() {
            return false;
        }

        public void reserveSpaceForRbw(long bytesToReserve) {
        }

        public void releaseReservedSpace(long bytesToRelease) {
        }
    }

    private static class SimulatedStorage {
        private final Map<String, SimulatedBPStorage> map = new HashMap<String, SimulatedBPStorage>();
        private final long capacity;
        private final DatanodeStorage dnStorage;

        synchronized long getFree() {
            return this.capacity - this.getUsed();
        }

        long getCapacity() {
            return this.capacity;
        }

        synchronized long getUsed() {
            long used = 0L;
            for (SimulatedBPStorage bpStorage : this.map.values()) {
                used += bpStorage.getUsed();
            }
            return used;
        }

        synchronized long getBlockPoolUsed(String bpid) throws IOException {
            return this.getBPStorage(bpid).getUsed();
        }

        int getNumFailedVolumes() {
            return 0;
        }

        synchronized boolean alloc(String bpid, long amount) throws IOException {
            if (this.getFree() >= amount) {
                this.getBPStorage(bpid).alloc(amount);
                return true;
            }
            return false;
        }

        synchronized void free(String bpid, long amount) throws IOException {
            this.getBPStorage(bpid).free(amount);
        }

        SimulatedStorage(long cap, DatanodeStorage.State state) {
            this.capacity = cap;
            this.dnStorage = new DatanodeStorage("SimulatedStorage-" + DatanodeStorage.generateUuid(), state, StorageType.DEFAULT);
        }

        synchronized void addBlockPool(String bpid) {
            SimulatedBPStorage bpStorage = this.map.get(bpid);
            if (bpStorage != null) {
                return;
            }
            this.map.put(bpid, new SimulatedBPStorage());
        }

        synchronized void removeBlockPool(String bpid) {
            this.map.remove(bpid);
        }

        private SimulatedBPStorage getBPStorage(String bpid) throws IOException {
            SimulatedBPStorage bpStorage = this.map.get(bpid);
            if (bpStorage == null) {
                throw new IOException("block pool " + bpid + " not found");
            }
            return bpStorage;
        }

        String getStorageUuid() {
            return this.dnStorage.getStorageID();
        }

        DatanodeStorage getDnStorage() {
            return this.dnStorage;
        }

        synchronized StorageReport getStorageReport(String bpid) {
            return new StorageReport(this.dnStorage, false, this.getCapacity(), this.getUsed(), this.getFree(), this.map.get(bpid).getUsed());
        }
    }

    private static class SimulatedBPStorage {
        private long used = 0L;

        long getUsed() {
            return this.used;
        }

        void alloc(long amount) {
            this.used += amount;
        }

        void free(long amount) {
            this.used -= amount;
        }

        SimulatedBPStorage() {
        }
    }

    private class BInfo
    implements ReplicaInPipelineInterface {
        final Block theBlock;
        private boolean finalized = false;
        SimulatedOutputStream oStream = null;
        private long bytesAcked;
        private long bytesRcvd;

        BInfo(String bpid, Block b, boolean forWriting) throws IOException {
            this.theBlock = new Block(b);
            if (this.theBlock.getNumBytes() < 0L) {
                this.theBlock.setNumBytes(0L);
            }
            if (!SimulatedFSDataset.this.storage.alloc(bpid, this.theBlock.getNumBytes())) {
                DataNode.LOG.warn((Object)"Lack of free storage on a block alloc");
                throw new IOException("Creating block, no free space available");
            }
            if (forWriting) {
                this.finalized = false;
                this.oStream = new SimulatedOutputStream();
            } else {
                this.finalized = true;
                this.oStream = null;
            }
        }

        public String getStorageUuid() {
            return SimulatedFSDataset.this.storage.getStorageUuid();
        }

        public synchronized long getGenerationStamp() {
            return this.theBlock.getGenerationStamp();
        }

        public synchronized long getNumBytes() {
            if (!this.finalized) {
                return this.bytesRcvd;
            }
            return this.theBlock.getNumBytes();
        }

        public synchronized void setNumBytes(long length) {
            if (!this.finalized) {
                this.bytesRcvd = length;
            } else {
                this.theBlock.setNumBytes(length);
            }
        }

        synchronized SimulatedInputStream getIStream() {
            if (!this.finalized) {
                return new SimulatedInputStream(this.oStream.getLength(), 9);
            }
            return new SimulatedInputStream(this.theBlock.getNumBytes(), 9);
        }

        synchronized void finalizeBlock(String bpid, long finalSize) throws IOException {
            if (this.finalized) {
                throw new IOException("Finalizing a block that has already been finalized" + this.theBlock.getBlockId());
            }
            if (this.oStream == null) {
                DataNode.LOG.error((Object)"Null oStream on unfinalized block - bug");
                throw new IOException("Unexpected error on finalize");
            }
            if (this.oStream.getLength() != finalSize) {
                DataNode.LOG.warn((Object)("Size passed to finalize (" + finalSize + ")does not match what was written:" + this.oStream.getLength()));
                throw new IOException("Size passed to finalize does not match the amount of data written");
            }
            long extraLen = finalSize - this.theBlock.getNumBytes();
            if (extraLen > 0L) {
                if (!SimulatedFSDataset.this.storage.alloc(bpid, extraLen)) {
                    DataNode.LOG.warn((Object)"Lack of free storage on a block alloc");
                    throw new IOException("Creating block, no free space available");
                }
            } else {
                SimulatedFSDataset.this.storage.free(bpid, -extraLen);
            }
            this.theBlock.setNumBytes(finalSize);
            this.finalized = true;
            this.oStream = null;
        }

        synchronized void unfinalizeBlock() throws IOException {
            if (!this.finalized) {
                throw new IOException("Unfinalized a block that's not finalized " + this.theBlock);
            }
            this.finalized = false;
            this.oStream = new SimulatedOutputStream();
            long blockLen = this.theBlock.getNumBytes();
            this.oStream.setLength(blockLen);
            this.bytesRcvd = blockLen;
            this.bytesAcked = blockLen;
        }

        SimulatedInputStream getMetaIStream() {
            return new SimulatedInputStream(nullCrcFileData);
        }

        synchronized boolean isFinalized() {
            return this.finalized;
        }

        public synchronized ReplicaOutputStreams createStreams(boolean isCreate, DataChecksum requestedChecksum) throws IOException {
            if (this.finalized) {
                throw new IOException("Trying to write to a finalized replica " + this.theBlock);
            }
            SimulatedOutputStream crcStream = new SimulatedOutputStream();
            return new ReplicaOutputStreams((OutputStream)this.oStream, (OutputStream)crcStream, requestedChecksum, SimulatedFSDataset.this.volume.isTransientStorage());
        }

        public synchronized long getBlockId() {
            return this.theBlock.getBlockId();
        }

        public synchronized long getVisibleLength() {
            return this.getBytesAcked();
        }

        public HdfsServerConstants.ReplicaState getState() {
            return null;
        }

        public synchronized long getBytesAcked() {
            if (this.finalized) {
                return this.theBlock.getNumBytes();
            }
            return this.bytesAcked;
        }

        public synchronized void setBytesAcked(long bytesAcked) {
            if (!this.finalized) {
                this.bytesAcked = bytesAcked;
            }
        }

        public void releaseAllBytesReserved() {
        }

        public synchronized long getBytesOnDisk() {
            if (this.finalized) {
                return this.theBlock.getNumBytes();
            }
            return this.oStream.getLength();
        }

        public void setLastChecksumAndDataLen(long dataLength, byte[] lastChecksum) {
            this.oStream.setLength(dataLength);
        }

        public ChunkChecksum getLastChecksumAndDataLen() {
            return new ChunkChecksum(this.oStream.getLength(), null);
        }

        public boolean isOnTransientStorage() {
            return false;
        }
    }

    static class Factory
    extends FsDatasetSpi.Factory<SimulatedFSDataset> {
        Factory() {
        }

        public SimulatedFSDataset newInstance(DataNode datanode, DataStorage storage, Configuration conf) throws IOException {
            return new SimulatedFSDataset(storage, conf);
        }

        public boolean isSimulated() {
            return true;
        }
    }
}

