/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.UnitsConversionUtil;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DominantResourceCalculator
extends ResourceCalculator {
    static final Log LOG = LogFactory.getLog(DominantResourceCalculator.class);

    private int compare(Resource lhs, Resource rhs) {
        boolean lhsGreater = false;
        boolean rhsGreater = false;
        int ret = 0;
        int maxLength = ResourceUtils.getNumberOfKnownResourceTypes();
        for (int i = 0; i < maxLength; ++i) {
            ResourceInformation rhsResourceInformation;
            ResourceInformation lhsResourceInformation = lhs.getResourceInformation(i);
            int diff = lhsResourceInformation.compareTo(rhsResourceInformation = rhs.getResourceInformation(i));
            if (diff >= 1) {
                lhsGreater = true;
                continue;
            }
            if (diff > -1) continue;
            rhsGreater = true;
        }
        if (lhsGreater && rhsGreater) {
            ret = 0;
        } else if (lhsGreater) {
            ret = 1;
        } else if (rhsGreater) {
            ret = -1;
        }
        return ret;
    }

    @Override
    public int compare(Resource clusterResource, Resource lhs, Resource rhs, boolean singleType) {
        double diff;
        if (lhs.equals((Object)rhs)) {
            return 0;
        }
        if (this.isInvalidDivisor(clusterResource)) {
            return this.compare(lhs, rhs);
        }
        Object[] clusterRes = clusterResource.getResources();
        int maxLength = ResourceUtils.getNumberOfKnownResourceTypes();
        double[] lhsShares = new double[maxLength];
        double[] rhsShares = new double[maxLength];
        try {
            if (singleType) {
                double[] max = new double[2];
                this.calculateShares((ResourceInformation[])clusterRes, lhs, rhs, lhsShares, rhsShares, max);
                diff = max[0] - max[1];
            } else if (maxLength == 2) {
                diff = this.calculateSharesForTwoMandatoryResources((ResourceInformation[])clusterRes, lhs, rhs, lhsShares, rhsShares);
            } else {
                this.calculateShares((ResourceInformation[])clusterRes, lhs, rhs, lhsShares, rhsShares);
                Arrays.sort(lhsShares);
                Arrays.sort(rhsShares);
                diff = this.compareShares(lhsShares, rhsShares);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            StringWriter out = new StringWriter();
            ex.printStackTrace(new PrintWriter(out));
            LOG.error((Object)("A problem was encountered while calculating resource availability that should not occur under normal circumstances. Please report this error to the Hadoop community by opening a JIRA ticket at http://issues.apache.org/jira and including the following information:\n* Exception encountered: " + out + "* " + "Cluster resources: " + Arrays.toString(clusterRes) + "\n* " + "LHS resource: " + Arrays.toString(lhs.getResources()) + "\n* " + "RHS resource: " + Arrays.toString(rhs.getResources())));
            LOG.error((Object)"The resource manager is in an inconsistent state. It is safe for the resource manager to be restarted as the error encountered should be transitive. If high availability is enabled, failing over to a standby resource manager is also safe.");
            throw new YarnRuntimeException("A problem was encountered while calculating resource availability that should not occur under normal circumstances. Please see the log for more information.", (Throwable)ex);
        }
        return (int)Math.signum(diff);
    }

    private void calculateShares(ResourceInformation[] clusterRes, Resource first, Resource second, double[] firstShares, double[] secondShares) {
        ResourceInformation[] firstRes = first.getResources();
        ResourceInformation[] secondRes = second.getResources();
        int maxLength = ResourceUtils.getNumberOfKnownResourceTypes();
        for (int i = 0; i < maxLength; ++i) {
            firstShares[i] = this.calculateShare(clusterRes[i], firstRes[i]);
            secondShares[i] = this.calculateShare(clusterRes[i], secondRes[i]);
        }
    }

    private int calculateSharesForTwoMandatoryResources(ResourceInformation[] clusterRes, Resource first, Resource second, double[] firstShares, double[] secondShares) {
        ResourceInformation[] firstRes = first.getResources();
        ResourceInformation[] secondRes = second.getResources();
        firstShares[0] = this.calculateShare(clusterRes[0], firstRes[0]);
        secondShares[0] = this.calculateShare(clusterRes[0], secondRes[0]);
        firstShares[1] = this.calculateShare(clusterRes[1], firstRes[1]);
        secondShares[1] = this.calculateShare(clusterRes[1], secondRes[1]);
        int firstDom = 0;
        int firstSub = 1;
        if (firstShares[1] > firstShares[0]) {
            firstDom = 1;
            firstSub = 0;
        }
        int secondDom = 0;
        int secondSub = 1;
        if (secondShares[1] > secondShares[0]) {
            secondDom = 1;
            secondSub = 0;
        }
        if (firstShares[firstDom] > secondShares[secondDom]) {
            return 1;
        }
        if (firstShares[firstDom] < secondShares[secondDom]) {
            return -1;
        }
        if (firstShares[firstSub] > secondShares[secondSub]) {
            return 1;
        }
        if (firstShares[firstSub] < secondShares[secondSub]) {
            return -1;
        }
        return 0;
    }

    private void calculateShares(ResourceInformation[] clusterRes, Resource first, Resource second, double[] firstShares, double[] secondShares, double[] max) {
        ResourceInformation[] firstRes = first.getResources();
        ResourceInformation[] secondRes = second.getResources();
        max[0] = 0.0;
        max[1] = 0.0;
        int maxLength = ResourceUtils.getNumberOfKnownResourceTypes();
        for (int i = 0; i < maxLength; ++i) {
            firstShares[i] = this.calculateShare(clusterRes[i], firstRes[i]);
            secondShares[i] = this.calculateShare(clusterRes[i], secondRes[i]);
            if (firstShares[i] > max[0]) {
                max[0] = firstShares[i];
            }
            if (!(secondShares[i] > max[1])) continue;
            max[1] = secondShares[i];
        }
    }

    private double calculateShare(ResourceInformation clusterRes, ResourceInformation res) {
        long value = UnitsConversionUtil.convert((String)res.getUnits(), (String)clusterRes.getUnits(), (long)res.getValue());
        return (double)value / (double)clusterRes.getValue();
    }

    private double compareShares(double[] lhsShares, double[] rhsShares) {
        double diff = 0.0;
        for (int i = lhsShares.length - 1; i >= 0 && (diff = lhsShares[i] - rhsShares[i]) == 0.0; --i) {
        }
        return diff;
    }

    @Override
    public long computeAvailableContainers(Resource available, Resource required) {
        long min = Long.MAX_VALUE;
        int maxLength = ResourceUtils.getNumberOfKnownResourceTypes();
        for (int i = 0; i < maxLength; ++i) {
            ResourceInformation availableResource = available.getResourceInformation(i);
            ResourceInformation requiredResource = required.getResourceInformation(i);
            long requiredResourceValue = UnitsConversionUtil.convert((String)requiredResource.getUnits(), (String)availableResource.getUnits(), (long)requiredResource.getValue());
            if (requiredResourceValue == 0L) continue;
            long tmp = availableResource.getValue() / requiredResourceValue;
            min = min < tmp ? min : tmp;
        }
        return min > Integer.MAX_VALUE ? Integer.MAX_VALUE : (long)((int)min);
    }

    @Override
    public float divide(Resource clusterResource, Resource numerator, Resource denominator) {
        int nKnownResourceTypes = ResourceUtils.getNumberOfKnownResourceTypes();
        ResourceInformation[] clusterRes = clusterResource.getResources();
        double[] numeratorShares = new double[nKnownResourceTypes];
        double[] denominatorShares = new double[nKnownResourceTypes];
        double[] max = new double[2];
        this.calculateShares(clusterRes, numerator, denominator, numeratorShares, denominatorShares, max);
        return (float)(max[0] / max[1]);
    }

    @Override
    public boolean isInvalidDivisor(Resource r) {
        for (ResourceInformation res : r.getResources()) {
            if (res.getValue() != 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public float ratio(Resource a, Resource b) {
        float ratio = 0.0f;
        int maxLength = ResourceUtils.getNumberOfKnownResourceTypes();
        for (int i = 0; i < maxLength; ++i) {
            ResourceInformation aResourceInformation = a.getResourceInformation(i);
            ResourceInformation bResourceInformation = b.getResourceInformation(i);
            long bResourceValue = UnitsConversionUtil.convert((String)bResourceInformation.getUnits(), (String)aResourceInformation.getUnits(), (long)bResourceInformation.getValue());
            float tmp = (float)aResourceInformation.getValue() / (float)bResourceValue;
            ratio = ratio > tmp ? ratio : tmp;
        }
        return ratio;
    }

    @Override
    public Resource divideAndCeil(Resource numerator, int denominator) {
        return this.divideAndCeil(numerator, (long)denominator);
    }

    public Resource divideAndCeil(Resource numerator, long denominator) {
        Resource ret = Resource.newInstance((Resource)numerator);
        int maxLength = ResourceUtils.getNumberOfKnownResourceTypes();
        for (int i = 0; i < maxLength; ++i) {
            ResourceInformation resourceInformation = ret.getResourceInformation(i);
            resourceInformation.setValue(DominantResourceCalculator.divideAndCeil(resourceInformation.getValue(), denominator));
        }
        return ret;
    }

    @Override
    public Resource divideAndCeil(Resource numerator, float denominator) {
        return Resources.createResource(DominantResourceCalculator.divideAndCeil(numerator.getMemorySize(), denominator), DominantResourceCalculator.divideAndCeil(numerator.getVirtualCores(), denominator));
    }

    @Override
    public Resource normalize(Resource r, Resource minimumResource, Resource maximumResource, Resource stepFactor) {
        Resource ret = Resource.newInstance((Resource)r);
        int maxLength = ResourceUtils.getNumberOfKnownResourceTypes();
        for (int i = 0; i < maxLength; ++i) {
            ResourceInformation rResourceInformation = r.getResourceInformation(i);
            ResourceInformation minimumResourceInformation = minimumResource.getResourceInformation(i);
            ResourceInformation maximumResourceInformation = maximumResource.getResourceInformation(i);
            ResourceInformation stepFactorResourceInformation = stepFactor.getResourceInformation(i);
            ResourceInformation tmp = ret.getResourceInformation(i);
            long rValue = rResourceInformation.getValue();
            long minimumValue = UnitsConversionUtil.convert((String)minimumResourceInformation.getUnits(), (String)rResourceInformation.getUnits(), (long)minimumResourceInformation.getValue());
            long maximumValue = UnitsConversionUtil.convert((String)maximumResourceInformation.getUnits(), (String)rResourceInformation.getUnits(), (long)maximumResourceInformation.getValue());
            long stepFactorValue = UnitsConversionUtil.convert((String)stepFactorResourceInformation.getUnits(), (String)rResourceInformation.getUnits(), (long)stepFactorResourceInformation.getValue());
            long value = Math.max(rValue, minimumValue);
            if (stepFactorValue != 0L) {
                value = DominantResourceCalculator.roundUp(value, stepFactorValue);
            }
            tmp.setValue(Math.min(value, maximumValue));
            ret.setResourceInformation(i, tmp);
        }
        return ret;
    }

    @Override
    public Resource roundUp(Resource r, Resource stepFactor) {
        return this.rounding(r, stepFactor, true);
    }

    @Override
    public Resource roundDown(Resource r, Resource stepFactor) {
        return this.rounding(r, stepFactor, false);
    }

    private Resource rounding(Resource r, Resource stepFactor, boolean roundUp) {
        Resource ret = Resource.newInstance((Resource)r);
        int maxLength = ResourceUtils.getNumberOfKnownResourceTypes();
        for (int i = 0; i < maxLength; ++i) {
            ResourceInformation rResourceInformation = r.getResourceInformation(i);
            ResourceInformation stepFactorResourceInformation = stepFactor.getResourceInformation(i);
            long rValue = rResourceInformation.getValue();
            long stepFactorValue = UnitsConversionUtil.convert((String)stepFactorResourceInformation.getUnits(), (String)rResourceInformation.getUnits(), (long)stepFactorResourceInformation.getValue());
            long value = rValue;
            if (stepFactorValue != 0L) {
                value = roundUp ? DominantResourceCalculator.roundUp(rValue, stepFactorValue) : DominantResourceCalculator.roundDown(rValue, stepFactorValue);
            }
            ResourceInformation.copy((ResourceInformation)rResourceInformation, (ResourceInformation)ret.getResourceInformation(i));
            ret.getResourceInformation(i).setValue(value);
        }
        return ret;
    }

    @Override
    public Resource multiplyAndNormalizeUp(Resource r, double by, Resource stepFactor) {
        return this.multiplyAndNormalize(r, by, stepFactor, true);
    }

    @Override
    public Resource multiplyAndNormalizeDown(Resource r, double by, Resource stepFactor) {
        return this.multiplyAndNormalize(r, by, stepFactor, false);
    }

    private Resource multiplyAndNormalize(Resource r, double by, Resource stepFactor, boolean roundUp) {
        Resource ret = Resource.newInstance((Resource)r);
        int maxLength = ResourceUtils.getNumberOfKnownResourceTypes();
        for (int i = 0; i < maxLength; ++i) {
            ResourceInformation rResourceInformation = r.getResourceInformation(i);
            ResourceInformation stepFactorResourceInformation = stepFactor.getResourceInformation(i);
            ResourceInformation tmp = ret.getResourceInformation(i);
            long rValue = rResourceInformation.getValue();
            long stepFactorValue = UnitsConversionUtil.convert((String)stepFactorResourceInformation.getUnits(), (String)rResourceInformation.getUnits(), (long)stepFactorResourceInformation.getValue());
            long value = stepFactorValue != 0L ? (roundUp ? DominantResourceCalculator.roundUp((long)Math.ceil((float)((double)rValue * by)), stepFactorValue) : DominantResourceCalculator.roundDown((long)((double)rValue * by), stepFactorValue)) : (roundUp ? (long)Math.ceil((float)((double)rValue * by)) : (long)((double)rValue * by));
            tmp.setValue(value);
        }
        return ret;
    }

    @Override
    public boolean fitsIn(Resource cluster, Resource smaller, Resource bigger) {
        int maxLength = ResourceUtils.getNumberOfKnownResourceTypes();
        for (int i = 0; i < maxLength; ++i) {
            ResourceInformation sResourceInformation = smaller.getResourceInformation(i);
            ResourceInformation bResourceInformation = bigger.getResourceInformation(i);
            long sResourceValue = UnitsConversionUtil.convert((String)sResourceInformation.getUnits(), (String)bResourceInformation.getUnits(), (long)sResourceInformation.getValue());
            if (sResourceValue <= bResourceInformation.getValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAnyMajorResourceZero(Resource resource) {
        return (float)resource.getMemorySize() == 0.0f || resource.getVirtualCores() == 0;
    }
}

