/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.ContainerManagerEventType;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.DefaultContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.NodeHealthCheckerService;
import org.apache.hadoop.yarn.server.nodemanager.NodeManagerEvent;
import org.apache.hadoop.yarn.server.nodemanager.NodeManagerEventType;
import org.apache.hadoop.yarn.server.nodemanager.NodeResourceMonitor;
import org.apache.hadoop.yarn.server.nodemanager.NodeResourceMonitorImpl;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdaterImpl;
import org.apache.hadoop.yarn.server.nodemanager.ResourceView;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;
import org.apache.hadoop.yarn.server.nodemanager.security.NMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.nodemanager.security.NMTokenSecretManagerInNM;
import org.apache.hadoop.yarn.server.nodemanager.webapp.WebServer;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;

public class NodeManager
extends CompositeService
implements EventHandler<NodeManagerEvent> {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private static final Log LOG = LogFactory.getLog(NodeManager.class);
    protected final NodeManagerMetrics metrics = NodeManagerMetrics.create();
    private ApplicationACLsManager aclsManager;
    private NodeHealthCheckerService nodeHealthChecker;
    private LocalDirsHandlerService dirsHandler;
    private Context context;
    private AsyncDispatcher dispatcher;
    private ContainerManagerImpl containerManager;
    private NodeStatusUpdater nodeStatusUpdater;
    private static CompositeService.CompositeServiceShutdownHook nodeManagerShutdownHook;
    private AtomicBoolean isStopping = new AtomicBoolean(false);

    public NodeManager() {
        super(NodeManager.class.getName());
    }

    protected NodeStatusUpdater createNodeStatusUpdater(Context context, Dispatcher dispatcher, NodeHealthCheckerService healthChecker) {
        return new NodeStatusUpdaterImpl(context, dispatcher, healthChecker, this.metrics);
    }

    protected NodeResourceMonitor createNodeResourceMonitor() {
        return new NodeResourceMonitorImpl();
    }

    protected ContainerManagerImpl createContainerManager(Context context, ContainerExecutor exec, DeletionService del, NodeStatusUpdater nodeStatusUpdater, ApplicationACLsManager aclsManager, LocalDirsHandlerService dirsHandler) {
        return new ContainerManagerImpl(context, exec, del, nodeStatusUpdater, this.metrics, aclsManager, dirsHandler);
    }

    protected WebServer createWebServer(Context nmContext, ResourceView resourceView, ApplicationACLsManager aclsManager, LocalDirsHandlerService dirsHandler) {
        return new WebServer(nmContext, resourceView, aclsManager, dirsHandler);
    }

    protected DeletionService createDeletionService(ContainerExecutor exec) {
        return new DeletionService(exec);
    }

    protected NMContext createNMContext(NMContainerTokenSecretManager containerTokenSecretManager, NMTokenSecretManagerInNM nmTokenSecretManager) {
        return new NMContext(containerTokenSecretManager, nmTokenSecretManager);
    }

    protected void doSecureLogin() throws IOException {
        SecurityUtil.login((Configuration)this.getConfig(), (String)"yarn.nodemanager.keytab", (String)"yarn.nodemanager.principal");
    }

    protected void serviceInit(Configuration conf) throws Exception {
        conf.setBoolean("yarn.dispatcher.exit-on-error", true);
        NMContainerTokenSecretManager containerTokenSecretManager = new NMContainerTokenSecretManager(conf);
        NMTokenSecretManagerInNM nmTokenSecretManager = new NMTokenSecretManagerInNM();
        this.context = this.createNMContext(containerTokenSecretManager, nmTokenSecretManager);
        this.aclsManager = new ApplicationACLsManager(conf);
        ContainerExecutor exec = (ContainerExecutor)ReflectionUtils.newInstance((Class)conf.getClass("yarn.nodemanager.container-executor.class", DefaultContainerExecutor.class, ContainerExecutor.class), (Configuration)conf);
        try {
            exec.init();
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed to initialize container executor", (Throwable)e);
        }
        DeletionService del = this.createDeletionService(exec);
        this.addService((Service)del);
        this.dispatcher = new AsyncDispatcher();
        this.nodeHealthChecker = new NodeHealthCheckerService();
        this.addService((Service)this.nodeHealthChecker);
        this.dirsHandler = this.nodeHealthChecker.getDiskHandler();
        this.nodeStatusUpdater = this.createNodeStatusUpdater(this.context, (Dispatcher)this.dispatcher, this.nodeHealthChecker);
        NodeResourceMonitor nodeResourceMonitor = this.createNodeResourceMonitor();
        this.addService(nodeResourceMonitor);
        this.containerManager = this.createContainerManager(this.context, exec, del, this.nodeStatusUpdater, this.aclsManager, this.dirsHandler);
        this.addService((Service)this.containerManager);
        ((NMContext)this.context).setContainerManager(this.containerManager);
        WebServer webServer = this.createWebServer(this.context, this.containerManager.getContainersMonitor(), this.aclsManager, this.dirsHandler);
        this.addService((Service)webServer);
        ((NMContext)this.context).setWebServer(webServer);
        this.dispatcher.register(ContainerManagerEventType.class, (EventHandler)this.containerManager);
        this.dispatcher.register(NodeManagerEventType.class, (EventHandler)this);
        this.addService((Service)this.dispatcher);
        DefaultMetricsSystem.initialize((String)"NodeManager");
        this.addService(this.nodeStatusUpdater);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        try {
            this.doSecureLogin();
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed NodeManager login", (Throwable)e);
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.isStopping.getAndSet(true)) {
            return;
        }
        super.serviceStop();
        DefaultMetricsSystem.shutdown();
    }

    public String getName() {
        return "NodeManager";
    }

    protected void shutDown() {
        new Thread(){

            @Override
            public void run() {
                NodeManager.this.stop();
            }
        }.start();
    }

    protected void resyncWithRM() {
        new Thread(){

            @Override
            public void run() {
                LOG.info((Object)"Notifying ContainerManager to block new container-requests");
                NodeManager.this.containerManager.setBlockNewContainerRequests(true);
                LOG.info((Object)"Cleaning up running containers on resync");
                NodeManager.this.containerManager.cleanupContainersOnNMResync();
                ((NodeStatusUpdaterImpl)NodeManager.this.nodeStatusUpdater).rebootNodeStatusUpdater();
            }
        }.start();
    }

    public NodeHealthCheckerService getNodeHealthChecker() {
        return this.nodeHealthChecker;
    }

    private void initAndStartNodeManager(Configuration conf, boolean hasToReboot) {
        try {
            if (hasToReboot && null != nodeManagerShutdownHook) {
                ShutdownHookManager.get().removeShutdownHook((Runnable)nodeManagerShutdownHook);
            }
            nodeManagerShutdownHook = new CompositeService.CompositeServiceShutdownHook((CompositeService)this);
            ShutdownHookManager.get().addShutdownHook((Runnable)nodeManagerShutdownHook, 30);
            this.init(conf);
            this.start();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting NodeManager", t);
            System.exit(-1);
        }
    }

    public void handle(NodeManagerEvent event) {
        switch ((NodeManagerEventType)event.getType()) {
            case SHUTDOWN: {
                this.shutDown();
                break;
            }
            case RESYNC: {
                this.resyncWithRM();
                break;
            }
            default: {
                LOG.warn((Object)("Invalid shutdown event " + event.getType() + ". Ignoring."));
            }
        }
    }

    NodeManager createNewNodeManager() {
        return new NodeManager();
    }

    ContainerManagerImpl getContainerManager() {
        return this.containerManager;
    }

    Dispatcher getNMDispatcher() {
        return this.dispatcher;
    }

    @VisibleForTesting
    public Context getNMContext() {
        return this.context;
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(NodeManager.class, (String[])args, (Log)LOG);
        NodeManager nodeManager = new NodeManager();
        YarnConfiguration conf = new YarnConfiguration();
        NodeManager.setHttpPolicy((Configuration)conf);
        nodeManager.initAndStartNodeManager((Configuration)conf, false);
    }

    private static void setHttpPolicy(Configuration conf) {
        HttpConfig.setPolicy((HttpConfig.Policy)HttpConfig.Policy.fromString((String)conf.get("yarn.http.policy", "HTTP_ONLY")));
    }

    @VisibleForTesting
    @InterfaceAudience.Private
    public NodeStatusUpdater getNodeStatusUpdater() {
        return this.nodeStatusUpdater;
    }

    public static class NMContext
    implements Context {
        private NodeId nodeId = null;
        private final ConcurrentMap<ApplicationId, Application> applications = new ConcurrentHashMap<ApplicationId, Application>();
        private final ConcurrentMap<ContainerId, Container> containers = new ConcurrentSkipListMap<ContainerId, Container>();
        private final NMContainerTokenSecretManager containerTokenSecretManager;
        private final NMTokenSecretManagerInNM nmTokenSecretManager;
        private ContainerManagementProtocol containerManager;
        private WebServer webServer;
        private final NodeHealthStatus nodeHealthStatus = (NodeHealthStatus)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(NodeHealthStatus.class);

        public NMContext(NMContainerTokenSecretManager containerTokenSecretManager, NMTokenSecretManagerInNM nmTokenSecretManager) {
            this.containerTokenSecretManager = containerTokenSecretManager;
            this.nmTokenSecretManager = nmTokenSecretManager;
            this.nodeHealthStatus.setIsNodeHealthy(true);
            this.nodeHealthStatus.setHealthReport("Healthy");
            this.nodeHealthStatus.setLastHealthReportTime(System.currentTimeMillis());
        }

        @Override
        public NodeId getNodeId() {
            return this.nodeId;
        }

        @Override
        public int getHttpPort() {
            return this.webServer.getPort();
        }

        @Override
        public ConcurrentMap<ApplicationId, Application> getApplications() {
            return this.applications;
        }

        @Override
        public ConcurrentMap<ContainerId, Container> getContainers() {
            return this.containers;
        }

        @Override
        public NMContainerTokenSecretManager getContainerTokenSecretManager() {
            return this.containerTokenSecretManager;
        }

        @Override
        public NMTokenSecretManagerInNM getNMTokenSecretManager() {
            return this.nmTokenSecretManager;
        }

        @Override
        public NodeHealthStatus getNodeHealthStatus() {
            return this.nodeHealthStatus;
        }

        @Override
        public ContainerManagementProtocol getContainerManager() {
            return this.containerManager;
        }

        public void setContainerManager(ContainerManagementProtocol containerManager) {
            this.containerManager = containerManager;
        }

        public void setWebServer(WebServer webServer) {
            this.webServer = webServer;
        }

        public void setNodeId(NodeId nodeId) {
            this.nodeId = nodeId;
        }
    }
}

