/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerRecoverEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.util.resource.Resources;

public abstract class AbstractYarnScheduler<T extends SchedulerApplicationAttempt, N extends SchedulerNode>
extends AbstractService
implements ResourceScheduler {
    private static final Log LOG = LogFactory.getLog(AbstractYarnScheduler.class);
    protected Map<NodeId, N> nodes = new ConcurrentHashMap<NodeId, N>();
    protected Resource clusterResource = Resource.newInstance((int)0, (int)0);
    protected Resource minimumAllocation;
    protected Resource maximumAllocation;
    protected RMContext rmContext;
    protected Map<ApplicationId, SchedulerApplication<T>> applications;
    protected static final List<Container> EMPTY_CONTAINER_LIST = new ArrayList<Container>();
    protected static final Allocation EMPTY_ALLOCATION = new Allocation(EMPTY_CONTAINER_LIST, Resources.createResource((int)0), null, null, null);

    public AbstractYarnScheduler(String name) {
        super(name);
    }

    public synchronized List<Container> getTransferredContainers(ApplicationAttemptId currentAttempt) {
        ApplicationId appId = currentAttempt.getApplicationId();
        SchedulerApplication<T> app = this.applications.get(appId);
        ArrayList<Container> containerList = new ArrayList<Container>();
        RMApp appImpl = (RMApp)this.rmContext.getRMApps().get(appId);
        if (appImpl.getApplicationSubmissionContext().getUnmanagedAM()) {
            return containerList;
        }
        Collection<RMContainer> liveContainers = ((SchedulerApplicationAttempt)app.getCurrentAppAttempt()).getLiveContainers();
        ContainerId amContainerId = ((RMApp)this.rmContext.getRMApps().get(appId)).getCurrentAppAttempt().getMasterContainer().getId();
        for (RMContainer rmContainer : liveContainers) {
            if (rmContainer.getContainerId().equals((Object)amContainerId)) continue;
            containerList.add(rmContainer.getContainer());
        }
        return containerList;
    }

    public Map<ApplicationId, SchedulerApplication<T>> getSchedulerApplications() {
        return this.applications;
    }

    @Override
    public Resource getClusterResource() {
        return this.clusterResource;
    }

    @Override
    public Resource getMinimumResourceCapability() {
        return this.minimumAllocation;
    }

    @Override
    public Resource getMaximumResourceCapability() {
        return this.maximumAllocation;
    }

    public T getApplicationAttempt(ApplicationAttemptId applicationAttemptId) {
        SchedulerApplication<T> app = this.applications.get(applicationAttemptId.getApplicationId());
        return app == null ? null : (T)app.getCurrentAppAttempt();
    }

    @Override
    public SchedulerAppReport getSchedulerAppInfo(ApplicationAttemptId appAttemptId) {
        T attempt = this.getApplicationAttempt(appAttemptId);
        if (attempt == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request for appInfo of unknown attempt " + appAttemptId));
            }
            return null;
        }
        return new SchedulerAppReport((SchedulerApplicationAttempt)attempt);
    }

    @Override
    public ApplicationResourceUsageReport getAppResourceUsageReport(ApplicationAttemptId appAttemptId) {
        T attempt = this.getApplicationAttempt(appAttemptId);
        if (attempt == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request for appInfo of unknown attempt " + appAttemptId));
            }
            return null;
        }
        return ((SchedulerApplicationAttempt)attempt).getResourceUsageReport();
    }

    public T getCurrentAttemptForContainer(ContainerId containerId) {
        return this.getApplicationAttempt(containerId.getApplicationAttemptId());
    }

    @Override
    public RMContainer getRMContainer(ContainerId containerId) {
        T attempt = this.getCurrentAttemptForContainer(containerId);
        return attempt == null ? null : ((SchedulerApplicationAttempt)attempt).getRMContainer(containerId);
    }

    @Override
    public SchedulerNodeReport getNodeReport(NodeId nodeId) {
        SchedulerNode node = (SchedulerNode)this.nodes.get(nodeId);
        return node == null ? null : new SchedulerNodeReport(node);
    }

    @Override
    public String moveApplication(ApplicationId appId, String newQueue) throws YarnException {
        throw new YarnException(this.getClass().getSimpleName() + " does not support moving apps between queues");
    }

    private void killOrphanContainerOnNode(RMNode node, NMContainerStatus container) {
        if (!container.getContainerState().equals((Object)ContainerState.COMPLETE)) {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeCleanContainerEvent(node.getNodeID(), container.getContainerId()));
        }
    }

    public synchronized void recoverContainersOnNode(List<NMContainerStatus> containerReports, RMNode nm) {
        if (!this.rmContext.isWorkPreservingRecoveryEnabled() || containerReports == null || containerReports != null && containerReports.isEmpty()) {
            return;
        }
        for (NMContainerStatus container : containerReports) {
            Container masterContainer;
            ApplicationId appId = container.getContainerId().getApplicationAttemptId().getApplicationId();
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(appId);
            if (rmApp == null) {
                LOG.error((Object)("Skip recovering container " + container + " for unknown application."));
                this.killOrphanContainerOnNode(nm, container);
                continue;
            }
            if (rmApp.getApplicationSubmissionContext().getUnmanagedAM()) {
                LOG.info((Object)("Skip recovering container " + container + " for unmanaged AM." + rmApp.getApplicationId()));
                this.killOrphanContainerOnNode(nm, container);
                continue;
            }
            SchedulerApplication<T> schedulerApp = this.applications.get(appId);
            if (schedulerApp == null) {
                LOG.info((Object)("Skip recovering container  " + container + " for unknown SchedulerApplication. Application current state is " + (Object)((Object)rmApp.getState())));
                this.killOrphanContainerOnNode(nm, container);
                continue;
            }
            LOG.info((Object)("Recovering container " + container));
            T schedulerAttempt = schedulerApp.getCurrentAppAttempt();
            RMContainer rmContainer = this.recoverAndCreateContainer(container, nm);
            rmContainer.handle((Event)new RMContainerRecoverEvent(container.getContainerId(), container));
            ((SchedulerNode)this.nodes.get(nm.getNodeID())).recoverContainer(rmContainer);
            Queue queue = ((SchedulerApplicationAttempt)schedulerAttempt).getQueue();
            queue.recoverContainer(this.clusterResource, (SchedulerApplicationAttempt)schedulerAttempt, rmContainer);
            ((SchedulerApplicationAttempt)schedulerAttempt).recoverContainer(rmContainer);
            RMAppAttempt appAttempt = rmApp.getCurrentAppAttempt();
            if (appAttempt == null || (masterContainer = appAttempt.getMasterContainer()) == null || !masterContainer.getId().equals((Object)rmContainer.getContainerId())) continue;
            ((RMContainerImpl)rmContainer).setAMContainer(true);
        }
    }

    private RMContainer recoverAndCreateContainer(NMContainerStatus status, RMNode node) {
        Container container = Container.newInstance((ContainerId)status.getContainerId(), (NodeId)node.getNodeID(), (String)node.getHttpAddress(), (Resource)status.getAllocatedResource(), (Priority)status.getPriority(), null);
        ApplicationAttemptId attemptId = container.getId().getApplicationAttemptId();
        RMContainerImpl rmContainer = new RMContainerImpl(container, attemptId, node.getNodeID(), this.applications.get(attemptId.getApplicationId()).getUser(), this.rmContext, status.getCreationTime());
        return rmContainer;
    }

    protected void recoverResourceRequestForContainer(RMContainer rmContainer) {
        List<ResourceRequest> requests = rmContainer.getResourceRequests();
        if (requests == null) {
            return;
        }
        T schedulerAttempt = this.getCurrentAttemptForContainer(rmContainer.getContainerId());
        if (schedulerAttempt != null) {
            ((SchedulerApplicationAttempt)schedulerAttempt).recoverResourceRequests(requests);
        }
    }

    public SchedulerNode getSchedulerNode(NodeId nodeId) {
        return (SchedulerNode)this.nodes.get(nodeId);
    }
}

