/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class RLESparseResourceAllocation {
    private static final int THRESHOLD = 100;
    private static final Resource ZERO_RESOURCE = Resources.none();
    private NavigableMap<Long, Resource> cumulativeCapacity = new TreeMap<Long, Resource>();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final ResourceCalculator resourceCalculator;

    public RLESparseResourceAllocation(ResourceCalculator resourceCalculator) {
        this.resourceCalculator = resourceCalculator;
    }

    public RLESparseResourceAllocation(NavigableMap<Long, Resource> out, ResourceCalculator resourceCalculator) {
        this.cumulativeCapacity = out;
        this.resourceCalculator = resourceCalculator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addInterval(ReservationInterval reservationInterval, Resource totCap) {
        if (totCap.equals((Object)ZERO_RESOURCE)) {
            return true;
        }
        this.writeLock.lock();
        try {
            TreeMap<Long, Resource> addInt = new TreeMap<Long, Resource>();
            addInt.put(reservationInterval.getStartTime(), totCap);
            addInt.put(reservationInterval.getEndTime(), ZERO_RESOURCE);
            try {
                this.cumulativeCapacity = RLESparseResourceAllocation.merge(this.resourceCalculator, totCap, this.cumulativeCapacity, addInt, Long.MIN_VALUE, Long.MAX_VALUE, RLEOperator.add);
            }
            catch (PlanningException planningException) {
                // empty catch block
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeInterval(ReservationInterval reservationInterval, Resource totCap) {
        if (totCap.equals((Object)ZERO_RESOURCE)) {
            return true;
        }
        this.writeLock.lock();
        try {
            TreeMap<Long, Resource> removeInt = new TreeMap<Long, Resource>();
            removeInt.put(reservationInterval.getStartTime(), totCap);
            removeInt.put(reservationInterval.getEndTime(), ZERO_RESOURCE);
            try {
                this.cumulativeCapacity = RLESparseResourceAllocation.merge(this.resourceCalculator, totCap, this.cumulativeCapacity, removeInt, Long.MIN_VALUE, Long.MAX_VALUE, RLEOperator.subtract);
            }
            catch (PlanningException planningException) {
                // empty catch block
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getCapacityAtTime(long tick) {
        this.readLock.lock();
        try {
            Map.Entry<Long, Resource> closestStep = this.cumulativeCapacity.floorEntry(tick);
            if (closestStep != null) {
                Resource resource = Resources.clone((Resource)closestStep.getValue());
                return resource;
            }
            Resource resource = Resources.clone((Resource)ZERO_RESOURCE);
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEarliestStartTime() {
        this.readLock.lock();
        try {
            if (this.cumulativeCapacity.isEmpty()) {
                long l = -1L;
                return l;
            }
            long l = (Long)this.cumulativeCapacity.firstKey();
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLatestNonNullTime() {
        this.readLock.lock();
        try {
            if (this.cumulativeCapacity.isEmpty()) {
                long l = -1L;
                return l;
            }
            Map.Entry<Long, Resource> last = this.cumulativeCapacity.lastEntry();
            if (last.getValue() == null) {
                long l = this.cumulativeCapacity.floorKey(last.getKey() - 1L);
                return l;
            }
            long l = last.getKey();
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            if (this.cumulativeCapacity.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            if (this.cumulativeCapacity.size() == 2) {
                boolean bl = this.cumulativeCapacity.firstEntry().getValue().equals((Object)ZERO_RESOURCE) && this.cumulativeCapacity.lastEntry().getValue() == null;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder ret = new StringBuilder();
        this.readLock.lock();
        try {
            if (this.cumulativeCapacity.size() > 100) {
                ret.append("Number of steps: ").append(this.cumulativeCapacity.size()).append(" earliest entry: ").append(this.cumulativeCapacity.firstKey()).append(" latest entry: ").append(this.cumulativeCapacity.lastKey());
            } else {
                for (Map.Entry r : this.cumulativeCapacity.entrySet()) {
                    ret.append(r.getKey()).append(": ").append(r.getValue()).append("\n ");
                }
            }
            String string = ret.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toMemJSONString() {
        StringWriter json = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)json);
        this.readLock.lock();
        try {
            jsonWriter.beginObject();
            for (Map.Entry r : this.cumulativeCapacity.entrySet()) {
                jsonWriter.name(((Long)r.getKey()).toString()).value(((Resource)r.getValue()).toString());
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String i$ = json.toString();
            return i$;
        }
        catch (IOException e) {
            String string = "";
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ReservationInterval, Resource> toIntervalMap() {
        this.readLock.lock();
        try {
            TreeMap<ReservationInterval, Resource> allocations = new TreeMap<ReservationInterval, Resource>();
            if (this.isEmpty()) {
                TreeMap<ReservationInterval, Resource> treeMap = allocations;
                return treeMap;
            }
            Map.Entry lastEntry = null;
            for (Map.Entry entry : this.cumulativeCapacity.entrySet()) {
                if (lastEntry != null && entry.getValue() != null) {
                    ReservationInterval interval = new ReservationInterval((Long)lastEntry.getKey(), (Long)entry.getKey());
                    Resource resource = (Resource)lastEntry.getValue();
                    allocations.put(interval, resource);
                }
                lastEntry = entry;
            }
            TreeMap<ReservationInterval, Resource> treeMap = allocations;
            return treeMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigableMap<Long, Resource> getCumulative() {
        this.readLock.lock();
        try {
            NavigableMap<Long, Resource> navigableMap = this.cumulativeCapacity;
            return navigableMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static RLESparseResourceAllocation merge(ResourceCalculator resCalc, Resource clusterResource, RLESparseResourceAllocation a, RLESparseResourceAllocation b, RLEOperator operator, long start, long end) throws PlanningException {
        NavigableMap<Long, Resource> cumA = a.getRangeOverlapping(start, end).getCumulative();
        NavigableMap<Long, Resource> cumB = b.getRangeOverlapping(start, end).getCumulative();
        NavigableMap<Long, Resource> out = RLESparseResourceAllocation.merge(resCalc, clusterResource, cumA, cumB, start, end, operator);
        return new RLESparseResourceAllocation(out, resCalc);
    }

    private static NavigableMap<Long, Resource> merge(ResourceCalculator resCalc, Resource clusterResource, NavigableMap<Long, Resource> a, NavigableMap<Long, Resource> b, long start, long end, RLEOperator operator) throws PlanningException {
        if (a == null || a.isEmpty()) {
            if (operator == RLEOperator.subtract || operator == RLEOperator.subtractTestNonNegative) {
                return RLESparseResourceAllocation.negate(operator, b);
            }
            return b;
        }
        if (b == null || b.isEmpty()) {
            return a;
        }
        Iterator aIt = a.entrySet().iterator();
        Iterator bIt = b.entrySet().iterator();
        Map.Entry<Long, Object> curA = aIt.next();
        Map.Entry<Long, Object> curB = bIt.next();
        Map.Entry<Long, Object> lastA = null;
        Map.Entry<Long, Resource> lastB = null;
        boolean aIsDone = false;
        boolean bIsDone = false;
        TreeMap<Long, Resource> out = new TreeMap<Long, Resource>();
        while (!curA.equals(lastA) || !curB.equals(lastB)) {
            Resource outRes;
            long time = -1L;
            if (bIsDone || (Long)curA.getKey() < (Long)curB.getKey() && !aIsDone) {
                outRes = RLESparseResourceAllocation.combineValue(operator, resCalc, clusterResource, curA, lastB);
                time = curA.getKey() < start ? start : curA.getKey();
                lastA = curA;
                if (aIt.hasNext()) {
                    curA = aIt.next();
                } else {
                    aIsDone = true;
                }
            } else if (aIsDone || curA.getKey() > (Long)curB.getKey() && !bIsDone) {
                outRes = RLESparseResourceAllocation.combineValue(operator, resCalc, clusterResource, lastA, curB);
                time = curB.getKey() < start ? start : curB.getKey();
                lastB = curB;
                if (bIt.hasNext()) {
                    curB = bIt.next();
                } else {
                    bIsDone = true;
                }
            } else {
                outRes = RLESparseResourceAllocation.combineValue(operator, resCalc, clusterResource, curA, curB);
                time = curA.getKey() < start ? start : curA.getKey();
                lastA = curA;
                if (aIt.hasNext()) {
                    curA = aIt.next();
                } else {
                    aIsDone = true;
                }
                lastB = curB;
                if (bIt.hasNext()) {
                    curB = bIt.next();
                } else {
                    bIsDone = true;
                }
            }
            RLESparseResourceAllocation.addIfNeeded(out, time, outRes);
        }
        RLESparseResourceAllocation.addIfNeeded(out, end, null);
        return out;
    }

    private static NavigableMap<Long, Resource> negate(RLEOperator operator, NavigableMap<Long, Resource> a) throws PlanningException {
        TreeMap<Long, Resource> out = new TreeMap<Long, Resource>();
        for (Map.Entry e : a.entrySet()) {
            Resource val = Resources.negate((Resource)((Resource)e.getValue()));
            if (operator == RLEOperator.subtractTestNonNegative && Resources.fitsIn((Resource)val, (Resource)ZERO_RESOURCE) && !Resources.equals((Resource)val, (Resource)ZERO_RESOURCE)) {
                throw new PlanningException("RLESparseResourceAllocation: merge failed as the resulting RLESparseResourceAllocation would be negative");
            }
            out.put((Long)e.getKey(), val);
        }
        return out;
    }

    private static void addIfNeeded(TreeMap<Long, Resource> out, long time, Resource outRes) {
        if (out.isEmpty() || out.lastEntry() != null && outRes == null || !Resources.equals((Resource)out.lastEntry().getValue(), (Resource)outRes)) {
            out.put(time, outRes);
        }
    }

    private static Resource combineValue(RLEOperator op, ResourceCalculator resCalc, Resource clusterResource, Map.Entry<Long, Resource> eA, Map.Entry<Long, Resource> eB) throws PlanningException {
        if (eA == null || eA.getValue() == null) {
            if (eB == null || eB.getValue() == null) {
                return null;
            }
            if (op == RLEOperator.subtract) {
                return Resources.negate((Resource)eB.getValue());
            }
            return eB.getValue();
        }
        if (eB == null || eB.getValue() == null) {
            return eA.getValue();
        }
        Resource a = eA.getValue();
        Resource b = eB.getValue();
        switch (op) {
            case add: {
                return Resources.add((Resource)a, (Resource)b);
            }
            case subtract: {
                return Resources.subtract((Resource)a, (Resource)b);
            }
            case subtractTestNonNegative: {
                if (!Resources.fitsIn((Resource)b, (Resource)a)) {
                    throw new PlanningException("RLESparseResourceAllocation: merge failed as the resulting RLESparseResourceAllocation would be negative");
                }
                return Resources.subtract((Resource)a, (Resource)b);
            }
            case min: {
                return Resources.min((ResourceCalculator)resCalc, (Resource)clusterResource, (Resource)a, (Resource)b);
            }
            case max: {
                return Resources.max((ResourceCalculator)resCalc, (Resource)clusterResource, (Resource)a, (Resource)b);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RLESparseResourceAllocation getRangeOverlapping(long start, long end) {
        this.readLock.lock();
        try {
            RLESparseResourceAllocation ret;
            NavigableMap<Long, Resource> a = this.getCumulative();
            if (a != null && !a.isEmpty()) {
                if (start > (Long)a.firstKey()) {
                    long previous = a.floorKey(start);
                    a = a.tailMap(previous, true);
                }
                if (end < (Long)a.lastKey()) {
                    a = a.headMap(end, true);
                }
            }
            RLESparseResourceAllocation rLESparseResourceAllocation = ret = new RLESparseResourceAllocation(a, this.resourceCalculator);
            return rLESparseResourceAllocation;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static enum RLEOperator {
        add,
        subtract,
        min,
        max,
        subtractTestNonNegative;

    }
}

