/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMoveEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerNMDoneChangeResourceEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerRecoverEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedContainerChangeRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class AbstractYarnScheduler<T extends SchedulerApplicationAttempt, N extends SchedulerNode>
extends AbstractService
implements ResourceScheduler {
    private static final Log LOG = LogFactory.getLog(AbstractYarnScheduler.class);
    protected Map<NodeId, N> nodes = new ConcurrentHashMap<NodeId, N>();
    protected Resource clusterResource = Resource.newInstance((int)0, (int)0);
    protected Resource minimumAllocation;
    protected Resource maximumAllocation;
    private Resource configuredMaximumAllocation;
    private int maxNodeMemory = -1;
    private int maxNodeVCores = -1;
    private final ReentrantReadWriteLock.ReadLock maxAllocReadLock;
    private final ReentrantReadWriteLock.WriteLock maxAllocWriteLock;
    private boolean useConfiguredMaximumAllocationOnly = true;
    private long configuredMaximumAllocationWaitTime;
    protected RMContext rmContext;
    private volatile Priority maxClusterLevelAppPriority;
    protected ConcurrentMap<ApplicationId, SchedulerApplication<T>> applications;
    protected int nmExpireInterval;
    protected static final List<Container> EMPTY_CONTAINER_LIST = new ArrayList<Container>();
    protected static final Allocation EMPTY_ALLOCATION = new Allocation(EMPTY_CONTAINER_LIST, Resources.createResource((int)0), null, null, null);

    public AbstractYarnScheduler(String name) {
        super(name);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.maxAllocReadLock = lock.readLock();
        this.maxAllocWriteLock = lock.writeLock();
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.nmExpireInterval = conf.getInt("yarn.nm.liveness-monitor.expiry-interval-ms", 600000);
        this.configuredMaximumAllocationWaitTime = conf.getLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 10000L);
        this.maxClusterLevelAppPriority = this.getMaxPriorityFromConf(conf);
        this.createReleaseCache();
        super.serviceInit(conf);
    }

    @Override
    public List<Container> getTransferredContainers(ApplicationAttemptId currentAttempt) {
        ApplicationId appId = currentAttempt.getApplicationId();
        SchedulerApplication app = (SchedulerApplication)this.applications.get(appId);
        ArrayList<Container> containerList = new ArrayList<Container>();
        RMApp appImpl = (RMApp)this.rmContext.getRMApps().get(appId);
        if (appImpl.getApplicationSubmissionContext().getUnmanagedAM()) {
            return containerList;
        }
        if (app == null) {
            return containerList;
        }
        Collection<RMContainer> liveContainers = ((SchedulerApplicationAttempt)app.getCurrentAppAttempt()).getLiveContainers();
        ContainerId amContainerId = ((RMApp)this.rmContext.getRMApps().get(appId)).getCurrentAppAttempt().getMasterContainer().getId();
        for (RMContainer rmContainer : liveContainers) {
            if (rmContainer.getContainerId().equals((Object)amContainerId)) continue;
            containerList.add(rmContainer.getContainer());
        }
        return containerList;
    }

    public Map<ApplicationId, SchedulerApplication<T>> getSchedulerApplications() {
        return this.applications;
    }

    public void addBlacklistedNodeIdsToList(SchedulerApplicationAttempt app, List<NodeId> blacklistNodeIdList) {
        for (Map.Entry<NodeId, N> nodeEntry : this.nodes.entrySet()) {
            if (!SchedulerAppUtils.isPlaceBlacklisted(app, (SchedulerNode)nodeEntry.getValue(), LOG)) continue;
            blacklistNodeIdList.add(nodeEntry.getKey());
        }
    }

    @Override
    public Resource getClusterResource() {
        return this.clusterResource;
    }

    @Override
    public Resource getMinimumResourceCapability() {
        return this.minimumAllocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getMaximumResourceCapability() {
        Resource maxResource;
        this.maxAllocReadLock.lock();
        try {
            if (this.useConfiguredMaximumAllocationOnly) {
                if (System.currentTimeMillis() - ResourceManager.getClusterTimeStamp() > this.configuredMaximumAllocationWaitTime) {
                    this.useConfiguredMaximumAllocationOnly = false;
                }
                maxResource = Resources.clone((Resource)this.configuredMaximumAllocation);
            } else {
                maxResource = Resources.clone((Resource)this.maximumAllocation);
            }
        }
        finally {
            this.maxAllocReadLock.unlock();
        }
        return maxResource;
    }

    @Override
    public Resource getMaximumResourceCapability(String queueName) {
        return this.getMaximumResourceCapability();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initMaximumResourceCapability(Resource maximumAllocation) {
        this.maxAllocWriteLock.lock();
        try {
            if (this.configuredMaximumAllocation == null) {
                this.configuredMaximumAllocation = Resources.clone((Resource)maximumAllocation);
                this.maximumAllocation = Resources.clone((Resource)maximumAllocation);
            }
        }
        finally {
            this.maxAllocWriteLock.unlock();
        }
    }

    protected synchronized void containerLaunchedOnNode(ContainerId containerId, SchedulerNode node) {
        T application = this.getCurrentAttemptForContainer(containerId);
        if (application == null) {
            LOG.info((Object)("Unknown application " + containerId.getApplicationAttemptId().getApplicationId() + " launched container " + containerId + " on node: " + node));
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeCleanContainerEvent(node.getNodeID(), containerId));
            return;
        }
        ((SchedulerApplicationAttempt)application).containerLaunchedOnNode(containerId, node.getNodeID());
        node.containerStarted(containerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void containerIncreasedOnNode(ContainerId containerId, SchedulerNode node, Container increasedContainerReportedByNM) {
        LeafQueue leafQueue;
        T application = this.getCurrentAttemptForContainer(containerId);
        if (application == null) {
            LOG.info((Object)("Unknown application " + containerId.getApplicationAttemptId().getApplicationId() + " increased container " + containerId + " on node: " + node));
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeCleanContainerEvent(node.getNodeID(), containerId));
            return;
        }
        LeafQueue leafQueue2 = leafQueue = (LeafQueue)((SchedulerApplicationAttempt)application).getQueue();
        synchronized (leafQueue2) {
            RMContainer rmContainer = this.getRMContainer(containerId);
            if (rmContainer == null) {
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeCleanContainerEvent(node.getNodeID(), containerId));
                return;
            }
            rmContainer.handle((Event)new RMContainerNMDoneChangeResourceEvent(containerId, increasedContainerReportedByNM.getResource()));
        }
    }

    public T getApplicationAttempt(ApplicationAttemptId applicationAttemptId) {
        SchedulerApplication app = (SchedulerApplication)this.applications.get(applicationAttemptId.getApplicationId());
        return app == null ? null : (T)app.getCurrentAppAttempt();
    }

    @Override
    public SchedulerAppReport getSchedulerAppInfo(ApplicationAttemptId appAttemptId) {
        T attempt = this.getApplicationAttempt(appAttemptId);
        if (attempt == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request for appInfo of unknown attempt " + appAttemptId));
            }
            return null;
        }
        return new SchedulerAppReport((SchedulerApplicationAttempt)attempt);
    }

    @Override
    public ApplicationResourceUsageReport getAppResourceUsageReport(ApplicationAttemptId appAttemptId) {
        T attempt = this.getApplicationAttempt(appAttemptId);
        if (attempt == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request for appInfo of unknown attempt " + appAttemptId));
            }
            return null;
        }
        return ((SchedulerApplicationAttempt)attempt).getResourceUsageReport();
    }

    public T getCurrentAttemptForContainer(ContainerId containerId) {
        return this.getApplicationAttempt(containerId.getApplicationAttemptId());
    }

    @Override
    public RMContainer getRMContainer(ContainerId containerId) {
        T attempt = this.getCurrentAttemptForContainer(containerId);
        return attempt == null ? null : ((SchedulerApplicationAttempt)attempt).getRMContainer(containerId);
    }

    @Override
    public SchedulerNodeReport getNodeReport(NodeId nodeId) {
        SchedulerNode node = (SchedulerNode)this.nodes.get(nodeId);
        return node == null ? null : new SchedulerNodeReport(node);
    }

    @Override
    public String moveApplication(ApplicationId appId, String newQueue) throws YarnException {
        throw new YarnException(this.getClass().getSimpleName() + " does not support moving apps between queues");
    }

    @Override
    public void removeQueue(String queueName) throws YarnException {
        throw new YarnException(this.getClass().getSimpleName() + " does not support removing queues");
    }

    @Override
    public void addQueue(Queue newQueue) throws YarnException {
        throw new YarnException(this.getClass().getSimpleName() + " does not support this operation");
    }

    @Override
    public void setEntitlement(String queue, QueueEntitlement entitlement) throws YarnException {
        throw new YarnException(this.getClass().getSimpleName() + " does not support this operation");
    }

    private void killOrphanContainerOnNode(RMNode node, NMContainerStatus container) {
        if (!container.getContainerState().equals((Object)ContainerState.COMPLETE)) {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeCleanContainerEvent(node.getNodeID(), container.getContainerId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void recoverContainersOnNode(List<NMContainerStatus> containerReports, RMNode nm) {
        if (!this.rmContext.isWorkPreservingRecoveryEnabled() || containerReports == null || containerReports != null && containerReports.isEmpty()) {
            return;
        }
        for (NMContainerStatus container : containerReports) {
            Container masterContainer;
            ApplicationId appId = container.getContainerId().getApplicationAttemptId().getApplicationId();
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(appId);
            if (rmApp == null) {
                LOG.error((Object)("Skip recovering container " + container + " for unknown application."));
                this.killOrphanContainerOnNode(nm, container);
                continue;
            }
            SchedulerApplication schedulerApp = (SchedulerApplication)this.applications.get(appId);
            if (schedulerApp == null) {
                LOG.info((Object)("Skip recovering container  " + container + " for unknown SchedulerApplication. Application current state is " + (Object)((Object)rmApp.getState())));
                this.killOrphanContainerOnNode(nm, container);
                continue;
            }
            LOG.info((Object)("Recovering container " + container));
            Object schedulerAttempt = schedulerApp.getCurrentAppAttempt();
            if (!(rmApp.getApplicationSubmissionContext().getKeepContainersAcrossApplicationAttempts() || !((SchedulerApplicationAttempt)schedulerAttempt).isStopped() && ((SchedulerApplicationAttempt)schedulerAttempt).getApplicationAttemptId().equals((Object)container.getContainerId().getApplicationAttemptId()))) {
                LOG.info((Object)("Skip recovering container " + container + " for already stopped attempt."));
                this.killOrphanContainerOnNode(nm, container);
                continue;
            }
            RMContainer rmContainer = this.recoverAndCreateContainer(container, nm);
            rmContainer.handle((Event)new RMContainerRecoverEvent(container.getContainerId(), container));
            SchedulerNode schedulerNode = (SchedulerNode)this.nodes.get(nm.getNodeID());
            schedulerNode.recoverContainer(rmContainer);
            Queue queue = ((SchedulerApplicationAttempt)schedulerAttempt).getQueue();
            queue.recoverContainer(this.clusterResource, (SchedulerApplicationAttempt)schedulerAttempt, rmContainer);
            ((SchedulerApplicationAttempt)schedulerAttempt).recoverContainer(schedulerNode, rmContainer);
            RMAppAttempt appAttempt = rmApp.getCurrentAppAttempt();
            if (appAttempt != null && (masterContainer = appAttempt.getMasterContainer()) != null && masterContainer.getId().equals((Object)rmContainer.getContainerId())) {
                ((RMContainerImpl)rmContainer).setAMContainer(true);
            }
            Object t = schedulerAttempt;
            synchronized (t) {
                Set<ContainerId> releases = ((SchedulerApplicationAttempt)schedulerAttempt).getPendingRelease();
                if (releases.contains(container.getContainerId())) {
                    rmContainer.handle((Event)new RMContainerFinishedEvent(container.getContainerId(), SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container released by application"), RMContainerEventType.RELEASED));
                    releases.remove(container.getContainerId());
                    LOG.info((Object)(container.getContainerId() + " is released by application."));
                }
            }
        }
    }

    private RMContainer recoverAndCreateContainer(NMContainerStatus status, RMNode node) {
        Container container = Container.newInstance((ContainerId)status.getContainerId(), (NodeId)node.getNodeID(), (String)node.getHttpAddress(), (Resource)status.getAllocatedResource(), (Priority)status.getPriority(), null);
        container.setVersion(status.getVersion());
        ApplicationAttemptId attemptId = container.getId().getApplicationAttemptId();
        RMContainerImpl rmContainer = new RMContainerImpl(container, attemptId, node.getNodeID(), ((SchedulerApplication)this.applications.get(attemptId.getApplicationId())).getUser(), this.rmContext, status.getCreationTime(), status.getNodeLabelExpression());
        return rmContainer;
    }

    private void recoverResourceRequestForContainer(RMContainer rmContainer) {
        List<ResourceRequest> requests = rmContainer.getResourceRequests();
        if (requests == null) {
            return;
        }
        T schedulerAttempt = this.getCurrentAttemptForContainer(rmContainer.getContainerId());
        if (schedulerAttempt != null) {
            ((SchedulerApplicationAttempt)schedulerAttempt).recoverResourceRequestsForContainer(requests);
        }
    }

    protected void createReleaseCache() {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                AbstractYarnScheduler.this.clearPendingContainerCache();
                LOG.info((Object)"Release request cache is cleaned up");
            }
        }, this.nmExpireInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void clearPendingContainerCache() {
        for (SchedulerApplication app : this.applications.values()) {
            Object attempt = app.getCurrentAppAttempt();
            if (attempt == null) continue;
            Object t = attempt;
            synchronized (t) {
                for (ContainerId containerId : ((SchedulerApplicationAttempt)attempt).getPendingRelease()) {
                    RMAuditLogger.logFailure(app.getUser(), "AM Released Container", "Unauthorized access or invalid container", "Scheduler", "Trying to release container not owned by app or with invalid id.", ((SchedulerApplicationAttempt)attempt).getApplicationId(), containerId);
                }
                ((SchedulerApplicationAttempt)attempt).getPendingRelease().clear();
            }
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void completedContainer(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        if (rmContainer == null) {
            LOG.info((Object)("Container " + containerStatus.getContainerId() + " completed with event " + (Object)((Object)event) + ", but corresponding RMContainer doesn't exist."));
            return;
        }
        this.completedContainerInternal(rmContainer, containerStatus, event);
        this.recoverResourceRequestForContainer(rmContainer);
    }

    protected abstract void completedContainerInternal(RMContainer var1, ContainerStatus var2, RMContainerEventType var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseContainers(List<ContainerId> containers, SchedulerApplicationAttempt attempt) {
        for (ContainerId containerId : containers) {
            RMContainer rmContainer = this.getRMContainer(containerId);
            if (rmContainer == null) {
                if (System.currentTimeMillis() - ResourceManager.getClusterTimeStamp() < (long)this.nmExpireInterval) {
                    LOG.info((Object)(containerId + " doesn't exist. Add the container" + " to the release request cache as it maybe on recovery."));
                    SchedulerApplicationAttempt schedulerApplicationAttempt = attempt;
                    synchronized (schedulerApplicationAttempt) {
                        attempt.getPendingRelease().add(containerId);
                    }
                } else {
                    RMAuditLogger.logFailure(attempt.getUser(), "AM Released Container", "Unauthorized access or invalid container", "Scheduler", "Trying to release container not owned by app or with invalid id.", attempt.getApplicationId(), containerId);
                }
            }
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(containerId, "Container released by application"), RMContainerEventType.RELEASED);
        }
    }

    protected void decreaseContainers(List<UpdateContainerRequest> decreaseRequests, SchedulerApplicationAttempt attempt) {
        if (null == decreaseRequests || decreaseRequests.isEmpty()) {
            return;
        }
        List<SchedContainerChangeRequest> schedDecreaseRequests = this.createSchedContainerChangeRequests(decreaseRequests, false);
        for (SchedContainerChangeRequest request : schedDecreaseRequests) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Processing decrease request:" + request));
            }
            this.decreaseContainer(request, attempt);
        }
    }

    protected abstract void decreaseContainer(SchedContainerChangeRequest var1, SchedulerApplicationAttempt var2);

    @Override
    public SchedulerNode getSchedulerNode(NodeId nodeId) {
        return (SchedulerNode)this.nodes.get(nodeId);
    }

    @Override
    public synchronized void moveAllApps(String sourceQueue, String destQueue) throws YarnException {
        try {
            this.getQueueInfo(destQueue, false, false);
        }
        catch (IOException e) {
            LOG.warn((Object)e);
            throw new YarnException((Throwable)e);
        }
        List apps = this.getAppsInQueue(sourceQueue);
        if (apps == null) {
            String errMsg = "The specified Queue: " + sourceQueue + " doesn't exist";
            LOG.warn((Object)errMsg);
            throw new YarnException(errMsg);
        }
        for (ApplicationAttemptId app : apps) {
            SettableFuture future = SettableFuture.create();
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppMoveEvent(app.getApplicationId(), destQueue, (SettableFuture<Object>)future));
        }
    }

    @Override
    public synchronized void killAllAppsInQueue(String queueName) throws YarnException {
        List apps = this.getAppsInQueue(queueName);
        if (apps == null) {
            String errMsg = "The specified Queue: " + queueName + " doesn't exist";
            LOG.warn((Object)errMsg);
            throw new YarnException(errMsg);
        }
        for (ApplicationAttemptId app : apps) {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(app.getApplicationId(), RMAppEventType.KILL, "Application killed due to expiry of reservation queue " + queueName + "."));
        }
    }

    public synchronized void updateNodeResource(RMNode nm, ResourceOption resourceOption) {
        SchedulerNode node = this.getSchedulerNode(nm.getNodeID());
        Resource newResource = resourceOption.getResource();
        Resource oldResource = node.getTotalResource();
        if (!oldResource.equals((Object)newResource)) {
            this.rmContext.getNodeLabelManager().updateNodeResource(nm.getNodeID(), newResource);
            LOG.info((Object)("Update resource on node: " + node.getNodeName() + " from: " + oldResource + ", to: " + newResource));
            this.nodes.remove(nm.getNodeID());
            this.updateMaximumAllocation(node, false);
            node.updateTotalResource(newResource);
            this.nodes.put(nm.getNodeID(), node);
            this.updateMaximumAllocation(node, true);
            Resources.subtractFrom((Resource)this.clusterResource, (Resource)oldResource);
            Resources.addTo((Resource)this.clusterResource, (Resource)newResource);
        } else {
            LOG.warn((Object)("Update resource on node: " + node.getNodeName() + " with the same resource: " + newResource));
        }
    }

    @Override
    public EnumSet<YarnServiceProtos.SchedulerResourceTypes> getSchedulingResourceTypes() {
        return EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY);
    }

    @Override
    public Set<String> getPlanQueues() throws YarnException {
        throw new YarnException(this.getClass().getSimpleName() + " does not support reservations");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateMaximumAllocation(SchedulerNode node, boolean add) {
        Resource totalResource = node.getTotalResource();
        this.maxAllocWriteLock.lock();
        try {
            if (add) {
                int nodeVCores;
                int nodeMemory = (int)totalResource.getMemorySize();
                if (nodeMemory > this.maxNodeMemory) {
                    this.maxNodeMemory = nodeMemory;
                    this.maximumAllocation.setMemorySize(Math.min(this.configuredMaximumAllocation.getMemorySize(), (long)this.maxNodeMemory));
                }
                if ((nodeVCores = totalResource.getVirtualCores()) > this.maxNodeVCores) {
                    this.maxNodeVCores = nodeVCores;
                    this.maximumAllocation.setVirtualCores(Math.min(this.configuredMaximumAllocation.getVirtualCores(), this.maxNodeVCores));
                }
            } else {
                if ((long)this.maxNodeMemory == totalResource.getMemorySize()) {
                    this.maxNodeMemory = -1;
                }
                if (this.maxNodeVCores == totalResource.getVirtualCores()) {
                    this.maxNodeVCores = -1;
                }
                if (this.maxNodeMemory == -1 || this.maxNodeVCores == -1) {
                    for (Map.Entry<NodeId, N> nodeEntry : this.nodes.entrySet()) {
                        int nodeVCores;
                        int nodeMemory = (int)((SchedulerNode)nodeEntry.getValue()).getTotalResource().getMemorySize();
                        if (nodeMemory > this.maxNodeMemory) {
                            this.maxNodeMemory = nodeMemory;
                        }
                        if ((nodeVCores = ((SchedulerNode)nodeEntry.getValue()).getTotalResource().getVirtualCores()) <= this.maxNodeVCores) continue;
                        this.maxNodeVCores = nodeVCores;
                    }
                    if (this.maxNodeMemory == -1) {
                        this.maximumAllocation.setMemorySize(this.configuredMaximumAllocation.getMemorySize());
                    } else {
                        this.maximumAllocation.setMemorySize(Math.min(this.configuredMaximumAllocation.getMemorySize(), (long)this.maxNodeMemory));
                    }
                    if (this.maxNodeVCores == -1) {
                        this.maximumAllocation.setVirtualCores(this.configuredMaximumAllocation.getVirtualCores());
                    } else {
                        this.maximumAllocation.setVirtualCores(Math.min(this.configuredMaximumAllocation.getVirtualCores(), this.maxNodeVCores));
                    }
                }
            }
        }
        finally {
            this.maxAllocWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshMaximumAllocation(Resource newMaxAlloc) {
        this.maxAllocWriteLock.lock();
        try {
            this.configuredMaximumAllocation = Resources.clone((Resource)newMaxAlloc);
            long maxMemory = newMaxAlloc.getMemorySize();
            if (this.maxNodeMemory != -1) {
                maxMemory = Math.min(maxMemory, (long)this.maxNodeMemory);
            }
            int maxVcores = newMaxAlloc.getVirtualCores();
            if (this.maxNodeVCores != -1) {
                maxVcores = Math.min(maxVcores, this.maxNodeVCores);
            }
            this.maximumAllocation = Resources.createResource((long)maxMemory, (int)maxVcores);
        }
        finally {
            this.maxAllocWriteLock.unlock();
        }
    }

    @Override
    public List<ResourceRequest> getPendingResourceRequestsForAttempt(ApplicationAttemptId attemptId) {
        T attempt = this.getApplicationAttempt(attemptId);
        if (attempt != null) {
            return ((SchedulerApplicationAttempt)attempt).getAppSchedulingInfo().getAllResourceRequests();
        }
        return null;
    }

    @Override
    public Priority checkAndGetApplicationPriority(Priority priorityFromContext, String user, String queueName, ApplicationId applicationId) throws YarnException {
        return Priority.newInstance((int)0);
    }

    @Override
    public void updateApplicationPriority(Priority newPriority, ApplicationId applicationId) throws YarnException {
    }

    @Override
    public Priority getMaxClusterLevelAppPriority() {
        return this.maxClusterLevelAppPriority;
    }

    private Priority getMaxPriorityFromConf(Configuration conf) {
        return Priority.newInstance((int)conf.getInt("yarn.cluster.max-application-priority", 0));
    }

    @Override
    public synchronized void setClusterMaxPriority(Configuration conf) throws YarnException {
        try {
            this.maxClusterLevelAppPriority = this.getMaxPriorityFromConf(conf);
        }
        catch (NumberFormatException e) {
            throw new YarnException((Throwable)e);
        }
        LOG.info((Object)("Updated the cluste max priority to maxClusterLevelAppPriority = " + this.maxClusterLevelAppPriority));
    }

    private SchedContainerChangeRequest createSchedContainerChangeRequest(UpdateContainerRequest request, boolean increase) throws YarnException {
        ContainerId containerId = request.getContainerId();
        RMContainer rmContainer = this.getRMContainer(containerId);
        if (null == rmContainer) {
            String msg = "Failed to get rmContainer for " + (increase ? "increase" : "decrease") + " request, with container-id=" + containerId;
            throw new InvalidResourceRequestException(msg);
        }
        SchedulerNode schedulerNode = this.getSchedulerNode(rmContainer.getAllocatedNode());
        return new SchedContainerChangeRequest(this.rmContext, schedulerNode, rmContainer, request.getCapability());
    }

    protected List<SchedContainerChangeRequest> createSchedContainerChangeRequests(List<UpdateContainerRequest> changeRequests, boolean increase) {
        ArrayList<SchedContainerChangeRequest> schedulerChangeRequests = new ArrayList<SchedContainerChangeRequest>();
        for (UpdateContainerRequest r : changeRequests) {
            SchedContainerChangeRequest sr = null;
            try {
                sr = this.createSchedContainerChangeRequest(r, increase);
            }
            catch (YarnException e) {
                LOG.warn((Object)"Error happens when checking increase request, Ignoring.. exception=", (Throwable)e);
                continue;
            }
            schedulerChangeRequests.add(sr);
        }
        return schedulerChangeRequests;
    }
}

