/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.ams.ApplicationMasterServiceContext;
import org.apache.hadoop.yarn.ams.ApplicationMasterServiceProcessor;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;

class AMSProcessingChain
implements ApplicationMasterServiceProcessor {
    private static final Log LOG = LogFactory.getLog(AMSProcessingChain.class);
    private ApplicationMasterServiceProcessor head;
    private RMContext rmContext;

    AMSProcessingChain(ApplicationMasterServiceProcessor rootProcessor) {
        if (rootProcessor == null) {
            throw new YarnRuntimeException("No root ApplicationMasterServiceProcessor specified for the processing chain..");
        }
        this.head = rootProcessor;
    }

    public void init(ApplicationMasterServiceContext amsContext, ApplicationMasterServiceProcessor nextProcessor) {
        LOG.info((Object)("Initializing AMS Processing chain. Root Processor=[" + this.head.getClass().getName() + "]."));
        this.rmContext = (RMContext)amsContext;
        this.head.init(amsContext, null);
    }

    public synchronized void addProcessor(ApplicationMasterServiceProcessor processor) {
        LOG.info((Object)("Adding [" + processor.getClass().getName() + "] tp top of" + " AMS Processing chain. "));
        processor.init((ApplicationMasterServiceContext)this.rmContext, this.head);
        this.head = processor;
    }

    public void registerApplicationMaster(ApplicationAttemptId applicationAttemptId, RegisterApplicationMasterRequest request, RegisterApplicationMasterResponse resp) throws IOException {
        this.head.registerApplicationMaster(applicationAttemptId, request, resp);
    }

    public void allocate(ApplicationAttemptId appAttemptId, AllocateRequest request, AllocateResponse response) throws YarnException {
        this.head.allocate(appAttemptId, request, response);
    }

    public void finishApplicationMaster(ApplicationAttemptId applicationAttemptId, FinishApplicationMasterRequest request, FinishApplicationMasterResponse response) {
        this.head.finishApplicationMaster(applicationAttemptId, request, response);
    }
}

