/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerReservedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedContainerChangeRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityHeadroomProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.AbstractContainerAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.ContainerAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ContainerAllocationProposal;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.PendingAsk;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ResourceCommitRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.SchedulerContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.PlacementSet;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.SchedulingPlacementSet;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FiCaSchedulerApp
extends SchedulerApplicationAttempt {
    private static final Log LOG = LogFactory.getLog(FiCaSchedulerApp.class);
    private final Set<ContainerId> containersToPreempt = new HashSet<ContainerId>();
    private CapacityHeadroomProvider headroomProvider;
    private ResourceCalculator rc = new DefaultResourceCalculator();
    private ResourceScheduler scheduler;
    private AbstractContainerAllocator containerAllocator;
    private String appSkipNodeDiagnostics;
    private Map<ContainerId, SchedContainerChangeRequest> toBeRemovedIncRequests = new ConcurrentHashMap<ContainerId, SchedContainerChangeRequest>();

    public FiCaSchedulerApp(ApplicationAttemptId applicationAttemptId, String user, Queue queue, AbstractUsersManager abstractUsersManager, RMContext rmContext) {
        this(applicationAttemptId, user, queue, abstractUsersManager, rmContext, Priority.newInstance((int)0), false);
    }

    public FiCaSchedulerApp(ApplicationAttemptId applicationAttemptId, String user, Queue queue, AbstractUsersManager abstractUsersManager, RMContext rmContext, Priority appPriority, boolean isAttemptRecovering) {
        this(applicationAttemptId, user, queue, abstractUsersManager, rmContext, appPriority, isAttemptRecovering, null);
    }

    public FiCaSchedulerApp(ApplicationAttemptId applicationAttemptId, String user, Queue queue, AbstractUsersManager abstractUsersManager, RMContext rmContext, Priority appPriority, boolean isAttemptRecovering, ActivitiesManager activitiesManager) {
        super(applicationAttemptId, user, queue, abstractUsersManager, rmContext);
        String partition;
        Resource amResource;
        RMApp rmApp = (RMApp)rmContext.getRMApps().get(this.getApplicationId());
        if (rmApp == null || rmApp.getAMResourceRequests() == null || rmApp.getAMResourceRequests().isEmpty()) {
            amResource = rmContext.getScheduler().getMinimumResourceCapability();
            partition = "";
        } else {
            amResource = rmApp.getAMResourceRequests().get(0).getCapability();
            partition = rmApp.getAMResourceRequests().get(0).getNodeLabelExpression() == null ? "" : rmApp.getAMResourceRequests().get(0).getNodeLabelExpression();
        }
        this.setAppAMNodePartitionName(partition);
        this.setAMResource(partition, amResource);
        this.setPriority(appPriority);
        this.setAttemptRecovering(isAttemptRecovering);
        this.scheduler = rmContext.getScheduler();
        if (this.scheduler.getResourceCalculator() != null) {
            this.rc = this.scheduler.getResourceCalculator();
        }
        this.containerAllocator = new ContainerAllocator(this, this.rc, rmContext, activitiesManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containerCompleted(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event, String partition) {
        try {
            this.writeLock.lock();
            ContainerId containerId = rmContainer.getContainerId();
            if (null == this.liveContainers.remove(containerId)) {
                boolean bl = false;
                return bl;
            }
            this.newlyAllocatedContainers.remove(rmContainer);
            rmContainer.handle((Event)new RMContainerFinishedEvent(containerId, containerStatus, event));
            this.containersToPreempt.remove(containerId);
            Resource containerResource = rmContainer.getContainer().getResource();
            RMAuditLogger.logSuccess(this.getUser(), "AM Released Container", "SchedulerApp", this.getApplicationId(), containerId, containerResource);
            this.queue.getMetrics().releaseResources(partition, this.getUser(), 1, containerResource);
            this.attemptResourceUsage.decUsed(partition, containerResource);
            this.lastMemoryAggregateAllocationUpdateTime = -1L;
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMContainer allocate(FiCaSchedulerNode node, SchedulerRequestKey schedulerKey, Container container) {
        try {
            this.readLock.lock();
            if (this.isStopped) {
                RMContainer rMContainer = null;
                return rMContainer;
            }
            if (this.getOutstandingAsksCount(schedulerKey) <= 0) {
                RMContainer rMContainer = null;
                return rMContainer;
            }
            SchedulingPlacementSet ps = this.appSchedulingInfo.getSchedulingPlacementSet(schedulerKey);
            if (null == ps) {
                LOG.warn((Object)("Failed to get " + SchedulingPlacementSet.class.getName() + " for application=" + this.getApplicationId() + " schedulerRequestKey=" + schedulerKey));
                RMContainer rMContainer = null;
                return rMContainer;
            }
            RMContainerImpl rmContainer = new RMContainerImpl(container, schedulerKey, this.getApplicationAttemptId(), node.getNodeID(), this.appSchedulingInfo.getUser(), this.rmContext, ps.getPrimaryRequestedNodePartition());
            rmContainer.setQueueName(this.getQueueName());
            this.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.ASSIGNED, null);
            RMContainerImpl rMContainerImpl = rmContainer;
            return rMContainerImpl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean rmContainerInFinalState(RMContainer rmContainer) {
        if (null == rmContainer) {
            return false;
        }
        return rmContainer.completed();
    }

    private boolean anyContainerInFinalState(ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> request) {
        for (SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer : request.getContainersToRelease()) {
            if (!this.rmContainerInFinalState(schedulerContainer.getRmContainer())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("To-release container=" + schedulerContainer.getRmContainer() + " is in final state"));
            }
            return true;
        }
        for (ContainerAllocationProposal containerAllocationProposal : request.getContainersToAllocate()) {
            for (SchedulerContainer r : containerAllocationProposal.getToRelease()) {
                if (!this.rmContainerInFinalState(r.getRmContainer())) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("To-release container=" + r.getRmContainer() + ", for to a new allocated container, is in final state"));
                }
                return true;
            }
            if (null == containerAllocationProposal.getAllocateFromReservedContainer() || !this.rmContainerInFinalState(containerAllocationProposal.getAllocateFromReservedContainer().getRmContainer())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Allocate from reserved container" + containerAllocationProposal.getAllocateFromReservedContainer().getRmContainer() + " is in final state"));
            }
            return true;
        }
        for (ContainerAllocationProposal containerAllocationProposal : request.getContainersToReserve()) {
            for (SchedulerContainer r : containerAllocationProposal.getToRelease()) {
                if (!this.rmContainerInFinalState(r.getRmContainer())) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("To-release container=" + r.getRmContainer() + ", for a reserved container, is in final state"));
                }
                return true;
            }
        }
        return false;
    }

    private boolean commonCheckContainerAllocation(Resource cluster, ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode> allocation, SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer) {
        RMContainer fromReservedContainer;
        RMContainer reservedContainerOnNode = schedulerContainer.getSchedulerNode().getReservedContainer();
        if (reservedContainerOnNode != null && (fromReservedContainer = allocation.getAllocateFromReservedContainer().getRmContainer()) != reservedContainerOnNode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Try to allocate from a non-existed reserved container");
            }
            return false;
        }
        Resource availableResource = Resources.clone((Resource)schedulerContainer.getSchedulerNode().getUnallocatedResource());
        if (allocation.getToRelease() != null && !allocation.getToRelease().isEmpty()) {
            for (SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> releaseContainer : allocation.getToRelease()) {
                if (releaseContainer.getRmContainer().getState() == RMContainerState.RESERVED || releaseContainer.getSchedulerNode() != schedulerContainer.getSchedulerNode()) continue;
                Resources.addTo((Resource)availableResource, (Resource)releaseContainer.getRmContainer().getAllocatedResource());
            }
        }
        if (!Resources.fitsIn((ResourceCalculator)this.rc, (Resource)cluster, (Resource)allocation.getAllocatedOrReservedResource(), (Resource)availableResource)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Node doesn't have enough available resource, asked=" + allocation.getAllocatedOrReservedResource() + " available=" + availableResource));
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(Resource cluster, ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> request) {
        List<ResourceRequest> resourceRequests = null;
        boolean reReservation = false;
        try {
            this.readLock.lock();
            if (this.anyContainerInFinalState(request)) {
                boolean bl = false;
                return bl;
            }
            if (request.anythingAllocatedOrReserved()) {
                ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode> allocation = request.getFirstAllocatedOrReservedContainer();
                SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer = allocation.getAllocatedOrReservedContainer();
                if (schedulerContainer.isAllocated()) {
                    resourceRequests = schedulerContainer.getRmContainer().getResourceRequests();
                    if (!this.appSchedulingInfo.checkAllocation(allocation.getAllocationLocalityType(), schedulerContainer.getSchedulerNode(), schedulerContainer.getSchedulerRequestKey())) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("No pending resource for: nodeType=" + (Object)((Object)allocation.getAllocationLocalityType()) + ", node=" + schedulerContainer.getSchedulerNode() + ", requestKey=" + schedulerContainer.getSchedulerRequestKey() + ", application=" + this.getApplicationAttemptId()));
                        }
                        boolean bl = false;
                        return bl;
                    }
                    this.commonCheckContainerAllocation(cluster, allocation, schedulerContainer);
                } else if (schedulerContainer.getRmContainer().getState() == RMContainerState.RESERVED) {
                    if (schedulerContainer.getRmContainer() != schedulerContainer.getSchedulerNode().getReservedContainer()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Try to re-reserve a container, but node " + schedulerContainer.getSchedulerNode() + " is already reserved by another container" + schedulerContainer.getSchedulerNode().getReservedContainer().getContainerId()));
                        }
                        boolean bl = false;
                        return bl;
                    }
                    reReservation = true;
                } else if (schedulerContainer.getSchedulerNode().getReservedContainer() != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Try to reserve a container, but the node is already reserved by another container=" + schedulerContainer.getSchedulerNode().getReservedContainer().getContainerId()));
                    }
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
        boolean accepted = true;
        if (!reReservation && request.anythingAllocatedOrReserved()) {
            accepted = this.getCSLeafQueue().accept(cluster, request);
        }
        if (!accepted && resourceRequests != null) {
            this.recoverResourceRequestsForContainer(resourceRequests);
        }
        return accepted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(Resource cluster, ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> request) {
        boolean reReservation = false;
        try {
            this.writeLock.lock();
            if (request.anythingAllocatedOrReserved()) {
                ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode> allocation = request.getFirstAllocatedOrReservedContainer();
                SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer = allocation.getAllocatedOrReservedContainer();
                RMContainer rmContainer = schedulerContainer.getRmContainer();
                boolean bl = reReservation = !schedulerContainer.isAllocated() && rmContainer.getState() == RMContainerState.RESERVED;
                if (rmContainer.getContainer().getId() == null) {
                    rmContainer.setContainerId(BuilderUtils.newContainerId((ApplicationAttemptId)this.getApplicationAttemptId(), (long)this.getNewContainerId()));
                }
                ContainerId containerId = rmContainer.getContainerId();
                if (schedulerContainer.isAllocated()) {
                    if (allocation.getAllocateFromReservedContainer() != null) {
                        RMContainer reservedContainer = allocation.getAllocateFromReservedContainer().getRmContainer();
                        this.unreserve(schedulerContainer.getSchedulerRequestKey(), schedulerContainer.getSchedulerNode(), reservedContainer);
                    }
                    this.addToNewlyAllocatedContainers(schedulerContainer.getSchedulerNode(), rmContainer);
                    this.liveContainers.put(containerId, rmContainer);
                    List<ResourceRequest> requests = this.appSchedulingInfo.allocate(allocation.getAllocationLocalityType(), schedulerContainer.getSchedulerNode(), schedulerContainer.getSchedulerRequestKey(), schedulerContainer.getRmContainer().getContainer());
                    ((RMContainerImpl)rmContainer).setResourceRequests(requests);
                    this.attemptResourceUsage.incUsed(schedulerContainer.getNodePartition(), allocation.getAllocatedOrReservedResource());
                    rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.START));
                    schedulerContainer.getSchedulerNode().allocateContainer(rmContainer);
                    this.incNumAllocatedContainers(allocation.getAllocationLocalityType(), allocation.getRequestLocalityType());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("allocate: applicationAttemptId=" + containerId.getApplicationAttemptId() + " container=" + containerId + " host=" + rmContainer.getAllocatedNode().getHost() + " type=" + (Object)((Object)allocation.getAllocationLocalityType())));
                    }
                    RMAuditLogger.logSuccess(this.getUser(), "AM Allocated Container", "SchedulerApp", this.getApplicationId(), containerId, allocation.getAllocatedOrReservedResource());
                } else {
                    this.reserve(schedulerContainer.getSchedulerRequestKey(), schedulerContainer.getSchedulerNode(), schedulerContainer.getRmContainer(), schedulerContainer.getRmContainer().getContainer(), reReservation);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (!reReservation) {
            this.getCSLeafQueue().apply(cluster, request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unreserve(SchedulerRequestKey schedulerKey, FiCaSchedulerNode node, RMContainer rmContainer) {
        try {
            this.writeLock.lock();
            if (this.internalUnreserve(node, schedulerKey)) {
                node.unreserveResource(this);
                this.queue.getMetrics().unreserveResource(node.getPartition(), this.getUser(), rmContainer.getReservedResource());
                this.queue.decReservedResource(node.getPartition(), rmContainer.getReservedResource());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean internalUnreserve(FiCaSchedulerNode node, SchedulerRequestKey schedulerKey) {
        RMContainer reservedContainer;
        Map reservedContainers = (Map)this.reservedContainers.get(schedulerKey);
        if (reservedContainers != null && (reservedContainer = (RMContainer)reservedContainers.remove(node.getNodeID())) != null && reservedContainer.getContainer() != null && reservedContainer.getContainer().getResource() != null) {
            if (reservedContainers.isEmpty()) {
                this.reservedContainers.remove(schedulerKey);
            }
            this.resetReReservations(schedulerKey);
            Resource resource = reservedContainer.getReservedResource();
            this.attemptResourceUsage.decReserved(node.getPartition(), resource);
            LOG.info((Object)("Application " + this.getApplicationId() + " unreserved " + " on node " + node + ", currently has " + reservedContainers.size() + " at priority " + schedulerKey.getPriority() + "; currentReservation " + this.attemptResourceUsage.getReserved() + " on node-label=" + node.getPartition()));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Resource> getTotalPendingRequestsPerPartition() {
        try {
            this.readLock.lock();
            HashMap<String, Resource> ret = new HashMap<String, Resource>();
            for (SchedulerRequestKey schedulerKey : this.appSchedulingInfo.getSchedulerKeys()) {
                PendingAsk ask;
                SchedulingPlacementSet ps = this.appSchedulingInfo.getSchedulingPlacementSet(schedulerKey);
                String nodePartition = ps.getPrimaryRequestedNodePartition();
                Resource res = (Resource)ret.get(nodePartition);
                if (null == res) {
                    res = Resources.createResource((int)0);
                    ret.put(nodePartition, res);
                }
                if ((ask = ps.getPendingAsk("*")).getCount() <= 0) continue;
                Resources.addTo((Resource)res, (Resource)Resources.multiply((Resource)ask.getPerAllocationResource(), (double)ask.getCount()));
            }
            HashMap<String, Resource> hashMap = ret;
            return hashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markContainerForPreemption(ContainerId cont) {
        try {
            this.writeLock.lock();
            if (this.liveContainers.containsKey(cont)) {
                this.containersToPreempt.add(cont);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Allocation getAllocation(ResourceCalculator resourceCalculator, Resource clusterResource, Resource minimumAllocation) {
        try {
            this.writeLock.lock();
            Set<ContainerId> currentContPreemption = Collections.unmodifiableSet(new HashSet<ContainerId>(this.containersToPreempt));
            this.containersToPreempt.clear();
            Resource tot = Resource.newInstance((int)0, (int)0);
            for (ContainerId c : currentContPreemption) {
                Resources.addTo((Resource)tot, (Resource)((RMContainer)this.liveContainers.get(c)).getContainer().getResource());
            }
            int numCont = (int)Math.ceil(Resources.divide((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)tot, (Resource)minimumAllocation));
            ResourceRequest rr = ResourceRequest.newBuilder().priority(Priority.UNDEFINED).resourceName("*").capability(minimumAllocation).numContainers(numCont).build();
            List<Container> newlyAllocatedContainers = this.pullNewlyAllocatedContainers();
            List<Container> newlyIncreasedContainers = this.pullNewlyIncreasedContainers();
            List<Container> newlyDecreasedContainers = this.pullNewlyDecreasedContainers();
            List<Container> newlyPromotedContainers = this.pullNewlyPromotedContainers();
            List<Container> newlyDemotedContainers = this.pullNewlyDemotedContainers();
            List<NMToken> updatedNMTokens = this.pullUpdatedNMTokens();
            Resource headroom = this.getHeadroom();
            this.setApplicationHeadroomForMetrics(headroom);
            Allocation allocation = new Allocation(newlyAllocatedContainers, headroom, null, currentContPreemption, Collections.singletonList(rr), updatedNMTokens, newlyIncreasedContainers, newlyDecreasedContainers, newlyPromotedContainers, newlyDemotedContainers);
            return allocation;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @VisibleForTesting
    public NodeId getNodeIdToUnreserve(SchedulerRequestKey schedulerKey, Resource resourceNeedUnreserve, ResourceCalculator rc, Resource clusterResource) {
        Map reservedContainers = (Map)this.reservedContainers.get(schedulerKey);
        if (reservedContainers != null && !reservedContainers.isEmpty()) {
            for (Map.Entry entry : reservedContainers.entrySet()) {
                NodeId nodeId = (NodeId)entry.getKey();
                RMContainer reservedContainer = (RMContainer)entry.getValue();
                Resource reservedResource = reservedContainer.getReservedResource();
                if (!Resources.fitsIn((ResourceCalculator)rc, (Resource)clusterResource, (Resource)resourceNeedUnreserve, (Resource)reservedResource)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("unreserving node with reservation size: " + reservedResource + " in order to allocate container with size: " + resourceNeedUnreserve));
                }
                return nodeId;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeadroomProvider(CapacityHeadroomProvider headroomProvider) {
        try {
            this.writeLock.lock();
            this.headroomProvider = headroomProvider;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getHeadroom() {
        try {
            this.readLock.lock();
            if (this.headroomProvider != null) {
                Resource resource = this.headroomProvider.getHeadroom();
                return resource;
            }
            Resource resource = super.getHeadroom();
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferStateFromPreviousAttempt(SchedulerApplicationAttempt appAttempt) {
        try {
            this.writeLock.lock();
            super.transferStateFromPreviousAttempt(appAttempt);
            this.headroomProvider = ((FiCaSchedulerApp)appAttempt).headroomProvider;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void reserve(SchedulerRequestKey schedulerKey, FiCaSchedulerNode node, RMContainer rmContainer, Container container, boolean reReservation) {
        if (!reReservation) {
            this.queue.getMetrics().reserveResource(node.getPartition(), this.getUser(), container.getResource());
        }
        rmContainer = super.reserve(node, schedulerKey, rmContainer, container);
        node.reserveResource(this, schedulerKey, rmContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public RMContainer findNodeToUnreserve(Resource clusterResource, FiCaSchedulerNode node, SchedulerRequestKey schedulerKey, Resource minimumUnreservedResource) {
        try {
            this.readLock.lock();
            NodeId idToUnreserve = this.getNodeIdToUnreserve(schedulerKey, minimumUnreservedResource, this.rc, clusterResource);
            if (idToUnreserve == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"checked to see if could unreserve for app but nothing reserved that matches for this app");
                }
                RMContainer rMContainer = null;
                return rMContainer;
            }
            FiCaSchedulerNode nodeToUnreserve = ((CapacityScheduler)this.scheduler).getNode(idToUnreserve);
            if (nodeToUnreserve == null) {
                LOG.error((Object)("node to unreserve doesn't exist, nodeid: " + idToUnreserve));
                RMContainer rMContainer = null;
                return rMContainer;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("unreserving for app: " + this.getApplicationId() + " on nodeId: " + idToUnreserve + " in order to replace reserved application and place it on node: " + node.getNodeID() + " needing: " + minimumUnreservedResource));
            }
            Resources.addTo((Resource)this.getHeadroom(), (Resource)nodeToUnreserve.getReservedContainer().getReservedResource());
            RMContainer rMContainer = nodeToUnreserve.getReservedContainer();
            return rMContainer;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public LeafQueue getCSLeafQueue() {
        return (LeafQueue)this.queue;
    }

    public CSAssignment assignContainers(Resource clusterResource, PlacementSet<FiCaSchedulerNode> ps, ResourceLimits currentResourceLimits, SchedulingMode schedulingMode, RMContainer reservedContainer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("pre-assignContainers for application " + this.getApplicationId()));
            this.showRequests();
        }
        return this.containerAllocator.assignContainers(clusterResource, ps, schedulingMode, currentResourceLimits, reservedContainer);
    }

    public void nodePartitionUpdated(RMContainer rmContainer, String oldPartition, String newPartition) {
        Resource containerResource = rmContainer.getAllocatedResource();
        this.attemptResourceUsage.decUsed(oldPartition, containerResource);
        this.attemptResourceUsage.incUsed(newPartition, containerResource);
        this.getCSLeafQueue().decUsedResource(oldPartition, containerResource, this);
        this.getCSLeafQueue().incUsedResource(newPartition, containerResource, this);
        if (rmContainer.isAMContainer()) {
            this.setAppAMNodePartitionName(newPartition);
            this.attemptResourceUsage.decAMUsed(oldPartition, containerResource);
            this.attemptResourceUsage.incAMUsed(newPartition, containerResource);
            this.getCSLeafQueue().decAMUsedResource(oldPartition, containerResource, this);
            this.getCSLeafQueue().incAMUsedResource(newPartition, containerResource, this);
        }
    }

    @Override
    protected void getPendingAppDiagnosticMessage(StringBuilder diagnosticMessage) {
        LeafQueue queue = this.getCSLeafQueue();
        diagnosticMessage.append(" Details : AM Partition = ");
        diagnosticMessage.append(this.appAMNodePartitionName.isEmpty() ? "<DEFAULT_PARTITION>" : this.appAMNodePartitionName);
        diagnosticMessage.append("; ");
        diagnosticMessage.append("AM Resource Request = ");
        diagnosticMessage.append(this.getAMResource(this.appAMNodePartitionName));
        diagnosticMessage.append("; ");
        diagnosticMessage.append("Queue Resource Limit for AM = ");
        diagnosticMessage.append(queue.getAMResourceLimitPerPartition(this.appAMNodePartitionName));
        diagnosticMessage.append("; ");
        diagnosticMessage.append("User AM Resource Limit of the queue = ");
        diagnosticMessage.append(queue.getUserAMResourceLimitPerPartition(this.appAMNodePartitionName, this.getUser()));
        diagnosticMessage.append("; ");
        diagnosticMessage.append("Queue AM Resource Usage = ");
        diagnosticMessage.append(queue.getQueueResourceUsage().getAMUsed(this.appAMNodePartitionName));
        diagnosticMessage.append("; ");
    }

    @Override
    protected void getActivedAppDiagnosticMessage(StringBuilder diagnosticMessage) {
        LeafQueue queue = this.getCSLeafQueue();
        QueueCapacities queueCapacities = queue.getQueueCapacities();
        diagnosticMessage.append(" Details : AM Partition = ");
        diagnosticMessage.append(this.appAMNodePartitionName.isEmpty() ? "<DEFAULT_PARTITION>" : this.appAMNodePartitionName);
        diagnosticMessage.append(" ; ");
        diagnosticMessage.append("Partition Resource = ");
        diagnosticMessage.append(this.rmContext.getNodeLabelManager().getResourceByLabel(this.appAMNodePartitionName, Resources.none()));
        diagnosticMessage.append(" ; ");
        diagnosticMessage.append("Queue's Absolute capacity = ");
        diagnosticMessage.append(queueCapacities.getAbsoluteCapacity(this.appAMNodePartitionName) * 100.0f);
        diagnosticMessage.append(" % ; ");
        diagnosticMessage.append("Queue's Absolute used capacity = ");
        diagnosticMessage.append(queueCapacities.getAbsoluteUsedCapacity(this.appAMNodePartitionName) * 100.0f);
        diagnosticMessage.append(" % ; ");
        diagnosticMessage.append("Queue's Absolute max capacity = ");
        diagnosticMessage.append(queueCapacities.getAbsoluteMaximumCapacity(this.appAMNodePartitionName) * 100.0f);
        diagnosticMessage.append(" % ; ");
    }

    public void updateAppSkipNodeDiagnostics(String message) {
        this.appSkipNodeDiagnostics = message;
    }

    public void updateNodeInfoForAMDiagnostics(FiCaSchedulerNode node) {
        if (null == node) {
            return;
        }
        if (this.isWaitingForAMContainer()) {
            StringBuilder diagnosticMessageBldr = new StringBuilder();
            if (this.appSkipNodeDiagnostics != null) {
                diagnosticMessageBldr.append(this.appSkipNodeDiagnostics);
                this.appSkipNodeDiagnostics = null;
            }
            diagnosticMessageBldr.append(" Last Node which was processed for the application : ");
            diagnosticMessageBldr.append(node.getNodeID());
            diagnosticMessageBldr.append(" ( Partition : ");
            diagnosticMessageBldr.append(node.getLabels());
            diagnosticMessageBldr.append(", Total resource : ");
            diagnosticMessageBldr.append(node.getTotalResource());
            diagnosticMessageBldr.append(", Available resource : ");
            diagnosticMessageBldr.append(node.getUnallocatedResource());
            diagnosticMessageBldr.append(" ).");
            this.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.ACTIVATED, diagnosticMessageBldr.toString());
        }
    }

    public SchedulingPlacementSet<FiCaSchedulerNode> getSchedulingPlacementSet(SchedulerRequestKey schedulerRequestKey) {
        return super.getSchedulingPlacementSet(schedulerRequestKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationResourceUsageReport getResourceUsageReport() {
        try {
            this.writeLock.lock();
            ApplicationResourceUsageReport report = super.getResourceUsageReport();
            Resource cluster = this.rmContext.getScheduler().getClusterResource();
            Resource totalPartitionRes = this.rmContext.getNodeLabelManager().getResourceByLabel(this.getAppAMNodePartitionName(), cluster);
            ResourceCalculator calc = this.rmContext.getScheduler().getResourceCalculator();
            if (!calc.isInvalidDivisor(totalPartitionRes)) {
                float queueAbsMaxCapPerPartition = ((AbstractCSQueue)this.getQueue()).getQueueCapacities().getAbsoluteCapacity(this.getAppAMNodePartitionName());
                float queueUsagePerc = calc.divide(totalPartitionRes, report.getUsedResources(), Resources.multiply((Resource)totalPartitionRes, (double)queueAbsMaxCapPerPartition)) * 100.0f;
                report.setQueueUsagePercentage(queueUsagePerc);
            }
            ApplicationResourceUsageReport applicationResourceUsageReport = report;
            return applicationResourceUsageReport;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public ReentrantReadWriteLock.WriteLock getWriteLock() {
        return this.writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean moveReservation(RMContainer reservedContainer, FiCaSchedulerNode sourceNode, FiCaSchedulerNode targetNode) {
        Map map;
        block18: {
            try {
                this.writeLock.lock();
                if (!sourceNode.getPartition().equals(targetNode.getPartition())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Failed to move reservation, two nodes are in different partition");
                    }
                    boolean bl = false;
                    this.writeLock.unlock();
                    return bl;
                }
                map = (Map)this.reservedContainers.get(reservedContainer.getReservedSchedulerKey());
                if (null == map) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Cannot find reserved container map.");
                    }
                    boolean bl = false;
                    this.writeLock.unlock();
                    return bl;
                }
                if (sourceNode.getReservedContainer() == reservedContainer) break block18;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"To-be-moved container already updated.");
                }
                boolean bl = false;
                this.writeLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                this.writeLock.unlock();
                throw throwable;
            }
        }
        FiCaSchedulerNode fiCaSchedulerNode = targetNode;
        // MONITORENTER : fiCaSchedulerNode
        if (targetNode.getReservedContainer() != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)"Target node is already occupied before moving");
        }
        try {
            targetNode.reserveResource(this, reservedContainer.getReservedSchedulerKey(), reservedContainer);
        }
        catch (IllegalStateException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Reserve on target node failed, e=", (Throwable)e);
            }
            boolean bl = false;
            // MONITOREXIT : fiCaSchedulerNode
            this.writeLock.unlock();
            return bl;
        }
        sourceNode.setReservedContainer(null);
        map.remove(sourceNode.getNodeID());
        reservedContainer.handle((Event)new RMContainerReservedEvent(reservedContainer.getContainerId(), reservedContainer.getReservedResource(), targetNode.getNodeID(), reservedContainer.getReservedSchedulerKey()));
        map.put(targetNode.getNodeID(), reservedContainer);
        boolean bl = true;
        // MONITOREXIT : fiCaSchedulerNode
        this.writeLock.unlock();
        return bl;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }
}

