/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.io.FileLink;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HBaseFsckRepair;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.HbckErrorReporter;
import org.apache.hadoop.hbase.util.HbckRegionInfo;
import org.apache.hadoop.hbase.util.HbckTableInfo;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.hbase.util.RetryCounterFactory;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.hbase.util.hbck.HFileCorruptionChecker;
import org.apache.hadoop.hbase.util.hbck.ReplicationChecker;
import org.apache.hadoop.hbase.util.hbck.TableIntegrityErrorHandler;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@InterfaceAudience.LimitedPrivate(value={"Tools"})
@InterfaceStability.Evolving
public class HBaseFsck
extends Configured
implements Closeable {
    public static final long DEFAULT_TIME_LAG = 60000L;
    public static final long DEFAULT_SLEEP_BEFORE_RERUN = 10000L;
    private static final int MAX_NUM_THREADS = 50;
    private static boolean rsSupportsOffline = true;
    private static final int DEFAULT_OVERLAPS_TO_SIDELINE = 2;
    private static final int DEFAULT_MAX_MERGE = 5;
    @VisibleForTesting
    public static final String HBCK_LOCK_FILE = "hbase-hbck.lock";
    private static final int DEFAULT_MAX_LOCK_FILE_ATTEMPTS = 5;
    private static final int DEFAULT_LOCK_FILE_ATTEMPT_SLEEP_INTERVAL = 200;
    private static final int DEFAULT_LOCK_FILE_ATTEMPT_MAX_SLEEP_TIME = 5000;
    private static final int DEFAULT_WAIT_FOR_LOCK_TIMEOUT = 80;
    private static final int DEFAULT_MAX_CREATE_ZNODE_ATTEMPTS = 5;
    private static final int DEFAULT_CREATE_ZNODE_ATTEMPT_SLEEP_INTERVAL = 200;
    private static final int DEFAULT_CREATE_ZNODE_ATTEMPT_MAX_SLEEP_TIME = 5000;
    private static final Logger LOG = LoggerFactory.getLogger((String)HBaseFsck.class.getName());
    private ClusterMetrics status;
    private ClusterConnection connection;
    private Admin admin;
    private Table meta;
    protected ExecutorService executor;
    private long startMillis = EnvironmentEdgeManager.currentTime();
    private HFileCorruptionChecker hfcc;
    private int retcode = 0;
    private Path HBCK_LOCK_PATH;
    private FSDataOutputStream hbckOutFd;
    private final AtomicBoolean hbckLockCleanup = new AtomicBoolean(false);
    private static final Set<String> unsupportedOptionsInV2 = Sets.newHashSet((Object[])new String[]{"-fix", "-fixAssignments", "-fixMeta", "-fixHdfsHoles", "-fixHdfsOrphans", "-fixTableOrphans", "-fixHdfsOverlaps", "-sidelineBigOverlaps", "-fixSplitParents", "-removeParents", "-fixEmptyMetaCells", "-repair", "-repairHoles", "-maxOverlapsToSideline", "-maxMerge"});
    private static boolean details = false;
    private long timelag = 60000L;
    private static boolean forceExclusive = false;
    private boolean fixAssignments = false;
    private boolean fixMeta = false;
    private boolean checkHdfs = true;
    private boolean fixHdfsHoles = false;
    private boolean fixHdfsOverlaps = false;
    private boolean fixHdfsOrphans = false;
    private boolean fixTableOrphans = false;
    private boolean fixVersionFile = false;
    private boolean fixSplitParents = false;
    private boolean removeParents = false;
    private boolean fixReferenceFiles = false;
    private boolean fixHFileLinks = false;
    private boolean fixEmptyMetaCells = false;
    private boolean fixReplication = false;
    private boolean cleanReplicationBarrier = false;
    private boolean fixAny = false;
    private Set<TableName> tablesIncluded = new HashSet<TableName>();
    private TableName cleanReplicationBarrierTable;
    private int maxMerge = 5;
    private int maxOverlapsToSideline = 2;
    private boolean sidelineBigOverlaps = false;
    private Path sidelineDir = null;
    private boolean rerun = false;
    private static boolean summary = false;
    private boolean checkMetaOnly = false;
    private boolean checkRegionBoundaries = false;
    private boolean ignorePreCheckPermission = false;
    private final HbckErrorReporter errors;
    int fixes = 0;
    private TreeMap<String, HbckRegionInfo> regionInfoMap = new TreeMap();
    private Set<Result> emptyRegionInfoQualifiers = new HashSet<Result>();
    private SortedMap<TableName, HbckTableInfo> tablesInfo = new ConcurrentSkipListMap<TableName, HbckTableInfo>();
    private List<HbckRegionInfo> orphanHdfsDirs = Collections.synchronizedList(new ArrayList());
    private Map<TableName, Set<String>> orphanTableDirs = new HashMap<TableName, Set<String>>();
    private Map<TableName, TableState> tableStates = new HashMap<TableName, TableState>();
    private final RetryCounterFactory lockFileRetryCounterFactory;
    private final RetryCounterFactory createZNodeRetryCounterFactory;
    private Map<TableName, Set<String>> skippedRegions = new HashMap<TableName, Set<String>>();
    private ZKWatcher zkw = null;
    private String hbckEphemeralNodePath = null;
    private boolean hbckZodeCreated = false;

    public HBaseFsck(Configuration conf) throws IOException, ClassNotFoundException {
        this(conf, HBaseFsck.createThreadPool(conf));
    }

    private static ExecutorService createThreadPool(Configuration conf) {
        int numThreads = conf.getInt("hbasefsck.numthreads", 50);
        return new ScheduledThreadPoolExecutor(numThreads, Threads.newDaemonThreadFactory((String)"hbasefsck"));
    }

    public HBaseFsck(Configuration conf, ExecutorService exec) throws MasterNotRunningException, ZooKeeperConnectionException, IOException, ClassNotFoundException {
        super(conf);
        this.errors = HBaseFsck.getErrorReporter(this.getConf());
        this.executor = exec;
        this.lockFileRetryCounterFactory = HBaseFsck.createLockRetryCounterFactory(this.getConf());
        this.createZNodeRetryCounterFactory = HBaseFsck.createZnodeRetryCounterFactory(this.getConf());
        this.zkw = this.createZooKeeperWatcher();
    }

    public static RetryCounterFactory createLockRetryCounterFactory(Configuration conf) {
        return new RetryCounterFactory(conf.getInt("hbase.hbck.lockfile.attempts", 5), conf.getInt("hbase.hbck.lockfile.attempt.sleep.interval", 200), conf.getInt("hbase.hbck.lockfile.attempt.maxsleeptime", 5000));
    }

    private static RetryCounterFactory createZnodeRetryCounterFactory(Configuration conf) {
        return new RetryCounterFactory(conf.getInt("hbase.hbck.createznode.attempts", 5), conf.getInt("hbase.hbck.createznode.attempt.sleep.interval", 200), conf.getInt("hbase.hbck.createznode.attempt.maxsleeptime", 5000));
    }

    @VisibleForTesting
    public static Path getTmpDir(Configuration conf) throws IOException {
        return new Path(FSUtils.getRootDir((Configuration)conf), ".tmp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<Path, FSDataOutputStream> checkAndMarkRunningHbck(Configuration conf, RetryCounter retryCounter) throws IOException {
        FileLockCallable callable = new FileLockCallable(conf, retryCounter);
        ExecutorService executor = Executors.newFixedThreadPool(1);
        FutureTask<FSDataOutputStream> futureTask = new FutureTask<FSDataOutputStream>(callable);
        executor.execute(futureTask);
        int timeoutInSeconds = conf.getInt("hbase.hbck.lockfile.maxwaittime", 80);
        FSDataOutputStream stream = null;
        try {
            stream = futureTask.get(timeoutInSeconds, TimeUnit.SECONDS);
        }
        catch (ExecutionException ee) {
            LOG.warn("Encountered exception when opening lock file", (Throwable)ee);
        }
        catch (InterruptedException ie) {
            LOG.warn("Interrupted when opening lock file", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException exception) {
            LOG.warn("Took more than " + timeoutInSeconds + " seconds in obtaining lock");
            futureTask.cancel(true);
        }
        finally {
            executor.shutdownNow();
        }
        return new Pair((Object)callable.getHbckLockPath(), (Object)stream);
    }

    private void unlockHbck() {
        if (this.isExclusive() && this.hbckLockCleanup.compareAndSet(true, false)) {
            RetryCounter retryCounter = this.lockFileRetryCounterFactory.create();
            while (true) {
                try {
                    IOUtils.closeQuietly((OutputStream)this.hbckOutFd);
                    FSUtils.delete((FileSystem)FSUtils.getCurrentFileSystem((Configuration)this.getConf()), (Path)this.HBCK_LOCK_PATH, (boolean)true);
                    LOG.info("Finishing hbck");
                    return;
                }
                catch (IOException ioe) {
                    LOG.info("Failed to delete " + this.HBCK_LOCK_PATH + ", try=" + (retryCounter.getAttemptTimes() + 1) + " of " + retryCounter.getMaxAttempts());
                    LOG.debug("Failed to delete " + this.HBCK_LOCK_PATH, (Throwable)ioe);
                    try {
                        retryCounter.sleepUntilNextRetry();
                        continue;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        LOG.warn("Interrupted while deleting lock file" + this.HBCK_LOCK_PATH);
                        return;
                    }
                    if (retryCounter.shouldRetry()) continue;
                }
                break;
            }
        }
    }

    public void connect() throws IOException {
        if (this.isExclusive()) {
            Pair<Path, FSDataOutputStream> pair = HBaseFsck.checkAndMarkRunningHbck(this.getConf(), this.lockFileRetryCounterFactory.create());
            this.HBCK_LOCK_PATH = (Path)pair.getFirst();
            this.hbckOutFd = (FSDataOutputStream)pair.getSecond();
            if (this.hbckOutFd == null) {
                this.setRetCode(-1);
                LOG.error("Another instance of hbck is fixing HBase, exiting this instance. [If you are sure no other instance is running, delete the lock file " + this.HBCK_LOCK_PATH + " and rerun the tool]");
                throw new IOException("Duplicate hbck - Abort");
            }
            this.hbckLockCleanup.set(true);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                IOUtils.closeQuietly((Closeable)HBaseFsck.this);
                HBaseFsck.this.cleanupHbckZnode();
                HBaseFsck.this.unlockHbck();
            }
        });
        LOG.info("Launching hbck");
        this.connection = (ClusterConnection)ConnectionFactory.createConnection((Configuration)this.getConf());
        this.admin = this.connection.getAdmin();
        this.meta = this.connection.getTable(TableName.META_TABLE_NAME);
        this.status = this.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS, new ClusterMetrics.Option[]{ClusterMetrics.Option.DEAD_SERVERS, ClusterMetrics.Option.MASTER, ClusterMetrics.Option.BACKUP_MASTERS, ClusterMetrics.Option.REGIONS_IN_TRANSITION, ClusterMetrics.Option.HBASE_VERSION}));
    }

    private void loadDeployedRegions() throws IOException, InterruptedException {
        Set<ServerName> regionServers = this.status.getLiveServerMetrics().keySet();
        this.errors.print("Number of live region servers: " + regionServers.size());
        if (details) {
            for (ServerName serverName : regionServers) {
                this.errors.print("  " + serverName.getServerName());
            }
        }
        List deadRegionServers = this.status.getDeadServerNames();
        this.errors.print("Number of dead region servers: " + deadRegionServers.size());
        if (details) {
            for (Object name : deadRegionServers) {
                this.errors.print("  " + name);
            }
        }
        this.errors.print("Master: " + this.status.getMasterName());
        List list = this.status.getBackupMasterNames();
        this.errors.print("Number of backup masters: " + list.size());
        if (details) {
            for (ServerName name : list) {
                this.errors.print("  " + name);
            }
        }
        this.errors.print("Average load: " + this.status.getAverageLoad());
        this.errors.print("Number of requests: " + this.status.getRequestCount());
        this.errors.print("Number of regions: " + this.status.getRegionCount());
        List rits = this.status.getRegionStatesInTransition();
        this.errors.print("Number of regions in transition: " + rits.size());
        if (details) {
            for (RegionState state : rits) {
                this.errors.print("  " + state.toDescriptiveString());
            }
        }
        this.processRegionServers(regionServers);
    }

    private void clearState() {
        this.fixes = 0;
        this.regionInfoMap.clear();
        this.emptyRegionInfoQualifiers.clear();
        this.tableStates.clear();
        this.errors.clear();
        this.tablesInfo.clear();
        this.orphanHdfsDirs.clear();
        this.skippedRegions.clear();
    }

    public void offlineHdfsIntegrityRepair() throws IOException, InterruptedException {
        if (this.shouldCheckHdfs() && (this.shouldFixHdfsOrphans() || this.shouldFixHdfsHoles() || this.shouldFixHdfsOverlaps() || this.shouldFixTableOrphans())) {
            LOG.info("Loading regioninfos HDFS");
            int maxIterations = this.getConf().getInt("hbase.hbck.integrityrepair.iterations.max", 3);
            int curIter = 0;
            do {
                this.clearState();
                this.restoreHdfsIntegrity();
            } while (this.fixes > 0 && ++curIter <= maxIterations);
            if (curIter > 2) {
                if (curIter == maxIterations) {
                    LOG.warn("Exiting integrity repairs after max " + curIter + " iterations. Tables integrity may not be fully repaired!");
                } else {
                    LOG.info("Successfully exiting integrity repairs after " + curIter + " iterations");
                }
            }
        }
    }

    public int onlineConsistencyRepair() throws IOException, KeeperException, InterruptedException {
        this.loadDeployedRegions();
        this.recordMetaRegion();
        if (!this.checkMetaRegion()) {
            String errorMsg = "hbase:meta table is not consistent. ";
            errorMsg = this.shouldFixAssignments() ? errorMsg + "HBCK will try fixing it. Rerun once hbase:meta is back to consistent state." : errorMsg + "Run HBCK with proper fix options to fix hbase:meta inconsistency.";
            this.errors.reportError(errorMsg + " Exiting...");
            return -2;
        }
        LOG.info("Loading regionsinfo from the hbase:meta table");
        boolean success = this.loadMetaEntries();
        if (!success) {
            return -1;
        }
        this.reportEmptyMetaCells();
        if (this.shouldFixEmptyMetaCells()) {
            this.fixEmptyMetaCells();
        }
        if (!this.checkMetaOnly) {
            this.reportTablesInFlux();
        }
        this.loadTableStates();
        if (this.shouldCheckHdfs()) {
            LOG.info("Loading region directories from HDFS");
            this.loadHdfsRegionDirs();
            LOG.info("Loading region information from HDFS");
            this.loadHdfsRegionInfos();
        }
        this.fixOrphanTables();
        LOG.info("Checking and fixing region consistency");
        this.checkAndFixConsistency();
        this.checkIntegrity();
        return this.errors.getErrorList().size();
    }

    private boolean setMasterInMaintenanceMode() throws IOException {
        RetryCounter retryCounter = this.createZNodeRetryCounterFactory.create();
        this.hbckEphemeralNodePath = ZNodePaths.joinZNode((String)this.zkw.getZNodePaths().masterMaintZNode, (String)("hbck-" + Long.toString(EnvironmentEdgeManager.currentTime())));
        do {
            block6: {
                try {
                    this.hbckZodeCreated = ZKUtil.createEphemeralNodeAndWatch((ZKWatcher)this.zkw, (String)this.hbckEphemeralNodePath, null);
                    if (this.hbckZodeCreated) {
                        break;
                    }
                }
                catch (KeeperException e) {
                    if (retryCounter.getAttemptTimes() < retryCounter.getMaxAttempts()) break block6;
                    throw new IOException("Can't create znode " + this.hbckEphemeralNodePath, e);
                }
            }
            LOG.warn("Fail to create znode " + this.hbckEphemeralNodePath + ", try=" + (retryCounter.getAttemptTimes() + 1) + " of " + retryCounter.getMaxAttempts());
            try {
                retryCounter.sleepUntilNextRetry();
            }
            catch (InterruptedException ie) {
                throw (InterruptedIOException)new InterruptedIOException("Can't create znode " + this.hbckEphemeralNodePath).initCause(ie);
            }
        } while (retryCounter.shouldRetry());
        return this.hbckZodeCreated;
    }

    private void cleanupHbckZnode() {
        block3: {
            try {
                if (this.zkw != null && this.hbckZodeCreated) {
                    ZKUtil.deleteNode((ZKWatcher)this.zkw, (String)this.hbckEphemeralNodePath);
                    this.hbckZodeCreated = false;
                }
            }
            catch (KeeperException e) {
                if (e.code().equals((Object)KeeperException.Code.NONODE)) break block3;
                LOG.warn("Delete HBCK znode " + this.hbckEphemeralNodePath + " failed ", (Throwable)e);
            }
        }
    }

    public int onlineHbck() throws IOException, KeeperException, InterruptedException, ReplicationException {
        this.errors.print("Version: " + this.status.getHBaseVersion());
        this.clearState();
        this.offlineHdfsIntegrityRepair();
        this.offlineReferenceFileRepair();
        this.offlineHLinkFileRepair();
        if (!this.setMasterInMaintenanceMode()) {
            LOG.warn("HBCK is running while master is not in maintenance mode, you might see transient error.  Please run HBCK multiple times to reduce the chance of transient error.");
        }
        this.onlineConsistencyRepair();
        if (this.checkRegionBoundaries) {
            this.checkRegionBoundaries();
        }
        this.checkAndFixReplication();
        this.cleanReplicationBarrier();
        this.cleanupHbckZnode();
        this.unlockHbck();
        this.printTableSummary(this.tablesInfo);
        return this.errors.summarize();
    }

    public static byte[] keyOnly(byte[] b) {
        if (b == null) {
            return b;
        }
        short rowlength = Bytes.toShort((byte[])b, (int)0);
        byte[] result = new byte[rowlength];
        System.arraycopy(b, 2, result, 0, rowlength);
        return result;
    }

    @Override
    public void close() throws IOException {
        try {
            this.cleanupHbckZnode();
            this.unlockHbck();
        }
        catch (Exception io) {
            LOG.warn(io.toString(), (Throwable)io);
        }
        finally {
            if (this.zkw != null) {
                this.zkw.close();
                this.zkw = null;
            }
            IOUtils.closeQuietly((Closeable)this.admin);
            IOUtils.closeQuietly((Closeable)this.meta);
            IOUtils.closeQuietly((Closeable)this.connection);
        }
    }

    public void checkRegionBoundaries() {
        try {
            Bytes.ByteArrayComparator comparator = new Bytes.ByteArrayComparator();
            List regions = MetaTableAccessor.getAllRegions((Connection)this.connection, (boolean)true);
            RegionBoundariesInformation currentRegionBoundariesInformation = new RegionBoundariesInformation();
            Path hbaseRoot = FSUtils.getRootDir((Configuration)this.getConf());
            for (RegionInfo regionInfo : regions) {
                Path tableDir = FSUtils.getTableDir((Path)hbaseRoot, (TableName)regionInfo.getTable());
                currentRegionBoundariesInformation.regionName = regionInfo.getRegionName();
                Path path = new Path(tableDir, regionInfo.getEncodedName());
                FileSystem fs = path.getFileSystem(this.getConf());
                FileStatus[] files = fs.listStatus(path);
                byte[] storeFirstKey = null;
                byte[] storeLastKey = null;
                for (FileStatus file : files) {
                    FileStatus[] storeFiles;
                    String fileName = file.getPath().toString();
                    if ((fileName = fileName.substring(fileName.lastIndexOf("/") + 1)).startsWith(".") || fileName.endsWith("recovered.edits")) continue;
                    for (FileStatus storeFile : storeFiles = fs.listStatus(file.getPath())) {
                        HFile.Reader reader = HFile.createReader(fs, storeFile.getPath(), CacheConfig.DISABLED, true, this.getConf());
                        if (reader.getFirstKey() != null && (storeFirstKey == null || comparator.compare(storeFirstKey, ((KeyValue.KeyOnlyKeyValue)reader.getFirstKey().get()).getKey()) > 0)) {
                            storeFirstKey = ((KeyValue.KeyOnlyKeyValue)reader.getFirstKey().get()).getKey();
                        }
                        if (reader.getLastKey() != null && (storeLastKey == null || comparator.compare(storeLastKey, ((KeyValue.KeyOnlyKeyValue)reader.getLastKey().get()).getKey()) < 0)) {
                            storeLastKey = ((KeyValue.KeyOnlyKeyValue)reader.getLastKey().get()).getKey();
                        }
                        reader.close();
                    }
                }
                currentRegionBoundariesInformation.metaFirstKey = regionInfo.getStartKey();
                currentRegionBoundariesInformation.metaLastKey = regionInfo.getEndKey();
                currentRegionBoundariesInformation.storesFirstKey = HBaseFsck.keyOnly(storeFirstKey);
                currentRegionBoundariesInformation.storesLastKey = HBaseFsck.keyOnly(storeLastKey);
                if (currentRegionBoundariesInformation.metaFirstKey.length == 0) {
                    currentRegionBoundariesInformation.metaFirstKey = null;
                }
                if (currentRegionBoundariesInformation.metaLastKey.length == 0) {
                    currentRegionBoundariesInformation.metaLastKey = null;
                }
                boolean valid = true;
                if (currentRegionBoundariesInformation.storesFirstKey != null && currentRegionBoundariesInformation.metaFirstKey != null) {
                    boolean bl = valid = valid && comparator.compare(currentRegionBoundariesInformation.storesFirstKey, currentRegionBoundariesInformation.metaFirstKey) >= 0;
                }
                if (currentRegionBoundariesInformation.storesLastKey != null && currentRegionBoundariesInformation.metaLastKey != null) {
                    boolean bl = valid = valid && comparator.compare(currentRegionBoundariesInformation.storesLastKey, currentRegionBoundariesInformation.metaLastKey) < 0;
                }
                if (valid) continue;
                this.errors.reportError(HbckErrorReporter.ERROR_CODE.BOUNDARIES_ERROR, "Found issues with regions boundaries", (HbckTableInfo)this.tablesInfo.get(regionInfo.getTable()));
                LOG.warn("Region's boundaries not aligned between stores and META for:");
                LOG.warn(Objects.toString(currentRegionBoundariesInformation));
            }
        }
        catch (IOException e) {
            LOG.error(e.toString(), (Throwable)e);
        }
    }

    private void adoptHdfsOrphans(Collection<HbckRegionInfo> orphanHdfsDirs) throws IOException {
        for (HbckRegionInfo hi : orphanHdfsDirs) {
            LOG.info("Attempting to handle orphan hdfs dir: " + hi.getHdfsRegionDir());
            this.adoptHdfsOrphan(hi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adoptHdfsOrphan(HbckRegionInfo hi) throws IOException {
        Path p = hi.getHdfsRegionDir();
        FileSystem fs = p.getFileSystem(this.getConf());
        FileStatus[] dirs = fs.listStatus(p);
        if (dirs == null) {
            LOG.warn("Attempt to adopt orphan hdfs region skipped because no files present in " + p + ". This dir could probably be deleted.");
            return;
        }
        TableName tableName = hi.getTableName();
        HbckTableInfo tableInfo = (HbckTableInfo)this.tablesInfo.get(tableName);
        Preconditions.checkNotNull((Object)tableInfo, (Object)("Table '" + tableName + "' not present!"));
        TableDescriptor template = tableInfo.getTableDescriptor();
        Pair orphanRegionRange = null;
        for (FileStatus cf : dirs) {
            FileStatus[] hfiles;
            String cfName = cf.getPath().getName();
            if (cfName.startsWith(".") || cfName.equals("splitWAL")) continue;
            for (FileStatus hfile : hfiles = fs.listStatus(cf.getPath())) {
                byte[] end;
                byte[] start;
                try (Closeable hf = null;){
                    hf = HFile.createReader(fs, hfile.getPath(), CacheConfig.DISABLED, true, this.getConf());
                    hf.loadFileInfo();
                    Optional<Cell> startKv = hf.getFirstKey();
                    start = CellUtil.cloneRow((Cell)startKv.get());
                    Optional<Cell> endKv = hf.getLastKey();
                    end = CellUtil.cloneRow((Cell)endKv.get());
                }
                if (orphanRegionRange == null) {
                    orphanRegionRange = new Pair((Object)start, (Object)end);
                    continue;
                }
                if (Bytes.compareTo((byte[])((byte[])orphanRegionRange.getFirst()), (byte[])start) > 0) {
                    orphanRegionRange.setFirst((Object)start);
                }
                if (Bytes.compareTo((byte[])((byte[])orphanRegionRange.getSecond()), (byte[])end) >= 0) continue;
                orphanRegionRange.setSecond((Object)end);
            }
        }
        if (orphanRegionRange == null) {
            LOG.warn("No data in dir " + p + ", sidelining data");
            ++this.fixes;
            this.sidelineRegionDir(fs, hi);
            return;
        }
        LOG.info("Min max keys are : [" + Bytes.toString((byte[])((byte[])orphanRegionRange.getFirst())) + ", " + Bytes.toString((byte[])((byte[])orphanRegionRange.getSecond())) + ")");
        RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)template.getTableName()).setStartKey((byte[])orphanRegionRange.getFirst()).setEndKey(Bytes.add((byte[])((byte[])orphanRegionRange.getSecond()), (byte[])new byte[1])).build();
        LOG.info("Creating new region : " + regionInfo);
        HRegion region = HBaseFsckRepair.createHDFSRegionDir(this.getConf(), regionInfo, template);
        Path target = region.getRegionFileSystem().getRegionDir();
        this.mergeRegionDirs(target, hi);
        ++this.fixes;
    }

    private int restoreHdfsIntegrity() throws IOException, InterruptedException {
        LOG.info("Loading HBase regioninfo from HDFS...");
        this.loadHdfsRegionDirs();
        int errs = this.errors.getErrorList().size();
        this.tablesInfo = this.loadHdfsRegionInfos();
        this.checkHdfsIntegrity(false, false);
        if (this.errors.getErrorList().size() == errs) {
            LOG.info("No integrity errors.  We are done with this phase. Glorious.");
            return 0;
        }
        if (this.shouldFixHdfsOrphans() && this.orphanHdfsDirs.size() > 0) {
            this.adoptHdfsOrphans(this.orphanHdfsDirs);
        }
        if (this.shouldFixHdfsHoles()) {
            this.clearState();
            this.loadHdfsRegionDirs();
            this.tablesInfo = this.loadHdfsRegionInfos();
            this.tablesInfo = this.checkHdfsIntegrity(this.shouldFixHdfsHoles(), false);
        }
        if (this.shouldFixHdfsOverlaps()) {
            this.clearState();
            this.loadHdfsRegionDirs();
            this.tablesInfo = this.loadHdfsRegionInfos();
            this.tablesInfo = this.checkHdfsIntegrity(false, this.shouldFixHdfsOverlaps());
        }
        return this.errors.getErrorList().size();
    }

    private void offlineReferenceFileRepair() throws IOException, InterruptedException {
        this.clearState();
        Configuration conf = this.getConf();
        Path hbaseRoot = FSUtils.getRootDir((Configuration)conf);
        FileSystem fs = hbaseRoot.getFileSystem(conf);
        LOG.info("Computing mapping of all store files");
        Map<String, Path> allFiles = FSUtils.getTableStoreFilePathMap(fs, hbaseRoot, (PathFilter)new FSUtils.ReferenceFileFilter(fs), this.executor, this.errors);
        this.errors.print("");
        LOG.info("Validating mapping using HDFS state");
        for (Path path : allFiles.values()) {
            Path referredToFile = StoreFileInfo.getReferredToFile(path);
            if (fs.exists(referredToFile)) continue;
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.LINGERING_REFERENCE_HFILE, "Found lingering reference file " + path);
            if (!this.shouldFixReferenceFiles()) continue;
            boolean success = false;
            String pathStr = path.toString();
            int index = pathStr.lastIndexOf(47);
            for (int i = 0; index > 0 && i < 5; ++i) {
                index = pathStr.lastIndexOf(47, index - 1);
            }
            if (index > 0) {
                Path rootDir = this.getSidelineDir();
                Path dst = new Path(rootDir, pathStr.substring(index + 1));
                fs.mkdirs(dst.getParent());
                LOG.info("Trying to sideline reference file " + path + " to " + dst);
                this.setShouldRerun();
                success = fs.rename(path, dst);
                this.debugLsr(dst);
            }
            if (success) continue;
            LOG.error("Failed to sideline reference file " + path);
        }
    }

    private void offlineHLinkFileRepair() throws IOException, InterruptedException {
        Configuration conf = this.getConf();
        Path hbaseRoot = FSUtils.getRootDir((Configuration)conf);
        FileSystem fs = hbaseRoot.getFileSystem(conf);
        LOG.info("Computing mapping of all link files");
        Map<String, Path> allFiles = FSUtils.getTableStoreFilePathMap(fs, hbaseRoot, (PathFilter)new FSUtils.HFileLinkFilter(), this.executor, this.errors);
        this.errors.print("");
        LOG.info("Validating mapping using HDFS state");
        for (Path path : allFiles.values()) {
            Path backRefPath;
            HFileLink actualLink = HFileLink.buildFromHFileLinkPattern(conf, path);
            if (actualLink.exists(fs)) continue;
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.LINGERING_HFILELINK, "Found lingering HFileLink " + path);
            if (!this.shouldFixHFileLinks()) continue;
            this.setShouldRerun();
            boolean success = this.sidelineFile(fs, hbaseRoot, path);
            if (!success) {
                LOG.error("Failed to sideline HFileLink file " + path);
            }
            if (success = this.sidelineFile(fs, hbaseRoot, backRefPath = FileLink.getBackReferencesDir(HFileArchiveUtil.getStoreArchivePath(conf, HFileLink.getReferencedTableName(path.getName().toString()), HFileLink.getReferencedRegionName(path.getName().toString()), path.getParent().getName()), HFileLink.getReferencedHFileName(path.getName().toString())))) continue;
            LOG.error("Failed to sideline HFileLink backreference file " + path);
        }
    }

    private boolean sidelineFile(FileSystem fs, Path hbaseRoot, Path path) throws IOException {
        URI uri = hbaseRoot.toUri().relativize(path.toUri());
        if (uri.isAbsolute()) {
            return false;
        }
        String relativePath = uri.getPath();
        Path rootDir = this.getSidelineDir();
        Path dst = new Path(rootDir, relativePath);
        boolean pathCreated = fs.mkdirs(dst.getParent());
        if (!pathCreated) {
            LOG.error("Failed to create path: " + dst.getParent());
            return false;
        }
        LOG.info("Trying to sideline file " + path + " to " + dst);
        return fs.rename(path, dst);
    }

    private void reportEmptyMetaCells() {
        this.errors.print("Number of empty REGIONINFO_QUALIFIER rows in hbase:meta: " + this.emptyRegionInfoQualifiers.size());
        if (details) {
            for (Result r : this.emptyRegionInfoQualifiers) {
                this.errors.print("  " + r);
            }
        }
    }

    private void reportTablesInFlux() {
        AtomicInteger numSkipped = new AtomicInteger(0);
        TableDescriptor[] allTables = this.getTables(numSkipped);
        this.errors.print("Number of Tables: " + allTables.length);
        if (details) {
            if (numSkipped.get() > 0) {
                this.errors.detail("Number of Tables in flux: " + numSkipped.get());
            }
            for (TableDescriptor td : allTables) {
                this.errors.detail("  Table: " + td.getTableName() + "\t" + (td.isReadOnly() ? "ro" : "rw") + "\t" + (td.isMetaRegion() ? "META" : "    ") + "\t families: " + td.getColumnFamilyCount());
            }
        }
    }

    public HbckErrorReporter getErrors() {
        return this.errors;
    }

    private SortedMap<TableName, HbckTableInfo> loadHdfsRegionInfos() throws IOException, InterruptedException {
        this.tablesInfo.clear();
        Collection<HbckRegionInfo> hbckRegionInfos = this.regionInfoMap.values();
        ArrayList<WorkItemHdfsRegionInfo> hbis = new ArrayList<WorkItemHdfsRegionInfo>(hbckRegionInfos.size());
        for (HbckRegionInfo hbi : hbckRegionInfos) {
            WorkItemHdfsRegionInfo work = new WorkItemHdfsRegionInfo(hbi, this, this.errors);
            hbis.add(work);
        }
        List hbiFutures = this.executor.invokeAll(hbis);
        for (int i = 0; i < hbiFutures.size(); ++i) {
            WorkItemHdfsRegionInfo work = (WorkItemHdfsRegionInfo)hbis.get(i);
            Future f = hbiFutures.get(i);
            try {
                f.get();
                continue;
            }
            catch (ExecutionException e) {
                LOG.warn("Failed to read .regioninfo file for region " + work.hbi.getRegionNameAsString(), e.getCause());
            }
        }
        Path hbaseRoot = FSUtils.getRootDir((Configuration)this.getConf());
        FileSystem fs = hbaseRoot.getFileSystem(this.getConf());
        for (HbckRegionInfo hbi : hbckRegionInfos) {
            HbckTableInfo modTInfo;
            block9: {
                if (hbi.getHdfsHRI() == null) continue;
                TableName tableName = hbi.getTableName();
                if (tableName == null) {
                    LOG.warn("tableName was null for: " + hbi);
                    continue;
                }
                modTInfo = (HbckTableInfo)this.tablesInfo.get(tableName);
                if (modTInfo == null) {
                    modTInfo = new HbckTableInfo(tableName, this);
                    this.tablesInfo.put(tableName, modTInfo);
                    try {
                        TableDescriptor htd = FSTableDescriptors.getTableDescriptorFromFs(fs, hbaseRoot, tableName);
                        modTInfo.htds.add(htd);
                    }
                    catch (IOException ioe) {
                        if (this.orphanTableDirs.containsKey(tableName)) break block9;
                        LOG.warn("Unable to read .tableinfo from " + hbaseRoot, (Throwable)ioe);
                        this.errors.reportError(HbckErrorReporter.ERROR_CODE.NO_TABLEINFO_FILE, "Unable to read .tableinfo from " + hbaseRoot + "/" + tableName);
                        HashSet<String> columns = new HashSet<String>();
                        this.orphanTableDirs.put(tableName, this.getColumnFamilyList(columns, hbi));
                    }
                }
            }
            if (hbi.isSkipChecks()) continue;
            modTInfo.addRegionInfo(hbi);
        }
        this.loadTableInfosForTablesWithNoRegion();
        this.errors.print("");
        return this.tablesInfo;
    }

    private Set<String> getColumnFamilyList(Set<String> columns, HbckRegionInfo hbi) throws IOException {
        FileStatus[] subDirs;
        Path regionDir = hbi.getHdfsRegionDir();
        FileSystem fs = regionDir.getFileSystem(this.getConf());
        for (FileStatus subdir : subDirs = fs.listStatus(regionDir, (PathFilter)new FSUtils.FamilyDirFilter(fs))) {
            String columnfamily = subdir.getPath().getName();
            columns.add(columnfamily);
        }
        return columns;
    }

    private boolean fabricateTableInfo(FSTableDescriptors fstd, TableName tableName, Set<String> columns) throws IOException {
        if (columns == null || columns.isEmpty()) {
            return false;
        }
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        for (String columnfamimly : columns) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)columnfamimly));
        }
        fstd.createTableDescriptor(builder.build(), true);
        return true;
    }

    public void fixEmptyMetaCells() throws IOException {
        if (this.shouldFixEmptyMetaCells() && !this.emptyRegionInfoQualifiers.isEmpty()) {
            LOG.info("Trying to fix empty REGIONINFO_QUALIFIER hbase:meta rows.");
            for (Result region : this.emptyRegionInfoQualifiers) {
                this.deleteMetaRegion(region.getRow());
                this.errors.getErrorList().remove((Object)HbckErrorReporter.ERROR_CODE.EMPTY_META_CELL);
            }
            this.emptyRegionInfoQualifiers.clear();
        }
    }

    public void fixOrphanTables() throws IOException {
        if (this.shouldFixTableOrphans() && !this.orphanTableDirs.isEmpty()) {
            ArrayList<TableName> tmpList = new ArrayList<TableName>(this.orphanTableDirs.keySet().size());
            tmpList.addAll(this.orphanTableDirs.keySet());
            TableDescriptor[] htds = this.getTableDescriptors(tmpList);
            Iterator<Map.Entry<TableName, Set<String>>> iter = this.orphanTableDirs.entrySet().iterator();
            int j = 0;
            int numFailedCase = 0;
            FSTableDescriptors fstd = new FSTableDescriptors(this.getConf());
            while (iter.hasNext()) {
                Map.Entry<TableName, Set<String>> entry = iter.next();
                TableName tableName = entry.getKey();
                LOG.info("Trying to fix orphan table error: " + tableName);
                if (j < htds.length) {
                    if (tableName.equals((Object)htds[j].getTableName())) {
                        TableDescriptor htd = htds[j];
                        LOG.info("fixing orphan table: " + tableName + " from cache");
                        fstd.createTableDescriptor(htd, true);
                        ++j;
                        iter.remove();
                    }
                } else if (this.fabricateTableInfo(fstd, tableName, entry.getValue())) {
                    LOG.warn("fixing orphan table: " + tableName + " with a default .tableinfo file");
                    LOG.warn("Strongly recommend to modify the TableDescriptor if necessary for: " + tableName);
                    iter.remove();
                } else {
                    LOG.error("Unable to create default .tableinfo for " + tableName + " while missing column family information");
                    ++numFailedCase;
                }
                ++this.fixes;
            }
            if (this.orphanTableDirs.isEmpty()) {
                this.setShouldRerun();
                LOG.warn("Strongly recommend to re-run manually hfsck after all orphanTableDirs being fixed");
            } else if (numFailedCase > 0) {
                LOG.error("Failed to fix " + numFailedCase + " OrphanTables with default .tableinfo files");
            }
        }
        this.orphanTableDirs.clear();
    }

    private void logParallelMerge() {
        if (this.getConf().getBoolean("hbasefsck.overlap.merge.parallel", true)) {
            LOG.info("Handling overlap merges in parallel. set hbasefsck.overlap.merge.parallel to false to run serially.");
        } else {
            LOG.info("Handling overlap merges serially.  set hbasefsck.overlap.merge.parallel to true to run in parallel.");
        }
    }

    private SortedMap<TableName, HbckTableInfo> checkHdfsIntegrity(boolean fixHoles, boolean fixOverlaps) throws IOException {
        LOG.info("Checking HBase region split map from HDFS data...");
        this.logParallelMerge();
        for (HbckTableInfo tInfo : this.tablesInfo.values()) {
            HbckTableInfo.IntegrityFixSuggester handler;
            if (fixHoles || fixOverlaps) {
                HbckTableInfo hbckTableInfo = tInfo;
                hbckTableInfo.getClass();
                handler = new HbckTableInfo.HDFSIntegrityFixer(hbckTableInfo, tInfo, this.errors, this.getConf(), fixHoles, fixOverlaps);
            } else {
                HbckTableInfo hbckTableInfo = tInfo;
                hbckTableInfo.getClass();
                handler = new HbckTableInfo.IntegrityFixSuggester(hbckTableInfo, tInfo, this.errors);
            }
            if (tInfo.checkRegionChain(handler)) continue;
            this.errors.report("Found inconsistency in table " + tInfo.getName());
        }
        return this.tablesInfo;
    }

    Path getSidelineDir() throws IOException {
        if (this.sidelineDir == null) {
            Path hbaseDir = FSUtils.getRootDir((Configuration)this.getConf());
            Path hbckDir = new Path(hbaseDir, ".hbck");
            this.sidelineDir = new Path(hbckDir, hbaseDir.getName() + "-" + this.startMillis);
        }
        return this.sidelineDir;
    }

    Path sidelineRegionDir(FileSystem fs, HbckRegionInfo hi) throws IOException {
        return this.sidelineRegionDir(fs, null, hi);
    }

    Path sidelineRegionDir(FileSystem fs, String parentDir, HbckRegionInfo hi) throws IOException {
        TableName tableName = hi.getTableName();
        Path regionDir = hi.getHdfsRegionDir();
        if (!fs.exists(regionDir)) {
            LOG.warn("No previous " + regionDir + " exists.  Continuing.");
            return null;
        }
        Path rootDir = this.getSidelineDir();
        if (parentDir != null) {
            rootDir = new Path(rootDir, parentDir);
        }
        Path sidelineTableDir = FSUtils.getTableDir((Path)rootDir, (TableName)tableName);
        Path sidelineRegionDir = new Path(sidelineTableDir, regionDir.getName());
        fs.mkdirs(sidelineRegionDir);
        boolean success = false;
        FileStatus[] cfs = fs.listStatus(regionDir);
        if (cfs == null) {
            LOG.info("Region dir is empty: " + regionDir);
        } else {
            for (FileStatus cf : cfs) {
                Path src = cf.getPath();
                Path dst = new Path(sidelineRegionDir, src.getName());
                if (fs.isFile(src)) {
                    success = fs.rename(src, dst);
                    if (success) continue;
                    String msg = "Unable to rename file " + src + " to " + dst;
                    LOG.error(msg);
                    throw new IOException(msg);
                }
                fs.mkdirs(dst);
                LOG.info("Sidelining files from " + src + " into containing region " + dst);
                FileStatus[] hfiles = fs.listStatus(src);
                if (hfiles != null && hfiles.length > 0) {
                    for (FileStatus hfile : hfiles) {
                        success = fs.rename(hfile.getPath(), dst);
                        if (success) continue;
                        String msg = "Unable to rename file " + src + " to " + dst;
                        LOG.error(msg);
                        throw new IOException(msg);
                    }
                }
                LOG.debug("Sideline directory contents:");
                this.debugLsr(sidelineRegionDir);
            }
        }
        LOG.info("Removing old region dir: " + regionDir);
        success = fs.delete(regionDir, true);
        if (!success) {
            String msg = "Unable to delete dir " + regionDir;
            LOG.error(msg);
            throw new IOException(msg);
        }
        return sidelineRegionDir;
    }

    private void loadTableStates() throws IOException {
        this.tableStates = MetaTableAccessor.getTableStates((Connection)this.connection);
        this.tableStates.put(TableName.META_TABLE_NAME, new TableState(TableName.META_TABLE_NAME, TableState.State.ENABLED));
    }

    boolean isTableDisabled(TableName tableName) {
        return this.tableStates.containsKey(tableName) && this.tableStates.get(tableName).inStates(new TableState.State[]{TableState.State.DISABLED, TableState.State.DISABLING});
    }

    public void loadHdfsRegionDirs() throws IOException, InterruptedException {
        Path rootDir = FSUtils.getRootDir((Configuration)this.getConf());
        FileSystem fs = rootDir.getFileSystem(this.getConf());
        ArrayList tableDirs = Lists.newArrayList();
        boolean foundVersionFile = fs.exists(new Path(rootDir, "hbase.version"));
        List<Path> paths = FSUtils.getTableDirs(fs, rootDir);
        for (Path path : paths) {
            TableName tableName = FSUtils.getTableName((Path)path);
            if ((this.checkMetaOnly || !this.isTableIncluded(tableName)) && !tableName.equals((Object)TableName.META_TABLE_NAME)) continue;
            tableDirs.add(fs.getFileStatus(path));
        }
        if (!foundVersionFile) {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.NO_VERSION_FILE, "Version file does not exist in root dir " + rootDir);
            if (this.shouldFixVersionFile()) {
                LOG.info("Trying to create a new hbase.version file.");
                this.setShouldRerun();
                FSUtils.setVersion(fs, rootDir, this.getConf().getInt("hbase.server.thread.wakefrequency", 10000), this.getConf().getInt("hbase.server.versionfile.writeattempts", 3));
            }
        }
        for (FileStatus tableDir : tableDirs) {
            LOG.debug("Loading region dirs from " + tableDir.getPath());
            WorkItemHdfsDir item = new WorkItemHdfsDir(fs, this.errors, tableDir);
            try {
                item.call();
            }
            catch (ExecutionException e) {
                LOG.warn("Could not completely load table dir " + tableDir.getPath(), e.getCause());
            }
        }
        this.errors.print("");
    }

    private boolean recordMetaRegion() throws IOException {
        RegionLocations rl = this.connection.locateRegion(TableName.META_TABLE_NAME, HConstants.EMPTY_START_ROW, false, false);
        if (rl == null) {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.NULL_META_REGION, "META region was not found in ZooKeeper");
            return false;
        }
        for (HRegionLocation metaLocation : rl.getRegionLocations()) {
            if (metaLocation == null) {
                this.errors.reportError(HbckErrorReporter.ERROR_CODE.NULL_META_REGION, "META region location is null");
                return false;
            }
            if (metaLocation.getRegionInfo() == null) {
                this.errors.reportError(HbckErrorReporter.ERROR_CODE.NULL_META_REGION, "META location regionInfo is null");
                return false;
            }
            if (metaLocation.getHostname() == null) {
                this.errors.reportError(HbckErrorReporter.ERROR_CODE.NULL_META_REGION, "META location hostName is null");
                return false;
            }
            ServerName sn = metaLocation.getServerName();
            HbckRegionInfo.MetaEntry m = new HbckRegionInfo.MetaEntry(metaLocation.getRegion(), sn, EnvironmentEdgeManager.currentTime());
            HbckRegionInfo hbckRegionInfo = this.regionInfoMap.get(metaLocation.getRegion().getEncodedName());
            if (hbckRegionInfo == null) {
                this.regionInfoMap.put(metaLocation.getRegion().getEncodedName(), new HbckRegionInfo(m));
                continue;
            }
            hbckRegionInfo.setMetaEntry(m);
        }
        return true;
    }

    private ZKWatcher createZooKeeperWatcher() throws IOException {
        return new ZKWatcher(this.getConf(), "hbase Fsck", new Abortable(){

            public void abort(String why, Throwable e) {
                LOG.error(why, e);
                System.exit(1);
            }

            public boolean isAborted() {
                return false;
            }
        });
    }

    private ServerName getMetaRegionServerName(int replicaId) throws IOException, KeeperException {
        return new MetaTableLocator().getMetaRegionLocation(this.zkw, replicaId);
    }

    void processRegionServers(Collection<ServerName> regionServerList) throws IOException, InterruptedException {
        ArrayList<WorkItemRegion> workItems = new ArrayList<WorkItemRegion>(regionServerList.size());
        for (ServerName rsinfo : regionServerList) {
            workItems.add(new WorkItemRegion(this, rsinfo, this.errors, this.connection));
        }
        List workFutures = this.executor.invokeAll(workItems);
        for (int i = 0; i < workFutures.size(); ++i) {
            WorkItemRegion item = (WorkItemRegion)workItems.get(i);
            Future f = workFutures.get(i);
            try {
                f.get();
                continue;
            }
            catch (ExecutionException e) {
                LOG.warn("Could not process regionserver " + item.rsinfo.getHostAndPort(), e.getCause());
            }
        }
    }

    private void checkAndFixConsistency() throws IOException, KeeperException, InterruptedException {
        ArrayList<CheckRegionConsistencyWorkItem> workItems = new ArrayList<CheckRegionConsistencyWorkItem>(this.regionInfoMap.size());
        for (Map.Entry<String, HbckRegionInfo> e : this.regionInfoMap.entrySet()) {
            if (e.getValue().getReplicaId() != 0) continue;
            workItems.add(new CheckRegionConsistencyWorkItem(e.getKey(), e.getValue()));
        }
        this.checkRegionConsistencyConcurrently(workItems);
        boolean prevHdfsCheck = this.shouldCheckHdfs();
        this.setCheckHdfs(false);
        ArrayList<CheckRegionConsistencyWorkItem> replicaWorkItems = new ArrayList<CheckRegionConsistencyWorkItem>(this.regionInfoMap.size());
        for (Map.Entry<String, HbckRegionInfo> e : this.regionInfoMap.entrySet()) {
            if (e.getValue().getReplicaId() == 0) continue;
            replicaWorkItems.add(new CheckRegionConsistencyWorkItem(e.getKey(), e.getValue()));
        }
        this.checkRegionConsistencyConcurrently(replicaWorkItems);
        this.setCheckHdfs(prevHdfsCheck);
        int terminateThreshold = this.getConf().getInt("hbase.hbck.skipped.regions.limit", 0);
        int numOfSkippedRegions = this.skippedRegions.size();
        if (numOfSkippedRegions > 0 && numOfSkippedRegions > terminateThreshold) {
            throw new IOException(numOfSkippedRegions + " region(s) could not be checked or repaired.  See logs for detail.");
        }
        if (this.shouldCheckHdfs()) {
            this.checkAndFixTableStates();
        }
    }

    private void checkRegionConsistencyConcurrently(List<CheckRegionConsistencyWorkItem> workItems) throws IOException, KeeperException, InterruptedException {
        if (workItems.isEmpty()) {
            return;
        }
        List workFutures = this.executor.invokeAll(workItems);
        for (Future f : workFutures) {
            try {
                f.get();
            }
            catch (ExecutionException e1) {
                LOG.warn("Could not check region consistency ", e1.getCause());
                if (e1.getCause() instanceof IOException) {
                    throw (IOException)e1.getCause();
                }
                if (e1.getCause() instanceof KeeperException) {
                    throw (KeeperException)e1.getCause();
                }
                if (e1.getCause() instanceof InterruptedException) {
                    throw (InterruptedException)e1.getCause();
                }
                throw new IOException(e1.getCause());
            }
        }
    }

    private void addSkippedRegion(HbckRegionInfo hbi) {
        Set<String> skippedRegionNames = this.skippedRegions.get(hbi.getTableName());
        if (skippedRegionNames == null) {
            skippedRegionNames = new HashSet<String>();
        }
        skippedRegionNames.add(hbi.getRegionNameAsString());
        this.skippedRegions.put(hbi.getTableName(), skippedRegionNames);
    }

    private void checkAndFixTableStates() throws IOException {
        for (Map.Entry<TableName, TableState> entry : this.tableStates.entrySet()) {
            TableName tableName = entry.getKey();
            TableState tableState = entry.getValue();
            HbckTableInfo tableInfo = (HbckTableInfo)this.tablesInfo.get(tableName);
            if (!this.isTableIncluded(tableName) || tableName.isSystemTable() || tableInfo != null) continue;
            if (this.fixMeta) {
                MetaTableAccessor.deleteTableState((Connection)this.connection, (TableName)tableName);
                TableState state = MetaTableAccessor.getTableState((Connection)this.connection, (TableName)tableName);
                if (state == null) continue;
                this.errors.reportError(HbckErrorReporter.ERROR_CODE.ORPHAN_TABLE_STATE, tableName + " unable to delete dangling table state " + tableState);
                continue;
            }
            if (this.checkMetaOnly) continue;
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.ORPHAN_TABLE_STATE, tableName + " has dangling table state " + tableState);
        }
        for (TableName tableName : this.tablesInfo.keySet()) {
            if (!this.isTableIncluded(tableName) || this.tableStates.containsKey(tableName)) continue;
            if (this.fixMeta) {
                MetaTableAccessor.updateTableState((Connection)this.connection, (TableName)tableName, (TableState.State)TableState.State.ENABLED);
                TableState newState = MetaTableAccessor.getTableState((Connection)this.connection, (TableName)tableName);
                if (newState != null) continue;
                this.errors.reportError(HbckErrorReporter.ERROR_CODE.NO_TABLE_STATE, "Unable to change state for table " + tableName + " in meta ");
                continue;
            }
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.NO_TABLE_STATE, tableName + " has no state in meta ");
        }
    }

    private void preCheckPermission() throws IOException, AccessDeniedException {
        FileStatus[] files;
        if (this.shouldIgnorePreCheckPermission()) {
            return;
        }
        Path hbaseDir = FSUtils.getRootDir((Configuration)this.getConf());
        FileSystem fs = hbaseDir.getFileSystem(this.getConf());
        UserProvider userProvider = UserProvider.instantiate((Configuration)this.getConf());
        UserGroupInformation ugi = userProvider.getCurrent().getUGI();
        for (FileStatus file : files = fs.listStatus(hbaseDir)) {
            try {
                FSUtils.checkAccess(ugi, file, FsAction.WRITE);
            }
            catch (AccessDeniedException ace) {
                LOG.warn("Got AccessDeniedException when preCheckPermission ", (Throwable)ace);
                this.errors.reportError(HbckErrorReporter.ERROR_CODE.WRONG_USAGE, "Current user " + ugi.getUserName() + " does not have write perms to " + file.getPath() + ". Please rerun hbck as hdfs user " + file.getOwner());
                throw ace;
            }
        }
    }

    private void deleteMetaRegion(HbckRegionInfo hi) throws IOException {
        this.deleteMetaRegion(hi.getMetaEntry().getRegionName());
    }

    private void deleteMetaRegion(byte[] metaKey) throws IOException {
        Delete d = new Delete(metaKey);
        this.meta.delete(d);
        LOG.info("Deleted " + Bytes.toString((byte[])metaKey) + " from META");
    }

    private void resetSplitParent(HbckRegionInfo hi) throws IOException {
        RowMutations mutations = new RowMutations(hi.getMetaEntry().getRegionName());
        Delete d = new Delete(hi.getMetaEntry().getRegionName());
        d.addColumn(HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER);
        d.addColumn(HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER);
        mutations.add(d);
        RegionInfo hri = RegionInfoBuilder.newBuilder((RegionInfo)hi.getMetaEntry()).setOffline(false).setSplit(false).build();
        Put p = MetaTableAccessor.makePutFromRegionInfo((RegionInfo)hri, (long)EnvironmentEdgeManager.currentTime());
        mutations.add(p);
        this.meta.mutateRow(mutations);
        LOG.info("Reset split parent " + hi.getMetaEntry().getRegionNameAsString() + " in META");
    }

    void offline(byte[] regionName) throws IOException {
        String regionString = Bytes.toStringBinary((byte[])regionName);
        if (!rsSupportsOffline) {
            LOG.warn("Using unassign region " + regionString + " instead of using offline method, you should restart HMaster after these repairs");
            this.admin.unassign(regionName, true);
            return;
        }
        try {
            LOG.info("Offlining region " + regionString);
            this.admin.offline(regionName);
        }
        catch (IOException ioe) {
            String notFoundMsg = "java.lang.NoSuchMethodException: org.apache.hadoop.hbase.master.HMaster.offline([B)";
            if (ioe.getMessage().contains(notFoundMsg)) {
                LOG.warn("Using unassign region " + regionString + " instead of using offline method, you should restart HMaster after these repairs");
                rsSupportsOffline = false;
                this.admin.unassign(regionName, true);
                return;
            }
            throw ioe;
        }
    }

    void closeRegion(HbckRegionInfo hi) throws IOException, InterruptedException {
        Result r;
        RegionLocations rl;
        if (hi.getMetaEntry() == null && hi.getHdfsEntry() == null) {
            this.undeployRegions(hi);
            return;
        }
        Get get = new Get(hi.getRegionName());
        get.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        get.addColumn(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
        get.addColumn(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER);
        if (hi.getReplicaId() == 0) {
            int numReplicas = this.admin.getTableDescriptor(hi.getTableName()).getRegionReplication();
            for (int i = 0; i < numReplicas; ++i) {
                get.addColumn(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn((int)i));
                get.addColumn(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn((int)i));
            }
        }
        if ((rl = MetaTableAccessor.getRegionLocations((Result)(r = this.meta.get(get)))) == null) {
            LOG.warn("Unable to close region " + hi.getRegionNameAsString() + " since meta does not have handle to reach it");
            return;
        }
        for (HRegionLocation h : rl.getRegionLocations()) {
            ServerName serverName = h.getServerName();
            if (serverName == null) {
                this.errors.reportError("Unable to close region " + hi.getRegionNameAsString() + " because meta does not have handle to reach it.");
                continue;
            }
            HRegionInfo hri = h.getRegionInfo();
            if (hri == null) {
                LOG.warn("Unable to close region " + hi.getRegionNameAsString() + " because hbase:meta had invalid or missing " + "info" + ":" + Bytes.toString((byte[])HConstants.REGIONINFO_QUALIFIER) + " qualifier value.");
                continue;
            }
            HBaseFsckRepair.closeRegionSilentlyAndWait((Connection)this.connection, serverName, (RegionInfo)hri);
        }
    }

    private void undeployRegions(HbckRegionInfo hi) throws IOException, InterruptedException {
        this.undeployRegionsForHbi(hi);
        if (hi.getReplicaId() != 0) {
            return;
        }
        int numReplicas = this.admin.getDescriptor(hi.getTableName()).getRegionReplication();
        for (int i = 1; i < numReplicas; ++i) {
            RegionInfo hri;
            HbckRegionInfo h;
            if (hi.getPrimaryHRIForDeployedReplica() == null || (h = this.regionInfoMap.get((hri = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)hi.getPrimaryHRIForDeployedReplica(), (int)i)).getEncodedName())) == null) continue;
            this.undeployRegionsForHbi(h);
            h.setSkipChecks(true);
        }
    }

    private void undeployRegionsForHbi(HbckRegionInfo hi) throws IOException, InterruptedException {
        for (HbckRegionInfo.OnlineEntry rse : hi.getOnlineEntries()) {
            LOG.debug("Undeploy region " + rse.getRegionInfo() + " from " + rse.getServerName());
            try {
                HBaseFsckRepair.closeRegionSilentlyAndWait((Connection)this.connection, rse.getServerName(), rse.getRegionInfo());
                this.offline(rse.getRegionInfo().getRegionName());
            }
            catch (IOException ioe) {
                LOG.warn("Got exception when attempting to offline region " + Bytes.toString((byte[])rse.getRegionInfo().getRegionName()), (Throwable)ioe);
            }
        }
    }

    private void tryAssignmentRepair(HbckRegionInfo hbi, String msg) throws IOException, KeeperException, InterruptedException {
        if (this.shouldFixAssignments()) {
            this.errors.print(msg);
            this.undeployRegions(hbi);
            this.setShouldRerun();
            Object hri = hbi.getHdfsHRI();
            if (hri == null) {
                hri = hbi.getMetaEntry();
            }
            HBaseFsckRepair.fixUnassigned(this.admin, hri);
            HBaseFsckRepair.waitUntilAssigned(this.admin, hri);
            if (hbi.getReplicaId() != 0) {
                return;
            }
            int replicationCount = this.admin.getTableDescriptor(hri.getTable()).getRegionReplication();
            for (int i = 1; i < replicationCount; ++i) {
                HbckRegionInfo h = this.regionInfoMap.get((hri = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)hri, (int)i)).getEncodedName());
                if (h != null) {
                    this.undeployRegions(h);
                    h.setSkipChecks(true);
                }
                HBaseFsckRepair.fixUnassigned(this.admin, hri);
                HBaseFsckRepair.waitUntilAssigned(this.admin, hri);
            }
        }
    }

    private void checkRegionConsistency(String key, HbckRegionInfo hbi) throws IOException, KeeperException, InterruptedException {
        boolean recentlyModified;
        if (hbi.isSkipChecks()) {
            return;
        }
        String descriptiveName = hbi.toString();
        boolean inMeta = hbi.getMetaEntry() != null;
        boolean inHdfs = !this.shouldCheckHdfs() || hbi.getHdfsRegionDir() != null;
        boolean hasMetaAssignment = inMeta && hbi.getMetaEntry().regionServer != null;
        boolean isDeployed = !hbi.getDeployedOn().isEmpty();
        boolean isMultiplyDeployed = hbi.getDeployedOn().size() > 1;
        boolean deploymentMatchesMeta = hasMetaAssignment && isDeployed && !isMultiplyDeployed && hbi.getMetaEntry().regionServer.equals((Object)hbi.getDeployedOn().get(0));
        boolean splitParent = inMeta && hbi.getMetaEntry().isSplit() && hbi.getMetaEntry().isOffline();
        boolean shouldBeDeployed = inMeta && !this.isTableDisabled(hbi.getMetaEntry().getTable());
        boolean bl = recentlyModified = inHdfs && hbi.getModTime() + this.timelag > EnvironmentEdgeManager.currentTime();
        if (hbi.containsOnlyHdfsEdits()) {
            return;
        }
        if (inMeta && inHdfs && isDeployed && deploymentMatchesMeta && shouldBeDeployed) {
            return;
        }
        if (inMeta && inHdfs && !shouldBeDeployed && !isDeployed) {
            LOG.info("Region " + descriptiveName + " is in META, and in a disabled tabled that is not deployed");
            return;
        }
        if (recentlyModified) {
            LOG.warn("Region " + descriptiveName + " was recently modified -- skipping");
            return;
        }
        if (!(inMeta || inHdfs || isDeployed)) {
            assert (false) : "Entry for region with no data";
        } else if (!inMeta && !inHdfs && isDeployed) {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.NOT_IN_META_HDFS, "Region " + descriptiveName + ", key=" + key + ", not on HDFS or in hbase:meta but deployed on " + Joiner.on((String)", ").join(hbi.getDeployedOn()));
            if (this.shouldFixAssignments()) {
                this.undeployRegions(hbi);
            }
        } else if (!inMeta && inHdfs && !isDeployed) {
            if (hbi.isMerged()) {
                hbi.setSkipChecks(true);
                LOG.info("Region " + descriptiveName + " got merge recently, its file(s) will be cleaned by CatalogJanitor later");
                return;
            }
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, "Region " + descriptiveName + " on HDFS, but not listed in hbase:meta or deployed on any region server");
            if (this.shouldFixMeta()) {
                if (!hbi.isHdfsRegioninfoPresent()) {
                    LOG.error("Region " + hbi.getHdfsHRI() + " could have been repaired in table integrity repair phase if -fixHdfsOrphans was used.");
                    return;
                }
                RegionInfo hri = hbi.getHdfsHRI();
                HbckTableInfo tableInfo = (HbckTableInfo)this.tablesInfo.get(hri.getTable());
                for (RegionInfo region : tableInfo.getRegionsFromMeta(this.regionInfoMap)) {
                    if (Bytes.compareTo((byte[])region.getStartKey(), (byte[])hri.getStartKey()) > 0 || region.getEndKey().length != 0 && Bytes.compareTo((byte[])region.getEndKey(), (byte[])hri.getEndKey()) < 0 || Bytes.compareTo((byte[])region.getStartKey(), (byte[])hri.getEndKey()) > 0 || region.isSplit() || region.isOffline()) continue;
                    Path regionDir = hbi.getHdfsRegionDir();
                    FileSystem fs = regionDir.getFileSystem(this.getConf());
                    List<Path> familyDirs = FSUtils.getFamilyDirs(fs, regionDir);
                    for (Path familyDir : familyDirs) {
                        List<Path> referenceFilePaths = FSUtils.getReferenceFilePaths(fs, familyDir);
                        for (Path referenceFilePath : referenceFilePaths) {
                            Path parentRegionDir = StoreFileInfo.getReferredToFile(referenceFilePath).getParent().getParent();
                            if (!parentRegionDir.toString().endsWith(region.getEncodedName())) continue;
                            LOG.warn(hri + " start and stop keys are in the range of " + region + ". The region might not be cleaned up from hdfs when region " + region + " split failed. Hence deleting from hdfs.");
                            HRegionFileSystem.deleteRegionFromFileSystem(this.getConf(), fs, regionDir.getParent(), hri);
                            return;
                        }
                    }
                }
                LOG.info("Patching hbase:meta with .regioninfo: " + hbi.getHdfsHRI());
                int numReplicas = this.admin.getTableDescriptor(hbi.getTableName()).getRegionReplication();
                HBaseFsckRepair.fixMetaHoleOnlineAndAddReplicas(this.getConf(), hbi.getHdfsHRI(), this.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet(), numReplicas);
                this.tryAssignmentRepair(hbi, "Trying to reassign region...");
            }
        } else if (!inMeta && inHdfs && isDeployed) {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.NOT_IN_META, "Region " + descriptiveName + " not in META, but deployed on " + Joiner.on((String)", ").join(hbi.getDeployedOn()));
            this.debugLsr(hbi.getHdfsRegionDir());
            if (hbi.getReplicaId() != 0 && this.shouldFixAssignments()) {
                this.undeployRegionsForHbi(hbi);
            }
            if (this.shouldFixMeta() && hbi.getReplicaId() == 0) {
                if (!hbi.isHdfsRegioninfoPresent()) {
                    LOG.error("This should have been repaired in table integrity repair phase");
                    return;
                }
                LOG.info("Patching hbase:meta with with .regioninfo: " + hbi.getHdfsHRI());
                int numReplicas = this.admin.getTableDescriptor(hbi.getTableName()).getRegionReplication();
                HBaseFsckRepair.fixMetaHoleOnlineAndAddReplicas(this.getConf(), hbi.getHdfsHRI(), this.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet(), numReplicas);
                this.tryAssignmentRepair(hbi, "Trying to fix unassigned region...");
            }
        } else if (inMeta && inHdfs && !isDeployed && splitParent) {
            if (hbi.getMetaEntry().splitA != null && hbi.getMetaEntry().splitB != null) {
                HbckRegionInfo infoA = this.regionInfoMap.get(hbi.getMetaEntry().splitA.getEncodedName());
                HbckRegionInfo infoB = this.regionInfoMap.get(hbi.getMetaEntry().splitB.getEncodedName());
                if (infoA != null && infoB != null) {
                    hbi.setSkipChecks(true);
                    return;
                }
            }
            if (hbi.getReplicaId() != 0) {
                LOG.info("Region " + descriptiveName + " is a split parent in META, in HDFS, and not deployed on any region server. This may be transient.");
                hbi.setSkipChecks(true);
                return;
            }
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.LINGERING_SPLIT_PARENT, "Region " + descriptiveName + " is a split parent in META, in HDFS, and not deployed on any region server. This could be transient, consider to run the catalog janitor first!");
            if (this.shouldFixSplitParents()) {
                this.setShouldRerun();
                this.resetSplitParent(hbi);
            }
        } else if (inMeta && !inHdfs && !isDeployed) {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.NOT_IN_HDFS_OR_DEPLOYED, "Region " + descriptiveName + " found in META, but not in HDFS or deployed on any region server.");
            if (this.shouldFixMeta()) {
                this.deleteMetaRegion(hbi);
            }
        } else if (inMeta && !inHdfs && isDeployed) {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.NOT_IN_HDFS, "Region " + descriptiveName + " found in META, but not in HDFS, and deployed on " + Joiner.on((String)", ").join(hbi.getDeployedOn()));
            if (this.shouldFixAssignments()) {
                this.errors.print("Trying to fix unassigned region...");
                this.undeployRegions(hbi);
            }
            if (this.shouldFixMeta()) {
                this.deleteMetaRegion(hbi);
            }
        } else if (inMeta && inHdfs && !isDeployed && shouldBeDeployed) {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.NOT_DEPLOYED, "Region " + descriptiveName + " not deployed on any region server.");
            this.tryAssignmentRepair(hbi, "Trying to fix unassigned region...");
        } else if (inMeta && inHdfs && isDeployed && !shouldBeDeployed) {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.SHOULD_NOT_BE_DEPLOYED, "Region " + descriptiveName + " should not be deployed according to META, but is deployed on " + Joiner.on((String)", ").join(hbi.getDeployedOn()));
            if (this.shouldFixAssignments()) {
                this.errors.print("Trying to close the region " + descriptiveName);
                this.setShouldRerun();
                HBaseFsckRepair.fixMultiAssignment((Connection)this.connection, (RegionInfo)hbi.getMetaEntry(), hbi.getDeployedOn());
            }
        } else if (inMeta && inHdfs && isMultiplyDeployed) {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.MULTI_DEPLOYED, "Region " + descriptiveName + " is listed in hbase:meta on region server " + hbi.getMetaEntry().regionServer + " but is multiply assigned to region servers " + Joiner.on((String)", ").join(hbi.getDeployedOn()));
            if (this.shouldFixAssignments()) {
                this.errors.print("Trying to fix assignment error...");
                this.setShouldRerun();
                HBaseFsckRepair.fixMultiAssignment((Connection)this.connection, (RegionInfo)hbi.getMetaEntry(), hbi.getDeployedOn());
            }
        } else if (inMeta && inHdfs && isDeployed && !deploymentMatchesMeta) {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.SERVER_DOES_NOT_MATCH_META, "Region " + descriptiveName + " listed in hbase:meta on region server " + hbi.getMetaEntry().regionServer + " but found on region server " + hbi.getDeployedOn().get(0));
            if (this.shouldFixAssignments()) {
                this.errors.print("Trying to fix assignment error...");
                this.setShouldRerun();
                HBaseFsckRepair.fixMultiAssignment((Connection)this.connection, (RegionInfo)hbi.getMetaEntry(), hbi.getDeployedOn());
                HBaseFsckRepair.waitUntilAssigned(this.admin, hbi.getHdfsHRI());
            }
        } else {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.UNKNOWN, "Region " + descriptiveName + " is in an unforeseen state: inMeta=" + inMeta + " inHdfs=" + inHdfs + " isDeployed=" + isDeployed + " isMultiplyDeployed=" + isMultiplyDeployed + " deploymentMatchesMeta=" + deploymentMatchesMeta + " shouldBeDeployed=" + shouldBeDeployed);
        }
    }

    SortedMap<TableName, HbckTableInfo> checkIntegrity() throws IOException {
        this.tablesInfo = new TreeMap<TableName, HbckTableInfo>();
        LOG.debug("There are " + this.regionInfoMap.size() + " region info entries");
        for (HbckRegionInfo hbi : this.regionInfoMap.values()) {
            if (hbi.getMetaEntry() == null) {
                Path p = hbi.getHdfsRegionDir();
                if (p != null) continue;
                this.errors.report("No regioninfo in Meta or HDFS. " + hbi);
                continue;
            }
            if (hbi.getMetaEntry().regionServer == null) {
                this.errors.detail("Skipping region because no region server: " + hbi);
                continue;
            }
            if (hbi.getMetaEntry().isOffline()) {
                this.errors.detail("Skipping region because it is offline: " + hbi);
                continue;
            }
            if (hbi.containsOnlyHdfsEdits()) {
                this.errors.detail("Skipping region because it only contains edits" + hbi);
                continue;
            }
            if (hbi.getDeployedOn().isEmpty()) continue;
            TableName tableName = hbi.getMetaEntry().getTable();
            HbckTableInfo modTInfo = (HbckTableInfo)this.tablesInfo.get(tableName);
            if (modTInfo == null) {
                modTInfo = new HbckTableInfo(tableName, this);
            }
            for (ServerName server : hbi.getDeployedOn()) {
                modTInfo.addServer(server);
            }
            if (!hbi.isSkipChecks()) {
                modTInfo.addRegionInfo(hbi);
            }
            this.tablesInfo.put(tableName, modTInfo);
        }
        this.loadTableInfosForTablesWithNoRegion();
        this.logParallelMerge();
        Iterator<Object> iterator = this.tablesInfo.values().iterator();
        while (iterator.hasNext()) {
            HbckTableInfo tInfo;
            HbckTableInfo hbckTableInfo = tInfo = (HbckTableInfo)iterator.next();
            hbckTableInfo.getClass();
            HbckTableInfo.IntegrityFixSuggester handler = new HbckTableInfo.IntegrityFixSuggester(hbckTableInfo, tInfo, this.errors);
            if (tInfo.checkRegionChain(handler)) continue;
            this.errors.report("Found inconsistency in table " + tInfo.getName());
        }
        return this.tablesInfo;
    }

    private void loadTableInfosForTablesWithNoRegion() throws IOException {
        Map<String, TableDescriptor> allTables = new FSTableDescriptors(this.getConf()).getAll();
        for (TableDescriptor htd : allTables.values()) {
            TableName tableName;
            if (this.checkMetaOnly && !htd.isMetaTable() || !this.isTableIncluded(tableName = htd.getTableName()) || this.tablesInfo.containsKey(tableName)) continue;
            HbckTableInfo tableInfo = new HbckTableInfo(tableName, this);
            tableInfo.htds.add(htd);
            this.tablesInfo.put(htd.getTableName(), tableInfo);
        }
    }

    public int mergeRegionDirs(Path targetRegionDir, HbckRegionInfo contained) throws IOException {
        int fileMoves = 0;
        String thread = Thread.currentThread().getName();
        LOG.debug("[" + thread + "] Contained region dir after close and pause");
        this.debugLsr(contained.getHdfsRegionDir());
        FileSystem fs = targetRegionDir.getFileSystem(this.getConf());
        FileStatus[] dirs = null;
        try {
            dirs = fs.listStatus(contained.getHdfsRegionDir());
        }
        catch (FileNotFoundException fnfe) {
            if (!fs.exists(contained.getHdfsRegionDir())) {
                LOG.warn("[" + thread + "] HDFS region dir " + contained.getHdfsRegionDir() + " is missing. Assuming already sidelined or moved.");
            } else {
                this.sidelineRegionDir(fs, contained);
            }
            return fileMoves;
        }
        if (dirs == null) {
            if (!fs.exists(contained.getHdfsRegionDir())) {
                LOG.warn("[" + thread + "] HDFS region dir " + contained.getHdfsRegionDir() + " already sidelined.");
            } else {
                this.sidelineRegionDir(fs, contained);
            }
            return fileMoves;
        }
        for (FileStatus cf : dirs) {
            Path src = cf.getPath();
            Path dst = new Path(targetRegionDir, src.getName());
            if (src.getName().equals(".regioninfo") || src.getName().equals("oldWALs")) continue;
            LOG.info("[" + thread + "] Moving files from " + src + " into containing region " + dst);
            for (FileStatus hfile : fs.listStatus(src)) {
                boolean success = fs.rename(hfile.getPath(), dst);
                if (!success) continue;
                ++fileMoves;
            }
            LOG.debug("[" + thread + "] Sideline directory contents:");
            this.debugLsr(targetRegionDir);
        }
        this.sidelineRegionDir(fs, contained);
        LOG.info("[" + thread + "] Sidelined region dir " + contained.getHdfsRegionDir() + " into " + this.getSidelineDir());
        this.debugLsr(contained.getHdfsRegionDir());
        return fileMoves;
    }

    TableDescriptor[] getTables(AtomicInteger numSkipped) {
        ArrayList<TableName> tableNames = new ArrayList<TableName>();
        long now = EnvironmentEdgeManager.currentTime();
        for (HbckRegionInfo hbi : this.regionInfoMap.values()) {
            HbckRegionInfo.MetaEntry info = hbi.getMetaEntry();
            if (info == null || info.getStartKey().length != 0 || info.isMetaRegion()) continue;
            if (info.modTime + this.timelag < now) {
                tableNames.add(info.getTable());
                continue;
            }
            numSkipped.incrementAndGet();
        }
        return this.getTableDescriptors(tableNames);
    }

    /*
     * Exception decompiling
     */
    TableDescriptor[] getTableDescriptors(List<TableName> tableNames) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized HbckRegionInfo getOrCreateInfo(String name) {
        HbckRegionInfo hbi = this.regionInfoMap.get(name);
        if (hbi == null) {
            hbi = new HbckRegionInfo(null);
            this.regionInfoMap.put(name, hbi);
        }
        return hbi;
    }

    private void checkAndFixReplication() throws ReplicationException {
        ReplicationChecker checker = new ReplicationChecker(this.getConf(), this.zkw, this.errors);
        checker.checkUnDeletedQueues();
        if (checker.hasUnDeletedQueues() && this.fixReplication) {
            checker.fixUnDeletedQueues();
            this.setShouldRerun();
        }
    }

    boolean checkMetaRegion() throws IOException, KeeperException, InterruptedException {
        HashMap<Integer, HbckRegionInfo> metaRegions = new HashMap<Integer, HbckRegionInfo>();
        for (HbckRegionInfo value : this.regionInfoMap.values()) {
            if (value.getMetaEntry() == null || !value.getMetaEntry().isMetaRegion()) continue;
            metaRegions.put(value.getReplicaId(), value);
        }
        int metaReplication = this.admin.getTableDescriptor(TableName.META_TABLE_NAME).getRegionReplication();
        boolean noProblem = true;
        for (int i = 0; i < metaReplication; ++i) {
            HbckRegionInfo metaHbckRegionInfo = (HbckRegionInfo)metaRegions.remove(i);
            List<Object> servers = new ArrayList();
            if (metaHbckRegionInfo != null) {
                servers = metaHbckRegionInfo.getDeployedOn();
            }
            if (servers.size() == 1) continue;
            noProblem = false;
            if (servers.isEmpty()) {
                this.assignMetaReplica(i);
                continue;
            }
            if (servers.size() <= 1) continue;
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.MULTI_META_REGION, "hbase:meta, replicaId " + metaHbckRegionInfo.getReplicaId() + " is found on more than one region.");
            if (!this.shouldFixAssignments()) continue;
            this.errors.print("Trying to fix a problem with hbase:meta, replicaId " + metaHbckRegionInfo.getReplicaId() + "..");
            this.setShouldRerun();
            HBaseFsckRepair.fixMultiAssignment((Connection)this.connection, (RegionInfo)metaHbckRegionInfo.getMetaEntry(), servers);
        }
        for (Map.Entry entry : metaRegions.entrySet()) {
            noProblem = false;
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.SHOULD_NOT_BE_DEPLOYED, "hbase:meta replicas are deployed in excess. Configured " + metaReplication + ", deployed " + metaRegions.size());
            if (!this.shouldFixAssignments()) continue;
            this.errors.print("Trying to undeploy excess replica, replicaId: " + entry.getKey() + " of hbase:meta..");
            this.setShouldRerun();
            this.unassignMetaReplica((HbckRegionInfo)entry.getValue());
        }
        return noProblem;
    }

    private void unassignMetaReplica(HbckRegionInfo hi) throws IOException, InterruptedException, KeeperException {
        this.undeployRegions(hi);
        ZKUtil.deleteNode((ZKWatcher)this.zkw, (String)this.zkw.getZNodePaths().getZNodeForReplica(hi.getMetaEntry().getReplicaId()));
    }

    private void assignMetaReplica(int replicaId) throws IOException, KeeperException, InterruptedException {
        this.errors.reportError(HbckErrorReporter.ERROR_CODE.NO_META_REGION, "hbase:meta, replicaId " + replicaId + " is not found on any region.");
        if (this.shouldFixAssignments()) {
            this.errors.print("Trying to fix a problem with hbase:meta..");
            this.setShouldRerun();
            RegionInfo h = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (int)replicaId);
            HBaseFsckRepair.fixUnassigned(this.admin, h);
            HBaseFsckRepair.waitUntilAssigned(this.admin, h);
        }
    }

    boolean loadMetaEntries() throws IOException {
        MetaTableAccessor.Visitor visitor = new MetaTableAccessor.Visitor(){
            int countRecord = 1;
            final Comparator<Cell> comp = new Comparator<Cell>(){

                @Override
                public int compare(Cell k1, Cell k2) {
                    return Long.compare(k1.getTimestamp(), k2.getTimestamp());
                }
            };

            public boolean visit(Result result) throws IOException {
                try {
                    long ts = Collections.max(result.listCells(), this.comp).getTimestamp();
                    RegionLocations rl = MetaTableAccessor.getRegionLocations((Result)result);
                    if (rl == null) {
                        HBaseFsck.this.emptyRegionInfoQualifiers.add(result);
                        HBaseFsck.this.errors.reportError(HbckErrorReporter.ERROR_CODE.EMPTY_META_CELL, "Empty REGIONINFO_QUALIFIER found in hbase:meta");
                        return true;
                    }
                    ServerName sn = null;
                    if (rl.getRegionLocation(0) == null || rl.getRegionLocation(0).getRegionInfo() == null) {
                        HBaseFsck.this.emptyRegionInfoQualifiers.add(result);
                        HBaseFsck.this.errors.reportError(HbckErrorReporter.ERROR_CODE.EMPTY_META_CELL, "Empty REGIONINFO_QUALIFIER found in hbase:meta");
                        return true;
                    }
                    HRegionInfo hri = rl.getRegionLocation(0).getRegionInfo();
                    if (!HBaseFsck.this.isTableIncluded(hri.getTable()) && !hri.isMetaRegion()) {
                        return true;
                    }
                    PairOfSameType daughters = MetaTableAccessor.getDaughterRegions((Result)result);
                    for (HRegionLocation h : rl.getRegionLocations()) {
                        if (h == null || h.getRegionInfo() == null) continue;
                        sn = h.getServerName();
                        hri = h.getRegionInfo();
                        HbckRegionInfo.MetaEntry m = null;
                        m = hri.getReplicaId() == 0 ? new HbckRegionInfo.MetaEntry((RegionInfo)hri, sn, ts, (RegionInfo)daughters.getFirst(), (RegionInfo)daughters.getSecond()) : new HbckRegionInfo.MetaEntry((RegionInfo)hri, sn, ts, null, null);
                        HbckRegionInfo previous = (HbckRegionInfo)HBaseFsck.this.regionInfoMap.get(hri.getEncodedName());
                        if (previous == null) {
                            HBaseFsck.this.regionInfoMap.put(hri.getEncodedName(), new HbckRegionInfo(m));
                            continue;
                        }
                        if (previous.getMetaEntry() == null) {
                            previous.setMetaEntry(m);
                            continue;
                        }
                        throw new IOException("Two entries in hbase:meta are same " + previous);
                    }
                    List mergeParents = MetaTableAccessor.getMergeRegions((Cell[])result.rawCells());
                    if (mergeParents != null) {
                        for (RegionInfo mergeRegion : mergeParents) {
                            if (mergeRegion == null) continue;
                            HbckRegionInfo hbInfo = HBaseFsck.this.getOrCreateInfo(mergeRegion.getEncodedName());
                            hbInfo.setMerged(true);
                        }
                    }
                    if (this.countRecord % 100 == 0) {
                        HBaseFsck.this.errors.progress();
                    }
                    ++this.countRecord;
                    return true;
                }
                catch (RuntimeException e) {
                    LOG.error("Result=" + result);
                    throw e;
                }
            }
        };
        if (!this.checkMetaOnly) {
            MetaTableAccessor.fullScanRegions((Connection)this.connection, (MetaTableAccessor.Visitor)visitor);
        }
        this.errors.print("");
        return true;
    }

    private void printTableSummary(SortedMap<TableName, HbckTableInfo> tablesInfo) {
        StringBuilder sb = new StringBuilder();
        this.errors.print("Summary:");
        for (HbckTableInfo tInfo : tablesInfo.values()) {
            int numOfSkippedRegions;
            int n = numOfSkippedRegions = this.skippedRegions.containsKey(tInfo.getName()) ? this.skippedRegions.get(tInfo.getName()).size() : 0;
            if (this.errors.tableHasErrors(tInfo)) {
                this.errors.print("Table " + tInfo.getName() + " is inconsistent.");
            } else if (numOfSkippedRegions > 0) {
                this.errors.print("Table " + tInfo.getName() + " is okay (with " + numOfSkippedRegions + " skipped regions).");
            } else {
                this.errors.print("Table " + tInfo.getName() + " is okay.");
            }
            this.errors.print("    Number of regions: " + tInfo.getNumRegions());
            if (numOfSkippedRegions > 0) {
                Set<String> skippedRegionStrings = this.skippedRegions.get(tInfo.getName());
                System.out.println("    Number of skipped regions: " + numOfSkippedRegions);
                System.out.println("      List of skipped regions:");
                for (String sr : skippedRegionStrings) {
                    System.out.println("        " + sr);
                }
            }
            sb.setLength(0);
            sb.append("    Deployed on: ");
            for (ServerName server : tInfo.deployedOn) {
                sb.append(" " + server.toString());
            }
            this.errors.print(sb.toString());
        }
    }

    static HbckErrorReporter getErrorReporter(Configuration conf) throws ClassNotFoundException {
        Class reporter = conf.getClass("hbasefsck.errorreporter", PrintingErrorReporter.class, HbckErrorReporter.class);
        return (HbckErrorReporter)ReflectionUtils.newInstance((Class)reporter, (Configuration)conf);
    }

    public static void setDisplayFullReport() {
        details = true;
    }

    public static boolean shouldDisplayFullReport() {
        return details;
    }

    public static void setForceExclusive() {
        forceExclusive = true;
    }

    public boolean isExclusive() {
        return this.fixAny || forceExclusive;
    }

    static void setSummary() {
        summary = true;
    }

    void setCheckMetaOnly() {
        this.checkMetaOnly = true;
    }

    void setRegionBoundariesCheck() {
        this.checkRegionBoundaries = true;
    }

    public void setFixReplication(boolean shouldFix) {
        this.fixReplication = shouldFix;
        this.fixAny |= shouldFix;
    }

    public void setCleanReplicationBarrier(boolean shouldClean) {
        this.cleanReplicationBarrier = shouldClean;
    }

    void setShouldRerun() {
        this.rerun = true;
    }

    public boolean shouldRerun() {
        return this.rerun;
    }

    public void setFixAssignments(boolean shouldFix) {
        this.fixAssignments = shouldFix;
        this.fixAny |= shouldFix;
    }

    boolean shouldFixAssignments() {
        return this.fixAssignments;
    }

    public void setFixMeta(boolean shouldFix) {
        this.fixMeta = shouldFix;
        this.fixAny |= shouldFix;
    }

    boolean shouldFixMeta() {
        return this.fixMeta;
    }

    public void setFixEmptyMetaCells(boolean shouldFix) {
        this.fixEmptyMetaCells = shouldFix;
        this.fixAny |= shouldFix;
    }

    boolean shouldFixEmptyMetaCells() {
        return this.fixEmptyMetaCells;
    }

    public void setCheckHdfs(boolean checking) {
        this.checkHdfs = checking;
    }

    boolean shouldCheckHdfs() {
        return this.checkHdfs;
    }

    public void setFixHdfsHoles(boolean shouldFix) {
        this.fixHdfsHoles = shouldFix;
        this.fixAny |= shouldFix;
    }

    boolean shouldFixHdfsHoles() {
        return this.fixHdfsHoles;
    }

    public void setFixTableOrphans(boolean shouldFix) {
        this.fixTableOrphans = shouldFix;
        this.fixAny |= shouldFix;
    }

    boolean shouldFixTableOrphans() {
        return this.fixTableOrphans;
    }

    public void setFixHdfsOverlaps(boolean shouldFix) {
        this.fixHdfsOverlaps = shouldFix;
        this.fixAny |= shouldFix;
    }

    boolean shouldFixHdfsOverlaps() {
        return this.fixHdfsOverlaps;
    }

    public void setFixHdfsOrphans(boolean shouldFix) {
        this.fixHdfsOrphans = shouldFix;
        this.fixAny |= shouldFix;
    }

    boolean shouldFixHdfsOrphans() {
        return this.fixHdfsOrphans;
    }

    public void setFixVersionFile(boolean shouldFix) {
        this.fixVersionFile = shouldFix;
        this.fixAny |= shouldFix;
    }

    public boolean shouldFixVersionFile() {
        return this.fixVersionFile;
    }

    public void setSidelineBigOverlaps(boolean sbo) {
        this.sidelineBigOverlaps = sbo;
    }

    public boolean shouldSidelineBigOverlaps() {
        return this.sidelineBigOverlaps;
    }

    public void setFixSplitParents(boolean shouldFix) {
        this.fixSplitParents = shouldFix;
        this.fixAny |= shouldFix;
    }

    public void setRemoveParents(boolean shouldFix) {
        this.removeParents = shouldFix;
        this.fixAny |= shouldFix;
    }

    boolean shouldFixSplitParents() {
        return this.fixSplitParents;
    }

    boolean shouldRemoveParents() {
        return this.removeParents;
    }

    public void setFixReferenceFiles(boolean shouldFix) {
        this.fixReferenceFiles = shouldFix;
        this.fixAny |= shouldFix;
    }

    boolean shouldFixReferenceFiles() {
        return this.fixReferenceFiles;
    }

    public void setFixHFileLinks(boolean shouldFix) {
        this.fixHFileLinks = shouldFix;
        this.fixAny |= shouldFix;
    }

    boolean shouldFixHFileLinks() {
        return this.fixHFileLinks;
    }

    public boolean shouldIgnorePreCheckPermission() {
        return !this.fixAny || this.ignorePreCheckPermission;
    }

    public void setIgnorePreCheckPermission(boolean ignorePreCheckPermission) {
        this.ignorePreCheckPermission = ignorePreCheckPermission;
    }

    public void setMaxMerge(int mm) {
        this.maxMerge = mm;
    }

    public int getMaxMerge() {
        return this.maxMerge;
    }

    public void setMaxOverlapsToSideline(int mo) {
        this.maxOverlapsToSideline = mo;
    }

    public int getMaxOverlapsToSideline() {
        return this.maxOverlapsToSideline;
    }

    boolean isTableIncluded(TableName table) {
        return this.tablesIncluded.isEmpty() || this.tablesIncluded.contains(table);
    }

    public void includeTable(TableName table) {
        this.tablesIncluded.add(table);
    }

    Set<TableName> getIncludedTables() {
        return new HashSet<TableName>(this.tablesIncluded);
    }

    public void setTimeLag(long seconds) {
        this.timelag = seconds * 1000L;
    }

    public void setSidelineDir(String sidelineDir) {
        this.sidelineDir = new Path(sidelineDir);
    }

    protected HFileCorruptionChecker createHFileCorruptionChecker(boolean sidelineCorruptHFiles) throws IOException {
        return new HFileCorruptionChecker(this.getConf(), this.executor, sidelineCorruptHFiles);
    }

    public HFileCorruptionChecker getHFilecorruptionChecker() {
        return this.hfcc;
    }

    public void setHFileCorruptionChecker(HFileCorruptionChecker hfcc) {
        this.hfcc = hfcc;
    }

    public void setRetCode(int code) {
        this.retcode = code;
    }

    public int getRetCode() {
        return this.retcode;
    }

    protected HBaseFsck printUsageAndExit() {
        StringWriter sw = new StringWriter(2048);
        PrintWriter out = new PrintWriter(sw);
        out.println("");
        out.println("-----------------------------------------------------------------------");
        out.println("NOTE: As of HBase version 2.0, the hbck tool is significantly changed.");
        out.println("In general, all Read-Only options are supported and can be be used");
        out.println("safely. Most -fix/ -repair options are NOT supported. Please see usage");
        out.println("below for details on which options are not supported.");
        out.println("-----------------------------------------------------------------------");
        out.println("");
        out.println("Usage: fsck [opts] {only tables}");
        out.println(" where [opts] are:");
        out.println("   -help Display help options (this)");
        out.println("   -details Display full report of all regions.");
        out.println("   -timelag <timeInSeconds>  Process only regions that  have not experienced any metadata updates in the last  <timeInSeconds> seconds.");
        out.println("   -sleepBeforeRerun <timeInSeconds> Sleep this many seconds before checking if the fix worked if run with -fix");
        out.println("   -summary Print only summary of the tables and status.");
        out.println("   -metaonly Only check the state of the hbase:meta table.");
        out.println("   -sidelineDir <hdfs://> HDFS path to backup existing meta.");
        out.println("   -boundaries Verify that regions boundaries are the same between META and store files.");
        out.println("   -exclusive Abort if another hbck is exclusive or fixing.");
        out.println("");
        out.println("  Datafile Repair options: (expert features, use with caution!)");
        out.println("   -checkCorruptHFiles     Check all Hfiles by opening them to make sure they are valid");
        out.println("   -sidelineCorruptHFiles  Quarantine corrupted HFiles.  implies -checkCorruptHFiles");
        out.println("");
        out.println(" Replication options");
        out.println("   -fixReplication   Deletes replication queues for removed peers");
        out.println("");
        out.println("  Metadata Repair options supported as of version 2.0: (expert features, use with caution!)");
        out.println("   -fixVersionFile   Try to fix missing hbase.version file in hdfs.");
        out.println("   -fixReferenceFiles  Try to offline lingering reference store files");
        out.println("   -fixHFileLinks  Try to offline lingering HFileLinks");
        out.println("   -noHdfsChecking   Don't load/check region info from HDFS. Assumes hbase:meta region info is good. Won't check/fix any HDFS issue, e.g. hole, orphan, or overlap");
        out.println("   -ignorePreCheckPermission  ignore filesystem permission pre-check");
        out.println("");
        out.println("NOTE: Following options are NOT supported as of HBase version 2.0+.");
        out.println("");
        out.println("  UNSUPPORTED Metadata Repair options: (expert features, use with caution!)");
        out.println("   -fix              Try to fix region assignments.  This is for backwards compatiblity");
        out.println("   -fixAssignments   Try to fix region assignments.  Replaces the old -fix");
        out.println("   -fixMeta          Try to fix meta problems.  This assumes HDFS region info is good.");
        out.println("   -fixHdfsHoles     Try to fix region holes in hdfs.");
        out.println("   -fixHdfsOrphans   Try to fix region dirs with no .regioninfo file in hdfs");
        out.println("   -fixTableOrphans  Try to fix table dirs with no .tableinfo file in hdfs (online mode only)");
        out.println("   -fixHdfsOverlaps  Try to fix region overlaps in hdfs.");
        out.println("   -maxMerge <n>     When fixing region overlaps, allow at most <n> regions to merge. (n=5 by default)");
        out.println("   -sidelineBigOverlaps  When fixing region overlaps, allow to sideline big overlaps");
        out.println("   -maxOverlapsToSideline <n>  When fixing region overlaps, allow at most <n> regions to sideline per group. (n=2 by default)");
        out.println("   -fixSplitParents  Try to force offline split parents to be online.");
        out.println("   -removeParents    Try to offline and sideline lingering parents and keep daughter regions.");
        out.println("   -fixEmptyMetaCells  Try to fix hbase:meta entries not referencing any region (empty REGIONINFO_QUALIFIER rows)");
        out.println("");
        out.println("  UNSUPPORTED Metadata Repair shortcuts");
        out.println("   -repair           Shortcut for -fixAssignments -fixMeta -fixHdfsHoles -fixHdfsOrphans -fixHdfsOverlaps -fixVersionFile -sidelineBigOverlaps -fixReferenceFiles-fixHFileLinks");
        out.println("   -repairHoles      Shortcut for -fixAssignments -fixMeta -fixHdfsHoles");
        out.println("");
        out.println(" Replication options");
        out.println("   -fixReplication   Deletes replication queues for removed peers");
        out.println("   -cleanReplicationBrarier [tableName] clean the replication barriers of a specified table, tableName is required");
        out.flush();
        this.errors.reportError(HbckErrorReporter.ERROR_CODE.WRONG_USAGE, sw.toString());
        this.setRetCode(-2);
        return this;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        Path hbasedir = FSUtils.getRootDir((Configuration)conf);
        URI defaultFs = hbasedir.getFileSystem(conf).getUri();
        FSUtils.setFsDefault((Configuration)conf, (Path)new Path(defaultFs));
        int ret = ToolRunner.run((Tool)new HBaseFsckTool(conf), (String[])args);
        System.exit(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HBaseFsck exec(ExecutorService exec, String[] args) throws KeeperException, IOException, InterruptedException, ReplicationException {
        block63: {
            long sleepBeforeRerun = 10000L;
            boolean checkCorruptHFiles = false;
            boolean sidelineCorruptHFiles = false;
            for (int i = 0; i < args.length; ++i) {
                String cmd = args[i];
                if (cmd.equals("-help") || cmd.equals("-h")) {
                    return this.printUsageAndExit();
                }
                if (cmd.equals("-details")) {
                    HBaseFsck.setDisplayFullReport();
                    continue;
                }
                if (cmd.equals("-exclusive")) {
                    HBaseFsck.setForceExclusive();
                    continue;
                }
                if (cmd.equals("-timelag")) {
                    if (i == args.length - 1) {
                        this.errors.reportError(HbckErrorReporter.ERROR_CODE.WRONG_USAGE, "HBaseFsck: -timelag needs a value.");
                        return this.printUsageAndExit();
                    }
                    try {
                        long timelag = Long.parseLong(args[++i]);
                        this.setTimeLag(timelag);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.errors.reportError(HbckErrorReporter.ERROR_CODE.WRONG_USAGE, "-timelag needs a numeric value.");
                        return this.printUsageAndExit();
                    }
                }
                if (cmd.equals("-sleepBeforeRerun")) {
                    if (i == args.length - 1) {
                        this.errors.reportError(HbckErrorReporter.ERROR_CODE.WRONG_USAGE, "HBaseFsck: -sleepBeforeRerun needs a value.");
                        return this.printUsageAndExit();
                    }
                    try {
                        sleepBeforeRerun = Long.parseLong(args[++i]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.errors.reportError(HbckErrorReporter.ERROR_CODE.WRONG_USAGE, "-sleepBeforeRerun needs a numeric value.");
                        return this.printUsageAndExit();
                    }
                }
                if (cmd.equals("-sidelineDir")) {
                    if (i == args.length - 1) {
                        this.errors.reportError(HbckErrorReporter.ERROR_CODE.WRONG_USAGE, "HBaseFsck: -sidelineDir needs a value.");
                        return this.printUsageAndExit();
                    }
                    this.setSidelineDir(args[++i]);
                    continue;
                }
                if (cmd.equals("-fix")) {
                    this.errors.reportError(HbckErrorReporter.ERROR_CODE.WRONG_USAGE, "This option is deprecated, please use  -fixAssignments instead.");
                    this.setFixAssignments(true);
                    continue;
                }
                if (cmd.equals("-fixAssignments")) {
                    this.setFixAssignments(true);
                    continue;
                }
                if (cmd.equals("-fixMeta")) {
                    this.setFixMeta(true);
                    continue;
                }
                if (cmd.equals("-noHdfsChecking")) {
                    this.setCheckHdfs(false);
                    continue;
                }
                if (cmd.equals("-fixHdfsHoles")) {
                    this.setFixHdfsHoles(true);
                    continue;
                }
                if (cmd.equals("-fixHdfsOrphans")) {
                    this.setFixHdfsOrphans(true);
                    continue;
                }
                if (cmd.equals("-fixTableOrphans")) {
                    this.setFixTableOrphans(true);
                    continue;
                }
                if (cmd.equals("-fixHdfsOverlaps")) {
                    this.setFixHdfsOverlaps(true);
                    continue;
                }
                if (cmd.equals("-fixVersionFile")) {
                    this.setFixVersionFile(true);
                    continue;
                }
                if (cmd.equals("-sidelineBigOverlaps")) {
                    this.setSidelineBigOverlaps(true);
                    continue;
                }
                if (cmd.equals("-fixSplitParents")) {
                    this.setFixSplitParents(true);
                    continue;
                }
                if (cmd.equals("-removeParents")) {
                    this.setRemoveParents(true);
                    continue;
                }
                if (cmd.equals("-ignorePreCheckPermission")) {
                    this.setIgnorePreCheckPermission(true);
                    continue;
                }
                if (cmd.equals("-checkCorruptHFiles")) {
                    checkCorruptHFiles = true;
                    continue;
                }
                if (cmd.equals("-sidelineCorruptHFiles")) {
                    sidelineCorruptHFiles = true;
                    continue;
                }
                if (cmd.equals("-fixReferenceFiles")) {
                    this.setFixReferenceFiles(true);
                    continue;
                }
                if (cmd.equals("-fixHFileLinks")) {
                    this.setFixHFileLinks(true);
                    continue;
                }
                if (cmd.equals("-fixEmptyMetaCells")) {
                    this.setFixEmptyMetaCells(true);
                    continue;
                }
                if (cmd.equals("-repair")) {
                    this.setFixHdfsHoles(true);
                    this.setFixHdfsOrphans(true);
                    this.setFixMeta(true);
                    this.setFixAssignments(true);
                    this.setFixHdfsOverlaps(true);
                    this.setFixVersionFile(true);
                    this.setSidelineBigOverlaps(true);
                    this.setFixSplitParents(false);
                    this.setCheckHdfs(true);
                    this.setFixReferenceFiles(true);
                    this.setFixHFileLinks(true);
                    continue;
                }
                if (cmd.equals("-repairHoles")) {
                    this.setFixHdfsHoles(true);
                    this.setFixHdfsOrphans(false);
                    this.setFixMeta(true);
                    this.setFixAssignments(true);
                    this.setFixHdfsOverlaps(false);
                    this.setSidelineBigOverlaps(false);
                    this.setFixSplitParents(false);
                    this.setCheckHdfs(true);
                    continue;
                }
                if (cmd.equals("-maxOverlapsToSideline")) {
                    if (i == args.length - 1) {
                        this.errors.reportError(HbckErrorReporter.ERROR_CODE.WRONG_USAGE, "-maxOverlapsToSideline needs a numeric value argument.");
                        return this.printUsageAndExit();
                    }
                    try {
                        int maxOverlapsToSideline = Integer.parseInt(args[++i]);
                        this.setMaxOverlapsToSideline(maxOverlapsToSideline);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.errors.reportError(HbckErrorReporter.ERROR_CODE.WRONG_USAGE, "-maxOverlapsToSideline needs a numeric value argument.");
                        return this.printUsageAndExit();
                    }
                }
                if (cmd.equals("-maxMerge")) {
                    if (i == args.length - 1) {
                        this.errors.reportError(HbckErrorReporter.ERROR_CODE.WRONG_USAGE, "-maxMerge needs a numeric value argument.");
                        return this.printUsageAndExit();
                    }
                    try {
                        int maxMerge = Integer.parseInt(args[++i]);
                        this.setMaxMerge(maxMerge);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.errors.reportError(HbckErrorReporter.ERROR_CODE.WRONG_USAGE, "-maxMerge needs a numeric value argument.");
                        return this.printUsageAndExit();
                    }
                }
                if (cmd.equals("-summary")) {
                    HBaseFsck.setSummary();
                    continue;
                }
                if (cmd.equals("-metaonly")) {
                    this.setCheckMetaOnly();
                    continue;
                }
                if (cmd.equals("-boundaries")) {
                    this.setRegionBoundariesCheck();
                    continue;
                }
                if (cmd.equals("-fixReplication")) {
                    this.setFixReplication(true);
                    continue;
                }
                if (cmd.equals("-cleanReplicationBarrier")) {
                    this.setCleanReplicationBarrier(true);
                    if (args[++i].startsWith("-")) {
                        this.printUsageAndExit();
                    }
                    this.setCleanReplicationBarrierTable(args[i]);
                    continue;
                }
                if (cmd.startsWith("-")) {
                    this.errors.reportError(HbckErrorReporter.ERROR_CODE.WRONG_USAGE, "Unrecognized option:" + cmd);
                    return this.printUsageAndExit();
                }
                this.includeTable(TableName.valueOf((String)cmd));
                this.errors.print("Allow checking/fixes for table: " + cmd);
            }
            this.errors.print("HBaseFsck command line options: " + StringUtils.join((Object[])args, (String)" "));
            try {
                this.preCheckPermission();
            }
            catch (AccessDeniedException ace) {
                Runtime.getRuntime().exit(-1);
            }
            catch (IOException ioe) {
                Runtime.getRuntime().exit(-1);
            }
            this.connect();
            if (!this.isOptionsSupported(args)) {
                return this.printUsageAndExit();
            }
            try {
                if (checkCorruptHFiles || sidelineCorruptHFiles) {
                    LOG.info("Checking all hfiles for corruption");
                    HFileCorruptionChecker hfcc = this.createHFileCorruptionChecker(sidelineCorruptHFiles);
                    this.setHFileCorruptionChecker(hfcc);
                    Set<TableName> tables = this.getIncludedTables();
                    ArrayList<Path> tableDirs = new ArrayList();
                    Path rootdir = FSUtils.getRootDir((Configuration)this.getConf());
                    if (tables.size() > 0) {
                        for (TableName t : tables) {
                            tableDirs.add(FSUtils.getTableDir((Path)rootdir, (TableName)t));
                        }
                    } else {
                        tableDirs = FSUtils.getTableDirs(FSUtils.getCurrentFileSystem((Configuration)this.getConf()), rootdir);
                    }
                    hfcc.checkTables(tableDirs);
                    hfcc.report(this.errors);
                }
                int code = this.onlineHbck();
                this.setRetCode(code);
                if (!this.shouldRerun()) break block63;
                try {
                    LOG.info("Sleeping " + sleepBeforeRerun + "ms before re-checking after fix...");
                    Thread.sleep(sleepBeforeRerun);
                }
                catch (InterruptedException ie) {
                    LOG.warn("Interrupted while sleeping");
                    HBaseFsck hBaseFsck = this;
                    IOUtils.closeQuietly((Closeable)this);
                    return hBaseFsck;
                }
                this.setFixAssignments(false);
                this.setFixMeta(false);
                this.setFixHdfsHoles(false);
                this.setFixHdfsOverlaps(false);
                this.setFixVersionFile(false);
                this.setFixTableOrphans(false);
                this.errors.resetErrors();
                code = this.onlineHbck();
                this.setRetCode(code);
            }
            finally {
                IOUtils.closeQuietly((Closeable)this);
            }
        }
        return this;
    }

    private boolean isOptionsSupported(String[] args) {
        boolean result = true;
        String hbaseServerVersion = this.status.getHBaseVersion();
        if (VersionInfo.compareVersion((String)"2.any.any", (String)hbaseServerVersion) < 0) {
            for (String arg : args) {
                if (!unsupportedOptionsInV2.contains(arg)) continue;
                this.errors.reportError(HbckErrorReporter.ERROR_CODE.UNSUPPORTED_OPTION, "option '" + arg + "' is not supportted!");
                result = false;
                break;
            }
        }
        return result;
    }

    public void setCleanReplicationBarrierTable(String cleanReplicationBarrierTable) {
        this.cleanReplicationBarrierTable = TableName.valueOf((String)cleanReplicationBarrierTable);
    }

    public void cleanReplicationBarrier() throws IOException {
        if (!this.cleanReplicationBarrier || this.cleanReplicationBarrierTable == null) {
            return;
        }
        if (this.cleanReplicationBarrierTable.isSystemTable()) {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.INVALID_TABLE, "invalid table: " + this.cleanReplicationBarrierTable);
            return;
        }
        boolean isGlobalScope = false;
        try {
            isGlobalScope = this.admin.getDescriptor(this.cleanReplicationBarrierTable).hasGlobalReplicationScope();
        }
        catch (TableNotFoundException e) {
            LOG.info("we may need to clean some erroneous data due to bugs");
        }
        if (isGlobalScope) {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.INVALID_TABLE, "table's replication scope is global: " + this.cleanReplicationBarrierTable);
            return;
        }
        ArrayList<byte[]> regionNames = new ArrayList<byte[]>();
        Scan barrierScan = new Scan();
        barrierScan.setCaching(100);
        barrierScan.addFamily(HConstants.REPLICATION_BARRIER_FAMILY);
        barrierScan.withStartRow(MetaTableAccessor.getTableStartRowForMeta((TableName)this.cleanReplicationBarrierTable, (MetaTableAccessor.QueryType)MetaTableAccessor.QueryType.REGION)).withStopRow(MetaTableAccessor.getTableStopRowForMeta((TableName)this.cleanReplicationBarrierTable, (MetaTableAccessor.QueryType)MetaTableAccessor.QueryType.REGION));
        try (ResultScanner scanner = this.meta.getScanner(barrierScan);){
            Result result;
            while ((result = scanner.next()) != null) {
                regionNames.add(result.getRow());
            }
        }
        if (regionNames.size() <= 0) {
            this.errors.reportError(HbckErrorReporter.ERROR_CODE.INVALID_TABLE, "there is no barriers of this table: " + this.cleanReplicationBarrierTable);
            return;
        }
        ReplicationQueueStorage queueStorage = ReplicationStorageFactory.getReplicationQueueStorage((ZKWatcher)this.zkw, (Configuration)this.getConf());
        List peerDescriptions = this.admin.listReplicationPeers();
        if (peerDescriptions != null && peerDescriptions.size() > 0) {
            List peers = peerDescriptions.stream().filter(peerConfig -> peerConfig.getPeerConfig().needToReplicate(this.cleanReplicationBarrierTable)).map(peerConfig -> peerConfig.getPeerId()).collect(Collectors.toList());
            try {
                ArrayList<String> batch = new ArrayList<String>();
                for (String peer : peers) {
                    for (byte[] regionName : regionNames) {
                        batch.add(RegionInfo.encodeRegionName((byte[])regionName));
                        if (batch.size() % 100 != 0) continue;
                        queueStorage.removeLastSequenceIds(peer, batch);
                        batch.clear();
                    }
                    if (batch.size() <= 0) continue;
                    queueStorage.removeLastSequenceIds(peer, batch);
                    batch.clear();
                }
            }
            catch (ReplicationException re) {
                throw new IOException(re);
            }
        }
        for (byte[] regionName : regionNames) {
            this.meta.delete(new Delete(regionName).addFamily(HConstants.REPLICATION_BARRIER_FAMILY));
        }
        this.setShouldRerun();
    }

    void debugLsr(Path p) throws IOException {
        HBaseFsck.debugLsr(this.getConf(), p, this.errors);
    }

    public static void debugLsr(Configuration conf, Path p) throws IOException {
        HBaseFsck.debugLsr(conf, p, new PrintingErrorReporter());
    }

    public static void debugLsr(Configuration conf, Path p, HbckErrorReporter errors) throws IOException {
        if (!LOG.isDebugEnabled() || p == null) {
            return;
        }
        FileSystem fs = p.getFileSystem(conf);
        if (!fs.exists(p)) {
            return;
        }
        errors.print(p.toString());
        if (fs.isFile(p)) {
            return;
        }
        if (fs.getFileStatus(p).isDirectory()) {
            FileStatus[] fss;
            for (FileStatus status : fss = fs.listStatus(p)) {
                HBaseFsck.debugLsr(conf, status.getPath(), errors);
            }
        }
    }

    static class HBaseFsckTool
    extends Configured
    implements Tool {
        HBaseFsckTool(Configuration conf) {
            super(conf);
        }

        public int run(String[] args) throws Exception {
            HBaseFsck hbck = new HBaseFsck(this.getConf());
            hbck.exec(hbck.executor, args);
            hbck.close();
            return hbck.getRetCode();
        }
    }

    static class WorkItemHdfsRegionInfo
    implements Callable<Void> {
        private HbckRegionInfo hbi;
        private HBaseFsck hbck;
        private HbckErrorReporter errors;

        WorkItemHdfsRegionInfo(HbckRegionInfo hbi, HBaseFsck hbck, HbckErrorReporter errors) {
            this.hbi = hbi;
            this.hbck = hbck;
            this.errors = errors;
        }

        @Override
        public synchronized Void call() throws IOException {
            if (this.hbi.getHdfsHRI() == null) {
                try {
                    this.errors.progress();
                    this.hbi.loadHdfsRegioninfo(this.hbck.getConf());
                }
                catch (IOException ioe) {
                    String msg = "Orphan region in HDFS: Unable to load .regioninfo from table " + this.hbi.getTableName() + " in hdfs dir " + this.hbi.getHdfsRegionDir() + "!  It may be an invalid format or version file.  Treating as an orphaned regiondir.";
                    this.errors.reportError(HbckErrorReporter.ERROR_CODE.ORPHAN_HDFS_REGION, msg);
                    try {
                        this.hbck.debugLsr(this.hbi.getHdfsRegionDir());
                    }
                    catch (IOException ioe2) {
                        LOG.error("Unable to read directory " + this.hbi.getHdfsRegionDir(), (Throwable)ioe2);
                        throw ioe2;
                    }
                    this.hbck.orphanHdfsDirs.add(this.hbi);
                    throw ioe;
                }
            }
            return null;
        }
    }

    class WorkItemHdfsDir
    implements Callable<Void> {
        private FileStatus tableDir;
        private HbckErrorReporter errors;
        private FileSystem fs;

        WorkItemHdfsDir(FileSystem fs, HbckErrorReporter errors, FileStatus status) {
            this.fs = fs;
            this.tableDir = status;
            this.errors = errors;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Void call() throws InterruptedException, ExecutionException {
            block10: {
                final Vector<IOException> exceptions = new Vector<IOException>();
                try {
                    FileStatus[] regionDirs = this.fs.listStatus(this.tableDir.getPath());
                    ArrayList futures = new ArrayList(regionDirs.length);
                    for (final FileStatus regionDir : regionDirs) {
                        this.errors.progress();
                        final String encodedName = regionDir.getPath().getName();
                        if (!encodedName.toLowerCase(Locale.ROOT).matches("[0-9a-f]+")) continue;
                        if (!exceptions.isEmpty()) break;
                        futures.add(HBaseFsck.this.executor.submit(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    LOG.debug("Loading region info from hdfs:" + regionDir.getPath());
                                    Path regioninfoFile = new Path(regionDir.getPath(), ".regioninfo");
                                    boolean regioninfoFileExists = WorkItemHdfsDir.this.fs.exists(regioninfoFile);
                                    if (!regioninfoFileExists && !WorkItemHdfsDir.this.fs.exists(regionDir.getPath())) {
                                        LOG.warn("By the time we tried to process this region dir it was already gone: " + regionDir.getPath());
                                        return;
                                    }
                                    HbckRegionInfo hbi = HBaseFsck.this.getOrCreateInfo(encodedName);
                                    HbckRegionInfo.HdfsEntry he = new HbckRegionInfo.HdfsEntry();
                                    HbckRegionInfo hbckRegionInfo = hbi;
                                    synchronized (hbckRegionInfo) {
                                        if (hbi.getHdfsRegionDir() != null) {
                                            WorkItemHdfsDir.this.errors.print("Directory " + encodedName + " duplicate??" + hbi.getHdfsRegionDir());
                                        }
                                        he.regionDir = regionDir.getPath();
                                        he.regionDirModTime = regionDir.getModificationTime();
                                        he.hdfsRegioninfoFilePresent = regioninfoFileExists;
                                        he.hdfsOnlyEdits = true;
                                        FileStatus[] subDirs = WorkItemHdfsDir.this.fs.listStatus(regionDir.getPath());
                                        Path ePath = WALSplitter.getRegionDirRecoveredEditsDir(regionDir.getPath());
                                        for (FileStatus subDir : subDirs) {
                                            WorkItemHdfsDir.this.errors.progress();
                                            String sdName = subDir.getPath().getName();
                                            if (sdName.startsWith(".") || sdName.equals(ePath.getName())) continue;
                                            he.hdfsOnlyEdits = false;
                                            break;
                                        }
                                        hbi.setHdfsEntry(he);
                                    }
                                }
                                catch (Exception e) {
                                    LOG.error("Could not load region dir", (Throwable)e);
                                    exceptions.add(e);
                                }
                            }
                        }));
                    }
                    for (Future future : futures) {
                        if (!exceptions.isEmpty()) {
                            break;
                        }
                        try {
                            future.get();
                        }
                        catch (ExecutionException e) {
                            LOG.error("Unexpected exec exception!  Should've been caught already.  (Bug?)", (Throwable)e);
                        }
                    }
                }
                catch (IOException e) {
                    LOG.error("Cannot execute WorkItemHdfsDir for " + this.tableDir, (Throwable)e);
                    exceptions.add(e);
                }
                finally {
                    if (exceptions.isEmpty()) break block10;
                    this.errors.reportError(HbckErrorReporter.ERROR_CODE.RS_CONNECT_FAILURE, "Table Directory: " + this.tableDir.getPath().getName() + " Unable to fetch all HDFS region information. ");
                    throw new ExecutionException("First exception in WorkItemHdfsDir", (Throwable)exceptions.firstElement());
                }
            }
            return null;
        }
    }

    static class WorkItemRegion
    implements Callable<Void> {
        private final HBaseFsck hbck;
        private final ServerName rsinfo;
        private final HbckErrorReporter errors;
        private final ClusterConnection connection;

        WorkItemRegion(HBaseFsck hbck, ServerName info, HbckErrorReporter errors, ClusterConnection connection) {
            this.hbck = hbck;
            this.rsinfo = info;
            this.errors = errors;
            this.connection = connection;
        }

        @Override
        public synchronized Void call() throws IOException {
            this.errors.progress();
            try {
                AdminProtos.AdminService.BlockingInterface server = this.connection.getAdmin(this.rsinfo);
                List<RegionInfo> regions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)server);
                regions = this.filterRegions(regions);
                if (details) {
                    this.errors.detail("RegionServer: " + this.rsinfo.getServerName() + " number of regions: " + regions.size());
                    for (RegionInfo rinfo : regions) {
                        this.errors.detail("  " + rinfo.getRegionNameAsString() + " id: " + rinfo.getRegionId() + " encoded_name: " + rinfo.getEncodedName() + " start: " + Bytes.toStringBinary((byte[])rinfo.getStartKey()) + " end: " + Bytes.toStringBinary((byte[])rinfo.getEndKey()));
                    }
                }
                for (RegionInfo r : regions) {
                    HbckRegionInfo hbi = this.hbck.getOrCreateInfo(r.getEncodedName());
                    hbi.addServer(r, this.rsinfo);
                }
            }
            catch (IOException e) {
                this.errors.reportError(HbckErrorReporter.ERROR_CODE.RS_CONNECT_FAILURE, "RegionServer: " + this.rsinfo.getServerName() + " Unable to fetch region information. " + e);
                throw e;
            }
            return null;
        }

        private List<RegionInfo> filterRegions(List<RegionInfo> regions) {
            ArrayList ret = Lists.newArrayList();
            for (RegionInfo hri : regions) {
                if (!hri.isMetaRegion() && (this.hbck.checkMetaOnly || !this.hbck.isTableIncluded(hri.getTable()))) continue;
                ret.add(hri);
            }
            return ret;
        }
    }

    static class PrintingErrorReporter
    implements HbckErrorReporter {
        public int errorCount = 0;
        private int showProgress;
        private static final int progressThreshold = 100;
        Set<HbckTableInfo> errorTables = new HashSet<HbckTableInfo>();
        private ArrayList<HbckErrorReporter.ERROR_CODE> errorList = new ArrayList();

        PrintingErrorReporter() {
        }

        @Override
        public void clear() {
            this.errorTables.clear();
            this.errorList.clear();
            this.errorCount = 0;
        }

        @Override
        public synchronized void reportError(HbckErrorReporter.ERROR_CODE errorCode, String message) {
            if (errorCode == HbckErrorReporter.ERROR_CODE.WRONG_USAGE) {
                System.err.println(message);
                return;
            }
            this.errorList.add(errorCode);
            if (!summary) {
                System.out.println("ERROR: " + message);
            }
            ++this.errorCount;
            this.showProgress = 0;
        }

        @Override
        public synchronized void reportError(HbckErrorReporter.ERROR_CODE errorCode, String message, HbckTableInfo table) {
            this.errorTables.add(table);
            this.reportError(errorCode, message);
        }

        @Override
        public synchronized void reportError(HbckErrorReporter.ERROR_CODE errorCode, String message, HbckTableInfo table, HbckRegionInfo info) {
            this.errorTables.add(table);
            String reference = "(region " + info.getRegionNameAsString() + ")";
            this.reportError(errorCode, reference + " " + message);
        }

        @Override
        public synchronized void reportError(HbckErrorReporter.ERROR_CODE errorCode, String message, HbckTableInfo table, HbckRegionInfo info1, HbckRegionInfo info2) {
            this.errorTables.add(table);
            String reference = "(regions " + info1.getRegionNameAsString() + " and " + info2.getRegionNameAsString() + ")";
            this.reportError(errorCode, reference + " " + message);
        }

        @Override
        public synchronized void reportError(String message) {
            this.reportError(HbckErrorReporter.ERROR_CODE.UNKNOWN, message);
        }

        @Override
        public synchronized void report(String message) {
            if (!summary) {
                System.out.println("ERROR: " + message);
            }
            this.showProgress = 0;
        }

        @Override
        public synchronized int summarize() {
            System.out.println(Integer.toString(this.errorCount) + " inconsistencies detected.");
            if (this.errorCount == 0) {
                System.out.println("Status: OK");
                return 0;
            }
            System.out.println("Status: INCONSISTENT");
            return -1;
        }

        @Override
        public ArrayList<HbckErrorReporter.ERROR_CODE> getErrorList() {
            return this.errorList;
        }

        @Override
        public synchronized void print(String message) {
            if (!summary) {
                System.out.println(message);
            }
        }

        @Override
        public boolean tableHasErrors(HbckTableInfo table) {
            return this.errorTables.contains(table);
        }

        @Override
        public void resetErrors() {
            this.errorCount = 0;
        }

        @Override
        public synchronized void detail(String message) {
            if (details) {
                System.out.println(message);
            }
            this.showProgress = 0;
        }

        @Override
        public synchronized void progress() {
            if (this.showProgress++ == 100) {
                if (!summary) {
                    System.out.print(".");
                }
                this.showProgress = 0;
            }
        }
    }

    static class WorkItemOverlapMerge
    implements Callable<Void> {
        private TableIntegrityErrorHandler handler;
        Collection<HbckRegionInfo> overlapgroup;

        WorkItemOverlapMerge(Collection<HbckRegionInfo> overlapgroup, TableIntegrityErrorHandler handler) {
            this.handler = handler;
            this.overlapgroup = overlapgroup;
        }

        @Override
        public Void call() throws Exception {
            this.handler.handleOverlapGroup(this.overlapgroup);
            return null;
        }
    }

    class CheckRegionConsistencyWorkItem
    implements Callable<Void> {
        private final String key;
        private final HbckRegionInfo hbi;

        CheckRegionConsistencyWorkItem(String key, HbckRegionInfo hbi) {
            this.key = key;
            this.hbi = hbi;
        }

        @Override
        public synchronized Void call() throws Exception {
            try {
                HBaseFsck.this.checkRegionConsistency(this.key, this.hbi);
            }
            catch (Exception e) {
                LOG.warn("Unable to complete check or repair the region '" + this.hbi.getRegionNameAsString() + "'.", (Throwable)e);
                if (this.hbi.getHdfsHRI().isMetaRegion()) {
                    throw e;
                }
                LOG.warn("Skip region '" + this.hbi.getRegionNameAsString() + "'");
                HBaseFsck.this.addSkippedRegion(this.hbi);
            }
            return null;
        }
    }

    private static class RegionBoundariesInformation {
        public byte[] regionName;
        public byte[] metaFirstKey;
        public byte[] metaLastKey;
        public byte[] storesFirstKey;
        public byte[] storesLastKey;

        private RegionBoundariesInformation() {
        }

        public String toString() {
            return "regionName=" + Bytes.toStringBinary((byte[])this.regionName) + "\nmetaFirstKey=" + Bytes.toStringBinary((byte[])this.metaFirstKey) + "\nmetaLastKey=" + Bytes.toStringBinary((byte[])this.metaLastKey) + "\nstoresFirstKey=" + Bytes.toStringBinary((byte[])this.storesFirstKey) + "\nstoresLastKey=" + Bytes.toStringBinary((byte[])this.storesLastKey);
        }
    }

    private static class FileLockCallable
    implements Callable<FSDataOutputStream> {
        RetryCounter retryCounter;
        private final Configuration conf;
        private Path hbckLockPath = null;

        public FileLockCallable(Configuration conf, RetryCounter retryCounter) {
            this.retryCounter = retryCounter;
            this.conf = conf;
        }

        Path getHbckLockPath() {
            return this.hbckLockPath;
        }

        @Override
        public FSDataOutputStream call() throws IOException {
            try {
                FileSystem fs = FSUtils.getCurrentFileSystem((Configuration)this.conf);
                FsPermission defaultPerms = FSUtils.getFilePermissions((FileSystem)fs, (Configuration)this.conf, (String)"hbase.data.umask");
                Path tmpDir = HBaseFsck.getTmpDir(this.conf);
                this.hbckLockPath = new Path(tmpDir, HBaseFsck.HBCK_LOCK_FILE);
                fs.mkdirs(tmpDir);
                FSDataOutputStream out = this.createFileWithRetries(fs, this.hbckLockPath, defaultPerms);
                out.writeBytes(InetAddress.getLocalHost().toString());
                out.writeBytes(" Written by an hbase-2.x Master to block an attempt by an hbase-1.x HBCK tool making modification to state. See 'HBCK must match HBase server version' in the hbase refguide.");
                out.flush();
                return out;
            }
            catch (RemoteException e) {
                if (AlreadyBeingCreatedException.class.getName().equals(e.getClassName())) {
                    return null;
                }
                throw e;
            }
        }

        private FSDataOutputStream createFileWithRetries(FileSystem fs, Path hbckLockFilePath, FsPermission defaultPerms) throws IOException {
            IOException exception = null;
            while (true) {
                try {
                    return FSUtils.create((FileSystem)fs, (Path)hbckLockFilePath, (FsPermission)defaultPerms, (boolean)false);
                }
                catch (IOException ioe) {
                    LOG.info("Failed to create lock file " + hbckLockFilePath.getName() + ", try=" + (this.retryCounter.getAttemptTimes() + 1) + " of " + this.retryCounter.getMaxAttempts());
                    LOG.debug("Failed to create lock file " + hbckLockFilePath.getName(), (Throwable)ioe);
                    try {
                        exception = ioe;
                        this.retryCounter.sleepUntilNextRetry();
                        continue;
                    }
                    catch (InterruptedException ie) {
                        throw (InterruptedIOException)new InterruptedIOException("Can't create lock file " + hbckLockFilePath.getName()).initCause(ie);
                    }
                    if (this.retryCounter.shouldRetry()) continue;
                    throw exception;
                }
                break;
            }
        }
    }
}

