/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.io.BoundedByteBufferPool;
import org.apache.hadoop.hbase.io.ByteBufferOutputStream;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.CodedOutputStream;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.org.apache.commons.io.IOUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;

@InterfaceAudience.Private
public class IPCUtil {
    public static final Log LOG = LogFactory.getLog(IPCUtil.class);
    private final int cellBlockDecompressionMultiplier;
    private final int cellBlockBuildingInitialBufferSize;
    private final Configuration conf;

    public IPCUtil(Configuration conf) {
        this.conf = conf;
        this.cellBlockDecompressionMultiplier = conf.getInt("hbase.ipc.cellblock.decompression.buffersize.multiplier", 3);
        this.cellBlockBuildingInitialBufferSize = ClassSize.align(conf.getInt("hbase.ipc.cellblock.building.initial.buffersize", 16384));
    }

    public ByteBuffer buildCellBlock(Codec codec, CompressionCodec compressor, CellScanner cellScanner) throws IOException {
        return this.buildCellBlock(codec, compressor, cellScanner, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer buildCellBlock(Codec codec, CompressionCodec compressor, CellScanner cellScanner, BoundedByteBufferPool pool) throws IOException {
        if (cellScanner == null) {
            return null;
        }
        if (codec == null) {
            throw new CellScannerButNoCodecException();
        }
        int bufferSize = this.cellBlockBuildingInitialBufferSize;
        ByteBufferOutputStream baos = null;
        if (pool != null) {
            ByteBuffer bb = pool.getBuffer();
            bufferSize = bb.capacity();
            baos = new ByteBufferOutputStream(bb);
        } else {
            if (cellScanner instanceof HeapSize) {
                long longSize = ((HeapSize)((Object)cellScanner)).heapSize();
                if (longSize > Integer.MAX_VALUE) {
                    throw new IOException("Size " + longSize + " > " + Integer.MAX_VALUE);
                }
                bufferSize = ClassSize.align((int)longSize);
            }
            baos = new ByteBufferOutputStream(bufferSize);
        }
        OutputStream os = baos;
        Compressor poolCompressor = null;
        try {
            if (compressor != null) {
                if (compressor instanceof Configurable) {
                    ((Configurable)((Object)compressor)).setConf(this.conf);
                }
                poolCompressor = CodecPool.getCompressor(compressor);
                os = compressor.createOutputStream(os, poolCompressor);
            }
            Codec.Encoder encoder = codec.getEncoder(os);
            int count = 0;
            while (cellScanner.advance()) {
                encoder.write(cellScanner.current());
                ++count;
            }
            encoder.flush();
            if (count == 0) {
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
        }
        finally {
            os.close();
            if (poolCompressor != null) {
                CodecPool.returnCompressor(poolCompressor);
            }
        }
        if (LOG.isTraceEnabled() && bufferSize < baos.size()) {
            LOG.trace((Object)("Buffer grew from initial bufferSize=" + bufferSize + " to " + baos.size() + "; up hbase.ipc.cellblock.building.initial.buffersize?"));
        }
        return baos.getByteBuffer();
    }

    public CellScanner createCellScanner(Codec codec, CompressionCodec compressor, byte[] cellBlock) throws IOException {
        return this.createCellScanner(codec, compressor, cellBlock, 0, cellBlock.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellScanner createCellScanner(Codec codec, CompressionCodec compressor, byte[] cellBlock, int offset, int length) throws IOException {
        ByteArrayInputStream is = null;
        if (compressor != null) {
            if (compressor instanceof Configurable) {
                ((Configurable)((Object)compressor)).setConf(this.conf);
            }
            Decompressor poolDecompressor = CodecPool.getDecompressor(compressor);
            CompressionInputStream cis = compressor.createInputStream(new ByteArrayInputStream(cellBlock, offset, length), poolDecompressor);
            ByteBufferOutputStream bbos = null;
            try {
                bbos = new ByteBufferOutputStream((length - offset) * this.cellBlockDecompressionMultiplier);
                IOUtils.copy((InputStream)cis, (OutputStream)bbos);
                bbos.close();
                ByteBuffer bb = bbos.getByteBuffer();
                is = new ByteArrayInputStream(bb.array(), 0, bb.limit());
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
                if (bbos != null) {
                    bbos.close();
                }
                CodecPool.returnDecompressor(poolDecompressor);
            }
        } else {
            is = new ByteArrayInputStream(cellBlock, offset, length);
        }
        return codec.getDecoder(is);
    }

    public static ByteBuffer getDelimitedMessageAsByteBuffer(Message m) throws IOException {
        if (m == null) {
            return null;
        }
        int serializedSize = m.getSerializedSize();
        int vintSize = CodedOutputStream.computeRawVarint32Size(serializedSize);
        byte[] buffer = new byte[serializedSize + vintSize];
        CodedOutputStream cos = CodedOutputStream.newInstance(buffer);
        cos.writeMessageNoTag(m);
        cos.flush();
        cos.checkNoSpaceLeft();
        return ByteBuffer.wrap(buffer);
    }

    public static int write(OutputStream dos, Message header, Message param, ByteBuffer cellBlock) throws IOException {
        int totalSize = IPCUtil.getTotalSizeWhenWrittenDelimited(header, param);
        if (cellBlock != null) {
            totalSize += cellBlock.remaining();
        }
        return IPCUtil.write(dos, header, param, cellBlock, totalSize);
    }

    private static int write(OutputStream dos, Message header, Message param, ByteBuffer cellBlock, int totalSize) throws IOException {
        dos.write(Bytes.toBytes(totalSize));
        header.writeDelimitedTo(dos);
        if (param != null) {
            param.writeDelimitedTo(dos);
        }
        if (cellBlock != null) {
            dos.write(cellBlock.array(), 0, cellBlock.remaining());
        }
        dos.flush();
        return totalSize;
    }

    public static void readChunked(DataInput in, byte[] dest, int offset, int len) throws IOException {
        int maxRead = 8192;
        while (offset < len) {
            in.readFully(dest, offset, Math.min(len - offset, maxRead));
            offset += maxRead;
        }
    }

    public static int getTotalSizeWhenWrittenDelimited(Message ... messages) {
        int totalSize = 0;
        for (Message m : messages) {
            if (m == null) continue;
            totalSize += m.getSerializedSize();
            totalSize += CodedOutputStream.computeRawVarint32Size(m.getSerializedSize());
        }
        Preconditions.checkArgument(totalSize < Integer.MAX_VALUE);
        return totalSize;
    }

    public static class CellScannerButNoCodecException
    extends HBaseIOException {
    }
}

