/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.hive.ql.io.orc.InStream;
import org.apache.hadoop.hive.ql.io.orc.IntegerReader;
import org.apache.hadoop.hive.ql.io.orc.PositionProvider;
import org.apache.hadoop.hive.ql.io.orc.RunLengthIntegerWriterV2;
import org.apache.hadoop.hive.ql.io.orc.SerializationUtils;

class RunLengthIntegerReaderV2
implements IntegerReader {
    private final InStream input;
    private final boolean signed;
    private final long[] literals = new long[512];
    private int numLiterals = 0;
    private int used = 0;

    RunLengthIntegerReaderV2(InStream input, boolean signed) throws IOException {
        this.input = input;
        this.signed = signed;
    }

    private void readValues() throws IOException {
        int firstByte = this.input.read();
        if (firstByte < 0) {
            throw new EOFException("Read past end of RLE integer from " + this.input);
        }
        int enc = firstByte >>> 6 & 3;
        if (RunLengthIntegerWriterV2.EncodingType.SHORT_REPEAT.ordinal() == enc) {
            this.readShortRepeatValues(firstByte);
        } else if (RunLengthIntegerWriterV2.EncodingType.DIRECT.ordinal() == enc) {
            this.readDirectValues(firstByte);
        } else if (RunLengthIntegerWriterV2.EncodingType.PATCHED_BASE.ordinal() == enc) {
            this.readPatchedBaseValues(firstByte);
        } else {
            this.readDeltaValues(firstByte);
        }
    }

    private void readDeltaValues(int firstByte) throws IOException {
        int fb = firstByte >>> 1 & 0x1F;
        if (fb != 0) {
            fb = SerializationUtils.decodeBitWidth(fb);
        }
        int len = (firstByte & 1) << 8;
        len |= this.input.read();
        long firstVal = 0L;
        firstVal = this.signed ? SerializationUtils.readVslong(this.input) : SerializationUtils.readVulong(this.input);
        long prevVal = firstVal;
        this.literals[this.numLiterals++] = firstVal;
        if (fb == 0) {
            long fd = SerializationUtils.readVslong(this.input);
            for (int i = 0; i < len; ++i) {
                this.literals[this.numLiterals++] = this.literals[this.numLiterals - 2] + fd;
            }
        } else {
            long deltaBase = SerializationUtils.readVslong(this.input);
            this.literals[this.numLiterals++] = firstVal + deltaBase;
            prevVal = this.literals[this.numLiterals - 1];
            SerializationUtils.readInts(this.literals, this.numLiterals, --len, fb, this.input);
            while (len > 0) {
                this.literals[this.numLiterals] = deltaBase < 0L ? prevVal - this.literals[this.numLiterals] : prevVal + this.literals[this.numLiterals];
                prevVal = this.literals[this.numLiterals];
                --len;
                ++this.numLiterals;
            }
        }
    }

    private void readPatchedBaseValues(int firstByte) throws IOException {
        long mask;
        int fbo = firstByte >>> 1 & 0x1F;
        int fb = SerializationUtils.decodeBitWidth(fbo);
        int len = (firstByte & 1) << 8;
        len |= this.input.read();
        ++len;
        int thirdByte = this.input.read();
        int bw = thirdByte >>> 5 & 7;
        ++bw;
        int pwo = thirdByte & 0x1F;
        int pw = SerializationUtils.decodeBitWidth(pwo);
        int fourthByte = this.input.read();
        int pgw = fourthByte >>> 5 & 7;
        ++pgw;
        int pl = fourthByte & 0x1F;
        long base = SerializationUtils.bytesToLongBE(this.input, bw);
        if ((base & (mask = 1L << bw * 8 - 1)) != 0L) {
            base &= mask ^ 0xFFFFFFFFFFFFFFFFL;
            base = -base;
        }
        long[] unpacked = new long[len];
        SerializationUtils.readInts(unpacked, 0, len, fb, this.input);
        long[] unpackedPatch = new long[pl];
        SerializationUtils.readInts(unpackedPatch, 0, pl, pw + pgw, this.input);
        int patchIdx = 0;
        long currGap = 0L;
        long currPatch = 0L;
        currGap = unpackedPatch[patchIdx] >>> pw;
        currPatch = unpackedPatch[patchIdx] & (long)((1 << pw) - 1);
        long actualGap = 0L;
        while (currGap == 255L && currPatch == 0L) {
            actualGap += 255L;
            currGap = unpackedPatch[++patchIdx] >>> pw;
            currPatch = unpackedPatch[patchIdx] & (long)((1 << pw) - 1);
        }
        actualGap += currGap;
        for (int i = 0; i < unpacked.length; ++i) {
            if ((long)i == actualGap) {
                long patchedVal = unpacked[i] | currPatch << fb;
                this.literals[this.numLiterals++] = base + patchedVal;
                if (++patchIdx >= pl) continue;
                currGap = unpackedPatch[patchIdx] >>> pw;
                currPatch = unpackedPatch[patchIdx] & (long)((1 << pw) - 1);
                actualGap = 0L;
                while (currGap == 255L && currPatch == 0L) {
                    actualGap += 255L;
                    currGap = unpackedPatch[++patchIdx] >>> pw;
                    currPatch = unpackedPatch[patchIdx] & (long)((1 << pw) - 1);
                }
                actualGap += currGap;
                actualGap += (long)i;
                continue;
            }
            this.literals[this.numLiterals++] = base + unpacked[i];
        }
    }

    private void readDirectValues(int firstByte) throws IOException {
        int fbo = firstByte >>> 1 & 0x1F;
        int fb = SerializationUtils.decodeBitWidth(fbo);
        int len = (firstByte & 1) << 8;
        len |= this.input.read();
        SerializationUtils.readInts(this.literals, this.numLiterals, ++len, fb, this.input);
        if (this.signed) {
            for (int i = 0; i < len; ++i) {
                this.literals[this.numLiterals] = SerializationUtils.zigzagDecode(this.literals[this.numLiterals]);
                ++this.numLiterals;
            }
        } else {
            this.numLiterals += len;
        }
    }

    private void readShortRepeatValues(int firstByte) throws IOException {
        int size = firstByte >>> 3 & 7;
        int len = firstByte & 7;
        len += 3;
        long val = SerializationUtils.bytesToLongBE(this.input, ++size);
        if (this.signed) {
            val = SerializationUtils.zigzagDecode(val);
        }
        for (int i = 0; i < len; ++i) {
            this.literals[this.numLiterals++] = val;
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.used != this.numLiterals || this.input.available() > 0;
    }

    @Override
    public long next() throws IOException {
        if (this.used == this.numLiterals) {
            this.numLiterals = 0;
            this.used = 0;
            this.readValues();
        }
        long result = this.literals[this.used++];
        return result;
    }

    @Override
    public void seek(PositionProvider index) throws IOException {
        int consumed;
        this.input.seek(index);
        if (consumed != 0) {
            for (consumed = (int)index.getNext(); consumed > 0; consumed -= this.numLiterals) {
                this.numLiterals = 0;
                this.readValues();
                this.used = consumed;
            }
        } else {
            this.used = 0;
            this.numLiterals = 0;
        }
    }

    @Override
    public void skip(long numValues) throws IOException {
        while (numValues > 0L) {
            if (this.used == this.numLiterals) {
                this.numLiterals = 0;
                this.used = 0;
                this.readValues();
            }
            long consume = Math.min(numValues, (long)(this.numLiterals - this.used));
            this.used = (int)((long)this.used + consume);
            numValues -= consume;
        }
    }
}

