/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.DemuxOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.SamplePruner;
import org.apache.hadoop.hive.ql.optimizer.listbucketingpruner.ListBucketingPruner;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.util.StringUtils;

public final class GenMapRedUtils {
    private static Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils");

    private static boolean needsTagging(ReduceWork rWork) {
        return rWork != null && (rWork.getReducer().getClass() == JoinOperator.class || rWork.getReducer().getClass() == DemuxOperator.class);
    }

    public static void initPlan(ReduceSinkOperator op, GenMRProcContext opProcCtx) throws SemanticException {
        Operator<OperatorDesc> reducer = op.getChildOperators().get(0);
        LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = opProcCtx.getMapCurrCtx();
        GenMRProcContext.GenMapRedCtx mapredCtx = (GenMRProcContext.GenMapRedCtx)mapCurrCtx.get(op.getParentOperators().get(0));
        Task<? extends Serializable> currTask = mapredCtx.getCurrTask();
        MapredWork plan = (MapredWork)currTask.getWork();
        HashMap<Operator<? extends OperatorDesc>, Task<? extends Serializable>> opTaskMap = opProcCtx.getOpTaskMap();
        Operator<? extends OperatorDesc> currTopOp = opProcCtx.getCurrTopOp();
        opTaskMap.put(reducer, currTask);
        plan.setReduceWork(new ReduceWork());
        plan.getReduceWork().setReducer(reducer);
        ReduceSinkDesc desc = (ReduceSinkDesc)op.getConf();
        plan.getReduceWork().setNumReduceTasks(desc.getNumReducers());
        if (GenMapRedUtils.needsTagging(plan.getReduceWork())) {
            plan.getReduceWork().setNeedsTagging(true);
        }
        assert (currTopOp != null);
        String currAliasId = opProcCtx.getCurrAliasId();
        if (!opProcCtx.isSeenOp(currTask, currTopOp)) {
            GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, currTask, false, opProcCtx);
        }
        currTopOp = null;
        currAliasId = null;
        opProcCtx.setCurrTask(currTask);
        opProcCtx.setCurrTopOp(currTopOp);
        opProcCtx.setCurrAliasId(currAliasId);
    }

    public static void initUnionPlan(ReduceSinkOperator op, UnionOperator currUnionOp, GenMRProcContext opProcCtx, Task<? extends Serializable> unionTask) throws SemanticException {
        Operator<OperatorDesc> reducer = op.getChildOperators().get(0);
        MapredWork plan = (MapredWork)unionTask.getWork();
        HashMap<Operator<? extends OperatorDesc>, Task<? extends Serializable>> opTaskMap = opProcCtx.getOpTaskMap();
        opTaskMap.put(reducer, unionTask);
        plan.setReduceWork(new ReduceWork());
        plan.getReduceWork().setReducer(reducer);
        plan.getReduceWork().setReducer(reducer);
        ReduceSinkDesc desc = (ReduceSinkDesc)op.getConf();
        plan.getReduceWork().setNumReduceTasks(desc.getNumReducers());
        if (GenMapRedUtils.needsTagging(plan.getReduceWork())) {
            plan.getReduceWork().setNeedsTagging(true);
        }
        GenMapRedUtils.initUnionPlan(opProcCtx, currUnionOp, unionTask, false);
    }

    private static void setUnionPlan(GenMRProcContext opProcCtx, boolean local, Task<? extends Serializable> currTask, GenMRProcContext.GenMRUnionCtx uCtx, boolean mergeTask) throws SemanticException {
        Operator<? extends OperatorDesc> currTopOp = opProcCtx.getCurrTopOp();
        if (currTopOp != null) {
            String currAliasId = opProcCtx.getCurrAliasId();
            if (mergeTask || !opProcCtx.isSeenOp(currTask, currTopOp)) {
                GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, currTask, local, opProcCtx);
            }
            currTopOp = null;
            opProcCtx.setCurrTopOp(currTopOp);
        } else {
            List<String> taskTmpDirLst = uCtx.getTaskTmpDir();
            if (taskTmpDirLst != null && !taskTmpDirLst.isEmpty()) {
                List<TableDesc> tt_descLst = uCtx.getTTDesc();
                assert (!taskTmpDirLst.isEmpty() && !tt_descLst.isEmpty());
                assert (taskTmpDirLst.size() == tt_descLst.size());
                int size = taskTmpDirLst.size();
                assert (!local);
                List<Operator<? extends OperatorDesc>> topOperators = uCtx.getListTopOperators();
                MapredWork plan = (MapredWork)currTask.getWork();
                for (int pos = 0; pos < size; ++pos) {
                    String taskTmpDir = taskTmpDirLst.get(pos);
                    TableDesc tt_desc = tt_descLst.get(pos);
                    MapWork mWork = plan.getMapWork();
                    if (mWork.getPathToAliases().get(taskTmpDir) != null) continue;
                    mWork.getPathToAliases().put(taskTmpDir, new ArrayList());
                    mWork.getPathToAliases().get(taskTmpDir).add(taskTmpDir);
                    mWork.getPathToPartitionInfo().put(taskTmpDir, new PartitionDesc(tt_desc, null));
                    mWork.getAliasToWork().put(taskTmpDir, topOperators.get(pos));
                }
            }
        }
    }

    public static void initUnionPlan(GenMRProcContext opProcCtx, UnionOperator currUnionOp, Task<? extends Serializable> currTask, boolean local) throws SemanticException {
        if (currUnionOp != null) {
            GenMRProcContext.GenMRUnionCtx uCtx = opProcCtx.getUnionTask(currUnionOp);
            assert (uCtx != null);
            GenMapRedUtils.setUnionPlan(opProcCtx, local, currTask, uCtx, false);
        }
    }

    public static void joinUnionPlan(GenMRProcContext opProcCtx, UnionOperator currUnionOp, Task<? extends Serializable> currentUnionTask, Task<? extends Serializable> existingTask, boolean local) throws SemanticException {
        assert (currUnionOp != null);
        GenMRProcContext.GenMRUnionCtx uCtx = opProcCtx.getUnionTask(currUnionOp);
        assert (uCtx != null);
        GenMapRedUtils.setUnionPlan(opProcCtx, local, existingTask, uCtx, true);
        ArrayList<Task<Serializable>> parTasks = null;
        if (opProcCtx.getRootTasks().contains(currentUnionTask)) {
            opProcCtx.getRootTasks().remove(currentUnionTask);
            if (!opProcCtx.getRootTasks().contains(existingTask) && (existingTask.getParentTasks() == null || existingTask.getParentTasks().isEmpty())) {
                opProcCtx.getRootTasks().add(existingTask);
            }
        }
        if (currentUnionTask != null && currentUnionTask.getParentTasks() != null && !currentUnionTask.getParentTasks().isEmpty()) {
            Object[] parTaskArr;
            parTasks = new ArrayList<Task<Serializable>>();
            parTasks.addAll(currentUnionTask.getParentTasks());
            for (Object parTask : parTaskArr = parTasks.toArray()) {
                ((Task)parTask).removeDependentTask(currentUnionTask);
            }
        }
        if (currentUnionTask != null && parTasks != null) {
            for (Task task : parTasks) {
                task.addDependentTask(existingTask);
                if (!opProcCtx.getRootTasks().contains(existingTask)) continue;
                opProcCtx.getRootTasks().remove(existingTask);
            }
        }
        opProcCtx.setCurrTask(existingTask);
    }

    public static void joinPlan(Task<? extends Serializable> currTask, Task<? extends Serializable> oldTask, GenMRProcContext opProcCtx) throws SemanticException {
        assert (currTask != null && oldTask != null);
        Operator<? extends OperatorDesc> currTopOp = opProcCtx.getCurrTopOp();
        ArrayList<Task<Serializable>> parTasks = null;
        if (currTask.getParentTasks() != null && !currTask.getParentTasks().isEmpty()) {
            Object[] parTaskArr;
            parTasks = new ArrayList<Task<Serializable>>();
            parTasks.addAll(currTask.getParentTasks());
            for (Object element : parTaskArr = parTasks.toArray()) {
                ((Task)element).removeDependentTask(currTask);
            }
        }
        if (currTopOp != null) {
            GenMapRedUtils.mergeInput(currTopOp, opProcCtx, oldTask, false);
        }
        if (parTasks != null) {
            for (Task task : parTasks) {
                task.addDependentTask(oldTask);
            }
        }
        if (oldTask instanceof MapRedTask && currTask instanceof MapRedTask) {
            ((MapredWork)((MapRedTask)currTask).getWork()).getMapWork().mergingInto(((MapredWork)((MapRedTask)oldTask).getWork()).getMapWork());
        }
        opProcCtx.setCurrTopOp(null);
        opProcCtx.setCurrTask(oldTask);
    }

    static boolean mergeInput(Operator<? extends OperatorDesc> currTopOp, GenMRProcContext opProcCtx, Task<? extends Serializable> task, boolean local) throws SemanticException {
        if (!opProcCtx.isSeenOp(task, currTopOp)) {
            String currAliasId = opProcCtx.getCurrAliasId();
            GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, task, local, opProcCtx);
            return true;
        }
        return false;
    }

    static void splitPlan(ReduceSinkOperator cRS, Task<? extends Serializable> parentTask, Task<? extends Serializable> childTask, GenMRProcContext opProcCtx) throws SemanticException {
        assert (parentTask != null && childTask != null);
        GenMapRedUtils.splitTasks(cRS, parentTask, childTask, opProcCtx);
    }

    static void splitPlan(ReduceSinkOperator cRS, GenMRProcContext opProcCtx) throws SemanticException {
        ParseContext parseCtx = opProcCtx.getParseCtx();
        Task<? extends Serializable> parentTask = opProcCtx.getCurrTask();
        MapredWork childPlan = GenMapRedUtils.getMapRedWork(parseCtx);
        Task<MapredWork> childTask = TaskFactory.get(childPlan, parseCtx.getConf(), new Task[0]);
        Operator<OperatorDesc> reducer = cRS.getChildOperators().get(0);
        ReduceWork rWork = new ReduceWork();
        childPlan.setReduceWork(rWork);
        rWork.setReducer(reducer);
        ReduceSinkDesc desc = (ReduceSinkDesc)cRS.getConf();
        childPlan.getReduceWork().setNumReduceTasks(new Integer(desc.getNumReducers()));
        opProcCtx.getOpTaskMap().put(reducer, childTask);
        GenMapRedUtils.splitTasks(cRS, parentTask, childTask, opProcCtx);
    }

    public static void setTaskPlan(String alias_id, Operator<? extends OperatorDesc> topOp, Task<?> task, boolean local, GenMRProcContext opProcCtx) throws SemanticException {
        GenMapRedUtils.setTaskPlan(alias_id, topOp, task, local, opProcCtx, null);
    }

    private static ReadEntity getParentViewInfo(String alias_id, Map<String, ReadEntity> viewAliasToInput) {
        String[] aliases = alias_id.split(":");
        String currentAlias = null;
        ReadEntity currentInput = null;
        for (int pos = 0; pos < aliases.length; ++pos) {
            ReadEntity input = viewAliasToInput.get(currentAlias = currentAlias == null ? aliases[pos] : currentAlias + ":" + aliases[pos]);
            if (input == null) {
                return currentInput;
            }
            currentInput = input;
        }
        return currentInput;
    }

    public static void setTaskPlan(String alias_id, Operator<? extends OperatorDesc> topOp, Task<?> task, boolean local, GenMRProcContext opProcCtx, PrunedPartitionList pList) throws SemanticException {
        Map<String, String> props;
        MapWork plan = ((MapredWork)task.getWork()).getMapWork();
        ParseContext parseCtx = opProcCtx.getParseCtx();
        Set<ReadEntity> inputs = opProcCtx.getInputs();
        ArrayList<Path> partDir = new ArrayList<Path>();
        ArrayList<PartitionDesc> partDesc = new ArrayList<PartitionDesc>();
        Path tblDir = null;
        TableDesc tblDesc = null;
        PrunedPartitionList partsList = pList;
        plan.setNameToSplitSample(parseCtx.getNameToSplitSample());
        if (partsList == null) {
            try {
                TableScanOperator tsOp = (TableScanOperator)topOp;
                partsList = PartitionPruner.prune(tsOp, parseCtx, alias_id);
            }
            catch (SemanticException e) {
                throw e;
            }
            catch (HiveException e) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                throw new SemanticException(e.getMessage(), e);
            }
        }
        Set<Partition> parts = partsList.getPartitions();
        PartitionDesc aliasPartnDesc = null;
        try {
            if (!parts.isEmpty()) {
                aliasPartnDesc = Utilities.getPartitionDesc(parts.iterator().next());
            }
        }
        catch (HiveException e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new SemanticException(e.getMessage(), e);
        }
        if (aliasPartnDesc == null) {
            aliasPartnDesc = new PartitionDesc(Utilities.getTableDesc(parseCtx.getTopToTable().get(topOp)), null);
        }
        if ((props = parseCtx.getTopToProps().get(topOp)) != null) {
            Properties target = aliasPartnDesc.getProperties();
            if (target == null) {
                target = new Properties();
                aliasPartnDesc.setProperties(target);
            }
            target.putAll(props);
        }
        plan.getAliasToPartnInfo().put(alias_id, aliasPartnDesc);
        long sizeNeeded = Integer.MAX_VALUE;
        int fileLimit = -1;
        if (parseCtx.getGlobalLimitCtx().isEnable()) {
            long sizePerRow = HiveConf.getLongVar(parseCtx.getConf(), HiveConf.ConfVars.HIVELIMITMAXROWSIZE);
            sizeNeeded = (long)parseCtx.getGlobalLimitCtx().getGlobalLimit() * sizePerRow;
            fileLimit = HiveConf.getIntVar(parseCtx.getConf(), HiveConf.ConfVars.HIVELIMITOPTLIMITFILE);
            if (sizePerRow <= 0L || fileLimit <= 0) {
                LOG.info((Object)"Skip optimization to reduce input size of 'limit'");
                parseCtx.getGlobalLimitCtx().disableOpt();
            } else if (parts.isEmpty()) {
                LOG.info((Object)"Empty input: skip limit optimiztion");
            } else {
                LOG.info((Object)("Try to reduce input size for 'limit' sizeNeeded: " + sizeNeeded + "  file limit : " + fileLimit));
            }
        }
        boolean isFirstPart = true;
        boolean emptyInput = true;
        boolean singlePartition = parts.size() == 1;
        ReadEntity parentViewInfo = GenMapRedUtils.getParentViewInfo(alias_id, parseCtx.getViewAliasToInput());
        PlanUtils.addInput(inputs, new ReadEntity(parseCtx.getTopToTable().get(topOp), parentViewInfo));
        for (Partition part : parts) {
            ExprNodeDesc listBucketingPruner;
            if (part.getTable().isPartitioned()) {
                PlanUtils.addInput(inputs, new ReadEntity(part, parentViewInfo));
            } else {
                PlanUtils.addInput(inputs, new ReadEntity(part.getTable(), parentViewInfo));
            }
            Path[] paths = null;
            FilterDesc.sampleDesc sampleDescr = parseCtx.getOpToSamplePruner().get(topOp);
            Map<String, ExprNodeDesc> partToPruner = parseCtx.getOpToPartToSkewedPruner().get(topOp);
            ExprNodeDesc exprNodeDesc = listBucketingPruner = partToPruner != null ? partToPruner.get(part.getName()) : null;
            if (sampleDescr != null) {
                assert (listBucketingPruner == null) : "Sampling and list bucketing can't coexit.";
                paths = SamplePruner.prune(part, sampleDescr);
                parseCtx.getGlobalLimitCtx().disableOpt();
            } else if (listBucketingPruner != null) {
                assert (sampleDescr == null) : "Sampling and list bucketing can't coexist.";
                paths = ListBucketingPruner.prune(parseCtx, part, listBucketingPruner);
            } else {
                if (parseCtx.getGlobalLimitCtx().isEnable()) {
                    if (isFirstPart) {
                        long sizeLeft = sizeNeeded;
                        ArrayList<Path> retPathList = new ArrayList<Path>();
                        SamplePruner.LimitPruneRetStatus status = SamplePruner.limitPrune(part, sizeLeft, fileLimit, retPathList);
                        if (status.equals((Object)SamplePruner.LimitPruneRetStatus.NoFile)) continue;
                        if (status.equals((Object)SamplePruner.LimitPruneRetStatus.NotQualify)) {
                            LOG.info((Object)("Use full input -- first " + fileLimit + " files are more than " + sizeNeeded + " bytes"));
                            parseCtx.getGlobalLimitCtx().disableOpt();
                        } else {
                            emptyInput = false;
                            paths = new Path[retPathList.size()];
                            int index = 0;
                            for (Path path : retPathList) {
                                paths[index++] = path;
                            }
                            if (status.equals((Object)SamplePruner.LimitPruneRetStatus.NeedAllFiles) && singlePartition) {
                                parseCtx.getGlobalLimitCtx().disableOpt();
                            }
                        }
                        isFirstPart = false;
                    } else {
                        paths = new Path[]{};
                    }
                }
                if (!parseCtx.getGlobalLimitCtx().isEnable()) {
                    paths = part.getPath();
                }
            }
            if (!part.getTable().isPartitioned()) {
                assert (tblDir == null && tblDesc == null);
                tblDir = paths[0];
                tblDesc = Utilities.getTableDesc(part.getTable());
            } else if (tblDesc == null) {
                tblDesc = Utilities.getTableDesc(part.getTable());
            }
            if (props != null) {
                Properties target = tblDesc.getProperties();
                if (target == null) {
                    target = new Properties();
                    tblDesc.setProperties(target);
                }
                target.putAll(props);
            }
            for (Path p : paths) {
                if (p == null) continue;
                String path = p.toString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding " + path + " of table" + alias_id));
                }
                partDir.add(p);
                try {
                    if (part.getTable().isPartitioned()) {
                        partDesc.add(Utilities.getPartitionDesc(part));
                        continue;
                    }
                    partDesc.add(Utilities.getPartitionDescFromTableDesc(tblDesc, part));
                }
                catch (HiveException e) {
                    LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                    throw new SemanticException(e.getMessage(), e);
                }
            }
        }
        if (emptyInput) {
            parseCtx.getGlobalLimitCtx().disableOpt();
        }
        Iterator iterPath = partDir.iterator();
        Iterator iterPartnDesc = partDesc.iterator();
        if (!local) {
            while (iterPath.hasNext()) {
                assert (iterPartnDesc.hasNext());
                String path = ((Path)iterPath.next()).toString();
                PartitionDesc prtDesc = (PartitionDesc)iterPartnDesc.next();
                if (plan.getPathToAliases().get(path) == null) {
                    plan.getPathToAliases().put(path, new ArrayList());
                }
                plan.getPathToAliases().get(path).add(alias_id);
                plan.getPathToPartitionInfo().put(path, prtDesc);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Information added for path " + path));
            }
            assert (plan.getAliasToWork().get(alias_id) == null);
            plan.getAliasToWork().put(alias_id, topOp);
        } else {
            MapredLocalWork localPlan = plan.getMapLocalWork();
            if (localPlan == null) {
                localPlan = new MapredLocalWork(new LinkedHashMap<String, Operator<? extends OperatorDesc>>(), new LinkedHashMap<String, FetchWork>());
            }
            assert (localPlan.getAliasToWork().get(alias_id) == null);
            assert (localPlan.getAliasToFetchWork().get(alias_id) == null);
            localPlan.getAliasToWork().put(alias_id, topOp);
            if (tblDir == null) {
                tblDesc = Utilities.getTableDesc(partsList.getSourceTable());
                localPlan.getAliasToFetchWork().put(alias_id, new FetchWork(FetchWork.convertPathToStringArray(partDir), partDesc, tblDesc));
            } else {
                localPlan.getAliasToFetchWork().put(alias_id, new FetchWork(tblDir.toString(), tblDesc));
            }
            plan.setMapLocalWork(localPlan);
        }
        opProcCtx.addSeenOp(task, topOp);
    }

    public static void setTaskPlan(String path, String alias, Operator<? extends OperatorDesc> topOp, MapWork plan, boolean local, TableDesc tt_desc) throws SemanticException {
        if (path == null || alias == null) {
            return;
        }
        if (!local) {
            if (plan.getPathToAliases().get(path) == null) {
                plan.getPathToAliases().put(path, new ArrayList());
            }
            plan.getPathToAliases().get(path).add(alias);
            plan.getPathToPartitionInfo().put(path, new PartitionDesc(tt_desc, null));
            plan.getAliasToWork().put(alias, topOp);
        } else {
            MapredLocalWork localPlan = plan.getMapLocalWork();
            if (localPlan == null) {
                localPlan = new MapredLocalWork(new LinkedHashMap<String, Operator<? extends OperatorDesc>>(), new LinkedHashMap<String, FetchWork>());
            }
            assert (localPlan.getAliasToWork().get(alias) == null);
            assert (localPlan.getAliasToFetchWork().get(alias) == null);
            localPlan.getAliasToWork().put(alias, topOp);
            localPlan.getAliasToFetchWork().put(alias, new FetchWork(alias, tt_desc));
            plan.setMapLocalWork(localPlan);
        }
    }

    public static void setKeyAndValueDesc(ReduceWork plan, Operator<? extends OperatorDesc> topOp) {
        if (topOp == null) {
            return;
        }
        if (topOp instanceof ReduceSinkOperator) {
            ReduceSinkOperator rs = (ReduceSinkOperator)topOp;
            plan.setKeyDesc(((ReduceSinkDesc)rs.getConf()).getKeySerializeInfo());
            int tag = Math.max(0, ((ReduceSinkDesc)rs.getConf()).getTag());
            List<TableDesc> tagToSchema = plan.getTagToValueDesc();
            while (tag + 1 > tagToSchema.size()) {
                tagToSchema.add(null);
            }
            tagToSchema.set(tag, ((ReduceSinkDesc)rs.getConf()).getValueSerializeInfo());
        } else {
            List<Operator<OperatorDesc>> children = topOp.getChildOperators();
            if (children != null) {
                for (Operator<OperatorDesc> op : children) {
                    GenMapRedUtils.setKeyAndValueDesc(plan, op);
                }
            }
        }
    }

    public static void setKeyAndValueDescForTaskTree(Task<? extends Serializable> task) {
        if (task instanceof ConditionalTask) {
            List<Task<? extends Serializable>> listTasks = ((ConditionalTask)task).getListTasks();
            for (Task<? extends Serializable> tsk : listTasks) {
                GenMapRedUtils.setKeyAndValueDescForTaskTree(tsk);
            }
        } else if (task instanceof ExecDriver) {
            MapredWork work = (MapredWork)task.getWork();
            work.getMapWork().deriveExplainAttributes();
            LinkedHashMap<String, Operator<? extends OperatorDesc>> opMap = work.getMapWork().getAliasToWork();
            if (opMap != null && !opMap.isEmpty()) {
                for (Operator op : ((HashMap)opMap).values()) {
                    GenMapRedUtils.setKeyAndValueDesc(work.getReduceWork(), op);
                }
            }
        }
        if (task.getChildTasks() == null) {
            return;
        }
        for (Task<Serializable> childTask : task.getChildTasks()) {
            GenMapRedUtils.setKeyAndValueDescForTaskTree(childTask);
        }
    }

    public static MapredWork getMapRedWork(ParseContext parseCtx) {
        MapredWork work = GenMapRedUtils.getMapRedWorkFromConf(parseCtx.getConf());
        work.getMapWork().setNameToSplitSample(parseCtx.getNameToSplitSample());
        return work;
    }

    public static MapredWork getMapRedWorkFromConf(HiveConf conf) {
        MapredWork mrWork = new MapredWork();
        MapWork work = mrWork.getMapWork();
        boolean mapperCannotSpanPartns = conf.getBoolVar(HiveConf.ConfVars.HIVE_MAPPER_CANNOT_SPAN_MULTIPLE_PARTITIONS);
        work.setMapperCannotSpanPartns(mapperCannotSpanPartns);
        work.setPathToAliases(new LinkedHashMap<String, ArrayList<String>>());
        work.setPathToPartitionInfo(new LinkedHashMap<String, PartitionDesc>());
        work.setAliasToWork(new LinkedHashMap<String, Operator<? extends OperatorDesc>>());
        work.setHadoopSupportsSplittable(conf.getBoolVar(HiveConf.ConfVars.HIVE_COMBINE_INPUT_FORMAT_SUPPORTS_SPLITTABLE));
        return mrWork;
    }

    public static Operator<? extends OperatorDesc> putOpInsertMap(Operator<? extends OperatorDesc> op, RowResolver rr, ParseContext parseCtx) {
        OpParseContext ctx = new OpParseContext(rr);
        parseCtx.getOpParseCtx().put(op, ctx);
        return op;
    }

    private static void splitTasks(ReduceSinkOperator op, Task<? extends Serializable> parentTask, Task<? extends Serializable> childTask, GenMRProcContext opProcCtx) throws SemanticException {
        if (op.getNumParent() != 1) {
            throw new IllegalStateException("Expecting operator " + op + " to have one parent. " + "But found multiple parents : " + op.getParentOperators());
        }
        ParseContext parseCtx = opProcCtx.getParseCtx();
        parentTask.addDependentTask(childTask);
        List<Task<? extends Serializable>> rootTasks = opProcCtx.getRootTasks();
        if (rootTasks.contains(childTask)) {
            rootTasks.remove(childTask);
        }
        Context baseCtx = parseCtx.getContext();
        String taskTmpDir = baseCtx.getMRTmpFileURI();
        Operator<OperatorDesc> parent = op.getParentOperators().get(0);
        TableDesc tt_desc = PlanUtils.getIntermediateFileTableDesc(PlanUtils.getFieldSchemasFromRowSchema(parent.getSchema(), "temporarycol"));
        boolean compressIntermediate = parseCtx.getConf().getBoolVar(HiveConf.ConfVars.COMPRESSINTERMEDIATE);
        FileSinkDesc desc = new FileSinkDesc(taskTmpDir, tt_desc, compressIntermediate);
        if (compressIntermediate) {
            desc.setCompressCodec(parseCtx.getConf().getVar(HiveConf.ConfVars.COMPRESSINTERMEDIATECODEC));
            desc.setCompressType(parseCtx.getConf().getVar(HiveConf.ConfVars.COMPRESSINTERMEDIATETYPE));
        }
        Operator<? extends OperatorDesc> fs_op = GenMapRedUtils.putOpInsertMap(OperatorFactory.get(desc, parent.getSchema(), new Operator[0]), null, parseCtx);
        List<Operator<? extends OperatorDesc>> childOpList = parent.getChildOperators();
        for (int pos = 0; pos < childOpList.size(); ++pos) {
            if (childOpList.get(pos) != op) continue;
            childOpList.set(pos, fs_op);
            break;
        }
        ArrayList<Operator<? extends OperatorDesc>> parentOpList = new ArrayList<Operator<? extends OperatorDesc>>();
        parentOpList.add(parent);
        fs_op.setParentOperators(parentOpList);
        RowResolver rowResolver = opProcCtx.getParseCtx().getOpParseCtx().get(parent).getRowResolver();
        Operator<? extends OperatorDesc> ts_op = GenMapRedUtils.putOpInsertMap(OperatorFactory.get(TableScanDesc.class, parent.getSchema()), rowResolver, parseCtx);
        childOpList = new ArrayList<Operator<OperatorDesc>>();
        childOpList.add(op);
        ts_op.setChildOperators(childOpList);
        op.getParentOperators().set(0, ts_op);
        LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = opProcCtx.getMapCurrCtx();
        mapCurrCtx.put(ts_op, new GenMRProcContext.GenMapRedCtx(childTask, null));
        String streamDesc = taskTmpDir;
        MapredWork cplan = (MapredWork)childTask.getWork();
        Operator<OperatorDesc> reducer = op.getChildOperators().get(0);
        if (GenMapRedUtils.needsTagging(cplan.getReduceWork())) {
            String origStreamDesc = streamDesc = "$INTNAME";
            int pos = 0;
            while (cplan.getMapWork().getAliasToWork().get(streamDesc) != null) {
                streamDesc = origStreamDesc.concat(String.valueOf(++pos));
            }
            cplan.getReduceWork().setNeedsTagging(true);
        }
        GenMapRedUtils.setTaskPlan(taskTmpDir, streamDesc, ts_op, cplan.getMapWork(), false, tt_desc);
        opProcCtx.setCurrTopOp(null);
        opProcCtx.setCurrAliasId(null);
        opProcCtx.setCurrTask(childTask);
        opProcCtx.addRootIfPossible(parentTask);
    }

    static boolean hasBranchFinished(Object ... children) {
        for (Object child : children) {
            if (child != null) continue;
            return false;
        }
        return true;
    }

    public static void replaceMapWork(String sourceAlias, String targetAlias, MapWork source, MapWork target) {
        LinkedHashMap<String, ArrayList<String>> sourcePathToAliases = source.getPathToAliases();
        LinkedHashMap<String, PartitionDesc> sourcePathToPartitionInfo = source.getPathToPartitionInfo();
        LinkedHashMap<String, Operator<? extends OperatorDesc>> sourceAliasToWork = source.getAliasToWork();
        LinkedHashMap<String, PartitionDesc> sourceAliasToPartnInfo = source.getAliasToPartnInfo();
        LinkedHashMap<String, ArrayList<String>> targetPathToAliases = target.getPathToAliases();
        LinkedHashMap<String, PartitionDesc> targetPathToPartitionInfo = target.getPathToPartitionInfo();
        LinkedHashMap<String, Operator<? extends OperatorDesc>> targetAliasToWork = target.getAliasToWork();
        LinkedHashMap<String, PartitionDesc> targetAliasToPartnInfo = target.getAliasToPartnInfo();
        if (!sourceAliasToWork.containsKey(sourceAlias) || !targetAliasToWork.containsKey(targetAlias)) {
            return;
        }
        if (sourceAliasToWork.size() > 1) {
            return;
        }
        targetAliasToWork.remove(targetAlias);
        targetAliasToPartnInfo.remove(targetAlias);
        ArrayList pathsToRemove = new ArrayList();
        for (Map.Entry entry : targetPathToAliases.entrySet()) {
            ArrayList aliases = (ArrayList)entry.getValue();
            aliases.remove(targetAlias);
            if (!aliases.isEmpty()) continue;
            pathsToRemove.add(entry.getKey());
        }
        for (String pathToRemove : pathsToRemove) {
            targetPathToAliases.remove(pathToRemove);
            targetPathToPartitionInfo.remove(pathToRemove);
        }
        targetAliasToWork.put(sourceAlias, (Operator<? extends OperatorDesc>)sourceAliasToWork.get(sourceAlias));
        targetAliasToPartnInfo.putAll(sourceAliasToPartnInfo);
        targetPathToPartitionInfo.putAll(sourcePathToPartitionInfo);
        ArrayList pathsToAdd = new ArrayList();
        for (Map.Entry entry : sourcePathToAliases.entrySet()) {
            ArrayList aliases = (ArrayList)entry.getValue();
            if (!aliases.contains(sourceAlias)) continue;
            pathsToAdd.add(entry.getKey());
        }
        for (String pathToAdd : pathsToAdd) {
            if (!targetPathToAliases.containsKey(pathToAdd)) {
                targetPathToAliases.put(pathToAdd, new ArrayList());
            }
            ((ArrayList)targetPathToAliases.get(pathToAdd)).add(sourceAlias);
        }
    }

    private GenMapRedUtils() {
    }
}

