/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.FileMetadataHandler;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FileMetadataExprType;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.thrift.TException;

public interface RawStore
extends Configurable {
    public void shutdown();

    public boolean openTransaction();

    @CanNotRetry
    public boolean commitTransaction();

    public boolean isActiveTransaction();

    @CanNotRetry
    public void rollbackTransaction();

    public void createDatabase(Database var1) throws InvalidObjectException, MetaException;

    public Database getDatabase(String var1) throws NoSuchObjectException;

    public boolean dropDatabase(String var1) throws NoSuchObjectException, MetaException;

    public boolean alterDatabase(String var1, Database var2) throws NoSuchObjectException, MetaException;

    public List<String> getDatabases(String var1) throws MetaException;

    public List<String> getAllDatabases() throws MetaException;

    public boolean createType(Type var1);

    public Type getType(String var1);

    public boolean dropType(String var1);

    public void createTable(Table var1) throws InvalidObjectException, MetaException;

    public boolean dropTable(String var1, String var2) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException;

    public Table getTable(String var1, String var2) throws MetaException;

    public boolean addPartition(Partition var1) throws InvalidObjectException, MetaException;

    public boolean addPartitions(String var1, String var2, List<Partition> var3) throws InvalidObjectException, MetaException;

    public boolean addPartitions(String var1, String var2, PartitionSpecProxy var3, boolean var4) throws InvalidObjectException, MetaException;

    public Partition getPartition(String var1, String var2, List<String> var3) throws MetaException, NoSuchObjectException;

    public boolean doesPartitionExist(String var1, String var2, List<String> var3) throws MetaException, NoSuchObjectException;

    public boolean dropPartition(String var1, String var2, List<String> var3) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException;

    public List<Partition> getPartitions(String var1, String var2, int var3) throws MetaException, NoSuchObjectException;

    public void alterTable(String var1, String var2, Table var3) throws InvalidObjectException, MetaException;

    public List<String> getTables(String var1, String var2) throws MetaException;

    public List<String> getTables(String var1, String var2, TableType var3) throws MetaException;

    public List<TableMeta> getTableMeta(String var1, String var2, List<String> var3) throws MetaException;

    public List<Table> getTableObjectsByName(String var1, List<String> var2) throws MetaException, UnknownDBException;

    public List<String> getAllTables(String var1) throws MetaException;

    public List<String> listTableNamesByFilter(String var1, String var2, short var3) throws MetaException, UnknownDBException;

    public List<String> listPartitionNames(String var1, String var2, short var3) throws MetaException;

    public List<String> listPartitionNamesByFilter(String var1, String var2, String var3, short var4) throws MetaException;

    public void alterPartition(String var1, String var2, List<String> var3, Partition var4) throws InvalidObjectException, MetaException;

    public void alterPartitions(String var1, String var2, List<List<String>> var3, List<Partition> var4) throws InvalidObjectException, MetaException;

    public boolean addIndex(Index var1) throws InvalidObjectException, MetaException;

    public Index getIndex(String var1, String var2, String var3) throws MetaException;

    public boolean dropIndex(String var1, String var2, String var3) throws MetaException;

    public List<Index> getIndexes(String var1, String var2, int var3) throws MetaException;

    public List<String> listIndexNames(String var1, String var2, short var3) throws MetaException;

    public void alterIndex(String var1, String var2, String var3, Index var4) throws InvalidObjectException, MetaException;

    public List<Partition> getPartitionsByFilter(String var1, String var2, String var3, short var4) throws MetaException, NoSuchObjectException;

    public boolean getPartitionsByExpr(String var1, String var2, byte[] var3, String var4, short var5, List<Partition> var6) throws TException;

    public int getNumPartitionsByFilter(String var1, String var2, String var3) throws MetaException, NoSuchObjectException;

    public int getNumPartitionsByExpr(String var1, String var2, byte[] var3) throws MetaException, NoSuchObjectException;

    public List<Partition> getPartitionsByNames(String var1, String var2, List<String> var3) throws MetaException, NoSuchObjectException;

    public Table markPartitionForEvent(String var1, String var2, Map<String, String> var3, PartitionEventType var4) throws MetaException, UnknownTableException, InvalidPartitionException, UnknownPartitionException;

    public boolean isPartitionMarkedForEvent(String var1, String var2, Map<String, String> var3, PartitionEventType var4) throws MetaException, UnknownTableException, InvalidPartitionException, UnknownPartitionException;

    public boolean addRole(String var1, String var2) throws InvalidObjectException, MetaException, NoSuchObjectException;

    public boolean removeRole(String var1) throws MetaException, NoSuchObjectException;

    public boolean grantRole(Role var1, String var2, PrincipalType var3, String var4, PrincipalType var5, boolean var6) throws MetaException, NoSuchObjectException, InvalidObjectException;

    public boolean revokeRole(Role var1, String var2, PrincipalType var3, boolean var4) throws MetaException, NoSuchObjectException;

    public PrincipalPrivilegeSet getUserPrivilegeSet(String var1, List<String> var2) throws InvalidObjectException, MetaException;

    public PrincipalPrivilegeSet getDBPrivilegeSet(String var1, String var2, List<String> var3) throws InvalidObjectException, MetaException;

    public PrincipalPrivilegeSet getTablePrivilegeSet(String var1, String var2, String var3, List<String> var4) throws InvalidObjectException, MetaException;

    public PrincipalPrivilegeSet getPartitionPrivilegeSet(String var1, String var2, String var3, String var4, List<String> var5) throws InvalidObjectException, MetaException;

    public PrincipalPrivilegeSet getColumnPrivilegeSet(String var1, String var2, String var3, String var4, String var5, List<String> var6) throws InvalidObjectException, MetaException;

    public List<HiveObjectPrivilege> listPrincipalGlobalGrants(String var1, PrincipalType var2);

    public List<HiveObjectPrivilege> listPrincipalDBGrants(String var1, PrincipalType var2, String var3);

    public List<HiveObjectPrivilege> listAllTableGrants(String var1, PrincipalType var2, String var3, String var4);

    public List<HiveObjectPrivilege> listPrincipalPartitionGrants(String var1, PrincipalType var2, String var3, String var4, List<String> var5, String var6);

    public List<HiveObjectPrivilege> listPrincipalTableColumnGrants(String var1, PrincipalType var2, String var3, String var4, String var5);

    public List<HiveObjectPrivilege> listPrincipalPartitionColumnGrants(String var1, PrincipalType var2, String var3, String var4, List<String> var5, String var6, String var7);

    public boolean grantPrivileges(PrivilegeBag var1) throws InvalidObjectException, MetaException, NoSuchObjectException;

    public boolean revokePrivileges(PrivilegeBag var1, boolean var2) throws InvalidObjectException, MetaException, NoSuchObjectException;

    public Role getRole(String var1) throws NoSuchObjectException;

    public List<String> listRoleNames();

    public List<Role> listRoles(String var1, PrincipalType var2);

    public List<RolePrincipalGrant> listRolesWithGrants(String var1, PrincipalType var2);

    public List<RolePrincipalGrant> listRoleMembers(String var1);

    public Partition getPartitionWithAuth(String var1, String var2, List<String> var3, String var4, List<String> var5) throws MetaException, NoSuchObjectException, InvalidObjectException;

    public List<Partition> getPartitionsWithAuth(String var1, String var2, short var3, String var4, List<String> var5) throws MetaException, NoSuchObjectException, InvalidObjectException;

    public List<String> listPartitionNamesPs(String var1, String var2, List<String> var3, short var4) throws MetaException, NoSuchObjectException;

    public List<Partition> listPartitionsPsWithAuth(String var1, String var2, List<String> var3, short var4, String var5, List<String> var6) throws MetaException, InvalidObjectException, NoSuchObjectException;

    public boolean updateTableColumnStatistics(ColumnStatistics var1) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException;

    public boolean updatePartitionColumnStatistics(ColumnStatistics var1, List<String> var2) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException;

    public ColumnStatistics getTableColumnStatistics(String var1, String var2, List<String> var3) throws MetaException, NoSuchObjectException;

    public List<ColumnStatistics> getPartitionColumnStatistics(String var1, String var2, List<String> var3, List<String> var4) throws MetaException, NoSuchObjectException;

    public boolean deletePartitionColumnStatistics(String var1, String var2, String var3, List<String> var4, String var5) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException;

    public boolean deleteTableColumnStatistics(String var1, String var2, String var3) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException;

    public long cleanupEvents();

    public boolean addToken(String var1, String var2);

    public boolean removeToken(String var1);

    public String getToken(String var1);

    public List<String> getAllTokenIdentifiers();

    public int addMasterKey(String var1) throws MetaException;

    public void updateMasterKey(Integer var1, String var2) throws NoSuchObjectException, MetaException;

    public boolean removeMasterKey(Integer var1);

    public String[] getMasterKeys();

    public void verifySchema() throws MetaException;

    public String getMetaStoreSchemaVersion() throws MetaException;

    public void setMetaStoreSchemaVersion(String var1, String var2) throws MetaException;

    public void dropPartitions(String var1, String var2, List<String> var3) throws MetaException, NoSuchObjectException;

    public List<HiveObjectPrivilege> listPrincipalDBGrantsAll(String var1, PrincipalType var2);

    public List<HiveObjectPrivilege> listPrincipalTableGrantsAll(String var1, PrincipalType var2);

    public List<HiveObjectPrivilege> listPrincipalPartitionGrantsAll(String var1, PrincipalType var2);

    public List<HiveObjectPrivilege> listPrincipalTableColumnGrantsAll(String var1, PrincipalType var2);

    public List<HiveObjectPrivilege> listPrincipalPartitionColumnGrantsAll(String var1, PrincipalType var2);

    public List<HiveObjectPrivilege> listGlobalGrantsAll();

    public List<HiveObjectPrivilege> listDBGrantsAll(String var1);

    public List<HiveObjectPrivilege> listPartitionColumnGrantsAll(String var1, String var2, String var3, String var4);

    public List<HiveObjectPrivilege> listTableGrantsAll(String var1, String var2);

    public List<HiveObjectPrivilege> listPartitionGrantsAll(String var1, String var2, String var3);

    public List<HiveObjectPrivilege> listTableColumnGrantsAll(String var1, String var2, String var3);

    public void createFunction(Function var1) throws InvalidObjectException, MetaException;

    public void alterFunction(String var1, String var2, Function var3) throws InvalidObjectException, MetaException;

    public void dropFunction(String var1, String var2) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException;

    public Function getFunction(String var1, String var2) throws MetaException;

    public List<Function> getAllFunctions() throws MetaException;

    public List<String> getFunctions(String var1, String var2) throws MetaException;

    public AggrStats get_aggr_stats_for(String var1, String var2, List<String> var3, List<String> var4) throws MetaException, NoSuchObjectException;

    public NotificationEventResponse getNextNotification(NotificationEventRequest var1);

    public void addNotificationEvent(NotificationEvent var1);

    public void cleanNotificationEvents(int var1);

    public CurrentNotificationEventId getCurrentNotificationEventId();

    public void flushCache();

    public ByteBuffer[] getFileMetadata(List<Long> var1) throws MetaException;

    public void putFileMetadata(List<Long> var1, List<ByteBuffer> var2, FileMetadataExprType var3) throws MetaException;

    public boolean isFileMetadataSupported();

    public void getFileMetadataByExpr(List<Long> var1, FileMetadataExprType var2, byte[] var3, ByteBuffer[] var4, ByteBuffer[] var5, boolean[] var6) throws MetaException;

    public FileMetadataHandler getFileMetadataHandler(FileMetadataExprType var1);

    @InterfaceStability.Evolving
    public int getTableCount() throws MetaException;

    @InterfaceStability.Evolving
    public int getPartitionCount() throws MetaException;

    @InterfaceStability.Evolving
    public int getDatabaseCount() throws MetaException;

    public List<SQLPrimaryKey> getPrimaryKeys(String var1, String var2) throws MetaException;

    public List<SQLForeignKey> getForeignKeys(String var1, String var2, String var3, String var4) throws MetaException;

    public void createTableWithConstraints(Table var1, List<SQLPrimaryKey> var2, List<SQLForeignKey> var3) throws InvalidObjectException, MetaException;

    public void dropConstraint(String var1, String var2, String var3) throws NoSuchObjectException;

    public void addPrimaryKeys(List<SQLPrimaryKey> var1) throws InvalidObjectException, MetaException;

    public void addForeignKeys(List<SQLForeignKey> var1) throws InvalidObjectException, MetaException;

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CanNotRetry {
    }
}

