/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.InterruptibleProcessing;
import org.apache.hadoop.hive.ql.exec.tez.TezProcessor;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RecordProcessor
extends InterruptibleProcessing {
    protected final JobConf jconf;
    protected Map<String, LogicalInput> inputs;
    protected Map<String, LogicalOutput> outputs;
    protected Map<String, OutputCollector> outMap;
    protected final ProcessorContext processorContext;
    public static final Logger l4j = LoggerFactory.getLogger(RecordProcessor.class);
    protected boolean isLogInfoEnabled = false;
    protected boolean isLogTraceEnabled = false;
    protected MRTaskReporter reporter;
    protected PerfLogger perfLogger = SessionState.getPerfLogger();
    protected String CLASS_NAME = RecordProcessor.class.getName();

    public RecordProcessor(JobConf jConf, ProcessorContext processorContext) {
        this.jconf = jConf;
        this.processorContext = processorContext;
    }

    void init(MRTaskReporter mrReporter, Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        this.reporter = mrReporter;
        this.inputs = inputs;
        this.outputs = outputs;
        this.isLogInfoEnabled = l4j.isInfoEnabled();
        this.isLogTraceEnabled = l4j.isTraceEnabled();
        this.checkAbortCondition();
        try {
            if (l4j.isDebugEnabled()) {
                l4j.debug("conf classpath = " + Arrays.asList(((URLClassLoader)this.jconf.getClassLoader()).getURLs()));
                l4j.debug("thread classpath = " + Arrays.asList(((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs()));
            }
        }
        catch (Exception e) {
            l4j.info("cannot get classpath: " + e.getMessage());
        }
    }

    abstract void run() throws Exception;

    abstract void close();

    protected void createOutputMap() {
        Preconditions.checkState(this.outMap == null, "Outputs should only be setup once");
        this.outMap = Maps.newHashMap();
        for (Map.Entry<String, LogicalOutput> entry : this.outputs.entrySet()) {
            TezProcessor.TezKVOutputCollector collector = new TezProcessor.TezKVOutputCollector(entry.getValue());
            this.outMap.put(entry.getKey(), collector);
        }
    }

    public List<BaseWork> getMergeWorkList(final JobConf jconf, String key, String queryId, ObjectCache cache, List<String> cacheKeys) throws HiveException {
        String prefixes = jconf.get("hive.tez.merge.file.prefixes");
        if (prefixes != null) {
            ArrayList<BaseWork> mergeWorkList = new ArrayList<BaseWork>();
            for (final String prefix : prefixes.split(",")) {
                if (prefix == null || prefix.isEmpty()) continue;
                key = prefix;
                cacheKeys.add(key);
                mergeWorkList.add((BaseWork)cache.retrieve(key, new Callable<Object>(){

                    @Override
                    public Object call() {
                        return Utilities.getMergeWork((Configuration)jconf, prefix);
                    }
                }));
            }
            return mergeWorkList;
        }
        return null;
    }
}

