/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorMR;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorThread;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Worker
extends CompactorThread {
    private static final String CLASS_NAME = Worker.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final long SLEEP_TIME = 5000L;
    private static final int baseThreadNum = 10002;
    private String name;
    private JobConf mrJob;

    public static String hostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Unable to resolve my host name " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        do {
            boolean launchedJob = false;
            try {
                String runAs;
                Partition p;
                Table t;
                CompactionInfo ci;
                block25: {
                    Table t1;
                    block24: {
                        ci = this.txnHandler.findNextToCompact(this.name);
                        if (ci == null && !this.stop.get()) {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException e) {
                                LOG.warn("Worker thread sleep interrupted " + e.getMessage());
                            }
                            continue;
                        }
                        t1 = null;
                        try {
                            t1 = this.resolveTable(ci);
                            if (t1 == null) {
                                LOG.info("Unable to find table " + ci.getFullTableName() + ", assuming it was dropped and moving on.");
                                this.txnHandler.markCleaned(ci);
                            }
                            break block24;
                        }
                        catch (MetaException e) {
                            this.txnHandler.markCleaned(ci);
                        }
                        continue;
                    }
                    t = t1;
                    p = null;
                    try {
                        p = this.resolvePartition(ci);
                        if (p == null && ci.partName != null) {
                            LOG.info("Unable to find partition " + ci.getFullPartitionName() + ", assuming it was dropped and moving on.");
                            this.txnHandler.markCleaned(ci);
                        }
                        break block25;
                    }
                    catch (Exception e) {
                        this.txnHandler.markCleaned(ci);
                    }
                    continue;
                }
                final StorageDescriptor sd = this.resolveStorageDescriptor(t, p);
                if (sd.getSortCols() != null && !sd.getSortCols().isEmpty()) {
                    LOG.error("Attempt to compact sorted table, which is not yet supported!");
                    this.txnHandler.markCleaned(ci);
                    continue;
                }
                boolean isMajor = ci.isMajorCompaction();
                final ValidTxnList txns = TxnUtils.createValidCompactTxnList(this.txnHandler.getOpenTxnsInfo());
                LOG.debug("ValidCompactTxnList: " + txns.writeToString());
                this.txnHandler.setCompactionHighestTxnId(ci, txns.getHighWatermark());
                final StringBuilder jobName = new StringBuilder(this.name);
                jobName.append("-compactor-");
                jobName.append(ci.getFullPartitionName());
                if (ci.runAs == null) {
                    runAs = this.findUserToRunAs(sd.getLocation(), t);
                    this.txnHandler.setRunAs(ci.id, runAs);
                } else {
                    runAs = ci.runAs;
                }
                LOG.info("Starting " + ci.type.toString() + " compaction for " + ci.getFullPartitionName());
                final StatsUpdater su = StatsUpdater.init(ci, this.txnHandler.findColumnsWithStats(ci), this.conf, this.runJobAsSelf(runAs) ? runAs : t.getOwner());
                final CompactorMR mr = new CompactorMR();
                launchedJob = true;
                try {
                    if (this.runJobAsSelf(runAs)) {
                        mr.run(this.conf, jobName.toString(), t, sd, txns, ci, su, this.txnHandler);
                    } else {
                        UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)t.getOwner(), (UserGroupInformation)UserGroupInformation.getLoginUser());
                        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                mr.run(Worker.this.conf, jobName.toString(), t, sd, txns, ci, su, Worker.this.txnHandler);
                                return null;
                            }
                        });
                        try {
                            FileSystem.closeAllForUGI((UserGroupInformation)ugi);
                        }
                        catch (IOException exception) {
                            LOG.error("Could not clean up file-system handles for UGI: " + ugi + " for " + ci.getFullPartitionName(), (Throwable)exception);
                        }
                    }
                    this.txnHandler.markCompacted(ci);
                    if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
                        this.mrJob = mr.getMrJob();
                    }
                }
                catch (Exception e) {
                    LOG.error("Caught exception while trying to compact " + ci + ".  Marking failed to avoid repeated failures, " + StringUtils.stringifyException((Throwable)e));
                    this.txnHandler.markFailed(ci);
                }
            }
            catch (Throwable t) {
                LOG.error("Caught an exception in the main loop of compactor worker " + this.name + ", " + StringUtils.stringifyException((Throwable)t));
            }
            if (launchedJob || this.stop.get()) continue;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.stop.get());
    }

    @Override
    public void init(AtomicBoolean stop, AtomicBoolean looped) throws MetaException {
        super.init(stop, looped);
        StringBuilder name = new StringBuilder(Worker.hostname());
        name.append("-");
        name.append(this.getId());
        this.name = name.toString();
        this.setName(name.toString());
    }

    public JobConf getMrJob() {
        return this.mrJob;
    }

    static final class StatsUpdater {
        private static final Logger LOG = LoggerFactory.getLogger(StatsUpdater.class);
        private final List<String> columnList;
        private final HiveConf conf;
        private final String userName;
        private final CompactionInfo ci;

        public static StatsUpdater init(CompactionInfo ci, List<String> columnListForStats, HiveConf conf, String userName) {
            return new StatsUpdater(ci, columnListForStats, conf, userName);
        }

        private StatsUpdater(CompactionInfo ci, List<String> columnListForStats, HiveConf conf, String userName) {
            this.conf = conf;
            this.userName = userName;
            this.ci = ci;
            if (!ci.isMajorCompaction() || columnListForStats == null || columnListForStats.isEmpty()) {
                this.columnList = Collections.emptyList();
                return;
            }
            this.columnList = columnListForStats;
        }

        void gatherStats() throws IOException {
            if (!this.ci.isMajorCompaction()) {
                return;
            }
            if (this.columnList.isEmpty()) {
                LOG.debug("No existing stats for " + this.ci.dbname + "." + this.ci.tableName + " found.  Will not run analyze.");
                return;
            }
            StringBuilder sb = new StringBuilder("analyze table ").append(this.ci.dbname).append(".").append(this.ci.tableName);
            if (this.ci.partName != null) {
                try {
                    sb.append(" partition(");
                    Map<String, String> partitionColumnValues = Warehouse.makeEscSpecFromName(this.ci.partName);
                    for (Map.Entry<String, String> ent : partitionColumnValues.entrySet()) {
                        sb.append(ent.getKey()).append("='").append(ent.getValue()).append("'");
                    }
                    sb.append(")");
                }
                catch (MetaException ex) {
                    throw new IOException(ex);
                }
            }
            sb.append(" compute statistics for columns ");
            for (String colName : this.columnList) {
                sb.append(colName).append(",");
            }
            sb.setLength(sb.length() - 1);
            LOG.info("running '" + sb.toString() + "'");
            Driver d = new Driver(this.conf, this.userName);
            SessionState localSession = null;
            if (SessionState.get() == null) {
                localSession = SessionState.start(new SessionState(this.conf));
            }
            try {
                CommandProcessorResponse cpr = d.run(sb.toString());
                if (cpr.getResponseCode() != 0) {
                    throw new IOException("Could not update stats for table " + this.ci.getFullTableName() + (this.ci.partName == null ? "" : "/" + this.ci.partName) + " due to: " + cpr);
                }
            }
            catch (CommandNeedRetryException cnre) {
                throw new IOException("Could not update stats for table " + this.ci.getFullTableName() + (this.ci.partName == null ? "" : "/" + this.ci.partName) + " due to: " + cnre.getMessage());
            }
            finally {
                if (localSession != null) {
                    localSession.close();
                }
            }
        }
    }
}

