/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage.row;

import java.io.IOException;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.storage.row.HoodieRowDataFileWriter;
import org.apache.hudi.io.storage.row.HoodieRowDataParquetConfig;
import org.apache.hudi.io.storage.row.HoodieRowDataParquetWriteSupport;
import org.apache.hudi.io.storage.row.HoodieRowDataParquetWriter;
import org.apache.hudi.table.HoodieTable;

public class HoodieRowDataFileWriterFactory {
    public static HoodieRowDataFileWriter getRowDataFileWriter(Path path, HoodieTable hoodieTable, HoodieWriteConfig config, RowType schema) throws IOException {
        String extension = FSUtils.getFileExtension((String)path.getName());
        if (HoodieFileFormat.PARQUET.getFileExtension().equals(extension)) {
            return HoodieRowDataFileWriterFactory.newParquetInternalRowFileWriter(path, config, schema, hoodieTable);
        }
        throw new UnsupportedOperationException(extension + " format not supported yet.");
    }

    private static HoodieRowDataFileWriter newParquetInternalRowFileWriter(Path path, HoodieWriteConfig writeConfig, RowType rowType, HoodieTable table) throws IOException {
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)writeConfig.getBloomFilterNumEntries(), (double)writeConfig.getBloomFilterFPP(), (int)writeConfig.getDynamicBloomFilterMaxNumEntries(), (String)writeConfig.getBloomFilterType());
        HoodieRowDataParquetWriteSupport writeSupport = new HoodieRowDataParquetWriteSupport(table.getHadoopConf(), rowType, filter);
        return new HoodieRowDataParquetWriter(path, new HoodieRowDataParquetConfig(writeSupport, writeConfig.getParquetCompressionCodec(), writeConfig.getParquetBlockSize(), writeConfig.getParquetPageSize(), writeConfig.getParquetMaxFileSize(), writeSupport.getHadoopConf(), writeConfig.getParquetCompressionRatio()));
    }
}

