/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json.canal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonOptions;
import org.apache.flink.formats.json.canal.CanalJsonDecodingFormat;
import org.apache.flink.formats.json.canal.CanalJsonOptions;
import org.apache.flink.formats.json.canal.CanalJsonSerializationSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;

public class CanalJsonFormatFactory
implements DeserializationFormatFactory,
SerializationFormatFactory {
    public static final String IDENTIFIER = "canal-json";

    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        CanalJsonOptions.validateDecodingFormatOptions(formatOptions);
        String database = formatOptions.getOptional(CanalJsonOptions.DATABASE_INCLUDE).orElse(null);
        String table = formatOptions.getOptional(CanalJsonOptions.TABLE_INCLUDE).orElse(null);
        boolean ignoreParseErrors = (Boolean)formatOptions.get(CanalJsonOptions.IGNORE_PARSE_ERRORS);
        TimestampFormat timestampFormat = JsonOptions.getTimestampFormat(formatOptions);
        return new CanalJsonDecodingFormat(database, table, ignoreParseErrors, timestampFormat);
    }

    public EncodingFormat<SerializationSchema<RowData>> createEncodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        CanalJsonOptions.validateEncodingFormatOptions(formatOptions);
        final TimestampFormat timestampFormat = JsonOptions.getTimestampFormat(formatOptions);
        final JsonOptions.MapNullKeyMode mapNullKeyMode = JsonOptions.getMapNullKeyMode(formatOptions);
        final String mapNullKeyLiteral = (String)formatOptions.get(CanalJsonOptions.JSON_MAP_NULL_KEY_LITERAL);
        final boolean encodeDecimalAsPlainNumber = (Boolean)formatOptions.get(JsonOptions.ENCODE_DECIMAL_AS_PLAIN_NUMBER);
        return new EncodingFormat<SerializationSchema<RowData>>(){

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
            }

            public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType consumedDataType) {
                RowType rowType = (RowType)consumedDataType.getLogicalType();
                return new CanalJsonSerializationSchema(rowType, timestampFormat, mapNullKeyMode, mapNullKeyLiteral, encodeDecimalAsPlainNumber);
            }
        };
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(CanalJsonOptions.IGNORE_PARSE_ERRORS);
        options.add(CanalJsonOptions.TIMESTAMP_FORMAT);
        options.add(CanalJsonOptions.DATABASE_INCLUDE);
        options.add(CanalJsonOptions.TABLE_INCLUDE);
        options.add(CanalJsonOptions.JSON_MAP_NULL_KEY_MODE);
        options.add(CanalJsonOptions.JSON_MAP_NULL_KEY_LITERAL);
        options.add(JsonOptions.ENCODE_DECIMAL_AS_PLAIN_NUMBER);
        return options;
    }
}

