/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json.debezium;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.formats.json.JsonOptions;
import org.apache.flink.table.api.ValidationException;

public class DebeziumJsonOptions {
    public static final ConfigOption<Boolean> SCHEMA_INCLUDE = ConfigOptions.key((String)"schema-include").booleanType().defaultValue((Object)false).withDescription("When setting up a Debezium Kafka Connect, users can enable a Kafka configuration 'value.converter.schemas.enable' to include schema in the message. This option indicates the Debezium JSON data include the schema in the message or not. Default is false.");
    public static final ConfigOption<Boolean> IGNORE_PARSE_ERRORS = JsonOptions.IGNORE_PARSE_ERRORS;
    public static final ConfigOption<String> TIMESTAMP_FORMAT = JsonOptions.TIMESTAMP_FORMAT;
    public static final ConfigOption<String> JSON_MAP_NULL_KEY_MODE = JsonOptions.MAP_NULL_KEY_MODE;
    public static final ConfigOption<String> JSON_MAP_NULL_KEY_LITERAL = JsonOptions.MAP_NULL_KEY_LITERAL;

    public static void validateDecodingFormatOptions(ReadableConfig tableOptions) {
        JsonOptions.validateDecodingFormatOptions(tableOptions);
    }

    public static void validateEncodingFormatOptions(ReadableConfig tableOptions) {
        JsonOptions.validateEncodingFormatOptions(tableOptions);
        if (((Boolean)tableOptions.get(SCHEMA_INCLUDE)).booleanValue()) {
            throw new ValidationException(String.format("Debezium JSON serialization doesn't support '%s.%s' option been set to true.", "debezium-json", SCHEMA_INCLUDE.key()));
        }
    }
}

