/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet;

import java.util.ArrayList;
import java.util.Map;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.avro.typeutils.AvroConversions;
import org.apache.flink.formats.avro.typeutils.GenericRecordAvroTypeInfo;
import org.apache.flink.formats.parquet.ParquetInputFormat;
import org.apache.flink.types.Row;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.schema.MessageType;

public class ParquetAvroInputFormat
extends ParquetInputFormat<GenericRecord>
implements ResultTypeQueryable<GenericRecord> {
    private static final long serialVersionUID = 1L;
    private transient Schema avroSchema;
    private String avroSchemaString;

    public ParquetAvroInputFormat(Path filePath, MessageType messageType) {
        super(filePath, messageType);
        this.avroSchema = new AvroSchemaConverter().convert(messageType);
        this.avroSchemaString = this.avroSchema.toString();
    }

    @Override
    public void selectFields(String[] fieldNames) {
        this.avroSchema = this.getProjectedSchema(fieldNames, this.avroSchema);
        this.avroSchemaString = this.avroSchema.toString();
        super.selectFields(fieldNames);
    }

    @Override
    protected GenericRecord convert(Row row) {
        if (this.avroSchema == null) {
            this.avroSchema = new Schema.Parser().parse(this.avroSchemaString);
        }
        return AvroConversions.convertRowToAvroRecord((Schema)this.avroSchema, (Row)row);
    }

    public GenericRecordAvroTypeInfo getProducedType() {
        return new GenericRecordAvroTypeInfo(this.avroSchema);
    }

    private Schema getProjectedSchema(String[] projectedFieldNames, Schema sourceAvroSchema) {
        ArrayList<Schema.Field> projectedFields = new ArrayList<Schema.Field>();
        for (String fieldName : projectedFieldNames) {
            projectedFields.add(this.deepCopyField(sourceAvroSchema.getField(fieldName)));
        }
        return Schema.createRecord(sourceAvroSchema.getName() + "_projected", sourceAvroSchema.getDoc(), sourceAvroSchema.getNamespace(), sourceAvroSchema.isError(), projectedFields);
    }

    private Schema.Field deepCopyField(Schema.Field field) {
        Schema.Field newField = new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal(), field.order());
        for (Map.Entry<String, Object> kv : field.getObjectProps().entrySet()) {
            newField.addProp(kv.getKey(), kv.getValue());
        }
        if (field.aliases() != null) {
            for (String alias : field.aliases()) {
                newField.addAlias(alias);
            }
        }
        return newField;
    }

    public Schema getAvroSchema() {
        return this.avroSchema;
    }
}

