/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.parquet.ParquetRowInputFormat;
import org.apache.flink.formats.parquet.utils.ParquetSchemaConverter;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.expressions.And;
import org.apache.flink.table.expressions.Attribute;
import org.apache.flink.table.expressions.BinaryComparison;
import org.apache.flink.table.expressions.BinaryExpression;
import org.apache.flink.table.expressions.EqualTo;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.GreaterThan;
import org.apache.flink.table.expressions.GreaterThanOrEqual;
import org.apache.flink.table.expressions.LessThan;
import org.apache.flink.table.expressions.LessThanOrEqual;
import org.apache.flink.table.expressions.Literal;
import org.apache.flink.table.expressions.Not;
import org.apache.flink.table.expressions.NotEqualTo;
import org.apache.flink.table.expressions.Or;
import org.apache.flink.table.sources.BatchTableSource;
import org.apache.flink.table.sources.FilterableTableSource;
import org.apache.flink.table.sources.ProjectableTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.io.InvalidRecordException;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetTableSource
implements BatchTableSource<Row>,
FilterableTableSource<Row>,
ProjectableTableSource<Row> {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetTableSource.class);
    private final String path;
    private final MessageType parquetSchema;
    private final TableSchema tableSchema;
    private final Configuration parquetConfig;
    private final RowTypeInfo typeInfo;
    @Nullable
    private final int[] selectedFields;
    @Nullable
    private final FilterPredicate predicate;
    private final boolean recursiveEnumeration;
    private boolean isFilterPushedDown;

    private ParquetTableSource(String path, MessageType parquetSchema, Configuration configuration, boolean recursiveEnumeration) {
        this(path, parquetSchema, configuration, recursiveEnumeration, null, null);
    }

    private ParquetTableSource(String path, MessageType parquetSchema, Configuration configuration, boolean recursiveEnumeration, @Nullable int[] selectedFields, @Nullable FilterPredicate predicate) {
        Preconditions.checkNotNull((Object)path, (String)"Path must not be null.");
        Preconditions.checkNotNull((Object)parquetSchema, (String)"ParquetSchema must not be null.");
        Preconditions.checkNotNull((Object)configuration, (String)"Configuration must not be null");
        this.path = path;
        this.parquetSchema = parquetSchema;
        this.parquetConfig = configuration;
        this.selectedFields = selectedFields;
        this.predicate = predicate;
        this.recursiveEnumeration = recursiveEnumeration;
        if (predicate != null) {
            this.isFilterPushedDown = true;
        }
        RowTypeInfo typeInfoFromSchema = (RowTypeInfo)ParquetSchemaConverter.fromParquetType(parquetSchema);
        this.typeInfo = selectedFields == null ? typeInfoFromSchema : RowTypeInfo.projectFields((RowTypeInfo)typeInfoFromSchema, (int[])selectedFields);
        this.tableSchema = new TableSchema(typeInfoFromSchema.getFieldNames(), typeInfoFromSchema.getFieldTypes());
    }

    public TableSource<Row> projectFields(int[] fields) {
        return new ParquetTableSource(this.path, this.parquetSchema, this.parquetConfig, this.recursiveEnumeration, fields, this.predicate);
    }

    public DataSet<Row> getDataSet(ExecutionEnvironment executionEnvironment) {
        ParquetRowInputFormat parquetRowInputFormat = new ParquetRowInputFormat(new Path(this.path), this.parquetSchema);
        parquetRowInputFormat.setNestedFileEnumeration(this.recursiveEnumeration);
        if (this.selectedFields != null) {
            parquetRowInputFormat.selectFields(this.typeInfo.getFieldNames());
        }
        if (this.predicate != null) {
            parquetRowInputFormat.setFilterPredicate(this.predicate);
        }
        return executionEnvironment.createInput((InputFormat)parquetRowInputFormat).name(this.explainSource());
    }

    public TableSource<Row> applyPredicate(List<Expression> predicates) {
        ArrayList<FilterPredicate> convertedPredicates = new ArrayList<FilterPredicate>(predicates.size());
        ArrayList<Expression> unsupportedExpressions = new ArrayList<Expression>(predicates.size());
        for (Expression toConvert : predicates) {
            FilterPredicate convertedPredicate = this.toParquetPredicate(toConvert);
            if (convertedPredicate != null) {
                convertedPredicates.add(convertedPredicate);
                continue;
            }
            unsupportedExpressions.add(toConvert);
        }
        predicates.clear();
        predicates.addAll(unsupportedExpressions);
        FilterPredicate parquetPredicate = null;
        if (!convertedPredicates.isEmpty()) {
            parquetPredicate = (FilterPredicate)convertedPredicates.get(0);
            for (FilterPredicate converted : convertedPredicates.subList(1, convertedPredicates.size())) {
                parquetPredicate = FilterApi.and(parquetPredicate, converted);
            }
        }
        return new ParquetTableSource(this.path, this.parquetSchema, this.parquetConfig, this.recursiveEnumeration, this.selectedFields, parquetPredicate);
    }

    public boolean isFilterPushedDown() {
        return this.isFilterPushedDown;
    }

    public TypeInformation<Row> getReturnType() {
        return this.typeInfo;
    }

    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    public String explainSource() {
        return "ParquetFile[path=" + this.path + ", schema=" + this.parquetSchema + ", filter=" + this.predicateString() + ", typeInfo=" + this.typeInfo + ", selectedFields=" + Arrays.toString(this.selectedFields) + ", pushDownStatus=" + this.isFilterPushedDown + "]";
    }

    private String predicateString() {
        if (this.predicate != null) {
            return this.predicate.toString();
        }
        return "TRUE";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private FilterPredicate toParquetPredicate(Expression exp) {
        if (exp instanceof Not) {
            FilterPredicate c = this.toParquetPredicate((Expression)((Not)exp).child());
            if (c != null) return FilterApi.not(c);
            return null;
        }
        if (exp instanceof BinaryComparison) {
            BinaryComparison binComp = (BinaryComparison)exp;
            if (!this.isValid(binComp)) {
                LOG.debug("Unsupported predict [{}] cannot be pushed to ParquetTableSource.", (Object)exp);
                return null;
            }
            boolean onRight = this.literalOnRight(binComp);
            Tuple2<Operators.Column, Comparable> columnPair = this.extractColumnAndLiteral(binComp);
            if (columnPair == null) return null;
            if (exp instanceof EqualTo) {
                if (columnPair.f0 instanceof Operators.IntColumn) {
                    return FilterApi.eq((Operators.IntColumn)columnPair.f0, (Integer)columnPair.f1);
                }
                if (columnPair.f0 instanceof Operators.LongColumn) {
                    return FilterApi.eq((Operators.LongColumn)columnPair.f0, (Long)columnPair.f1);
                }
                if (columnPair.f0 instanceof Operators.DoubleColumn) {
                    return FilterApi.eq((Operators.DoubleColumn)columnPair.f0, (Double)columnPair.f1);
                }
                if (columnPair.f0 instanceof Operators.FloatColumn) {
                    return FilterApi.eq((Operators.FloatColumn)columnPair.f0, (Float)columnPair.f1);
                }
                if (columnPair.f0 instanceof Operators.BooleanColumn) {
                    return FilterApi.eq((Operators.BooleanColumn)columnPair.f0, (Boolean)columnPair.f1);
                }
                if (!(columnPair.f0 instanceof Operators.BinaryColumn)) return null;
                return FilterApi.eq((Operators.BinaryColumn)columnPair.f0, (Binary)columnPair.f1);
            }
            if (exp instanceof NotEqualTo) {
                if (columnPair.f0 instanceof Operators.IntColumn) {
                    return FilterApi.notEq((Operators.IntColumn)columnPair.f0, (Integer)columnPair.f1);
                }
                if (columnPair.f0 instanceof Operators.LongColumn) {
                    return FilterApi.notEq((Operators.LongColumn)columnPair.f0, (Long)columnPair.f1);
                }
                if (columnPair.f0 instanceof Operators.DoubleColumn) {
                    return FilterApi.notEq((Operators.DoubleColumn)columnPair.f0, (Double)columnPair.f1);
                }
                if (columnPair.f0 instanceof Operators.FloatColumn) {
                    return FilterApi.notEq((Operators.FloatColumn)columnPair.f0, (Float)columnPair.f1);
                }
                if (columnPair.f0 instanceof Operators.BooleanColumn) {
                    return FilterApi.notEq((Operators.BooleanColumn)columnPair.f0, (Boolean)columnPair.f1);
                }
                if (!(columnPair.f0 instanceof Operators.BinaryColumn)) return null;
                return FilterApi.notEq((Operators.BinaryColumn)columnPair.f0, (Binary)columnPair.f1);
            }
            if (exp instanceof GreaterThan) {
                if (onRight) {
                    return this.greaterThan(exp, columnPair);
                }
                this.lessThan(exp, columnPair);
                return null;
            }
            if (exp instanceof GreaterThanOrEqual) {
                if (!onRight) return this.lessThanOrEqual(exp, columnPair);
                return this.greaterThanOrEqual(exp, columnPair);
            }
            if (exp instanceof LessThan) {
                if (!onRight) return this.greaterThan(exp, columnPair);
                return this.lessThan(exp, columnPair);
            }
            if (exp instanceof LessThanOrEqual) {
                if (!onRight) return this.greaterThanOrEqual(exp, columnPair);
                return this.lessThanOrEqual(exp, columnPair);
            }
            LOG.debug("Unsupported predicate [{}] cannot be pushed into ParquetTableSource.", (Object)exp);
            return null;
        }
        if (!(exp instanceof BinaryExpression)) return null;
        if (exp instanceof And) {
            LOG.debug("All of the predicates should be in CNF. Found an AND expression: {}.", (Object)exp);
            return null;
        }
        if (exp instanceof Or) {
            FilterPredicate c1 = this.toParquetPredicate((Expression)((Or)exp).left());
            FilterPredicate c2 = this.toParquetPredicate((Expression)((Or)exp).right());
            if (c1 == null) return null;
            if (c2 != null) return FilterApi.or(c1, c2);
            return null;
        }
        LOG.debug("Unsupported predicate [{}] cannot be pushed into ParquetTableSource.", (Object)exp);
        return null;
    }

    @Nullable
    private FilterPredicate greaterThan(Expression exp, Tuple2<Operators.Column, Comparable> columnPair) {
        Preconditions.checkArgument((boolean)(exp instanceof GreaterThan), (Object)"exp has to be GreaterThan");
        if (columnPair.f0 instanceof Operators.IntColumn) {
            return FilterApi.gt((Operators.IntColumn)columnPair.f0, (Integer)columnPair.f1);
        }
        if (columnPair.f0 instanceof Operators.LongColumn) {
            return FilterApi.gt((Operators.LongColumn)columnPair.f0, (Long)columnPair.f1);
        }
        if (columnPair.f0 instanceof Operators.DoubleColumn) {
            return FilterApi.gt((Operators.DoubleColumn)columnPair.f0, (Double)columnPair.f1);
        }
        if (columnPair.f0 instanceof Operators.FloatColumn) {
            return FilterApi.gt((Operators.FloatColumn)columnPair.f0, (Float)columnPair.f1);
        }
        return null;
    }

    @Nullable
    private FilterPredicate lessThan(Expression exp, Tuple2<Operators.Column, Comparable> columnPair) {
        Preconditions.checkArgument((boolean)(exp instanceof LessThan), (Object)"exp has to be LessThan");
        if (columnPair.f0 instanceof Operators.IntColumn) {
            return FilterApi.lt((Operators.IntColumn)columnPair.f0, (Integer)columnPair.f1);
        }
        if (columnPair.f0 instanceof Operators.LongColumn) {
            return FilterApi.lt((Operators.LongColumn)columnPair.f0, (Long)columnPair.f1);
        }
        if (columnPair.f0 instanceof Operators.DoubleColumn) {
            return FilterApi.lt((Operators.DoubleColumn)columnPair.f0, (Double)columnPair.f1);
        }
        if (columnPair.f0 instanceof Operators.FloatColumn) {
            return FilterApi.lt((Operators.FloatColumn)columnPair.f0, (Float)columnPair.f1);
        }
        return null;
    }

    @Nullable
    private FilterPredicate greaterThanOrEqual(Expression exp, Tuple2<Operators.Column, Comparable> columnPair) {
        Preconditions.checkArgument((boolean)(exp instanceof GreaterThanOrEqual), (Object)"exp has to be GreaterThanOrEqual");
        if (columnPair.f0 instanceof Operators.IntColumn) {
            return FilterApi.gtEq((Operators.IntColumn)columnPair.f0, (Integer)columnPair.f1);
        }
        if (columnPair.f0 instanceof Operators.LongColumn) {
            return FilterApi.gtEq((Operators.LongColumn)columnPair.f0, (Long)columnPair.f1);
        }
        if (columnPair.f0 instanceof Operators.DoubleColumn) {
            return FilterApi.gtEq((Operators.DoubleColumn)columnPair.f0, (Double)columnPair.f1);
        }
        if (columnPair.f0 instanceof Operators.FloatColumn) {
            return FilterApi.gtEq((Operators.FloatColumn)columnPair.f0, (Float)columnPair.f1);
        }
        return null;
    }

    @Nullable
    private FilterPredicate lessThanOrEqual(Expression exp, Tuple2<Operators.Column, Comparable> columnPair) {
        Preconditions.checkArgument((boolean)(exp instanceof LessThanOrEqual), (Object)"exp has to be LessThanOrEqual");
        if (columnPair.f0 instanceof Operators.IntColumn) {
            return FilterApi.ltEq((Operators.IntColumn)columnPair.f0, (Integer)columnPair.f1);
        }
        if (columnPair.f0 instanceof Operators.LongColumn) {
            return FilterApi.ltEq((Operators.LongColumn)columnPair.f0, (Long)columnPair.f1);
        }
        if (columnPair.f0 instanceof Operators.DoubleColumn) {
            return FilterApi.ltEq((Operators.DoubleColumn)columnPair.f0, (Double)columnPair.f1);
        }
        if (columnPair.f0 instanceof Operators.FloatColumn) {
            return FilterApi.ltEq((Operators.FloatColumn)columnPair.f0, (Float)columnPair.f1);
        }
        return null;
    }

    private boolean isValid(BinaryComparison comp) {
        return comp.left() instanceof Literal && comp.right() instanceof Attribute || comp.left() instanceof Attribute && comp.right() instanceof Literal;
    }

    private boolean literalOnRight(BinaryComparison comp) {
        if (comp.left() instanceof Literal && comp.right() instanceof Attribute) {
            return false;
        }
        if (comp.left() instanceof Attribute && comp.right() instanceof Literal) {
            return true;
        }
        throw new RuntimeException("Invalid binary comparison.");
    }

    private TypeInformation<?> getLiteralType(BinaryComparison comp) {
        if (this.literalOnRight(comp)) {
            return ((Literal)comp.right()).resultType();
        }
        return ((Literal)comp.left()).resultType();
    }

    private Object getLiteral(BinaryComparison comp) {
        if (this.literalOnRight(comp)) {
            return ((Literal)comp.right()).value();
        }
        return ((Literal)comp.left()).value();
    }

    private String getColumnName(BinaryComparison comp) {
        if (this.literalOnRight(comp)) {
            return ((Attribute)comp.left()).name();
        }
        return ((Attribute)comp.right()).name();
    }

    @Nullable
    private Tuple2<Operators.Column, Comparable> extractColumnAndLiteral(BinaryComparison comp) {
        String columnName = this.getColumnName(comp);
        ColumnPath columnPath = ColumnPath.fromDotString(columnName);
        TypeInformation<?> typeInfo = null;
        try {
            Type type = this.parquetSchema.getType(columnPath.toArray());
            typeInfo = ParquetSchemaConverter.convertParquetTypeToTypeInfo(type);
        }
        catch (InvalidRecordException e) {
            LOG.error("Pushed predicate on undefined field name {} in schema", (Object)columnName);
            return null;
        }
        Object value = this.getLiteral(comp);
        if (!(value instanceof Comparable)) {
            LOG.warn("Encountered a non-comparable literal of type {}.Cannot push predicate [{}] into ParquetTablesource.This is a bug and should be reported.", (Object)value.getClass().getCanonicalName(), (Object)comp);
            return null;
        }
        if (typeInfo == BasicTypeInfo.BYTE_TYPE_INFO || typeInfo == BasicTypeInfo.SHORT_TYPE_INFO || typeInfo == BasicTypeInfo.INT_TYPE_INFO) {
            return new Tuple2((Object)FilterApi.intColumn(columnName), (Object)((Number)value).intValue());
        }
        if (typeInfo == BasicTypeInfo.LONG_TYPE_INFO) {
            return new Tuple2((Object)FilterApi.longColumn(columnName), (Object)((Number)value).longValue());
        }
        if (typeInfo == BasicTypeInfo.FLOAT_TYPE_INFO) {
            return new Tuple2((Object)FilterApi.floatColumn(columnName), (Object)Float.valueOf(((Number)value).floatValue()));
        }
        if (typeInfo == BasicTypeInfo.BOOLEAN_TYPE_INFO) {
            return new Tuple2((Object)FilterApi.booleanColumn(columnName), (Object)((Boolean)value));
        }
        if (typeInfo == BasicTypeInfo.DOUBLE_TYPE_INFO) {
            return new Tuple2((Object)FilterApi.doubleColumn(columnName), (Object)((Number)value).doubleValue());
        }
        if (typeInfo == BasicTypeInfo.STRING_TYPE_INFO) {
            return new Tuple2((Object)FilterApi.binaryColumn(columnName), (Object)Binary.fromString((String)value));
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String path;
        private MessageType schema;
        private Configuration config;
        private boolean recursive = true;

        public Builder path(String path) {
            Preconditions.checkNotNull((Object)path, (String)"Path must not be null");
            Preconditions.checkArgument((!path.isEmpty() ? 1 : 0) != 0, (Object)"Path must not be empty");
            this.path = path;
            return this;
        }

        public Builder path(String path, boolean recursive) {
            Preconditions.checkNotNull((Object)path, (String)"Path must not be null");
            Preconditions.checkArgument((!path.isEmpty() ? 1 : 0) != 0, (Object)"Path must not be empty");
            this.path = path;
            this.recursive = recursive;
            return this;
        }

        public Builder forParquetSchema(MessageType parquetSchema) {
            Preconditions.checkNotNull((Object)parquetSchema, (String)"Parquet schema must not be null");
            this.schema = parquetSchema;
            return this;
        }

        public Builder withConfiguration(Configuration config) {
            Preconditions.checkNotNull((Object)config, (String)"Configuration must not be null.");
            this.config = config;
            return this;
        }

        public ParquetTableSource build() {
            Preconditions.checkNotNull((Object)this.path, (String)"Path must not be null");
            Preconditions.checkNotNull((Object)this.schema, (String)"Parquet schema must not be null");
            if (this.config == null) {
                this.config = new Configuration();
            }
            return new ParquetTableSource(this.path, this.schema, this.config, this.recursive);
        }
    }
}

