/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.client.transaction.ConcurrentOperation;
import org.apache.hudi.client.transaction.ConflictResolutionStrategy;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieWriteConflictException;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TransactionUtils {
    private static final Logger LOG = LogManager.getLogger(TransactionUtils.class);

    public static Option<HoodieCommitMetadata> resolveWriteConflictIfAny(HoodieTable table, Option<HoodieInstant> currentTxnOwnerInstant, Option<HoodieCommitMetadata> thisCommitMetadata, HoodieWriteConfig config, Option<HoodieInstant> lastCompletedTxnOwnerInstant, boolean reloadActiveTimeline, Set<String> pendingInstants) throws HoodieWriteConflictException {
        if (config.getWriteConcurrencyMode().supportsOptimisticConcurrencyControl()) {
            Stream<HoodieInstant> completedInstantsDuringCurrentWriteOperation = TransactionUtils.getCompletedInstantsDuringCurrentWriteOperation(table.getMetaClient(), pendingInstants);
            ConflictResolutionStrategy resolutionStrategy = config.getWriteConflictResolutionStrategy();
            Stream<HoodieInstant> instantStream = Stream.concat(resolutionStrategy.getCandidateInstants(reloadActiveTimeline ? table.getMetaClient().reloadActiveTimeline() : table.getActiveTimeline(), currentTxnOwnerInstant.get(), lastCompletedTxnOwnerInstant), completedInstantsDuringCurrentWriteOperation);
            ConcurrentOperation thisOperation = new ConcurrentOperation(currentTxnOwnerInstant.get(), thisCommitMetadata.orElse(new HoodieCommitMetadata()));
            instantStream.forEach(instant -> {
                try {
                    ConcurrentOperation otherOperation = new ConcurrentOperation((HoodieInstant)instant, table.getMetaClient());
                    if (resolutionStrategy.hasConflict(thisOperation, otherOperation)) {
                        LOG.info((Object)("Conflict encountered between current instant = " + thisOperation + " and instant = " + otherOperation + ", attempting to resolve it..."));
                        resolutionStrategy.resolveConflict(table, thisOperation, otherOperation);
                    }
                }
                catch (IOException io) {
                    throw new HoodieWriteConflictException("Unable to resolve conflict, if present", io);
                }
            });
            LOG.info((Object)"Successfully resolved conflicts, if any");
            return thisOperation.getCommitMetadataOption();
        }
        return thisCommitMetadata;
    }

    public static Option<Pair<HoodieInstant, Map<String, String>>> getLastCompletedTxnInstantAndMetadata(HoodieTableMetaClient metaClient) {
        Option<HoodieInstant> hoodieInstantOption = metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().lastInstant();
        try {
            if (hoodieInstantOption.isPresent()) {
                HoodieCommitMetadata commitMetadata = TimelineUtils.getCommitMetadata(hoodieInstantOption.get(), metaClient.getActiveTimeline());
                return Option.of(Pair.of(hoodieInstantOption.get(), commitMetadata.getExtraMetadata()));
            }
            return Option.empty();
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to read metadata for instant " + hoodieInstantOption.get(), io);
        }
    }

    public static Set<String> getInflightAndRequestedInstants(HoodieTableMetaClient metaClient) {
        Set<String> timelineActions = CollectionUtils.createImmutableSet("replacecommit", "compaction", "deltacommit", "commit");
        return metaClient.getActiveTimeline().getTimelineOfActions(timelineActions).filterInflightsAndRequested().getInstantsAsStream().map(HoodieInstant::getTimestamp).collect(Collectors.toSet());
    }

    public static Stream<HoodieInstant> getCompletedInstantsDuringCurrentWriteOperation(HoodieTableMetaClient metaClient, Set<String> pendingInstants) {
        return metaClient.reloadActiveTimeline().getCommitsTimeline().filterCompletedInstants().getInstantsAsStream().filter(f -> pendingInstants.contains(f.getTimestamp()));
    }
}

