/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.Arrays;
import java.util.List;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.HoodieTableMetaClient;

public class RocksDBSchemaHelper {
    private final String colFamilyForView;
    private final String colFamilyForPendingCompaction;
    private final String colFamilyForPendingLogCompaction;
    private final String colFamilyForBootstrapBaseFile;
    private final String colFamilyForStoredPartitions;
    private final String colFamilyForReplacedFileGroups;
    private final String colFamilyForPendingClusteringFileGroups;

    public RocksDBSchemaHelper(HoodieTableMetaClient metaClient) {
        this.colFamilyForBootstrapBaseFile = "hudi_bootstrap_basefile_" + metaClient.getBasePath().replace("/", "_");
        this.colFamilyForPendingCompaction = "hudi_pending_compaction_" + metaClient.getBasePath().replace("/", "_");
        this.colFamilyForPendingLogCompaction = "hudi_pending_log_compaction_" + metaClient.getBasePath().replace("/", "_");
        this.colFamilyForStoredPartitions = "hudi_partitions_" + metaClient.getBasePath().replace("/", "_");
        this.colFamilyForView = "hudi_view_" + metaClient.getBasePath().replace("/", "_");
        this.colFamilyForReplacedFileGroups = "hudi_replaced_fg" + metaClient.getBasePath().replace("/", "_");
        this.colFamilyForPendingClusteringFileGroups = "hudi_pending_clustering_fg" + metaClient.getBasePath().replace("/", "_");
    }

    public List<String> getAllColumnFamilies() {
        return Arrays.asList(this.getColFamilyForView(), this.getColFamilyForPendingCompaction(), this.getColFamilyForPendingLogCompaction(), this.getColFamilyForBootstrapBaseFile(), this.getColFamilyForStoredPartitions(), this.getColFamilyForReplacedFileGroups(), this.getColFamilyForFileGroupsInPendingClustering());
    }

    public String getKeyForPartitionLookup(String partition) {
        return String.format("part=%s", partition);
    }

    public String getKeyForPendingCompactionLookup(HoodieFileGroupId fgId) {
        return this.getPartitionFileIdBasedLookup(fgId);
    }

    public String getKeyForPendingLogCompactionLookup(HoodieFileGroupId fgId) {
        return this.getPartitionFileIdBasedLookup(fgId);
    }

    public String getKeyForBootstrapBaseFile(HoodieFileGroupId fgId) {
        return this.getPartitionFileIdBasedLookup(fgId);
    }

    public String getKeyForReplacedFileGroup(HoodieFileGroupId fgId) {
        return this.getPartitionFileIdBasedLookup(fgId);
    }

    public String getKeyForFileGroupsInPendingClustering(HoodieFileGroupId fgId) {
        return this.getPartitionFileIdBasedLookup(fgId);
    }

    public String getKeyForSliceView(HoodieFileGroup fileGroup, FileSlice slice) {
        return this.getKeyForSliceView(fileGroup.getPartitionPath(), fileGroup.getFileGroupId().getFileId(), slice.getBaseInstantTime());
    }

    public String getKeyForSliceView(String partitionPath, String fileId, String instantTime) {
        return String.format("type=slice,part=%s,id=%s,instant=%s", partitionPath, fileId, instantTime);
    }

    public String getPrefixForSliceViewByPartitionFile(String partitionPath, String fileId) {
        return String.format("type=slice,part=%s,id=%s,instant=", partitionPath, fileId);
    }

    public String getPrefixForDataFileViewByPartitionFile(String partitionPath, String fileId) {
        return String.format("type=df,part=%s,id=%s,instant=", partitionPath, fileId);
    }

    public String getKeyForDataFileView(HoodieFileGroup fileGroup, FileSlice slice) {
        return String.format("type=df,part=%s,id=%s,instant=%s", fileGroup.getPartitionPath(), fileGroup.getFileGroupId().getFileId(), slice.getBaseInstantTime());
    }

    public String getPrefixForSliceViewByPartition(String partitionPath) {
        return String.format("type=slice,part=%s,id=", partitionPath);
    }

    public String getPrefixForSliceView() {
        return "type=slice,part=";
    }

    public String getPrefixForDataFileViewByPartition(String partitionPath) {
        return String.format("type=df,part=%s,id=", partitionPath);
    }

    private String getPartitionFileIdBasedLookup(HoodieFileGroupId fgId) {
        return String.format("part=%s,id=%s", fgId.getPartitionPath(), fgId.getFileId());
    }

    public String getColFamilyForView() {
        return this.colFamilyForView;
    }

    public String getColFamilyForPendingCompaction() {
        return this.colFamilyForPendingCompaction;
    }

    public String getColFamilyForPendingLogCompaction() {
        return this.colFamilyForPendingLogCompaction;
    }

    public String getColFamilyForBootstrapBaseFile() {
        return this.colFamilyForBootstrapBaseFile;
    }

    public String getColFamilyForStoredPartitions() {
        return this.colFamilyForStoredPartitions;
    }

    public String getColFamilyForReplacedFileGroups() {
        return this.colFamilyForReplacedFileGroups;
    }

    public String getColFamilyForFileGroupsInPendingClustering() {
        return this.colFamilyForPendingClusteringFileGroups;
    }
}

