/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.queue;

import java.util.Iterator;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.queue.HoodieMessageQueue;
import org.apache.hudi.common.util.queue.HoodieProducer;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class IteratorBasedQueueProducer<I>
implements HoodieProducer<I> {
    private static final Logger LOG = LogManager.getLogger(IteratorBasedQueueProducer.class);
    private final Iterator<I> inputIterator;

    public IteratorBasedQueueProducer(Iterator<I> inputIterator) {
        this.inputIterator = inputIterator;
    }

    @Override
    public void produce(HoodieMessageQueue<I, ?> queue) throws Exception {
        LOG.info((Object)"starting to buffer records");
        while (this.inputIterator.hasNext()) {
            queue.insertRecord(this.inputIterator.next());
        }
        LOG.info((Object)"finished buffering records");
    }

    @Override
    public void close() {
        if (this.inputIterator instanceof ClosableIterator) {
            ((ClosableIterator)this.inputIterator).close();
        }
    }
}

