/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.expression;

import java.util.Arrays;
import org.apache.hudi.hive.expression.Expression;
import org.apache.hudi.hive.expression.ExpressionVisitor;

public class BinaryOperator
extends Expression {
    private final Expression.Operator operator;
    private final Expression left;
    private final Expression right;

    private BinaryOperator(Expression left, Expression.Operator operator, Expression right) {
        super(Arrays.asList(left, right));
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    public static BinaryOperator and(Expression left, Expression right) {
        return new BinaryOperator(left, Expression.Operator.AND, right);
    }

    public static BinaryOperator or(Expression left, Expression right) {
        return new BinaryOperator(left, Expression.Operator.OR, right);
    }

    public static BinaryOperator eq(Expression left, Expression right) {
        return new BinaryOperator(left, Expression.Operator.EQ, right);
    }

    public static BinaryOperator gteq(Expression left, Expression right) {
        return new BinaryOperator(left, Expression.Operator.GT_EQ, right);
    }

    public static BinaryOperator lteq(Expression left, Expression right) {
        return new BinaryOperator(left, Expression.Operator.LT_EQ, right);
    }

    public Expression.Operator getOperator() {
        return this.operator;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> exprVisitor) {
        return exprVisitor.visitBinaryOperator(this);
    }
}

