/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.utils.LazyIterableIterator;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.bucket.BucketIndexLocationMapper;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class HoodieBucketIndex
extends HoodieIndex<Object, Object> {
    private static final Logger LOG = LogManager.getLogger(HoodieBucketIndex.class);
    protected final int numBuckets;
    protected final List<String> indexKeyFields;

    public HoodieBucketIndex(HoodieWriteConfig config) {
        super(config);
        this.numBuckets = config.getBucketIndexNumBuckets();
        this.indexKeyFields = Arrays.asList(config.getBucketIndexHashField().split(","));
        LOG.info((Object)("Use bucket index, numBuckets = " + this.numBuckets + ", indexFields: " + this.indexKeyFields));
    }

    @Override
    public HoodieData<WriteStatus> updateLocation(HoodieData<WriteStatus> writeStatuses, HoodieEngineContext context, HoodieTable hoodieTable) throws HoodieIndexException {
        return writeStatuses;
    }

    @Override
    public <R> HoodieData<HoodieRecord<R>> tagLocation(HoodieData<HoodieRecord<R>> records, HoodieEngineContext context, HoodieTable hoodieTable) throws HoodieIndexException {
        List<String> partitions = records.map(HoodieRecord::getPartitionPath).distinct().collectAsList();
        LOG.info((Object)("Get BucketIndexLocationMapper for partitions: " + partitions));
        final BucketIndexLocationMapper mapper = this.getLocationMapper(hoodieTable, partitions);
        return records.mapPartitions(iterator2 -> new LazyIterableIterator<HoodieRecord<R>, HoodieRecord<R>>((Iterator)iterator2){

            @Override
            protected HoodieRecord<R> computeNext() {
                HoodieRecord record = (HoodieRecord)this.inputItr.next();
                Option<HoodieRecordLocation> loc = mapper.getRecordLocation(record.getKey());
                return HoodieIndexUtils.getTaggedRecord(record, loc);
            }
        }, false);
    }

    @Override
    public boolean requiresTagging(WriteOperationType operationType) {
        switch (operationType) {
            case INSERT: 
            case INSERT_OVERWRITE: 
            case UPSERT: 
            case DELETE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean rollbackCommit(String instantTime) {
        return true;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean canIndexLogFiles() {
        return true;
    }

    @Override
    public boolean isImplicitWithStorage() {
        return true;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    protected abstract BucketIndexLocationMapper getLocationMapper(HoodieTable var1, List<String> var2);
}

