/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.FlinkAppendHandle;
import org.apache.hudi.io.FlinkConcatAndReplaceHandle;
import org.apache.hudi.io.FlinkConcatHandle;
import org.apache.hudi.io.FlinkCreateHandle;
import org.apache.hudi.io.FlinkMergeAndReplaceHandle;
import org.apache.hudi.io.FlinkMergeAndReplaceHandleWithChangeLog;
import org.apache.hudi.io.FlinkMergeHandle;
import org.apache.hudi.io.FlinkMergeHandleWithChangeLog;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.io.MiniBatchHandle;
import org.apache.hudi.table.HoodieTable;

public class FlinkWriteHandleFactory {
    public static <T, I, K, O> Factory<T, I, K, O> getFactory(HoodieTableConfig tableConfig, HoodieWriteConfig writeConfig) {
        if (writeConfig.allowDuplicateInserts()) {
            return ClusterWriteHandleFactory.getInstance();
        }
        if (tableConfig.getTableType().equals((Object)HoodieTableType.MERGE_ON_READ)) {
            return DeltaCommitWriteHandleFactory.getInstance();
        }
        if (tableConfig.isCDCEnabled()) {
            return CdcWriteHandleFactory.getInstance();
        }
        return CommitWriteHandleFactory.getInstance();
    }

    private static class DeltaCommitWriteHandleFactory<T, I, K, O>
    implements Factory<T, I, K, O> {
        private static final DeltaCommitWriteHandleFactory<?, ?, ?, ?> INSTANCE = new DeltaCommitWriteHandleFactory();

        private DeltaCommitWriteHandleFactory() {
        }

        public static <T, I, K, O> DeltaCommitWriteHandleFactory<T, I, K, O> getInstance() {
            return INSTANCE;
        }

        @Override
        public HoodieWriteHandle<?, ?, ?, ?> create(Map<String, Path> bucketToHandles, HoodieRecord<T> record, HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> table, Iterator<HoodieRecord<T>> recordItr) {
            String fileID = record.getCurrentLocation().getFileId();
            String partitionPath = record.getPartitionPath();
            TaskContextSupplier contextSupplier = table.getTaskContextSupplier();
            return new FlinkAppendHandle<T, I, K, O>(config, instantTime, table, partitionPath, fileID, recordItr, contextSupplier);
        }
    }

    private static class CdcWriteHandleFactory<T, I, K, O>
    extends BaseCommitWriteHandleFactory<T, I, K, O> {
        private static final CdcWriteHandleFactory<?, ?, ?, ?> INSTANCE = new CdcWriteHandleFactory();

        private CdcWriteHandleFactory() {
        }

        public static <T, I, K, O> CdcWriteHandleFactory<T, I, K, O> getInstance() {
            return INSTANCE;
        }

        @Override
        protected HoodieWriteHandle<?, ?, ?, ?> createReplaceHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> table, Iterator<HoodieRecord<T>> recordItr, String partitionPath, String fileId, Path basePath) {
            return new FlinkMergeAndReplaceHandleWithChangeLog<T, I, K, O>(config, instantTime, table, recordItr, partitionPath, fileId, table.getTaskContextSupplier(), basePath);
        }

        @Override
        protected HoodieWriteHandle<?, ?, ?, ?> createMergeHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> table, Iterator<HoodieRecord<T>> recordItr, String partitionPath, String fileId) {
            return new FlinkMergeHandleWithChangeLog<T, I, K, O>(config, instantTime, table, recordItr, partitionPath, fileId, table.getTaskContextSupplier());
        }
    }

    private static class ClusterWriteHandleFactory<T, I, K, O>
    extends BaseCommitWriteHandleFactory<T, I, K, O> {
        private static final ClusterWriteHandleFactory<?, ?, ?, ?> INSTANCE = new ClusterWriteHandleFactory();

        private ClusterWriteHandleFactory() {
        }

        public static <T, I, K, O> ClusterWriteHandleFactory<T, I, K, O> getInstance() {
            return INSTANCE;
        }

        @Override
        protected HoodieWriteHandle<?, ?, ?, ?> createReplaceHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> table, Iterator<HoodieRecord<T>> recordItr, String partitionPath, String fileId, Path basePath) {
            return new FlinkConcatAndReplaceHandle<T, I, K, O>(config, instantTime, table, recordItr, partitionPath, fileId, table.getTaskContextSupplier(), basePath);
        }

        @Override
        protected HoodieWriteHandle<?, ?, ?, ?> createMergeHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> table, Iterator<HoodieRecord<T>> recordItr, String partitionPath, String fileId) {
            return new FlinkConcatHandle<T, I, K, O>(config, instantTime, table, recordItr, partitionPath, fileId, table.getTaskContextSupplier());
        }
    }

    private static class CommitWriteHandleFactory<T, I, K, O>
    extends BaseCommitWriteHandleFactory<T, I, K, O> {
        private static final CommitWriteHandleFactory<?, ?, ?, ?> INSTANCE = new CommitWriteHandleFactory();

        private CommitWriteHandleFactory() {
        }

        public static <T, I, K, O> CommitWriteHandleFactory<T, I, K, O> getInstance() {
            return INSTANCE;
        }

        @Override
        protected HoodieWriteHandle<?, ?, ?, ?> createReplaceHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> table, Iterator<HoodieRecord<T>> recordItr, String partitionPath, String fileId, Path basePath) {
            return new FlinkMergeAndReplaceHandle<T, I, K, O>(config, instantTime, table, recordItr, partitionPath, fileId, table.getTaskContextSupplier(), basePath);
        }

        @Override
        protected HoodieWriteHandle<?, ?, ?, ?> createMergeHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> table, Iterator<HoodieRecord<T>> recordItr, String partitionPath, String fileId) {
            return new FlinkMergeHandle<T, I, K, O>(config, instantTime, table, recordItr, partitionPath, fileId, table.getTaskContextSupplier());
        }
    }

    private static abstract class BaseCommitWriteHandleFactory<T, I, K, O>
    implements Factory<T, I, K, O> {
        private BaseCommitWriteHandleFactory() {
        }

        @Override
        public HoodieWriteHandle<?, ?, ?, ?> create(Map<String, Path> bucketToHandles, HoodieRecord<T> record, HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> table, Iterator<HoodieRecord<T>> recordItr) {
            HoodieRecordLocation loc = record.getCurrentLocation();
            String fileID = loc.getFileId();
            String partitionPath = record.getPartitionPath();
            Path writePath = bucketToHandles.get(fileID);
            if (writePath != null) {
                HoodieWriteHandle<?, ?, ?, ?> writeHandle = this.createReplaceHandle(config, instantTime, table, recordItr, partitionPath, fileID, writePath);
                bucketToHandles.put(fileID, ((MiniBatchHandle)((Object)writeHandle)).getWritePath());
                return writeHandle;
            }
            HoodieWriteHandle writeHandle = loc.getInstantTime().equals("I") ? new FlinkCreateHandle(config, instantTime, table, partitionPath, fileID, table.getTaskContextSupplier()) : this.createMergeHandle(config, instantTime, table, recordItr, partitionPath, fileID);
            bucketToHandles.put(fileID, ((MiniBatchHandle)((Object)writeHandle)).getWritePath());
            return writeHandle;
        }

        protected abstract HoodieWriteHandle<?, ?, ?, ?> createReplaceHandle(HoodieWriteConfig var1, String var2, HoodieTable<T, I, K, O> var3, Iterator<HoodieRecord<T>> var4, String var5, String var6, Path var7);

        protected abstract HoodieWriteHandle<?, ?, ?, ?> createMergeHandle(HoodieWriteConfig var1, String var2, HoodieTable<T, I, K, O> var3, Iterator<HoodieRecord<T>> var4, String var5, String var6);
    }

    public static interface Factory<T, I, K, O> {
        public HoodieWriteHandle<?, ?, ?, ?> create(Map<String, Path> var1, HoodieRecord<T> var2, HoodieWriteConfig var3, String var4, HoodieTable<T, I, K, O> var5, Iterator<HoodieRecord<T>> var6);
    }
}

