/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.io.storage.HoodieAvroFileWriterFactory;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.org.apache.avro.Schema;

public class HoodieFileWriterFactory {
    private static HoodieFileWriterFactory getWriterFactory(HoodieRecord.HoodieRecordType recordType) {
        switch (recordType) {
            case AVRO: {
                return new HoodieAvroFileWriterFactory();
            }
            case SPARK: {
                try {
                    Class<?> clazz = ReflectionUtils.getClass("org.apache.hudi.io.storage.HoodieSparkFileWriterFactory");
                    return (HoodieFileWriterFactory)clazz.newInstance();
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                    throw new HoodieException("Unable to create hoodie spark file writer factory", e);
                }
            }
        }
        throw new UnsupportedOperationException((Object)((Object)recordType) + " record type not supported yet.");
    }

    public static <T, I, K, O> HoodieFileWriter getFileWriter(String instantTime, Path path, Configuration conf, HoodieConfig config, Schema schema, TaskContextSupplier taskContextSupplier, HoodieRecord.HoodieRecordType recordType) throws IOException {
        String extension = FSUtils.getFileExtension(path.getName());
        HoodieFileWriterFactory factory = HoodieFileWriterFactory.getWriterFactory(recordType);
        return factory.getFileWriterByFormat(extension, instantTime, path, conf, config, schema, taskContextSupplier);
    }

    public static <T, I, K, O> HoodieFileWriter getFileWriter(HoodieFileFormat format, FSDataOutputStream outputStream, Configuration conf, HoodieConfig config, Schema schema, HoodieRecord.HoodieRecordType recordType) throws IOException {
        HoodieFileWriterFactory factory = HoodieFileWriterFactory.getWriterFactory(recordType);
        return factory.getFileWriterByFormat(format, outputStream, conf, config, schema);
    }

    protected <T, I, K, O> HoodieFileWriter getFileWriterByFormat(String extension, String instantTime, Path path, Configuration conf, HoodieConfig config, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        if (HoodieFileFormat.PARQUET.getFileExtension().equals(extension)) {
            return this.newParquetFileWriter(instantTime, path, conf, config, schema, taskContextSupplier);
        }
        if (HoodieFileFormat.HFILE.getFileExtension().equals(extension)) {
            return this.newHFileFileWriter(instantTime, path, conf, config, schema, taskContextSupplier);
        }
        if (HoodieFileFormat.ORC.getFileExtension().equals(extension)) {
            return this.newOrcFileWriter(instantTime, path, conf, config, schema, taskContextSupplier);
        }
        throw new UnsupportedOperationException(extension + " format not supported yet.");
    }

    protected <T, I, K, O> HoodieFileWriter getFileWriterByFormat(HoodieFileFormat format, FSDataOutputStream outputStream, Configuration conf, HoodieConfig config, Schema schema) throws IOException {
        switch (format) {
            case PARQUET: {
                return this.newParquetFileWriter(outputStream, conf, config, schema);
            }
        }
        throw new UnsupportedOperationException((Object)((Object)format) + " format not supported yet.");
    }

    protected HoodieFileWriter newParquetFileWriter(String instantTime, Path path, Configuration conf, HoodieConfig config, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected HoodieFileWriter newParquetFileWriter(FSDataOutputStream outputStream, Configuration conf, HoodieConfig config, Schema schema) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected HoodieFileWriter newHFileFileWriter(String instantTime, Path path, Configuration conf, HoodieConfig config, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected HoodieFileWriter newOrcFileWriter(String instantTime, Path path, Configuration conf, HoodieConfig config, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected BloomFilter createBloomFilter(HoodieConfig config) {
        return BloomFilterFactory.createBloomFilter(60000, 1.0E-9, 100000, BloomFilterTypeCode.DYNAMIC_V0.name());
    }
}

