/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.io.storage.HoodieHBaseKVComparator;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparator;
import org.apache.hudi.org.apache.hadoop.hbase.io.compress.Compression;

public class HoodieHFileConfig {
    public static final CellComparator HFILE_COMPARATOR = new HoodieHBaseKVComparator();
    public static final boolean PREFETCH_ON_OPEN = false;
    public static final boolean CACHE_DATA_IN_L1 = false;
    public static final boolean DROP_BEHIND_CACHE_COMPACTION = true;
    private final Compression.Algorithm compressionAlgorithm;
    private final int blockSize;
    private final long maxFileSize;
    private final boolean prefetchBlocksOnOpen;
    private final boolean cacheDataInL1;
    private final boolean dropBehindCacheCompaction;
    private final Configuration hadoopConf;
    private final BloomFilter bloomFilter;
    private final CellComparator hfileComparator;
    private final String keyFieldName;

    public HoodieHFileConfig(Configuration hadoopConf, Compression.Algorithm compressionAlgorithm, int blockSize, long maxFileSize, String keyFieldName, boolean prefetchBlocksOnOpen, boolean cacheDataInL1, boolean dropBehindCacheCompaction, BloomFilter bloomFilter, CellComparator hfileComparator) {
        this.hadoopConf = hadoopConf;
        this.compressionAlgorithm = compressionAlgorithm;
        this.blockSize = blockSize;
        this.maxFileSize = maxFileSize;
        this.prefetchBlocksOnOpen = prefetchBlocksOnOpen;
        this.cacheDataInL1 = cacheDataInL1;
        this.dropBehindCacheCompaction = dropBehindCacheCompaction;
        this.bloomFilter = bloomFilter;
        this.hfileComparator = hfileComparator;
        this.keyFieldName = keyFieldName;
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    public Compression.Algorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public boolean shouldPrefetchBlocksOnOpen() {
        return this.prefetchBlocksOnOpen;
    }

    public boolean shouldCacheDataInL1() {
        return this.cacheDataInL1;
    }

    public boolean shouldDropBehindCacheCompaction() {
        return this.dropBehindCacheCompaction;
    }

    public boolean useBloomFilter() {
        return this.bloomFilter != null;
    }

    public BloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public CellComparator getHFileComparator() {
        return this.hfileComparator;
    }

    public String getKeyFieldName() {
        return this.keyFieldName;
    }
}

